/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.mozilla.javascript.AccessorSlot;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.ConstProperties;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Delegator;
import org.mozilla.javascript.ExternalArrayData;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.LambdaFunction;
import org.mozilla.javascript.LambdaSlot;
import org.mozilla.javascript.LazilyLoadedCtor;
import org.mozilla.javascript.LazyLoadSlot;
import org.mozilla.javascript.MemberBox;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Slot;
import org.mozilla.javascript.SlotMapContainer;
import org.mozilla.javascript.Symbol;
import org.mozilla.javascript.SymbolScriptable;
import org.mozilla.javascript.ThreadSafeSlotMapContainer;
import org.mozilla.javascript.TopLevel;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;
import org.mozilla.javascript.annotations.JSConstructor;
import org.mozilla.javascript.annotations.JSFunction;
import org.mozilla.javascript.annotations.JSGetter;
import org.mozilla.javascript.annotations.JSSetter;
import org.mozilla.javascript.annotations.JSStaticFunction;
import org.mozilla.javascript.debug.DebuggableObject;

public abstract class ScriptableObject
implements Scriptable,
SymbolScriptable,
Serializable,
DebuggableObject,
ConstProperties {
    private static final long serialVersionUID = 2829861078851942586L;
    public static final int EMPTY = 0;
    public static final int READONLY = 1;
    public static final int DONTENUM = 2;
    public static final int PERMANENT = 4;
    public static final int UNINITIALIZED_CONST = 8;
    public static final int CONST = 13;
    private Scriptable prototypeObject;
    private Scriptable parentScopeObject;
    private transient SlotMapContainer slotMap;
    private transient ExternalArrayData externalData;
    private volatile Map<Object, Object> associatedValues;
    private boolean isExtensible = true;
    private boolean isSealed = false;
    private static final Method GET_ARRAY_LENGTH;
    private static final Comparator<Object> KEY_COMPARATOR;

    protected static ScriptableObject buildDataDescriptor(Scriptable scriptable, Object object, int n) {
        NativeObject nativeObject = new NativeObject();
        ScriptRuntime.setBuiltinProtoAndParent(nativeObject, scriptable, TopLevel.Builtins.Object);
        nativeObject.defineProperty("value", object, 0);
        nativeObject.setCommonDescriptorProperties(n, true);
        return nativeObject;
    }

    protected void setCommonDescriptorProperties(int n, boolean bl) {
        if (bl) {
            this.defineProperty("writable", (Object)((n & 1) == 0 ? 1 : 0), 0);
        }
        this.defineProperty("enumerable", (Object)((n & 2) == 0 ? 1 : 0), 0);
        this.defineProperty("configurable", (Object)((n & 4) == 0 ? 1 : 0), 0);
    }

    static void checkValidAttributes(int n) {
        int n2 = 15;
        if ((n & 0xFFFFFFF0) != 0) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
    }

    private static SlotMapContainer createSlotMap(int n) {
        Context context = Context.getCurrentContext();
        if (context != null && context.hasFeature(17)) {
            return new ThreadSafeSlotMapContainer(n);
        }
        return new SlotMapContainer(n);
    }

    public ScriptableObject() {
        this.slotMap = ScriptableObject.createSlotMap(0);
    }

    public ScriptableObject(Scriptable scriptable, Scriptable scriptable2) {
        if (scriptable == null) {
            throw new IllegalArgumentException();
        }
        this.parentScopeObject = scriptable;
        this.prototypeObject = scriptable2;
        this.slotMap = ScriptableObject.createSlotMap(0);
    }

    public String getTypeOf() {
        return this.avoidObjectDetection() ? "undefined" : "object";
    }

    @Override
    public abstract String getClassName();

    @Override
    public boolean has(String string, Scriptable scriptable) {
        return null != this.slotMap.query(string, 0);
    }

    @Override
    public boolean has(int n, Scriptable scriptable) {
        if (this.externalData != null) {
            return n < this.externalData.getArrayLength();
        }
        return null != this.slotMap.query(null, n);
    }

    @Override
    public boolean has(Symbol symbol, Scriptable scriptable) {
        return null != this.slotMap.query(symbol, 0);
    }

    @Override
    public Object get(String string, Scriptable scriptable) {
        Slot slot = this.slotMap.query(string, 0);
        if (slot == null) {
            return Scriptable.NOT_FOUND;
        }
        return slot.getValue(scriptable);
    }

    @Override
    public Object get(int n, Scriptable scriptable) {
        if (this.externalData != null) {
            if (n < this.externalData.getArrayLength()) {
                return this.externalData.getArrayElement(n);
            }
            return Scriptable.NOT_FOUND;
        }
        Slot slot = this.slotMap.query(null, n);
        if (slot == null) {
            return Scriptable.NOT_FOUND;
        }
        return slot.getValue(scriptable);
    }

    @Override
    public Object get(Symbol symbol, Scriptable scriptable) {
        Slot slot = this.slotMap.query(symbol, 0);
        if (slot == null) {
            return Scriptable.NOT_FOUND;
        }
        return slot.getValue(scriptable);
    }

    @Override
    public void put(String string, Scriptable scriptable, Object object) {
        if (this.putImpl(string, 0, scriptable, object)) {
            return;
        }
        if (scriptable == this) {
            throw Kit.codeBug();
        }
        scriptable.put(string, scriptable, object);
    }

    @Override
    public void put(int n, Scriptable scriptable, Object object) {
        if (this.externalData != null) {
            if (n >= this.externalData.getArrayLength()) {
                throw new JavaScriptException(ScriptRuntime.newNativeError(Context.getCurrentContext(), this, TopLevel.NativeErrors.RangeError, new Object[]{"External array index out of bounds "}), null, 0);
            }
            this.externalData.setArrayElement(n, object);
            return;
        }
        if (this.putImpl(null, n, scriptable, object)) {
            return;
        }
        if (scriptable == this) {
            throw Kit.codeBug();
        }
        scriptable.put(n, scriptable, object);
    }

    @Override
    public void put(Symbol symbol, Scriptable scriptable, Object object) {
        if (this.putImpl(symbol, 0, scriptable, object)) {
            return;
        }
        if (scriptable == this) {
            throw Kit.codeBug();
        }
        ScriptableObject.ensureSymbolScriptable(scriptable).put(symbol, scriptable, object);
    }

    @Override
    public void delete(String string) {
        this.checkNotSealed(string, 0);
        this.slotMap.remove(string, 0);
    }

    @Override
    public void delete(int n) {
        this.checkNotSealed(null, n);
        this.slotMap.remove(null, n);
    }

    @Override
    public void delete(Symbol symbol) {
        this.checkNotSealed(symbol, 0);
        this.slotMap.remove(symbol, 0);
    }

    @Override
    public void putConst(String string, Scriptable scriptable, Object object) {
        if (this.putConstImpl(string, 0, scriptable, object, 1)) {
            return;
        }
        if (scriptable == this) {
            throw Kit.codeBug();
        }
        if (scriptable instanceof ConstProperties) {
            ((ConstProperties)((Object)scriptable)).putConst(string, scriptable, object);
        } else {
            scriptable.put(string, scriptable, object);
        }
    }

    @Override
    public void defineConst(String string, Scriptable scriptable) {
        if (this.putConstImpl(string, 0, scriptable, Undefined.instance, 8)) {
            return;
        }
        if (scriptable == this) {
            throw Kit.codeBug();
        }
        if (scriptable instanceof ConstProperties) {
            ((ConstProperties)((Object)scriptable)).defineConst(string, scriptable);
        }
    }

    @Override
    public boolean isConst(String string) {
        Slot slot = this.slotMap.query(string, 0);
        if (slot == null) {
            return false;
        }
        return (slot.getAttributes() & 5) == 5;
    }

    @Deprecated
    public final int getAttributes(String string, Scriptable scriptable) {
        return this.getAttributes(string);
    }

    @Deprecated
    public final int getAttributes(int n, Scriptable scriptable) {
        return this.getAttributes(n);
    }

    @Deprecated
    public final void setAttributes(String string, Scriptable scriptable, int n) {
        this.setAttributes(string, n);
    }

    @Deprecated
    public void setAttributes(int n, Scriptable scriptable, int n2) {
        this.setAttributes(n, n2);
    }

    public int getAttributes(String string) {
        return this.getAttributeSlot(string, 0).getAttributes();
    }

    public int getAttributes(int n) {
        return this.getAttributeSlot(null, n).getAttributes();
    }

    public int getAttributes(Symbol symbol) {
        return this.getAttributeSlot(symbol).getAttributes();
    }

    public void setAttributes(String string, int n) {
        this.checkNotSealed(string, 0);
        Slot slot = this.slotMap.modify(string, 0, 0);
        slot.setAttributes(n);
    }

    public void setAttributes(int n, int n2) {
        this.checkNotSealed(null, n);
        Slot slot = this.slotMap.modify(null, n, 0);
        slot.setAttributes(n2);
    }

    public void setAttributes(Symbol symbol, int n) {
        this.checkNotSealed(symbol, 0);
        Slot slot = this.slotMap.modify(symbol, 0, 0);
        slot.setAttributes(n);
    }

    public void setGetterOrSetter(String string, int n, Callable callable, boolean bl) {
        AccessorSlot accessorSlot;
        Slot slot;
        if (string != null && n != 0) {
            throw new IllegalArgumentException(string);
        }
        this.checkNotSealed(string, n);
        if (this.isExtensible()) {
            slot = this.slotMap.modify(string, n, 0);
            if (slot instanceof AccessorSlot) {
                accessorSlot = (AccessorSlot)slot;
            } else {
                accessorSlot = new AccessorSlot(slot);
                this.slotMap.replace(slot, accessorSlot);
            }
        } else {
            slot = this.slotMap.query(string, n);
            if (slot instanceof AccessorSlot) {
                accessorSlot = (AccessorSlot)slot;
            } else {
                return;
            }
        }
        int n2 = accessorSlot.getAttributes();
        if ((n2 & 1) != 0) {
            throw Context.reportRuntimeErrorById("msg.modify.readonly", string);
        }
        if (bl) {
            accessorSlot.setter = callable instanceof Function ? new AccessorSlot.FunctionSetter(callable) : null;
        } else {
            accessorSlot.getter = callable instanceof Function ? new AccessorSlot.FunctionGetter(callable) : null;
        }
        accessorSlot.value = Undefined.instance;
    }

    public Object getGetterOrSetter(String string, int n, Scriptable scriptable, boolean bl) {
        if (string != null && n != 0) {
            throw new IllegalArgumentException(string);
        }
        Slot slot = this.slotMap.query(string, n);
        if (slot == null) {
            return null;
        }
        Function function = bl ? slot.getSetterFunction(string, scriptable) : slot.getGetterFunction(string, scriptable);
        return function == null ? Undefined.instance : function;
    }

    @Deprecated
    public Object getGetterOrSetter(String string, int n, boolean bl) {
        return this.getGetterOrSetter(string, n, this, bl);
    }

    protected boolean isGetterOrSetter(String string, int n, boolean bl) {
        Slot slot = this.slotMap.query(string, n);
        return slot != null && slot.isSetterSlot();
    }

    void addLazilyInitializedValue(String string, int n, LazilyLoadedCtor lazilyLoadedCtor, int n2) {
        LazyLoadSlot lazyLoadSlot;
        if (string != null && n != 0) {
            throw new IllegalArgumentException(string);
        }
        this.checkNotSealed(string, n);
        Slot slot = this.slotMap.modify(string, n, 0);
        if (slot instanceof LazyLoadSlot) {
            lazyLoadSlot = (LazyLoadSlot)slot;
        } else {
            lazyLoadSlot = new LazyLoadSlot(slot);
            this.slotMap.replace(slot, lazyLoadSlot);
        }
        lazyLoadSlot.setAttributes(n2);
        lazyLoadSlot.value = lazilyLoadedCtor;
    }

    public void setExternalArrayData(ExternalArrayData externalArrayData) {
        this.externalData = externalArrayData;
        if (externalArrayData == null) {
            this.delete("length");
        } else {
            this.defineProperty("length", null, GET_ARRAY_LENGTH, null, 3);
        }
    }

    public ExternalArrayData getExternalArrayData() {
        return this.externalData;
    }

    public Object getExternalArrayLength() {
        return this.externalData == null ? 0 : this.externalData.getArrayLength();
    }

    @Override
    public Scriptable getPrototype() {
        return this.prototypeObject;
    }

    @Override
    public void setPrototype(Scriptable scriptable) {
        this.prototypeObject = scriptable;
    }

    @Override
    public Scriptable getParentScope() {
        return this.parentScopeObject;
    }

    @Override
    public void setParentScope(Scriptable scriptable) {
        this.parentScopeObject = scriptable;
    }

    @Override
    public Object[] getIds() {
        return this.getIds(false, false);
    }

    @Override
    public Object[] getAllIds() {
        return this.getIds(true, false);
    }

    @Override
    public Object getDefaultValue(Class<?> clazz) {
        return ScriptableObject.getDefaultValue(this, clazz);
    }

    public static Object getDefaultValue(Scriptable scriptable, Class<?> clazz) {
        Context context = null;
        for (int i = 0; i < 2; ++i) {
            Object object;
            boolean bl = clazz == ScriptRuntime.StringClass ? i == 0 : i == 1;
            String string = bl ? "toString" : "valueOf";
            Object object2 = ScriptableObject.getProperty(scriptable, string);
            if (!(object2 instanceof Function)) continue;
            Function function = (Function)object2;
            if (context == null) {
                context = Context.getContext();
            }
            if ((object2 = function.call(context, function.getParentScope(), scriptable, ScriptRuntime.emptyArgs)) == null) continue;
            if (!(object2 instanceof Scriptable)) {
                return object2;
            }
            if (clazz == ScriptRuntime.ScriptableClass || clazz == ScriptRuntime.FunctionClass) {
                return object2;
            }
            if (!bl || !(object2 instanceof Wrapper) || !((object = ((Wrapper)object2).unwrap()) instanceof String)) continue;
            return object;
        }
        String string = clazz == null ? "undefined" : clazz.getName();
        throw ScriptRuntime.typeErrorById("msg.default.value", string);
    }

    @Override
    public boolean hasInstance(Scriptable scriptable) {
        return ScriptRuntime.jsDelegatesTo(scriptable, this);
    }

    public boolean avoidObjectDetection() {
        return false;
    }

    protected Object equivalentValues(Object object) {
        return this == object ? Boolean.TRUE : Scriptable.NOT_FOUND;
    }

    public static <T extends Scriptable> void defineClass(Scriptable scriptable, Class<T> clazz) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        ScriptableObject.defineClass(scriptable, clazz, false, false);
    }

    public static <T extends Scriptable> void defineClass(Scriptable scriptable, Class<T> clazz, boolean bl) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        ScriptableObject.defineClass(scriptable, clazz, bl, false);
    }

    public static <T extends Scriptable> String defineClass(Scriptable scriptable, Class<T> clazz, boolean bl, boolean bl2) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        BaseFunction baseFunction = ScriptableObject.buildClassCtor(scriptable, clazz, bl, bl2);
        if (baseFunction == null) {
            return null;
        }
        String string = baseFunction.getClassPrototype().getClassName();
        ScriptableObject.defineProperty(scriptable, string, baseFunction, 2);
        return string;
    }

    /*
     * WARNING - void declaration
     */
    static <T extends Scriptable> BaseFunction buildClassCtor(Scriptable scriptable, Class<T> clazz, boolean bl, boolean bl2) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        FunctionObject functionObject;
        void var10_25;
        void var10_23;
        Object object;
        String string;
        Object object2;
        Object object3;
        AccessibleObject[] accessibleObjectArray = FunctionObject.getMethodList(clazz);
        for (Method method : accessibleObjectArray) {
            if (!method.getName().equals("init")) continue;
            Class<?>[] classArray = method.getParameterTypes();
            if (classArray.length == 3 && classArray[0] == ScriptRuntime.ContextClass && classArray[1] == ScriptRuntime.ScriptableClass && classArray[2] == Boolean.TYPE && Modifier.isStatic(method.getModifiers())) {
                Object[] objectArray = new Object[]{Context.getContext(), scriptable, bl ? Boolean.TRUE : Boolean.FALSE};
                method.invoke(null, objectArray);
                return null;
            }
            if (classArray.length != 1 || classArray[0] != ScriptRuntime.ScriptableClass || !Modifier.isStatic(method.getModifiers())) continue;
            Object[] objectArray = new Object[]{scriptable};
            method.invoke(null, objectArray);
            return null;
        }
        Executable[] executableArray = clazz.getConstructors();
        Executable executable = null;
        for (Executable object32 : executableArray) {
            if (((Constructor)object32).getParameterTypes().length != 0) continue;
            executable = object32;
            break;
        }
        if (executable == null) {
            throw Context.reportRuntimeErrorById("msg.zero.arg.ctor", clazz.getName());
        }
        Scriptable scriptable2 = (Scriptable)executable.newInstance(ScriptRuntime.emptyArgs);
        String string2 = scriptable2.getClassName();
        Object object4 = ScriptableObject.getProperty(ScriptableObject.getTopLevelScope(scriptable), string2);
        if (object4 instanceof BaseFunction && (object3 = ((BaseFunction)object4).getPrototypeProperty()) != null && clazz.equals(object3.getClass())) {
            return (BaseFunction)object4;
        }
        Object var10_21 = null;
        if (bl2 && ScriptRuntime.ScriptableClass.isAssignableFrom((Class<?>)(object2 = clazz.getSuperclass())) && !Modifier.isAbstract(((Class)object2).getModifiers()) && (string = ScriptableObject.defineClass(scriptable, object = ScriptableObject.extendsScriptable(object2), bl, bl2)) != null) {
            Scriptable scriptable3 = ScriptableObject.getClassPrototype(scriptable, string);
        }
        if (var10_23 == null) {
            Scriptable scriptable4 = ScriptableObject.getObjectPrototype(scriptable);
        }
        scriptable2.setPrototype((Scriptable)var10_25);
        object2 = "jsFunction_";
        object = "jsStaticFunction_";
        string = "jsGet_";
        String string3 = "jsSet_";
        String string4 = "jsConstructor";
        Member member = ScriptableObject.findAnnotatedMember(accessibleObjectArray, JSConstructor.class);
        if (member == null) {
            member = ScriptableObject.findAnnotatedMember(executableArray, JSConstructor.class);
        }
        if (member == null) {
            member = FunctionObject.findSingleMethod((Method[])accessibleObjectArray, "jsConstructor");
        }
        if (member == null) {
            if (executableArray.length == 1) {
                member = executableArray[0];
            } else if (executableArray.length == 2) {
                if (((Constructor)executableArray[0]).getParameterTypes().length == 0) {
                    member = executableArray[1];
                } else if (((Constructor)executableArray[1]).getParameterTypes().length == 0) {
                    member = executableArray[0];
                }
            }
            if (member == null) {
                throw Context.reportRuntimeErrorById("msg.ctor.multiple.parms", clazz.getName());
            }
        }
        if ((functionObject = new FunctionObject(string2, member, scriptable)).isVarArgsMethod()) {
            throw Context.reportRuntimeErrorById("msg.varargs.ctor", member.getName());
        }
        functionObject.initAsConstructor(scriptable, scriptable2, 7);
        AccessibleObject accessibleObject = null;
        HashSet<String> hashSet = new HashSet<String>();
        HashSet hashSet2 = new HashSet();
        for (AccessibleObject accessibleObject2 : accessibleObjectArray) {
            Object object5;
            String string5;
            boolean bl3;
            HashSet<String> hashSet3;
            Object object6;
            if (accessibleObject2 == member) continue;
            String string6 = ((Method)accessibleObject2).getName();
            if (string6.equals("finishInit") && ((Class<?>[])(object6 = ((Method)accessibleObject2).getParameterTypes())).length == 3 && object6[0] == ScriptRuntime.ScriptableClass && object6[1] == FunctionObject.class && object6[2] == ScriptRuntime.ScriptableClass && Modifier.isStatic(((Method)accessibleObject2).getModifiers())) {
                accessibleObject = accessibleObject2;
                continue;
            }
            if (string6.indexOf(36) != -1 || string6.equals("jsConstructor")) continue;
            object6 = null;
            String string7 = null;
            if (accessibleObject2.isAnnotationPresent(JSFunction.class)) {
                object6 = ((Method)accessibleObject2).getAnnotation(JSFunction.class);
            } else if (accessibleObject2.isAnnotationPresent(JSStaticFunction.class)) {
                object6 = ((Method)accessibleObject2).getAnnotation(JSStaticFunction.class);
            } else if (accessibleObject2.isAnnotationPresent(JSGetter.class)) {
                object6 = ((Method)accessibleObject2).getAnnotation(JSGetter.class);
            } else if (accessibleObject2.isAnnotationPresent(JSSetter.class)) continue;
            if (object6 == null) {
                if (string6.startsWith("jsFunction_")) {
                    string7 = "jsFunction_";
                } else if (string6.startsWith("jsStaticFunction_")) {
                    string7 = "jsStaticFunction_";
                } else {
                    if (!string6.startsWith("jsGet_")) continue;
                    string7 = "jsGet_";
                }
            }
            if ((hashSet3 = (bl3 = object6 instanceof JSStaticFunction || string7 == "jsStaticFunction_") ? hashSet : hashSet2).contains(string5 = ScriptableObject.getPropertyName(string6, string7, object6))) {
                throw Context.reportRuntimeErrorById("duplicate.defineClass.name", string6, string5);
            }
            hashSet3.add(string5);
            string6 = string5;
            if (object6 instanceof JSGetter || string7 == "jsGet_") {
                if (!(scriptable2 instanceof ScriptableObject)) {
                    throw Context.reportRuntimeErrorById("msg.extend.scriptable", scriptable2.getClass().toString(), string6);
                }
                object5 = ScriptableObject.findSetterMethod((Method[])accessibleObjectArray, string6, "jsSet_");
                int n = 6 | (object5 != null ? 0 : 1);
                ((ScriptableObject)scriptable2).defineProperty(string6, null, (Method)accessibleObject2, (Method)object5, n);
                continue;
            }
            if (bl3 && !Modifier.isStatic(((Method)accessibleObject2).getModifiers())) {
                throw Context.reportRuntimeError("jsStaticFunction must be used with static method.");
            }
            object5 = new FunctionObject(string6, (Member)((Object)accessibleObject2), scriptable2);
            if (((FunctionObject)object5).isVarArgsConstructor()) {
                throw Context.reportRuntimeErrorById("msg.varargs.fun", member.getName());
            }
            ScriptableObject.defineProperty((Scriptable)(bl3 ? functionObject : scriptable2), string6, object5, 2);
            if (!bl) continue;
            ((ScriptableObject)object5).sealObject();
        }
        if (accessibleObject != null) {
            Object[] objectArray = new Object[]{scriptable, functionObject, scriptable2};
            accessibleObject.invoke(null, objectArray);
        }
        if (bl) {
            functionObject.sealObject();
            if (scriptable2 instanceof ScriptableObject) {
                ((ScriptableObject)scriptable2).sealObject();
            }
        }
        return functionObject;
    }

    private static Member findAnnotatedMember(AccessibleObject[] accessibleObjectArray, Class<? extends Annotation> clazz) {
        for (AccessibleObject accessibleObject : accessibleObjectArray) {
            if (!accessibleObject.isAnnotationPresent(clazz)) continue;
            return (Member)((Object)accessibleObject);
        }
        return null;
    }

    private static Method findSetterMethod(Method[] methodArray, String string, String string2) {
        String string3 = "set" + Character.toUpperCase(string.charAt(0)) + string.substring(1);
        for (Method method : methodArray) {
            JSSetter object = method.getAnnotation(JSSetter.class);
            if (object == null || !string.equals(object.value()) && (!"".equals(object.value()) || !string3.equals(method.getName()))) continue;
            return method;
        }
        String string4 = string2 + string;
        for (Method method : methodArray) {
            if (!string4.equals(method.getName())) continue;
            return method;
        }
        return null;
    }

    private static String getPropertyName(String string, String string2, Annotation annotation) {
        if (string2 != null) {
            return string.substring(string2.length());
        }
        String string3 = null;
        if (annotation instanceof JSGetter) {
            string3 = ((JSGetter)annotation).value();
            if ((string3 == null || string3.length() == 0) && string.length() > 3 && string.startsWith("get") && Character.isUpperCase((string3 = string.substring(3)).charAt(0))) {
                if (string3.length() == 1) {
                    string3 = string3.toLowerCase();
                } else if (!Character.isUpperCase(string3.charAt(1))) {
                    string3 = Character.toLowerCase(string3.charAt(0)) + string3.substring(1);
                }
            }
        } else if (annotation instanceof JSFunction) {
            string3 = ((JSFunction)annotation).value();
        } else if (annotation instanceof JSStaticFunction) {
            string3 = ((JSStaticFunction)annotation).value();
        }
        if (string3 == null || string3.length() == 0) {
            string3 = string;
        }
        return string3;
    }

    private static <T extends Scriptable> Class<T> extendsScriptable(Class<?> clazz) {
        if (ScriptRuntime.ScriptableClass.isAssignableFrom(clazz)) {
            return clazz;
        }
        return null;
    }

    public void defineProperty(String string, Object object, int n) {
        this.checkNotSealed(string, 0);
        this.put(string, (Scriptable)this, object);
        this.setAttributes(string, n);
    }

    public void defineProperty(Symbol symbol, Object object, int n) {
        this.checkNotSealed(symbol, 0);
        this.put(symbol, (Scriptable)this, object);
        this.setAttributes(symbol, n);
    }

    public static void defineProperty(Scriptable scriptable, String string, Object object, int n) {
        if (!(scriptable instanceof ScriptableObject)) {
            scriptable.put(string, scriptable, object);
            return;
        }
        ScriptableObject scriptableObject = (ScriptableObject)scriptable;
        scriptableObject.defineProperty(string, object, n);
    }

    protected void defineProperty(Scriptable scriptable, String string, int n, Callable callable, int n2, int n3) {
        LambdaFunction lambdaFunction = new LambdaFunction(scriptable, string, n, callable);
        lambdaFunction.setStandardPropertyAttributes(n3);
        this.defineProperty(string, (Object)lambdaFunction, n2);
    }

    public static void defineConstProperty(Scriptable scriptable, String string) {
        if (scriptable instanceof ConstProperties) {
            ConstProperties constProperties = (ConstProperties)((Object)scriptable);
            constProperties.defineConst(string, scriptable);
        } else {
            ScriptableObject.defineProperty(scriptable, string, Undefined.instance, 13);
        }
    }

    public void defineProperty(String string, Class<?> clazz, int n) {
        int n2 = string.length();
        if (n2 == 0) {
            throw new IllegalArgumentException();
        }
        char[] cArray = new char[3 + n2];
        string.getChars(0, n2, cArray, 3);
        cArray[3] = Character.toUpperCase(cArray[3]);
        cArray[0] = 103;
        cArray[1] = 101;
        cArray[2] = 116;
        String string2 = new String(cArray);
        cArray[0] = 115;
        String string3 = new String(cArray);
        Method[] methodArray = FunctionObject.getMethodList(clazz);
        Method method = FunctionObject.findSingleMethod(methodArray, string2);
        Method method2 = FunctionObject.findSingleMethod(methodArray, string3);
        if (method2 == null) {
            n |= 1;
        }
        this.defineProperty(string, null, method, method2 == null ? null : method2, n);
    }

    public void defineProperty(String string, Object object, Method method, Method method2, int n) {
        Slot slot;
        Object object2;
        Object object3;
        MemberBox memberBox = null;
        if (method != null) {
            boolean bl;
            memberBox = new MemberBox(method);
            if (!Modifier.isStatic(method.getModifiers())) {
                bl = object != null;
                memberBox.delegateTo = object;
            } else {
                bl = true;
                memberBox.delegateTo = Void.TYPE;
            }
            String string2 = null;
            object3 = method.getParameterTypes();
            if (((Class<?>[])object3).length == 0) {
                if (bl) {
                    string2 = "msg.obj.getter.parms";
                }
            } else if (((Class<?>[])object3).length == 1) {
                object2 = object3[0];
                if (object2 != ScriptRuntime.ScriptableClass && object2 != ScriptRuntime.ScriptableObjectClass) {
                    string2 = "msg.bad.getter.parms";
                } else if (!bl) {
                    string2 = "msg.bad.getter.parms";
                }
            } else {
                string2 = "msg.bad.getter.parms";
            }
            if (string2 != null) {
                throw Context.reportRuntimeErrorById(string2, method.toString());
            }
        }
        MemberBox memberBox2 = null;
        if (method2 != null) {
            boolean bl;
            if (method2.getReturnType() != Void.TYPE) {
                throw Context.reportRuntimeErrorById("msg.setter.return", method2.toString());
            }
            memberBox2 = new MemberBox(method2);
            if (!Modifier.isStatic(method2.getModifiers())) {
                bl = object != null;
                memberBox2.delegateTo = object;
            } else {
                bl = true;
                memberBox2.delegateTo = Void.TYPE;
            }
            object3 = null;
            object2 = method2.getParameterTypes();
            if (((Class<?>[])object2).length == 1) {
                if (bl) {
                    object3 = "msg.setter2.expected";
                }
            } else if (((Class<?>[])object2).length == 2) {
                Class<?> clazz = object2[0];
                if (clazz != ScriptRuntime.ScriptableClass && clazz != ScriptRuntime.ScriptableObjectClass) {
                    object3 = "msg.setter2.parms";
                } else if (!bl) {
                    object3 = "msg.setter1.parms";
                }
            } else {
                object3 = "msg.setter.parms";
            }
            if (object3 != null) {
                throw Context.reportRuntimeErrorById(object3, new Object[]{method2.toString()});
            }
        }
        if ((slot = this.slotMap.modify(string, 0, 0)) instanceof AccessorSlot) {
            object3 = (Class<?>[])slot;
        } else {
            object3 = new AccessorSlot(slot);
            this.slotMap.replace(slot, (Slot)object3);
        }
        object3.setAttributes(n);
        if (memberBox != null) {
            object3.getter = new AccessorSlot.MemberBoxGetter(memberBox);
        }
        if (memberBox2 != null) {
            object3.setter = new AccessorSlot.MemberBoxSetter(memberBox2);
        }
    }

    public void defineOwnProperties(Context context, ScriptableObject scriptableObject) {
        int n;
        Object[] objectArray = scriptableObject.getIds(false, true);
        ScriptableObject[] scriptableObjectArray = new ScriptableObject[objectArray.length];
        int n2 = objectArray.length;
        for (n = 0; n < n2; ++n) {
            Object object = ScriptRuntime.getObjectElem(scriptableObject, objectArray[n], context);
            ScriptableObject scriptableObject2 = ScriptableObject.ensureScriptableObject(object);
            this.checkPropertyDefinition(scriptableObject2);
            scriptableObjectArray[n] = scriptableObject2;
        }
        n2 = objectArray.length;
        for (n = 0; n < n2; ++n) {
            this.defineOwnProperty(context, objectArray[n], scriptableObjectArray[n]);
        }
    }

    public void defineOwnProperty(Context context, Object object, ScriptableObject scriptableObject) {
        this.checkPropertyDefinition(scriptableObject);
        this.defineOwnProperty(context, object, scriptableObject, true);
    }

    protected void defineOwnProperty(Context context, Object object, ScriptableObject scriptableObject, boolean bl) {
        int n;
        boolean bl2;
        Object object2;
        Object object3 = null;
        int n2 = 0;
        if (object instanceof Symbol) {
            object3 = object;
        } else {
            object2 = ScriptRuntime.toStringIdOrIndex(object);
            if (((ScriptRuntime.StringIdOrIndex)object2).stringId == null) {
                n2 = ((ScriptRuntime.StringIdOrIndex)object2).index;
            } else {
                object3 = ((ScriptRuntime.StringIdOrIndex)object2).stringId;
            }
        }
        object2 = this.slotMap.query(object3, n2);
        boolean bl3 = bl2 = object2 == null;
        if (bl) {
            ScriptableObject scriptableObject2 = object2 == null ? null : ((Slot)object2).getPropertyDescriptor(context, this);
            this.checkPropertyChange(object, scriptableObject2, scriptableObject);
        }
        boolean bl4 = ScriptableObject.isAccessorDescriptor(scriptableObject);
        if (object2 == null) {
            object2 = this.slotMap.modify(object3, n2, 0);
            n = this.applyDescriptorToAttributeBitset(7, scriptableObject);
        } else {
            n = this.applyDescriptorToAttributeBitset(((Slot)object2).getAttributes(), scriptableObject);
        }
        if (bl4) {
            Object object4;
            AccessorSlot accessorSlot;
            if (object2 instanceof AccessorSlot) {
                accessorSlot = (AccessorSlot)object2;
            } else {
                accessorSlot = new AccessorSlot((Slot)object2);
                this.slotMap.replace((Slot)object2, accessorSlot);
            }
            Object object5 = ScriptableObject.getProperty((Scriptable)scriptableObject, "get");
            if (object5 != NOT_FOUND) {
                accessorSlot.getter = new AccessorSlot.FunctionGetter(object5);
            }
            if ((object4 = ScriptableObject.getProperty((Scriptable)scriptableObject, "set")) != NOT_FOUND) {
                accessorSlot.setter = new AccessorSlot.FunctionSetter(object4);
            }
            accessorSlot.value = Undefined.instance;
            accessorSlot.setAttributes(n);
        } else {
            Object object6;
            if (!((Slot)object2).isValueSlot() && ScriptableObject.isDataDescriptor(scriptableObject)) {
                object6 = new Slot((Slot)object2);
                this.slotMap.replace((Slot)object2, (Slot)object6);
                object2 = object6;
            }
            if ((object6 = ScriptableObject.getProperty((Scriptable)scriptableObject, "value")) != NOT_FOUND) {
                ((Slot)object2).value = object6;
            } else if (bl2) {
                ((Slot)object2).value = Undefined.instance;
            }
            ((Slot)object2).setAttributes(n);
        }
    }

    public void defineProperty(String string, Supplier<Object> supplier, Consumer<Object> consumer, int n) {
        LambdaSlot lambdaSlot;
        Slot slot = this.slotMap.modify(string, 0, n);
        if (slot instanceof LambdaSlot) {
            lambdaSlot = (LambdaSlot)slot;
        } else {
            lambdaSlot = new LambdaSlot(slot);
            this.slotMap.replace(slot, lambdaSlot);
        }
        lambdaSlot.getter = supplier;
        lambdaSlot.setter = consumer;
        this.setAttributes(string, n);
    }

    protected void checkPropertyDefinition(ScriptableObject scriptableObject) {
        Object object = ScriptableObject.getProperty((Scriptable)scriptableObject, "get");
        if (object != NOT_FOUND && object != Undefined.instance && !(object instanceof Callable)) {
            throw ScriptRuntime.notFunctionError(object);
        }
        Object object2 = ScriptableObject.getProperty((Scriptable)scriptableObject, "set");
        if (object2 != NOT_FOUND && object2 != Undefined.instance && !(object2 instanceof Callable)) {
            throw ScriptRuntime.notFunctionError(object2);
        }
        if (ScriptableObject.isDataDescriptor(scriptableObject) && ScriptableObject.isAccessorDescriptor(scriptableObject)) {
            throw ScriptRuntime.typeErrorById("msg.both.data.and.accessor.desc", new Object[0]);
        }
    }

    protected void checkPropertyChange(Object object, ScriptableObject scriptableObject, ScriptableObject scriptableObject2) {
        if (scriptableObject == null) {
            if (!this.isExtensible()) {
                throw ScriptRuntime.typeErrorById("msg.not.extensible", new Object[0]);
            }
        } else if (ScriptableObject.isFalse(scriptableObject.get("configurable", (Scriptable)scriptableObject))) {
            if (ScriptableObject.isTrue(ScriptableObject.getProperty((Scriptable)scriptableObject2, "configurable"))) {
                throw ScriptRuntime.typeErrorById("msg.change.configurable.false.to.true", object);
            }
            if (ScriptableObject.isTrue(scriptableObject.get("enumerable", (Scriptable)scriptableObject)) != ScriptableObject.isTrue(ScriptableObject.getProperty((Scriptable)scriptableObject2, "enumerable"))) {
                throw ScriptRuntime.typeErrorById("msg.change.enumerable.with.configurable.false", object);
            }
            boolean bl = ScriptableObject.isDataDescriptor(scriptableObject2);
            boolean bl2 = ScriptableObject.isAccessorDescriptor(scriptableObject2);
            if (bl || bl2) {
                if (bl && ScriptableObject.isDataDescriptor(scriptableObject)) {
                    if (ScriptableObject.isFalse(scriptableObject.get("writable", (Scriptable)scriptableObject))) {
                        if (ScriptableObject.isTrue(ScriptableObject.getProperty((Scriptable)scriptableObject2, "writable"))) {
                            throw ScriptRuntime.typeErrorById("msg.change.writable.false.to.true.with.configurable.false", object);
                        }
                        if (!this.sameValue(ScriptableObject.getProperty((Scriptable)scriptableObject2, "value"), scriptableObject.get("value", (Scriptable)scriptableObject))) {
                            throw ScriptRuntime.typeErrorById("msg.change.value.with.writable.false", object);
                        }
                    }
                } else if (bl2 && ScriptableObject.isAccessorDescriptor(scriptableObject)) {
                    if (!this.sameValue(ScriptableObject.getProperty((Scriptable)scriptableObject2, "set"), scriptableObject.get("set", (Scriptable)scriptableObject))) {
                        throw ScriptRuntime.typeErrorById("msg.change.setter.with.configurable.false", object);
                    }
                    if (!this.sameValue(ScriptableObject.getProperty((Scriptable)scriptableObject2, "get"), scriptableObject.get("get", (Scriptable)scriptableObject))) {
                        throw ScriptRuntime.typeErrorById("msg.change.getter.with.configurable.false", object);
                    }
                } else {
                    if (ScriptableObject.isDataDescriptor(scriptableObject)) {
                        throw ScriptRuntime.typeErrorById("msg.change.property.data.to.accessor.with.configurable.false", object);
                    }
                    throw ScriptRuntime.typeErrorById("msg.change.property.accessor.to.data.with.configurable.false", object);
                }
            }
        }
    }

    protected static boolean isTrue(Object object) {
        return object != NOT_FOUND && ScriptRuntime.toBoolean(object);
    }

    protected static boolean isFalse(Object object) {
        return !ScriptableObject.isTrue(object);
    }

    protected boolean sameValue(Object object, Object object2) {
        if (object == NOT_FOUND) {
            return true;
        }
        if (object2 == NOT_FOUND) {
            object2 = Undefined.instance;
        }
        if (object2 instanceof Number && object instanceof Number) {
            double d = ((Number)object2).doubleValue();
            double d2 = ((Number)object).doubleValue();
            if (Double.isNaN(d) && Double.isNaN(d2)) {
                return true;
            }
            if (d == 0.0 && Double.doubleToLongBits(d) != Double.doubleToLongBits(d2)) {
                return false;
            }
        }
        return ScriptRuntime.shallowEq(object2, object);
    }

    protected int applyDescriptorToAttributeBitset(int n, ScriptableObject scriptableObject) {
        Object object;
        Object object2;
        Object object3 = ScriptableObject.getProperty((Scriptable)scriptableObject, "enumerable");
        if (object3 != NOT_FOUND) {
            int n2 = n = ScriptRuntime.toBoolean(object3) ? n & 0xFFFFFFFD : n | 2;
        }
        if ((object2 = ScriptableObject.getProperty((Scriptable)scriptableObject, "writable")) != NOT_FOUND) {
            int n3 = n = ScriptRuntime.toBoolean(object2) ? n & 0xFFFFFFFE : n | 1;
        }
        if ((object = ScriptableObject.getProperty((Scriptable)scriptableObject, "configurable")) != NOT_FOUND) {
            n = ScriptRuntime.toBoolean(object) ? n & 0xFFFFFFFB : n | 4;
        }
        return n;
    }

    protected static boolean isDataDescriptor(ScriptableObject scriptableObject) {
        return ScriptableObject.hasProperty((Scriptable)scriptableObject, "value") || ScriptableObject.hasProperty((Scriptable)scriptableObject, "writable");
    }

    protected static boolean isAccessorDescriptor(ScriptableObject scriptableObject) {
        return ScriptableObject.hasProperty((Scriptable)scriptableObject, "get") || ScriptableObject.hasProperty((Scriptable)scriptableObject, "set");
    }

    protected boolean isGenericDescriptor(ScriptableObject scriptableObject) {
        return !ScriptableObject.isDataDescriptor(scriptableObject) && !ScriptableObject.isAccessorDescriptor(scriptableObject);
    }

    protected static Scriptable ensureScriptable(Object object) {
        if (!(object instanceof Scriptable)) {
            throw ScriptRuntime.typeErrorById("msg.arg.not.object", ScriptRuntime.typeof(object));
        }
        return (Scriptable)object;
    }

    protected static SymbolScriptable ensureSymbolScriptable(Object object) {
        if (!(object instanceof SymbolScriptable)) {
            throw ScriptRuntime.typeErrorById("msg.object.not.symbolscriptable", ScriptRuntime.typeof(object));
        }
        return (SymbolScriptable)object;
    }

    protected static ScriptableObject ensureScriptableObject(Object object) {
        if (object instanceof ScriptableObject) {
            return (ScriptableObject)object;
        }
        if (object instanceof Delegator) {
            return (ScriptableObject)((Delegator)object).getDelegee();
        }
        throw ScriptRuntime.typeErrorById("msg.arg.not.object", ScriptRuntime.typeof(object));
    }

    public void defineFunctionProperties(String[] stringArray, Class<?> clazz, int n) {
        Method[] methodArray = FunctionObject.getMethodList(clazz);
        for (String string : stringArray) {
            Method method = FunctionObject.findSingleMethod(methodArray, string);
            if (method == null) {
                throw Context.reportRuntimeErrorById("msg.method.not.found", string, clazz.getName());
            }
            FunctionObject functionObject = new FunctionObject(string, method, this);
            this.defineProperty(string, (Object)functionObject, n);
        }
    }

    public static Scriptable getObjectPrototype(Scriptable scriptable) {
        return TopLevel.getBuiltinPrototype(ScriptableObject.getTopLevelScope(scriptable), TopLevel.Builtins.Object);
    }

    public static Scriptable getFunctionPrototype(Scriptable scriptable) {
        return TopLevel.getBuiltinPrototype(ScriptableObject.getTopLevelScope(scriptable), TopLevel.Builtins.Function);
    }

    public static Scriptable getGeneratorFunctionPrototype(Scriptable scriptable) {
        return TopLevel.getBuiltinPrototype(ScriptableObject.getTopLevelScope(scriptable), TopLevel.Builtins.GeneratorFunction);
    }

    public static Scriptable getArrayPrototype(Scriptable scriptable) {
        return TopLevel.getBuiltinPrototype(ScriptableObject.getTopLevelScope(scriptable), TopLevel.Builtins.Array);
    }

    public static Scriptable getClassPrototype(Scriptable scriptable, String string) {
        Object object;
        Object object2 = ScriptableObject.getProperty(scriptable = ScriptableObject.getTopLevelScope(scriptable), string);
        if (object2 instanceof BaseFunction) {
            object = ((BaseFunction)object2).getPrototypeProperty();
        } else if (object2 instanceof Scriptable) {
            Scriptable scriptable2 = (Scriptable)object2;
            object = scriptable2.get("prototype", scriptable2);
        } else {
            return null;
        }
        if (object instanceof Scriptable) {
            return (Scriptable)object;
        }
        return null;
    }

    public static Scriptable getTopLevelScope(Scriptable scriptable) {
        Scriptable scriptable2;
        while ((scriptable2 = scriptable.getParentScope()) != null) {
            scriptable = scriptable2;
        }
        return scriptable;
    }

    public boolean isExtensible() {
        return this.isExtensible;
    }

    public void preventExtensions() {
        this.isExtensible = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sealObject() {
        if (!this.isSealed) {
            long l = this.slotMap.readLock();
            try {
                for (Slot slot : this.slotMap) {
                    Object object = slot.value;
                    if (!(object instanceof LazilyLoadedCtor)) continue;
                    LazilyLoadedCtor lazilyLoadedCtor = (LazilyLoadedCtor)object;
                    try {
                        lazilyLoadedCtor.init();
                    }
                    finally {
                        slot.value = lazilyLoadedCtor.getValue();
                    }
                }
                this.isSealed = true;
            }
            finally {
                this.slotMap.unlockRead(l);
            }
        }
    }

    public final boolean isSealed() {
        return this.isSealed;
    }

    private void checkNotSealed(Object object, int n) {
        if (!this.isSealed()) {
            return;
        }
        String string = object != null ? object.toString() : Integer.toString(n);
        throw Context.reportRuntimeErrorById("msg.modify.sealed", string);
    }

    public static Object getProperty(Scriptable scriptable, String string) {
        Object object;
        Scriptable scriptable2 = scriptable;
        while ((object = scriptable.get(string, scriptable2)) == Scriptable.NOT_FOUND && (scriptable = scriptable.getPrototype()) != null) {
        }
        return object;
    }

    public static Object getProperty(Scriptable scriptable, Symbol symbol) {
        Object object;
        Scriptable scriptable2 = scriptable;
        while ((object = ScriptableObject.ensureSymbolScriptable(scriptable).get(symbol, scriptable2)) == Scriptable.NOT_FOUND && (scriptable = scriptable.getPrototype()) != null) {
        }
        return object;
    }

    public static <T> T getTypedProperty(Scriptable scriptable, int n, Class<T> clazz) {
        Object object = ScriptableObject.getProperty(scriptable, n);
        if (object == Scriptable.NOT_FOUND) {
            object = null;
        }
        return clazz.cast(Context.jsToJava(object, clazz));
    }

    public static Object getProperty(Scriptable scriptable, int n) {
        Object object;
        Scriptable scriptable2 = scriptable;
        while ((object = scriptable.get(n, scriptable2)) == Scriptable.NOT_FOUND && (scriptable = scriptable.getPrototype()) != null) {
        }
        return object;
    }

    public static <T> T getTypedProperty(Scriptable scriptable, String string, Class<T> clazz) {
        Object object = ScriptableObject.getProperty(scriptable, string);
        if (object == Scriptable.NOT_FOUND) {
            object = null;
        }
        return clazz.cast(Context.jsToJava(object, clazz));
    }

    public static boolean hasProperty(Scriptable scriptable, String string) {
        return null != ScriptableObject.getBase(scriptable, string);
    }

    public static void redefineProperty(Scriptable scriptable, String string, boolean bl) {
        ConstProperties constProperties;
        Scriptable scriptable2 = ScriptableObject.getBase(scriptable, string);
        if (scriptable2 == null) {
            return;
        }
        if (scriptable2 instanceof ConstProperties && (constProperties = (ConstProperties)((Object)scriptable2)).isConst(string)) {
            throw ScriptRuntime.typeErrorById("msg.const.redecl", string);
        }
        if (bl) {
            throw ScriptRuntime.typeErrorById("msg.var.redecl", string);
        }
    }

    public static boolean hasProperty(Scriptable scriptable, int n) {
        return null != ScriptableObject.getBase(scriptable, n);
    }

    public static boolean hasProperty(Scriptable scriptable, Symbol symbol) {
        return null != ScriptableObject.getBase(scriptable, symbol);
    }

    public static void putProperty(Scriptable scriptable, String string, Object object) {
        Scriptable scriptable2 = ScriptableObject.getBase(scriptable, string);
        if (scriptable2 == null) {
            scriptable2 = scriptable;
        }
        scriptable2.put(string, scriptable, object);
    }

    public static void putProperty(Scriptable scriptable, Symbol symbol, Object object) {
        Scriptable scriptable2 = ScriptableObject.getBase(scriptable, symbol);
        if (scriptable2 == null) {
            scriptable2 = scriptable;
        }
        ScriptableObject.ensureSymbolScriptable(scriptable2).put(symbol, scriptable, object);
    }

    public static void putConstProperty(Scriptable scriptable, String string, Object object) {
        Scriptable scriptable2 = ScriptableObject.getBase(scriptable, string);
        if (scriptable2 == null) {
            scriptable2 = scriptable;
        }
        if (scriptable2 instanceof ConstProperties) {
            ((ConstProperties)((Object)scriptable2)).putConst(string, scriptable, object);
        }
    }

    public static void putProperty(Scriptable scriptable, int n, Object object) {
        Scriptable scriptable2 = ScriptableObject.getBase(scriptable, n);
        if (scriptable2 == null) {
            scriptable2 = scriptable;
        }
        scriptable2.put(n, scriptable, object);
    }

    public static boolean deleteProperty(Scriptable scriptable, String string) {
        Scriptable scriptable2 = ScriptableObject.getBase(scriptable, string);
        if (scriptable2 == null) {
            return true;
        }
        scriptable2.delete(string);
        return !scriptable2.has(string, scriptable);
    }

    public static boolean deleteProperty(Scriptable scriptable, int n) {
        Scriptable scriptable2 = ScriptableObject.getBase(scriptable, n);
        if (scriptable2 == null) {
            return true;
        }
        scriptable2.delete(n);
        return !scriptable2.has(n, scriptable);
    }

    public static Object[] getPropertyIds(Scriptable scriptable) {
        if (scriptable == null) {
            return ScriptRuntime.emptyArgs;
        }
        Object[] objectArray = scriptable.getIds();
        ObjToIntMap objToIntMap = null;
        while ((scriptable = scriptable.getPrototype()) != null) {
            int n;
            Object[] objectArray2 = scriptable.getIds();
            if (objectArray2.length == 0) continue;
            if (objToIntMap == null) {
                if (objectArray.length == 0) {
                    objectArray = objectArray2;
                    continue;
                }
                objToIntMap = new ObjToIntMap(objectArray.length + objectArray2.length);
                for (n = 0; n != objectArray.length; ++n) {
                    objToIntMap.intern(objectArray[n]);
                }
                objectArray = null;
            }
            for (n = 0; n != objectArray2.length; ++n) {
                objToIntMap.intern(objectArray2[n]);
            }
        }
        if (objToIntMap != null) {
            objectArray = objToIntMap.getKeys();
        }
        return objectArray;
    }

    public static Object callMethod(Scriptable scriptable, String string, Object[] objectArray) {
        return ScriptableObject.callMethod(null, scriptable, string, objectArray);
    }

    public static Object callMethod(Context context, Scriptable scriptable, String string, Object[] objectArray) {
        Object object = ScriptableObject.getProperty(scriptable, string);
        if (!(object instanceof Function)) {
            throw ScriptRuntime.notFunctionError(scriptable, string);
        }
        Function function = (Function)object;
        Scriptable scriptable2 = ScriptableObject.getTopLevelScope(scriptable);
        if (context != null) {
            return function.call(context, scriptable2, scriptable, objectArray);
        }
        return Context.call(null, function, scriptable2, scriptable, objectArray);
    }

    static Scriptable getBase(Scriptable scriptable, String string) {
        Scriptable scriptable2 = scriptable;
        while (!scriptable2.has(string, scriptable) && (scriptable2 = scriptable2.getPrototype()) != null) {
        }
        return scriptable2;
    }

    static Scriptable getBase(Scriptable scriptable, int n) {
        Scriptable scriptable2 = scriptable;
        while (!scriptable2.has(n, scriptable) && (scriptable2 = scriptable2.getPrototype()) != null) {
        }
        return scriptable2;
    }

    private static Scriptable getBase(Scriptable scriptable, Symbol symbol) {
        Scriptable scriptable2 = scriptable;
        while (!ScriptableObject.ensureSymbolScriptable(scriptable2).has(symbol, scriptable) && (scriptable2 = scriptable2.getPrototype()) != null) {
        }
        return scriptable2;
    }

    public final Object getAssociatedValue(Object object) {
        Map<Object, Object> map = this.associatedValues;
        if (map == null) {
            return null;
        }
        return map.get(object);
    }

    public static Object getTopScopeValue(Scriptable scriptable, Object object) {
        scriptable = ScriptableObject.getTopLevelScope(scriptable);
        do {
            ScriptableObject scriptableObject;
            Object object2;
            if (!(scriptable instanceof ScriptableObject) || (object2 = (scriptableObject = (ScriptableObject)scriptable).getAssociatedValue(object)) == null) continue;
            return object2;
        } while ((scriptable = scriptable.getPrototype()) != null);
        return null;
    }

    public final synchronized Object associateValue(Object object, Object object2) {
        if (object2 == null) {
            throw new IllegalArgumentException();
        }
        Map<Object, Object> map = this.associatedValues;
        if (map == null) {
            this.associatedValues = map = new HashMap<Object, Object>();
        }
        return Kit.initHash(map, object, object2);
    }

    private boolean putImpl(Object object, int n, Scriptable scriptable, Object object2) {
        return this.putImpl(object, n, scriptable, object2, Context.isCurrentContextStrict());
    }

    boolean putImpl(Object object, int n, Scriptable scriptable, Object object2, boolean bl) {
        Slot slot;
        if (this != scriptable) {
            slot = this.slotMap.query(object, n);
            if (!this.isExtensible && (slot == null || !(slot instanceof AccessorSlot) && (slot.getAttributes() & 1) != 0) && bl) {
                throw ScriptRuntime.typeErrorById("msg.not.extensible", new Object[0]);
            }
            if (slot == null) {
                return false;
            }
        } else if (!this.isExtensible) {
            slot = this.slotMap.query(object, n);
            if ((slot == null || !(slot instanceof AccessorSlot) && (slot.getAttributes() & 1) != 0) && bl) {
                throw ScriptRuntime.typeErrorById("msg.not.extensible", new Object[0]);
            }
            if (slot == null) {
                return true;
            }
        } else {
            if (this.isSealed) {
                this.checkNotSealed(object, n);
            }
            slot = this.slotMap.modify(object, n, 0);
        }
        return slot.setValue(object2, this, scriptable, bl);
    }

    private boolean putConstImpl(String string, int n, Scriptable scriptable, Object object, int n2) {
        Object object2;
        assert (n2 != 0);
        if (!this.isExtensible && ((Context)(object2 = Context.getContext())).isStrictMode()) {
            throw ScriptRuntime.typeErrorById("msg.not.extensible", new Object[0]);
        }
        if (this != scriptable) {
            object2 = this.slotMap.query(string, n);
            if (object2 == null) {
                return false;
            }
        } else if (!this.isExtensible()) {
            object2 = this.slotMap.query(string, n);
            if (object2 == null) {
                return true;
            }
        } else {
            this.checkNotSealed(string, n);
            object2 = this.slotMap.modify(string, n, 13);
            int n3 = ((Slot)object2).getAttributes();
            if ((n3 & 1) == 0) {
                throw Context.reportRuntimeErrorById("msg.var.redecl", string);
            }
            if ((n3 & 8) != 0) {
                ((Slot)object2).value = object;
                if (n2 != 8) {
                    ((Slot)object2).setAttributes(n3 & 0xFFFFFFF7);
                }
            }
            return true;
        }
        return ((Slot)object2).setValue(object, this, scriptable);
    }

    private Slot getAttributeSlot(String string, int n) {
        Slot slot = this.slotMap.query(string, n);
        if (slot == null) {
            String string2 = string != null ? string : Integer.toString(n);
            throw Context.reportRuntimeErrorById("msg.prop.not.found", string2);
        }
        return slot;
    }

    private Slot getAttributeSlot(Symbol symbol) {
        Slot slot = this.slotMap.query(symbol, 0);
        if (slot == null) {
            throw Context.reportRuntimeErrorById("msg.prop.not.found", symbol);
        }
        return slot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object[] getIds(boolean bl, boolean bl2) {
        Object[] objectArray;
        Object object2;
        int n;
        Object[] objectArray2;
        int n2;
        int n3 = n2 = this.externalData == null ? 0 : this.externalData.getArrayLength();
        if (n2 == 0) {
            objectArray2 = ScriptRuntime.emptyArgs;
        } else {
            objectArray2 = new Object[n2];
            for (n = 0; n < n2; ++n) {
                objectArray2[n] = n;
            }
        }
        if (this.slotMap.isEmpty()) {
            return objectArray2;
        }
        n = n2;
        long l = this.slotMap.readLock();
        try {
            for (Object object2 : this.slotMap) {
                if (!bl && (((Slot)object2).getAttributes() & 2) != 0 || !bl2 && ((Slot)object2).name instanceof Symbol) continue;
                if (n == n2) {
                    Object[] objectArray3 = objectArray2;
                    objectArray2 = new Object[this.slotMap.dirtySize() + n2];
                    if (objectArray3 != null) {
                        System.arraycopy(objectArray3, 0, objectArray2, 0, n2);
                    }
                }
                objectArray2[n++] = ((Slot)object2).name != null ? ((Slot)object2).name : Integer.valueOf(((Slot)object2).indexOrHash);
            }
        }
        finally {
            this.slotMap.unlockRead(l);
        }
        if (n == objectArray2.length + n2) {
            objectArray = objectArray2;
        } else {
            objectArray = new Object[n];
            System.arraycopy(objectArray2, 0, objectArray, 0, n);
        }
        object2 = Context.getCurrentContext();
        if (object2 != null && ((Context)object2).hasFeature(16)) {
            Arrays.sort(objectArray, KEY_COMPARATOR);
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        long l = this.slotMap.readLock();
        try {
            int n = this.slotMap.dirtySize();
            if (n == 0) {
                objectOutputStream.writeInt(0);
            } else {
                objectOutputStream.writeInt(n);
                for (Slot slot : this.slotMap) {
                    objectOutputStream.writeObject(slot);
                }
            }
        }
        finally {
            this.slotMap.unlockRead(l);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.slotMap = ScriptableObject.createSlotMap(n);
        for (int i = 0; i < n; ++i) {
            Slot slot = (Slot)objectInputStream.readObject();
            this.slotMap.add(slot);
        }
    }

    protected ScriptableObject getOwnPropertyDescriptor(Context context, Object object) {
        Slot slot = this.querySlot(context, object);
        if (slot == null) {
            return null;
        }
        return slot.getPropertyDescriptor(context, this);
    }

    protected Slot querySlot(Context context, Object object) {
        if (object instanceof Symbol) {
            return this.slotMap.query(object, 0);
        }
        ScriptRuntime.StringIdOrIndex stringIdOrIndex = ScriptRuntime.toStringIdOrIndex(object);
        if (stringIdOrIndex.stringId == null) {
            return this.slotMap.query(null, stringIdOrIndex.index);
        }
        return this.slotMap.query(stringIdOrIndex.stringId, 0);
    }

    public int size() {
        return this.slotMap.size();
    }

    public boolean isEmpty() {
        return this.slotMap.isEmpty();
    }

    public Object get(Object object) {
        Object object2 = null;
        if (object instanceof String) {
            object2 = this.get((String)object, (Scriptable)this);
        } else if (object instanceof Symbol) {
            object2 = this.get((Symbol)object, (Scriptable)this);
        } else if (object instanceof Number) {
            object2 = this.get(((Number)object).intValue(), (Scriptable)this);
        }
        if (object2 == Scriptable.NOT_FOUND || object2 == Undefined.instance) {
            return null;
        }
        if (object2 instanceof Wrapper) {
            return ((Wrapper)object2).unwrap();
        }
        return object2;
    }

    static {
        try {
            GET_ARRAY_LENGTH = ScriptableObject.class.getMethod("getExternalArrayLength", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(noSuchMethodException);
        }
        KEY_COMPARATOR = new KeyComparator();
    }

    public static final class KeyComparator
    implements Comparator<Object>,
    Serializable {
        private static final long serialVersionUID = 6411335891523988149L;

        @Override
        public int compare(Object object, Object object2) {
            if (object instanceof Integer) {
                if (object2 instanceof Integer) {
                    return ((Integer)object).compareTo((Integer)object2);
                }
                return -1;
            }
            if (object2 instanceof Integer) {
                return 1;
            }
            return 0;
        }
    }
}

