/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.parser;

import io.sf.carte.echosvg.parser.DefaultLengthListHandler;
import io.sf.carte.echosvg.parser.ParseException;
import java.util.LinkedList;

public class LengthArrayProducer
extends DefaultLengthListHandler {
    protected LinkedList<float[]> vs;
    protected float[] v;
    protected LinkedList<short[]> us;
    protected short[] u;
    protected int index;
    protected int count;
    protected short currentUnit = (short)255;

    public short[] getLengthTypeArray() {
        return this.u;
    }

    public float[] getLengthValueArray() {
        return this.v;
    }

    @Override
    public void startLengthList() throws ParseException {
        this.us = new LinkedList();
        this.u = new short[11];
        this.vs = new LinkedList();
        this.v = new float[11];
        this.count = 0;
        this.index = 0;
    }

    public void numberValue(float f) throws ParseException {
        throw new IllegalStateException("Unexpected <number>: " + f);
    }

    @Override
    public void lengthValue(float f) throws ParseException {
        if (this.index == this.v.length) {
            this.vs.add(this.v);
            this.v = new float[this.v.length * 2 + 1];
            this.us.add(this.u);
            this.u = new short[this.u.length * 2 + 1];
            this.index = 0;
        }
        this.v[this.index] = f;
    }

    @Override
    public void startLength() throws ParseException {
        this.currentUnit = 0;
    }

    @Override
    public void endLength() throws ParseException {
        this.u[this.index++] = this.currentUnit;
        ++this.count;
    }

    @Override
    protected void setUnit(short s) {
        this.currentUnit = s;
    }

    @Override
    public void endLengthList() throws ParseException {
        float[] fArray = new float[this.count];
        int n = 0;
        for (float[] object2 : this.vs) {
            System.arraycopy(object2, 0, fArray, n, object2.length);
            n += object2.length;
        }
        System.arraycopy(this.v, 0, fArray, n, this.index);
        this.vs.clear();
        this.v = fArray;
        Object object3 = new short[this.count];
        n = 0;
        for (short[] sArray : this.us) {
            System.arraycopy(sArray, 0, object3, n, sArray.length);
            n += sArray.length;
        }
        System.arraycopy(this.u, 0, object3, n, this.index);
        this.us.clear();
        this.u = (short[])object3;
    }
}

