/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.AlgebraicExpression;
import io.sf.carte.doc.style.css.CSSExpression;
import io.sf.carte.doc.style.css.CSSOperandExpression;
import io.sf.carte.doc.style.css.CSSPrimitiveValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.doc.style.css.property.StyleExpression;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;

class SumExpression
extends StyleExpression
implements AlgebraicExpression {
    private static final long serialVersionUID = 1L;
    private final LinkedList<StyleExpression> operands = new LinkedList();

    SumExpression() {
    }

    SumExpression(SumExpression sumExpression) {
        Iterator iterator = sumExpression.operands.iterator();
        while (iterator.hasNext()) {
            this.operands.add(((StyleExpression)iterator.next()).clone());
        }
    }

    @Override
    void addExpression(StyleExpression styleExpression) {
        this.operands.add(styleExpression);
        styleExpression.setParentExpression(this);
        if (this.nextOperandInverse) {
            styleExpression.setInverseOperation(true);
            this.nextOperandInverse = false;
        }
    }

    @Override
    void replaceLastExpression(StyleExpression styleExpression) {
        StyleExpression styleExpression2 = this.operands.removeLast();
        if (styleExpression2.isInverseOperation()) {
            styleExpression2.setInverseOperation(false);
            styleExpression.setInverseOperation(true);
        }
        styleExpression2.setParentExpression(null);
        styleExpression.addExpression(styleExpression2);
        styleExpression.setParentExpression(this);
        this.operands.addLast(styleExpression);
    }

    @Override
    public StyleExpression item(int n) {
        try {
            return this.operands.get(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    @Override
    public int getLength() {
        return this.operands.size();
    }

    @Override
    public CSSExpression.AlgebraicPart getPartType() {
        return CSSExpression.AlgebraicPart.SUM;
    }

    @Override
    public int hashCode() {
        int n = 1021;
        int n2 = super.hashCode();
        n2 = 1021 * n2 + (this.operands == null ? 0 : this.operands.hashCode());
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        SumExpression sumExpression = (SumExpression)object;
        return !(this.operands == null ? sumExpression.operands != null : !this.operands.equals(sumExpression.operands));
    }

    @Override
    public String getCssText() {
        if (this.operands.isEmpty()) {
            return "";
        }
        BufferSimpleWriter bufferSimpleWriter = new BufferSimpleWriter(32 + this.operands.size() * 16);
        try {
            this.writeCssText((SimpleWriter)bufferSimpleWriter);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bufferSimpleWriter.toString();
    }

    @Override
    public String getMinifiedCssText() {
        if (this.operands.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(32);
        Iterator iterator = this.operands.iterator();
        CSSExpression cSSExpression = (CSSExpression)iterator.next();
        this.appendMinifiedFirstExpression(cSSExpression, stringBuilder);
        while (iterator.hasNext()) {
            cSSExpression = (CSSExpression)iterator.next();
            this.appendMinifiedExpression(cSSExpression, stringBuilder);
        }
        return stringBuilder.toString();
    }

    private void appendMinifiedFirstExpression(CSSExpression cSSExpression, StringBuilder stringBuilder) {
        boolean bl = false;
        if (cSSExpression.isInverseOperation()) {
            if (cSSExpression.getPartType() == CSSExpression.AlgebraicPart.SUM) {
                stringBuilder.append(" - (");
                bl = true;
            } else {
                NumberValue numberValue;
                CSSPrimitiveValue cSSPrimitiveValue;
                if (cSSExpression.getPartType() == CSSExpression.AlgebraicPart.OPERAND && (cSSPrimitiveValue = ((CSSOperandExpression)cSSExpression).getOperand()).getPrimitiveType() == CSSValue.Type.NUMERIC && (numberValue = (NumberValue)cSSPrimitiveValue).isNegativeNumber()) {
                    stringBuilder.append(" + ");
                    stringBuilder.append(numberValue.minifyAbsolute(""));
                    return;
                }
                stringBuilder.append(" - ");
            }
        }
        stringBuilder.append(cSSExpression.getMinifiedCssText());
        if (bl) {
            stringBuilder.append(')');
        }
    }

    private void appendMinifiedExpression(CSSExpression cSSExpression, StringBuilder stringBuilder) {
        boolean bl = false;
        if (cSSExpression.isInverseOperation()) {
            if (cSSExpression.getPartType() == CSSExpression.AlgebraicPart.SUM) {
                stringBuilder.append(" - (");
                bl = true;
            } else {
                NumberValue numberValue;
                CSSPrimitiveValue cSSPrimitiveValue;
                if (cSSExpression.getPartType() == CSSExpression.AlgebraicPart.OPERAND && (cSSPrimitiveValue = ((CSSOperandExpression)cSSExpression).getOperand()).getPrimitiveType() == CSSValue.Type.NUMERIC && (numberValue = (NumberValue)cSSPrimitiveValue).isNegativeNumber()) {
                    stringBuilder.append(" + ");
                    stringBuilder.append(numberValue.minifyAbsolute(""));
                    return;
                }
                stringBuilder.append(" - ");
            }
        } else {
            NumberValue numberValue;
            CSSPrimitiveValue cSSPrimitiveValue;
            if (cSSExpression.getPartType() == CSSExpression.AlgebraicPart.OPERAND && (cSSPrimitiveValue = ((CSSOperandExpression)cSSExpression).getOperand()).getPrimitiveType() == CSSValue.Type.NUMERIC && (numberValue = (NumberValue)cSSPrimitiveValue).isNegativeNumber()) {
                stringBuilder.append(" - ");
                stringBuilder.append(numberValue.minifyAbsolute(""));
                return;
            }
            stringBuilder.append(" + ");
        }
        stringBuilder.append(cSSExpression.getMinifiedCssText());
        if (bl) {
            stringBuilder.append(')');
        }
    }

    @Override
    public void writeCssText(SimpleWriter simpleWriter) throws IOException {
        if (!this.operands.isEmpty()) {
            Iterator iterator = this.operands.iterator();
            StyleExpression styleExpression = (StyleExpression)iterator.next();
            this.writeFirstExpression(styleExpression, simpleWriter);
            while (iterator.hasNext()) {
                styleExpression = (StyleExpression)iterator.next();
                this.writeExpression(styleExpression, simpleWriter);
            }
        }
    }

    private void writeFirstExpression(StyleExpression styleExpression, SimpleWriter simpleWriter) throws IOException {
        boolean bl = false;
        if (styleExpression.isInverseOperation()) {
            if (styleExpression.getPartType() == CSSExpression.AlgebraicPart.SUM) {
                simpleWriter.write((CharSequence)" - (");
                bl = true;
            } else {
                NumberValue numberValue;
                CSSPrimitiveValue cSSPrimitiveValue;
                if (styleExpression.getPartType() == CSSExpression.AlgebraicPart.OPERAND && (cSSPrimitiveValue = ((CSSOperandExpression)((Object)styleExpression)).getOperand()).getPrimitiveType() == CSSValue.Type.NUMERIC && (numberValue = (NumberValue)cSSPrimitiveValue).isNegativeNumber()) {
                    simpleWriter.write((CharSequence)" + ");
                    numberValue.serializeAbsolute(simpleWriter);
                    return;
                }
                simpleWriter.write((CharSequence)" - ");
            }
        }
        styleExpression.writeCssText(simpleWriter);
        if (bl) {
            simpleWriter.write(')');
        }
    }

    private void writeExpression(StyleExpression styleExpression, SimpleWriter simpleWriter) throws IOException {
        boolean bl = false;
        if (styleExpression.isInverseOperation()) {
            if (styleExpression.getPartType() == CSSExpression.AlgebraicPart.SUM) {
                simpleWriter.write((CharSequence)" - (");
                bl = true;
            } else {
                NumberValue numberValue;
                CSSPrimitiveValue cSSPrimitiveValue;
                if (styleExpression.getPartType() == CSSExpression.AlgebraicPart.OPERAND && (cSSPrimitiveValue = ((CSSOperandExpression)((Object)styleExpression)).getOperand()).getPrimitiveType() == CSSValue.Type.NUMERIC && (numberValue = (NumberValue)cSSPrimitiveValue).isNegativeNumber()) {
                    simpleWriter.write((CharSequence)" + ");
                    numberValue.serializeAbsolute(simpleWriter);
                    return;
                }
                simpleWriter.write((CharSequence)" - ");
            }
        } else {
            NumberValue numberValue;
            CSSPrimitiveValue cSSPrimitiveValue;
            if (styleExpression.getPartType() == CSSExpression.AlgebraicPart.OPERAND && (cSSPrimitiveValue = ((CSSOperandExpression)((Object)styleExpression)).getOperand()).getPrimitiveType() == CSSValue.Type.NUMERIC && (numberValue = (NumberValue)cSSPrimitiveValue).isNegativeNumber()) {
                simpleWriter.write((CharSequence)" - ");
                numberValue.serializeAbsolute(simpleWriter);
                return;
            }
            simpleWriter.write((CharSequence)" + ");
        }
        styleExpression.writeCssText(simpleWriter);
        if (bl) {
            simpleWriter.write(')');
        }
    }

    @Override
    public SumExpression clone() {
        return new SumExpression(this);
    }

    static AlgebraicExpression createSumExpression() {
        return new SumExpression();
    }
}

