/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.DataInput;
import java.io.IOException;
import jogamp.graph.font.typecast.ot.table.HeadTable;
import jogamp.graph.font.typecast.ot.table.MaxpTable;
import jogamp.graph.font.typecast.ot.table.Table;

public class LocaTable
implements Table {
    private int[] _offsets;
    private short _factor;
    private int _length;

    public LocaTable(DataInput dataInput, int n, HeadTable headTable, MaxpTable maxpTable) throws IOException {
        int n2;
        boolean bl;
        this._offsets = new int[maxpTable.getNumGlyphs() + 1];
        boolean bl2 = bl = headTable.getIndexToLocFormat() == 0;
        if (bl) {
            this._factor = (short)2;
            for (n2 = 0; n2 <= maxpTable.getNumGlyphs(); ++n2) {
                this._offsets[n2] = dataInput.readUnsignedShort();
            }
        } else {
            this._factor = 1;
            for (n2 = 0; n2 <= maxpTable.getNumGlyphs(); ++n2) {
                this._offsets[n2] = dataInput.readInt();
            }
        }
        n2 = 0;
        int n3 = 0;
        for (int n4 : this._offsets) {
            if (n4 < n2) {
                System.err.printf("LocaTable: Offset at index %d is bad (%d < %d)%n", n3, n4, n2);
            }
            n2 = n4;
            ++n3;
        }
        this._length = n;
    }

    public int getOffset(int n) {
        if (this._offsets == null) {
            return 0;
        }
        return this._offsets[n] * this._factor;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("'loca' Table - Index To Location Table\n--------------------------------------\n").append("Size = ").append(this._length).append(" bytes, ").append(this._offsets.length).append(" entries\n");
        for (int i = 0; i < this._offsets.length; ++i) {
            stringBuilder.append("        Idx ").append(i).append(" -> glyfOff 0x").append(this.getOffset(i)).append("\n");
        }
        return stringBuilder.toString();
    }
}

