/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.dom.svg;

import io.sf.carte.echosvg.dom.svg.AbstractSVGList;
import io.sf.carte.echosvg.dom.svg.ListHandler;
import io.sf.carte.echosvg.dom.svg.SVGItem;
import io.sf.carte.echosvg.dom.svg.SVGPointItem;
import io.sf.carte.echosvg.parser.ParseException;
import io.sf.carte.echosvg.parser.PointsHandler;
import io.sf.carte.echosvg.parser.PointsParser;
import org.w3c.dom.DOMException;
import org.w3c.dom.svg.SVGException;
import org.w3c.dom.svg.SVGPoint;
import org.w3c.dom.svg.SVGPointList;

public abstract class AbstractSVGPointList
extends AbstractSVGList
implements SVGPointList {
    public static final String SVG_POINT_LIST_SEPARATOR = " ";

    @Override
    protected String getItemSeparator() {
        return SVG_POINT_LIST_SEPARATOR;
    }

    protected abstract SVGException createSVGException(short var1, String var2, Object[] var3);

    public SVGPoint initialize(SVGPoint sVGPoint) throws DOMException, SVGException {
        return (SVGPoint)this.initializeImpl(sVGPoint);
    }

    public SVGPoint getItem(int n) throws DOMException {
        return (SVGPoint)this.getItemImpl(n);
    }

    public SVGPoint insertItemBefore(SVGPoint sVGPoint, int n) throws DOMException, SVGException {
        return (SVGPoint)this.insertItemBeforeImpl(sVGPoint, n);
    }

    public SVGPoint replaceItem(SVGPoint sVGPoint, int n) throws DOMException, SVGException {
        return (SVGPoint)this.replaceItemImpl(sVGPoint, n);
    }

    public SVGPoint removeItem(int n) throws DOMException {
        return (SVGPoint)this.removeItemImpl(n);
    }

    public SVGPoint appendItem(SVGPoint sVGPoint) throws DOMException, SVGException {
        return (SVGPoint)this.appendItemImpl(sVGPoint);
    }

    @Override
    protected SVGItem createSVGItem(Object object) {
        SVGPoint sVGPoint = (SVGPoint)object;
        return new SVGPointItem(sVGPoint.getX(), sVGPoint.getY());
    }

    @Override
    protected void doParse(String string, ListHandler listHandler) throws ParseException {
        PointsListBuilder pointsListBuilder = new PointsListBuilder(listHandler);
        PointsParser pointsParser = new PointsParser((PointsHandler)pointsListBuilder);
        pointsParser.parse(string);
    }

    @Override
    protected void checkItemType(Object object) throws SVGException {
        if (!(object instanceof SVGPoint)) {
            this.createSVGException((short)0, "expected.point", null);
        }
    }

    protected static class PointsListBuilder
    implements PointsHandler {
        protected ListHandler listHandler;

        public PointsListBuilder(ListHandler listHandler) {
            this.listHandler = listHandler;
        }

        public void startPoints() throws ParseException {
            this.listHandler.startList();
        }

        public void point(float f, float f2) throws ParseException {
            this.listHandler.item(new SVGPointItem(f, f2));
        }

        public void endPoints() throws ParseException {
            this.listHandler.endList();
        }
    }
}

