/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class DoublyIndexedTable<K, L> {
    protected int initialCapacity;
    protected Entry[] table;
    protected int count;

    public DoublyIndexedTable() {
        this(16);
    }

    public DoublyIndexedTable(int n) {
        this.initialCapacity = n;
        this.table = new Entry[n];
    }

    public DoublyIndexedTable(DoublyIndexedTable<K, L> doublyIndexedTable) {
        this.initialCapacity = doublyIndexedTable.initialCapacity;
        this.table = new Entry[doublyIndexedTable.table.length];
        for (int i = 0; i < doublyIndexedTable.table.length; ++i) {
            Entry entry = null;
            Entry entry2 = doublyIndexedTable.table[i];
            while (entry2 != null) {
                entry = new Entry(entry2.hash, entry2.key1, entry2.key2, entry2.value, entry);
                entry2 = entry2.next;
            }
            this.table[i] = entry;
        }
        this.count = doublyIndexedTable.count;
    }

    public int size() {
        return this.count;
    }

    public Object put(K k, L l, Object object) {
        Entry entry;
        int n = this.hashCode(k, l) & Integer.MAX_VALUE;
        int n2 = n % this.table.length;
        Entry entry2 = this.table[n2];
        while (entry2 != null) {
            if (entry2.hash == n && entry2.match(k, l)) {
                Object object2 = entry2.value;
                entry2.value = object;
                return object2;
            }
            entry2 = entry2.next;
        }
        int n3 = this.table.length;
        if (this.count++ >= n3 - (n3 >> 2)) {
            this.rehash();
            n2 = n % this.table.length;
        }
        this.table[n2] = entry = new Entry(n, k, l, object, this.table[n2]);
        return null;
    }

    public Object get(K k, L l) {
        int n = this.hashCode(k, l) & Integer.MAX_VALUE;
        int n2 = n % this.table.length;
        Entry entry = this.table[n2];
        while (entry != null) {
            if (entry.hash == n && entry.match(k, l)) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    public Object remove(K k, L l) {
        int n = this.hashCode(k, l) & Integer.MAX_VALUE;
        int n2 = n % this.table.length;
        Entry entry = this.table[n2];
        if (entry == null) {
            return null;
        }
        if (entry.hash == n && entry.match(k, l)) {
            this.table[n2] = entry.next;
            --this.count;
            return entry.value;
        }
        Entry entry2 = entry;
        entry = entry.next;
        while (entry != null) {
            if (entry.hash == n && entry.match(k, l)) {
                entry2.next = entry.next;
                --this.count;
                return entry.value;
            }
            entry2 = entry;
            entry = entry.next;
        }
        return null;
    }

    public Object[] getValuesArray() {
        Object[] objectArray = new Object[this.count];
        int n = 0;
        Entry[] entryArray = this.table;
        int n2 = entryArray.length;
        for (int i = 0; i < n2; ++i) {
            Entry entry;
            Entry entry2 = entry = entryArray[i];
            while (entry2 != null) {
                objectArray[n++] = entry2.value;
                entry2 = entry2.next;
            }
        }
        return objectArray;
    }

    public void clear() {
        this.table = new Entry[this.initialCapacity];
        this.count = 0;
    }

    public Iterator<Entry> iterator() {
        return new TableIterator();
    }

    protected void rehash() {
        Entry[] entryArray = this.table;
        this.table = new Entry[entryArray.length * 2 + 1];
        for (int i = entryArray.length - 1; i >= 0; --i) {
            Entry entry = entryArray[i];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.next;
                int n = entry2.hash % this.table.length;
                entry2.next = this.table[n];
                this.table[n] = entry2;
            }
        }
    }

    protected int hashCode(Object object, Object object2) {
        int n = object == null ? 0 : object.hashCode();
        return n ^ (object2 == null ? 0 : object2.hashCode());
    }

    public class Entry {
        protected int hash;
        protected K key1;
        protected L key2;
        protected Object value;
        protected Entry next;

        Entry(int n, K k, L l, Object object, Entry entry) {
            this.hash = n;
            this.key1 = k;
            this.key2 = l;
            this.value = object;
            this.next = entry;
        }

        public K getKey1() {
            return this.key1;
        }

        public L getKey2() {
            return this.key2;
        }

        public Object getValue() {
            return this.value;
        }

        protected boolean match(K k, L l) {
            if (this.key1 != null ? !this.key1.equals(k) : k != null) {
                return false;
            }
            if (this.key2 != null) {
                return this.key2.equals(l);
            }
            return l == null;
        }
    }

    protected class TableIterator
    implements Iterator<Entry> {
        private int nextIndex;
        private Entry nextEntry;
        private boolean finished;

        public TableIterator() {
            while (this.nextIndex < DoublyIndexedTable.this.table.length) {
                this.nextEntry = DoublyIndexedTable.this.table[this.nextIndex];
                if (this.nextEntry != null) break;
                ++this.nextIndex;
            }
            this.finished = this.nextEntry == null;
        }

        @Override
        public boolean hasNext() {
            return !this.finished;
        }

        @Override
        public Entry next() {
            if (this.finished) {
                throw new NoSuchElementException();
            }
            Entry entry = this.nextEntry;
            this.findNext();
            return entry;
        }

        protected void findNext() {
            this.nextEntry = this.nextEntry.next;
            if (this.nextEntry == null) {
                ++this.nextIndex;
                while (this.nextIndex < DoublyIndexedTable.this.table.length) {
                    this.nextEntry = DoublyIndexedTable.this.table[this.nextIndex];
                    if (this.nextEntry != null) break;
                    ++this.nextIndex;
                }
            }
            this.finished = this.nextEntry == null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

