/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.ext.awt.geom;

import io.sf.carte.echosvg.ext.awt.geom.Cubic;
import io.sf.carte.echosvg.ext.awt.geom.Linear;
import io.sf.carte.echosvg.ext.awt.geom.Quadradic;
import io.sf.carte.echosvg.ext.awt.geom.Segment;
import java.awt.Shape;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class SegmentList {
    List<Segment> segments = new LinkedList<Segment>();

    public SegmentList() {
    }

    public SegmentList(Shape shape) {
        PathIterator pathIterator = shape.getPathIterator(null);
        float[] fArray = new float[6];
        Point2D.Double double_ = null;
        Point2D.Double double_2 = null;
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(fArray);
            switch (n) {
                case 0: {
                    double_2 = double_ = new Point2D.Double(fArray[0], fArray[1]);
                    break;
                }
                case 1: {
                    Point2D.Double double_3 = new Point2D.Double(fArray[0], fArray[1]);
                    this.segments.add(new Linear(double_, double_3));
                    double_ = double_3;
                    break;
                }
                case 2: {
                    Point2D.Double double_3 = new Point2D.Double(fArray[0], fArray[1]);
                    Point2D.Double double_4 = new Point2D.Double(fArray[2], fArray[3]);
                    this.segments.add(new Quadradic(double_, double_3, double_4));
                    double_ = double_4;
                    break;
                }
                case 3: {
                    Point2D.Double double_3 = new Point2D.Double(fArray[0], fArray[1]);
                    Point2D.Double double_4 = new Point2D.Double(fArray[2], fArray[3]);
                    Point2D.Double double_5 = new Point2D.Double(fArray[4], fArray[5]);
                    this.segments.add(new Cubic(double_, double_3, double_4, double_5));
                    double_ = double_5;
                    break;
                }
                case 4: {
                    this.segments.add(new Linear(double_, double_2));
                    double_ = double_2;
                }
            }
            pathIterator.next();
        }
    }

    public Rectangle2D getBounds2D() {
        Iterator<Segment> iterator = this.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        Rectangle2D rectangle2D = (Rectangle2D)iterator.next().getBounds2D().clone();
        while (iterator.hasNext()) {
            Segment segment = iterator.next();
            Rectangle2D rectangle2D2 = segment.getBounds2D();
            Rectangle2D.union(rectangle2D2, rectangle2D, rectangle2D);
        }
        return rectangle2D;
    }

    public void add(Segment segment) {
        this.segments.add(segment);
    }

    public Iterator<Segment> iterator() {
        return this.segments.iterator();
    }

    public int size() {
        return this.segments.size();
    }

    public SplitResults split(double d) {
        SegmentList segmentList = new SegmentList();
        SegmentList segmentList2 = new SegmentList();
        for (Segment segment : this.segments) {
            int n;
            Segment[] segmentArray;
            Segment.SplitResults splitResults = segment.split(d);
            if (splitResults == null) {
                segmentArray = segment.getBounds2D();
                if (segmentArray.getY() > d) {
                    segmentList2.add(segment);
                    continue;
                }
                if (segmentArray.getY() == d) {
                    if (segmentArray.getHeight() == 0.0) continue;
                    segmentList2.add(segment);
                    continue;
                }
                segmentList.add(segment);
                continue;
            }
            Segment[] segmentArray2 = segmentArray = splitResults.getAbove();
            int n2 = segmentArray2.length;
            for (n = 0; n < n2; ++n) {
                Segment segment2 = segmentArray2[n];
                segmentList.add(segment2);
            }
            Segment[] segmentArray3 = segmentArray2 = splitResults.getBelow();
            n = segmentArray3.length;
            for (int i = 0; i < n; ++i) {
                Segment segment3 = segmentArray3[i];
                segmentList2.add(segment3);
            }
        }
        return new SplitResults(segmentList, segmentList2);
    }

    public static class SplitResults {
        final SegmentList above;
        final SegmentList below;

        public SplitResults(SegmentList segmentList, SegmentList segmentList2) {
            this.above = segmentList != null && segmentList.size() > 0 ? segmentList : null;
            this.below = segmentList2 != null && segmentList2.size() > 0 ? segmentList2 : null;
        }

        public SegmentList getAbove() {
            return this.above;
        }

        public SegmentList getBelow() {
            return this.below;
        }
    }
}

