/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.av.impl;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.egl.EGL;
import com.jogamp.opengl.util.texture.TextureSequence;
import java.io.IOException;
import jogamp.opengl.util.av.EGLMediaPlayerImpl;

public class OMXGLMediaPlayer
extends EGLMediaPlayerImpl {
    static final boolean available = false;
    protected long moviePtr = 0L;

    public static final boolean isAvailable() {
        return available;
    }

    public OMXGLMediaPlayer() {
        super(EGLMediaPlayerImpl.TextureType.KHRImage, true);
        if (!available) {
            throw new RuntimeException("OMXGLMediaPlayer not available");
        }
        this.initOMX();
    }

    protected void initOMX() {
        this.moviePtr = this._createInstance();
        if (0L == this.moviePtr) {
            throw new GLException("Couldn't create OMXInstance");
        }
    }

    @Override
    protected TextureSequence.TextureFrame createTexImage(GL gL, int n) {
        EGLMediaPlayerImpl.EGLTextureFrame eGLTextureFrame = (EGLMediaPlayerImpl.EGLTextureFrame)super.createTexImage(gL, n);
        this._setStreamEGLImageTexture2D(this.moviePtr, n, eGLTextureFrame.getImage(), eGLTextureFrame.getSync());
        return eGLTextureFrame;
    }

    @Override
    protected void destroyTexFrame(GL gL, TextureSequence.TextureFrame textureFrame) {
        super.destroyTexFrame(gL, textureFrame);
    }

    @Override
    protected void destroyImpl() {
        if (this.moviePtr != 0L) {
            this._stop(this.moviePtr);
            this._detachVideoRenderer(this.moviePtr);
            this._destroyInstance(this.moviePtr);
            this.moviePtr = 0L;
        }
    }

    @Override
    protected void initStreamImpl(int n, int n2) throws IOException {
        if (0L == this.moviePtr) {
            throw new GLException("OMX native instance null");
        }
        if (!this.getUri().isFileScheme()) {
            throw new IOException("Only file schemes are allowed: " + this.getUri());
        }
        String string = this.getUri().path.decode();
        if (DEBUG) {
            System.out.println("initGLStream: clean path " + string);
        }
        if (DEBUG) {
            System.out.println("initGLStream: p1 " + this);
        }
        this._setStream(this.moviePtr, this.getTextureCount(), string);
        if (DEBUG) {
            System.out.println("initGLStream: p2 " + this);
        }
    }

    @Override
    protected final void initGLImpl(GL gL) throws IOException, GLException {
        this.setIsGLOriented(true);
    }

    @Override
    protected int getAudioPTSImpl() {
        return 0L != this.moviePtr ? this._getCurrentPosition(this.moviePtr) : 0;
    }

    @Override
    protected boolean setPlaySpeedImpl(float f) {
        if (0L == this.moviePtr) {
            throw new GLException("OMX native instance null");
        }
        this._setPlaySpeed(this.moviePtr, f);
        return true;
    }

    @Override
    public synchronized boolean resumeImpl() {
        if (0L == this.moviePtr) {
            return false;
        }
        this._play(this.moviePtr);
        return true;
    }

    @Override
    public synchronized boolean pauseImpl() {
        if (0L == this.moviePtr) {
            return false;
        }
        this._pause(this.moviePtr);
        return true;
    }

    @Override
    protected final void stopImpl() {
        this.destroyImpl();
        this.initOMX();
    }

    @Override
    protected int seekImpl(int n) {
        if (0L == this.moviePtr) {
            throw new GLException("OMX native instance null");
        }
        return this._seek(this.moviePtr, n);
    }

    @Override
    protected int getNextTextureImpl(GL gL, TextureSequence.TextureFrame textureFrame) {
        if (0L == this.moviePtr) {
            throw new GLException("OMX native instance null");
        }
        int n = this._getNextTextureID(this.moviePtr, true);
        if (0 < n) {
            // empty if block
        }
        return 0;
    }

    private String replaceAll(String string, String string2, String string3) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        while ((n = string.indexOf(string2, n2)) >= 0) {
            stringBuilder.append(string.substring(n2, n));
            stringBuilder.append(string3);
            n2 = n + 1;
        }
        return stringBuilder.append(string.substring(n2, string.length())).toString();
    }

    private void errorCheckEGL(String string) {
        int n = EGL.eglGetError();
        if (n != 12288) {
            System.out.println("EGL Error: (" + string + "): 0x" + Integer.toHexString(n));
        }
    }

    private static native boolean initIDs0();

    private native long _createInstance();

    private native void _destroyInstance(long var1);

    private native void _detachVideoRenderer(long var1);

    private native void _attachVideoRenderer(long var1);

    private native void _setStream(long var1, int var3, String var4);

    private native void _activateStream(long var1);

    private native void _setStreamEGLImageTexture2D(long var1, int var3, long var4, long var6);

    private native int _seek(long var1, int var3);

    private native void _setPlaySpeed(long var1, float var3);

    private native void _play(long var1);

    private native void _pause(long var1);

    private native void _stop(long var1);

    private native int _getNextTextureID(long var1, boolean var3);

    private native int _getCurrentPosition(long var1);
}

