/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.nativewindow.util;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.util.Bitstream;
import com.jogamp.nativewindow.util.PixelFormat;
import com.jogamp.nativewindow.util.PixelRectangle;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class PixelFormatUtil {
    private static boolean DEBUG = false;

    public static final int find(PixelFormat.CType cType, PixelFormat.CType[] cTypeArray, boolean bl) {
        int n;
        for (n = cTypeArray.length - 1; n >= 0 && cTypeArray[n] != cType; --n) {
        }
        if (0 > n && bl && 1 == cTypeArray.length && cTypeArray[0] == PixelFormat.CType.Y && (PixelFormat.CType.R == cType || PixelFormat.CType.G == cType || PixelFormat.CType.B == cType)) {
            return 0;
        }
        return n;
    }

    public static int getShiftedI32(int n, byte[] byArray, int n2) {
        if (n <= 4) {
            int n3 = 0;
            for (int i = 0; i < n; ++i) {
                n3 |= (0xFF & byArray[n2 + i]) << 8 * i;
            }
            return n3;
        }
        throw new UnsupportedOperationException(n + " bytesPerPixel too big, i.e. > 4");
    }

    public static long getShiftedI64(int n, byte[] byArray, int n2) {
        if (n <= 8) {
            long l = 0L;
            for (int i = 0; i < n; ++i) {
                l |= (long)((0xFF & byArray[n2 + i]) << 8 * i);
            }
            return l;
        }
        throw new UnsupportedOperationException(n + " bytesPerPixel too big, i.e. > 8");
    }

    public static int getShiftedI32(int n, ByteBuffer byteBuffer, boolean bl) {
        if (n <= 4) {
            int n2 = 0;
            if (bl) {
                int n3 = byteBuffer.position();
                for (int i = 0; i < n; ++i) {
                    n2 |= (0xFF & byteBuffer.get(n3 + i)) << 8 * i;
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    n2 |= (0xFF & byteBuffer.get()) << 8 * i;
                }
            }
            return n2;
        }
        throw new UnsupportedOperationException(n + " bytesPerPixel too big, i.e. > 4");
    }

    public static long getShiftedI64(int n, ByteBuffer byteBuffer, boolean bl) {
        if (n <= 8) {
            long l = 0L;
            if (bl) {
                int n2 = byteBuffer.position();
                for (int i = 0; i < n; ++i) {
                    l |= (long)((0xFF & byteBuffer.get(n2 + i)) << 8 * i);
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    l |= (long)((0xFF & byteBuffer.get()) << 8 * i);
                }
            }
            return l;
        }
        throw new UnsupportedOperationException(n + " bytesPerPixel too big, i.e. > 8");
    }

    public static PixelFormat getReversed(PixelFormat pixelFormat) {
        switch (pixelFormat) {
            case RGB565: {
                return PixelFormat.BGR565;
            }
            case BGR565: {
                return PixelFormat.RGB565;
            }
            case RGBA5551: {
                return PixelFormat.ABGR1555;
            }
            case ABGR1555: {
                return PixelFormat.RGBA5551;
            }
            case RGB888: {
                return PixelFormat.BGR888;
            }
            case BGR888: {
                return PixelFormat.RGB888;
            }
            case RGBA8888: {
                return PixelFormat.ABGR8888;
            }
            case ABGR8888: {
                return PixelFormat.RGBA8888;
            }
            case ARGB8888: {
                return PixelFormat.BGRA8888;
            }
            case BGRA8888: {
                return PixelFormat.ABGR8888;
            }
        }
        return pixelFormat;
    }

    public static int convertToInt32(PixelFormat pixelFormat, byte by, byte by2, byte by3, byte by4) {
        switch (pixelFormat) {
            case LUMINANCE: {
                byte by5 = (byte)(((0xFF & by) + (0xFF & by2) + (0xFF & by3)) / 3 * by4);
                return 0xFF000000 | (0xFF & by5) << 16 | (0xFF & by5) << 8 | 0xFF & by5;
            }
            case RGB888: {
                return 0xFF000000 | (0xFF & by3) << 16 | (0xFF & by2) << 8 | 0xFF & by;
            }
            case BGR888: {
                return 0xFF000000 | (0xFF & by) << 16 | (0xFF & by2) << 8 | 0xFF & by3;
            }
            case RGBA8888: {
                return (0xFF & by4) << 24 | (0xFF & by3) << 16 | (0xFF & by2) << 8 | 0xFF & by;
            }
            case ABGR8888: {
                return (0xFF & by) << 24 | (0xFF & by2) << 16 | (0xFF & by3) << 8 | 0xFF & by4;
            }
            case ARGB8888: {
                return (0xFF & by3) << 24 | (0xFF & by2) << 16 | (0xFF & by) << 8 | 0xFF & by4;
            }
            case BGRA8888: {
                return (0xFF & by4) << 24 | (0xFF & by) << 16 | (0xFF & by2) << 8 | 0xFF & by3;
            }
        }
        throw new InternalError("Unhandled format " + (Object)((Object)pixelFormat));
    }

    public static int convertToInt32(PixelFormat pixelFormat, PixelFormat pixelFormat2, ByteBuffer byteBuffer, int n) {
        byte by;
        byte by2;
        byte by3;
        byte by4;
        switch (pixelFormat2) {
            case LUMINANCE: {
                by3 = by4 = byteBuffer.get(n++);
                by2 = by4;
                by = -1;
                break;
            }
            case RGB888: {
                by4 = byteBuffer.get(n++);
                by3 = byteBuffer.get(n++);
                by2 = byteBuffer.get(n++);
                by = -1;
                break;
            }
            case BGR888: {
                by2 = byteBuffer.get(n++);
                by3 = byteBuffer.get(n++);
                by4 = byteBuffer.get(n++);
                by = -1;
                break;
            }
            case RGBA8888: {
                by4 = byteBuffer.get(n++);
                by3 = byteBuffer.get(n++);
                by2 = byteBuffer.get(n++);
                by = byteBuffer.get(n++);
                break;
            }
            case ABGR8888: {
                by = byteBuffer.get(n++);
                by2 = byteBuffer.get(n++);
                by3 = byteBuffer.get(n++);
                by4 = byteBuffer.get(n++);
                break;
            }
            case ARGB8888: {
                by = byteBuffer.get(n++);
                by4 = byteBuffer.get(n++);
                by3 = byteBuffer.get(n++);
                by2 = byteBuffer.get(n++);
                break;
            }
            case BGRA8888: {
                by2 = byteBuffer.get(n++);
                by3 = byteBuffer.get(n++);
                by4 = byteBuffer.get(n++);
                by = byteBuffer.get(n++);
                break;
            }
            default: {
                throw new InternalError("Unhandled format " + (Object)((Object)pixelFormat2));
            }
        }
        return PixelFormatUtil.convertToInt32(pixelFormat, by4, by3, by2, by);
    }

    public static int convertToInt32(PixelFormat pixelFormat, PixelFormat pixelFormat2, int n) {
        byte by;
        byte by2;
        byte by3;
        byte by4;
        switch (pixelFormat2) {
            case LUMINANCE: {
                by3 = by4 = (byte)n;
                by2 = by4;
                by = -1;
                break;
            }
            case RGB888: {
                by4 = (byte)n;
                by3 = (byte)(n >>> 8);
                by2 = (byte)(n >>> 16);
                by = -1;
                break;
            }
            case BGR888: {
                by2 = (byte)n;
                by3 = (byte)(n >>> 8);
                by4 = (byte)(n >>> 16);
                by = -1;
                break;
            }
            case RGBA8888: {
                by4 = (byte)n;
                by3 = (byte)(n >>> 8);
                by2 = (byte)(n >>> 16);
                by = (byte)(n >>> 24);
                break;
            }
            case ABGR8888: {
                by = (byte)n;
                by2 = (byte)(n >>> 8);
                by3 = (byte)(n >>> 16);
                by4 = (byte)(n >>> 24);
                break;
            }
            case ARGB8888: {
                by = (byte)n;
                by4 = (byte)(n >>> 8);
                by3 = (byte)(n >>> 16);
                by2 = (byte)(n >>> 24);
                break;
            }
            case BGRA8888: {
                by2 = (byte)n;
                by3 = (byte)(n >>> 8);
                by4 = (byte)(n >>> 16);
                by = (byte)(n >>> 24);
                break;
            }
            default: {
                throw new InternalError("Unhandled format " + (Object)((Object)pixelFormat2));
            }
        }
        return PixelFormatUtil.convertToInt32(pixelFormat, by4, by3, by2, by);
    }

    public static PixelRectangle convert(PixelRectangle pixelRectangle, PixelFormat pixelFormat, int n, boolean bl, boolean bl2) {
        int n2 = pixelRectangle.getSize().getWidth();
        int n3 = pixelRectangle.getSize().getHeight();
        int n4 = pixelFormat.comp.bytesPerPixel();
        int n5 = 0 != n ? n : n4 * n2;
        int n6 = n5 * n3;
        ByteBuffer byteBuffer = bl2 ? Buffers.newDirectByteBuffer((int)n6) : ByteBuffer.allocate(n6).order(pixelRectangle.getPixels().order());
        PixelFormatUtil.convert(pixelRectangle, byteBuffer, pixelFormat, bl, n5);
        return new PixelRectangle.GenericPixelRect(pixelFormat, pixelRectangle.getSize(), n5, bl, byteBuffer);
    }

    public static void convert(PixelRectangle pixelRectangle, ByteBuffer byteBuffer, PixelFormat pixelFormat, boolean bl, int n) throws IllegalStateException {
        PixelFormatUtil.convert(pixelRectangle.getSize().getWidth(), pixelRectangle.getSize().getHeight(), pixelRectangle.getPixels(), pixelRectangle.getPixelformat(), pixelRectangle.isGLOriented(), pixelRectangle.getStride(), byteBuffer, pixelFormat, bl, n);
    }

    public static void convert(int n, int n2, ByteBuffer byteBuffer, PixelFormat pixelFormat, boolean bl, int n3, ByteBuffer byteBuffer2, PixelFormat pixelFormat2, boolean bl2, int n4) throws IllegalStateException, IllegalArgumentException {
        boolean bl3;
        PixelFormat.Composition composition = pixelFormat.comp;
        PixelFormat.Composition composition2 = pixelFormat2.comp;
        int n5 = composition.bytesPerPixel();
        int n6 = composition2.bytesPerPixel();
        if (0 != n3) {
            if (n3 < n5 * n) {
                throw new IllegalArgumentException(String.format("Invalid %s stride %d, must be greater than bytesPerPixel %d * width %d", "source", n3, n5, n));
            }
        } else {
            n3 = n5 * n;
        }
        if (0 != n4) {
            if (n4 < n6 * n) {
                throw new IllegalArgumentException(String.format("Invalid %s stride %d, must be greater than bytesPerPixel %d * width %d", "destination", n4, n6, n));
            }
        } else {
            n4 = n6 * n;
        }
        int n7 = composition2.bitStride();
        boolean bl4 = bl != bl2;
        boolean bl5 = bl3 = composition.equals(composition2) && 0 == n7 % 8;
        if (DEBUG) {
            System.err.println("XXX: size " + n + "x" + n2 + ", fast_copy " + bl3);
            System.err.println("XXX: SRC fmt " + (Object)((Object)pixelFormat) + ", " + composition + ", stride " + n3 + ", isGLOrient " + bl);
            System.err.println("XXX: DST fmt " + (Object)((Object)pixelFormat2) + ", " + composition2 + ", stride " + n4 + ", isGLOrient " + bl2);
        }
        if (bl3) {
            for (int i = 0; i < n2; ++i) {
                int n8 = bl4 ? (n2 - 1 - i) * n3 : i * n3;
                int n9 = n4 * i;
                for (int j = 0; j < n; ++j) {
                    byteBuffer2.put(n9 + 0, byteBuffer.get(n8 + 0));
                    if (2 <= n6) {
                        byteBuffer2.put(n9 + 1, byteBuffer.get(n8 + 1));
                        if (3 <= n6) {
                            byteBuffer2.put(n9 + 2, byteBuffer.get(n8 + 2));
                            if (4 <= n6) {
                                byteBuffer2.put(n9 + 3, byteBuffer.get(n8 + 3));
                            }
                        }
                    }
                    n8 += n5;
                    n9 += n6;
                }
            }
        } else {
            ComponentMap componentMap = new ComponentMap(pixelFormat.comp, pixelFormat2.comp);
            Bitstream.ByteBufferStream byteBufferStream = new Bitstream.ByteBufferStream(byteBuffer);
            Bitstream bitstream = new Bitstream((Bitstream.ByteStream)byteBufferStream, false);
            bitstream.setThrowIOExceptionOnEOF(true);
            Bitstream.ByteBufferStream byteBufferStream2 = new Bitstream.ByteBufferStream(byteBuffer2);
            Bitstream bitstream2 = new Bitstream((Bitstream.ByteStream)byteBufferStream2, true);
            bitstream2.setThrowIOExceptionOnEOF(true);
            if (DEBUG) {
                System.err.println("XXX: cmap.dst2src " + Arrays.toString(componentMap.dst2src));
                System.err.println("XXX: cmap.src2dst " + Arrays.toString(componentMap.src2dst));
                System.err.println("XXX: cmap.srcRGBA " + Arrays.toString(componentMap.srcRGBA));
                System.err.println("XXX: srcBitStream " + bitstream);
                System.err.println("XXX: dstBitStream " + bitstream2);
            }
            try {
                for (int i = 0; i < n2; ++i) {
                    int n10 = bl4 ? (n2 - 1 - i) * n3 * 8 : i * n3 * 8;
                    bitstream.position((long)n10);
                    for (int j = 0; j < n; ++j) {
                        PixelFormatUtil.convert(componentMap, composition2, (Bitstream<ByteBuffer>)bitstream2, composition, (Bitstream<ByteBuffer>)bitstream);
                    }
                    bitstream2.skip((long)(n4 * 8 - n7 * n));
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            if (DEBUG) {
                System.err.println("XXX: srcBitStream " + bitstream);
                System.err.println("XXX: dstBitStream " + bitstream2);
            }
        }
    }

    public static void convert(ComponentMap componentMap, PixelFormat.Composition composition, Bitstream<ByteBuffer> bitstream, PixelFormat.Composition composition2, Bitstream<ByteBuffer> bitstream2) throws IllegalStateException, IOException {
        int n;
        int n2 = composition2.componentCount();
        int n3 = composition.componentCount();
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n3];
        int[] nArray3 = composition2.componentBitCount();
        int[] nArray4 = composition2.componentBitMask();
        int[] nArray5 = composition.componentBitCount();
        for (n = 0; n < n2; ++n) {
            nArray[n] = bitstream2.readBits31(nArray3[n]) & nArray4[n];
        }
        bitstream2.skip((long)(composition2.bitStride() - composition2.bitsPerPixel()));
        for (n = 0; n < n3; ++n) {
            nArray2[n] = composition.defaultValue(n, false);
        }
        if (1 == n3 && PixelFormat.CType.Y == composition.componentOrder()[0] && componentMap.hasSrcRGB) {
            n = nArray[componentMap.srcRGBA[0]];
            int n4 = nArray[componentMap.srcRGBA[1]];
            int n5 = nArray[componentMap.srcRGBA[2]];
            float f = composition2.toFloat(n, componentMap.srcRGBA[0], false);
            float f2 = composition2.toFloat(n4, componentMap.srcRGBA[1], false);
            float f3 = composition2.toFloat(n5, componentMap.srcRGBA[2], false);
            int n6 = 1;
            float f4 = 1.0f;
            float f5 = (f + f2 + f3) * f4 / 3.0f;
            int n7 = composition.fromFloat(f5, 0, false);
            bitstream.writeBits31(nArray5[0], n7);
            bitstream.skip((long)(composition.bitStride() - composition.bitsPerPixel()));
            if (DEBUG && bitstream2.position() <= 32L) {
                System.err.printf("convert: rgb[a] -> Y: rgb 0x%02X 0x%02X 0x%02X 0x%02X -> %f %f %f %f -> %f -> dstC 0 0x%08X (%d bits: %s)%n", n, n4, n5, n6, Float.valueOf(f), Float.valueOf(f2), Float.valueOf(f3), Float.valueOf(f4), Float.valueOf(f5), n7, nArray5[0], Bitstream.toBinString((boolean)true, (int)n7, (int)nArray5[0]));
            }
            return;
        }
        for (n = 0; n < n3; ++n) {
            int n8 = componentMap.dst2src[n];
            if (0 <= n8) {
                float f = composition2.toFloat(nArray[n8], n8, false);
                int n9 = composition.fromFloat(f, n, false);
                bitstream.writeBits31(nArray5[n], n9);
                if (!DEBUG || bitstream2.position() > 32L) continue;
                System.err.printf("convert: srcC %d: 0x%08X -> %f -> dstC %d 0x%08X (%d bits: %s)%n", n8, nArray[n8], Float.valueOf(f), n, n9, nArray5[n], Bitstream.toBinString((boolean)true, (int)n9, (int)nArray5[n]));
                continue;
            }
            bitstream.writeBits31(nArray5[n], nArray2[n]);
            if (!DEBUG || bitstream2.position() > 32L) continue;
            System.err.printf("convert: srcC %d: undef -> dstC %d 0x%08X (%d bits: %s)%n", n8, n, nArray2[n], nArray5[n], Bitstream.toBinString((boolean)true, (int)nArray2[n], (int)nArray5[n]));
        }
        bitstream.skip((long)(composition.bitStride() - composition.bitsPerPixel()));
    }

    public static class ComponentMap {
        final int[] dst2src;
        final int[] src2dst;
        final int[] srcRGBA;
        final boolean hasSrcRGB;

        public ComponentMap(PixelFormat.Composition composition, PixelFormat.Composition composition2) {
            int n;
            int n2 = composition.componentCount();
            int n3 = composition2.componentCount();
            PixelFormat.CType[] cTypeArray = composition.componentOrder();
            PixelFormat.CType[] cTypeArray2 = composition2.componentOrder();
            this.dst2src = new int[n3];
            for (n = 0; n < n3; ++n) {
                this.dst2src[n] = PixelFormatUtil.find(cTypeArray2[n], cTypeArray, true);
            }
            this.src2dst = new int[n2];
            for (n = 0; n < n2; ++n) {
                this.src2dst[n] = PixelFormatUtil.find(cTypeArray[n], cTypeArray2, true);
            }
            this.srcRGBA = new int[4];
            this.srcRGBA[0] = PixelFormatUtil.find(PixelFormat.CType.R, cTypeArray, false);
            this.srcRGBA[1] = PixelFormatUtil.find(PixelFormat.CType.G, cTypeArray, false);
            this.srcRGBA[2] = PixelFormatUtil.find(PixelFormat.CType.B, cTypeArray, false);
            this.srcRGBA[3] = PixelFormatUtil.find(PixelFormat.CType.A, cTypeArray, false);
            this.hasSrcRGB = 0 <= this.srcRGBA[0] && 0 <= this.srcRGBA[1] && 0 <= this.srcRGBA[2];
        }
    }
}

