/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.dom;

import io.sf.carte.echosvg.dom.AbstractDocument;
import io.sf.carte.echosvg.dom.AbstractProcessingInstruction;
import io.sf.carte.echosvg.dom.StyleSheetFactory;
import io.sf.carte.echosvg.dom.util.DOMUtilities;
import java.util.HashMap;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.stylesheets.LinkStyle;
import org.w3c.dom.stylesheets.StyleSheet;

public class StyleSheetProcessingInstruction
extends AbstractProcessingInstruction
implements LinkStyle {
    private static final long serialVersionUID = 1L;
    protected boolean readonly;
    protected transient StyleSheet sheet;
    protected StyleSheetFactory factory;
    protected transient HashMap<String, String> pseudoAttributes;

    protected StyleSheetProcessingInstruction() {
    }

    public StyleSheetProcessingInstruction(String string, AbstractDocument abstractDocument, StyleSheetFactory styleSheetFactory) {
        this.ownerDocument = abstractDocument;
        this.setData(string);
        this.factory = styleSheetFactory;
    }

    @Override
    public boolean isReadonly() {
        return this.readonly;
    }

    @Override
    public void setReadonly(boolean bl) {
        this.readonly = bl;
    }

    @Override
    public void setNodeName(String string) {
    }

    @Override
    public String getTarget() {
        return "xml-stylesheet";
    }

    @Override
    public StyleSheet getSheet() {
        if (this.sheet == null) {
            this.sheet = this.factory.createStyleSheet(this, this.getPseudoAttributes());
        }
        return this.sheet;
    }

    public HashMap<String, String> getPseudoAttributes() {
        if (this.pseudoAttributes == null) {
            this.pseudoAttributes = new HashMap();
            this.pseudoAttributes.put("alternate", "no");
            this.pseudoAttributes.put("media", "all");
            DOMUtilities.parseStyleSheetPIData(this.data, this.pseudoAttributes);
        }
        return this.pseudoAttributes;
    }

    @Override
    public void setData(String string) throws DOMException {
        super.setData(string);
        this.sheet = null;
        this.pseudoAttributes = null;
    }

    @Override
    protected Node newNode() {
        return new StyleSheetProcessingInstruction();
    }
}

