/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.xml.dtd;

import io.sf.carte.util.agent.AgentUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import org.w3c.dom.DocumentType;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.EntityResolver2;

public class DefaultEntityResolver
implements EntityResolver2 {
    private final HashMap<String, String> systemIdToFilename = new HashMap(69, 0.4f);
    private final HashMap<String, String> systemIdToPublicId = new HashMap(14);
    private static final DTDLoader dtdLoader = DefaultEntityResolver.createDTDLoader();
    private ClassLoader loader = null;
    private HashSet<String> whitelist = null;
    private static final String XHTML1_TRA_PUBLICID = "-//W3C//DTD XHTML 1.0 Transitional//EN";
    private static final String XHTML1_TRA_SYSTEMID = "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd";

    public DefaultEntityResolver() {
        this(true);
    }

    public DefaultEntityResolver(boolean bl) {
        this.systemIdToFilename.put("https://www.w3.org/TR/html5/entities.dtd", "/io/sf/carte/doc/xml/dtd/w3c/xhtml5.ent");
        this.systemIdToFilename.put("http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd", "/io/sf/carte/doc/xml/dtd/w3c/xhtml1-strict.dtd");
        this.systemIdToFilename.put(XHTML1_TRA_SYSTEMID, "/io/sf/carte/doc/xml/dtd/w3c/xhtml1-transitional.dtd");
        this.systemIdToFilename.put("http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd", "/io/sf/carte/doc/xml/dtd/w3c/xhtml11.dtd");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml11.dtd", "/io/sf/carte/doc/xml/dtd/w3c/xhtml11.dtd");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-lat1.ent", "/io/sf/carte/doc/xml/dtd/w3c/xhtml5.ent");
        this.systemIdToFilename.put("http://www.w3.org/TR/xhtml11/DTD/xhtml-lat1.ent", "/io/sf/carte/doc/xml/dtd/w3c/xhtml5.ent");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-symbol.ent", "/io/sf/carte/doc/xml/dtd/w3c/xhtml-symbol.ent");
        this.systemIdToFilename.put("http://www.w3.org/TR/xhtml11/DTD/xhtml-symbol.ent", "/io/sf/carte/doc/xml/dtd/w3c/xhtml-symbol.ent");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-special.ent", "/io/sf/carte/doc/xml/dtd/w3c/xhtml-special.ent");
        this.systemIdToFilename.put("http://www.w3.org/TR/xhtml11/DTD/xhtml-special.ent", "/io/sf/carte/doc/xml/dtd/w3c/xhtml-special.ent");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-inlstyle-1.mod", "/io/sf/carte/doc/xml/dtd/w3c/xhtml-inlstyle-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml11-model-1.mod", "/io/sf/carte/doc/xml/dtd/w3c/xhtml11-model-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-datatypes-1.mod", "/io/sf/carte/doc/xml/dtd/w3c/xhtml-datatypes-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-framework-1.mod", "/io/sf/carte/doc/xml/dtd/w3c/xhtml-framework-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-text-1.mod", "/io/sf/carte/doc/xml/dtd/w3c/xhtml-text-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-hypertext-1.mod", "/io/sf/carte/doc/xml/dtd/w3c/xhtml-hypertext-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-list-1.mod", "/io/sf/carte/doc/xml/dtd/w3c/xhtml-list-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-edit-1.mod", "/io/sf/carte/doc/xml/dtd/w3c/xhtml-edit-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-bdo-1.mod", "/io/sf/carte/doc/xml/dtd/w3c/xhtml-bdo-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-ruby-1.mod", "/io/sf/carte/doc/xml/dtd/w3c/xhtml-ruby-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-pres-1.mod", "/io/sf/carte/doc/xml/dtd/w3c/xhtml-pres-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-link-1.mod", "/io/sf/carte/doc/xml/dtd/w3c/xhtml-link-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-meta-1.mod", "/io/sf/carte/doc/xml/dtd/w3c/xhtml-meta-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-base-1.mod", "/io/sf/carte/doc/xml/dtd/w3c/xhtml-base-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-script-1.mod", "/io/sf/carte/doc/xml/dtd/w3c/xhtml-script-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-style-1.mod", "/io/sf/carte/doc/xml/dtd/w3c/xhtml-style-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-image-1.mod", "/io/sf/carte/doc/xml/dtd/w3c/xhtml-image-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-csismap-1.mod", "/io/sf/carte/doc/xml/dtd/w3c/xhtml-csismap-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-ssismap-1.mod", "/io/sf/carte/doc/xml/dtd/w3c/xhtml-ssismap-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-param-1.mod", "/io/sf/carte/doc/xml/dtd/w3c/xhtml-param-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-object-1.mod", "/io/sf/carte/doc/xml/dtd/w3c/xhtml-object-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-table-1.mod", "/io/sf/carte/doc/xml/dtd/w3c/xhtml-table-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-form-1.mod", "/io/sf/carte/doc/xml/dtd/w3c/xhtml-form-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-legacy-1.mod", "/io/sf/carte/doc/xml/dtd/w3c/xhtml-legacy-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-struct-1.mod", "/io/sf/carte/doc/xml/dtd/w3c/xhtml-struct-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/TR/xhtml1/DTD/xhtml1-frameset.dtd", "/io/sf/carte/doc/xml/dtd/w3c/xhtml1-frameset.dtd");
        this.systemIdToFilename.put("http://www.w3.org/TR/xhtml-basic/xhtml-basic11.dtd", "/io/sf/carte/doc/xml/dtd/w3c/xhtml-basic11.dtd");
        this.systemIdToFilename.put("http://www.w3.org/TR/html4/strict.dtd", "/io/sf/carte/doc/xml/dtd/w3c/html4-strict.dtd");
        this.systemIdToFilename.put("http://www.w3.org/TR/html4/loose.dtd", "/io/sf/carte/doc/xml/dtd/w3c/html4-loose.dtd");
        this.systemIdToFilename.put("http://www.w3.org/TR/html4/frameset.dtd", "/io/sf/carte/doc/xml/dtd/w3c/html4-frameset.dtd");
        this.systemIdToFilename.put("http://www.w3.org/Math/DTD/mathml2/mathml2.dtd", "/io/sf/carte/doc/xml/dtd/w3c/mathml2.dtd");
        this.systemIdToFilename.put("http://www.w3.org/Math/DTD/mathml1/mathml.dtd", "/io/sf/carte/doc/xml/dtd/w3c/mathml.dtd");
        this.systemIdToFilename.put("http://www.w3.org/2002/04/xhtml-math-svg/xhtml-math-svg.dtd", "/io/sf/carte/doc/xml/dtd/w3c/xhtml-math-svg.dtd");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-inlstruct-1.mod", "/io/sf/carte/doc/xml/dtd/w3c/xhtml-inlstruct-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-inlphras-1.mod", "/io/sf/carte/doc/xml/dtd/w3c/xhtml-inlphras-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-blkstruct-1.mod", "/io/sf/carte/doc/xml/dtd/w3c/xhtml-blkstruct-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-blkphras-1.mod", "/io/sf/carte/doc/xml/dtd/w3c/xhtml-blkphras-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-applet-1.mod", "/io/sf/carte/doc/xml/dtd/w3c/xhtml-applet-1.dtd");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-blkpres-1.mod", "/io/sf/carte/doc/xml/dtd/w3c/xhtml-blkpres-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-basic-form-1.mod", "/io/sf/carte/doc/xml/dtd/w3c/xhtml-basic-form-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-basic-table-1.mod", "/io/sf/carte/doc/xml/dtd/w3c/xhtml-basic-table-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-frames-1.mod", "/io/sf/carte/doc/xml/dtd/w3c/xhtml-frames-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-target-1.mod", "/io/sf/carte/doc/xml/dtd/w3c/xhtml-target-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-iframe-1.mod", "/io/sf/carte/doc/xml/dtd/w3c/xhtml-iframe-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-events-1.mod", "/io/sf/carte/doc/xml/dtd/w3c/xhtml-events-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-nameident-1.mod", "/io/sf/carte/doc/xml/dtd/w3c/xhtml-nameident-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-legacy-redecl-1.mod", "/io/sf/carte/doc/xml/dtd/w3c/xhtml-legacy-redecl-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-inlpres-1.mod", "/io/sf/carte/doc/xml/dtd/w3c/xhtml-inlpres-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-arch-1.mod", "/io/sf/carte/doc/xml/dtd/w3c/xhtml-arch-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-notations-1.mod", "/io/sf/carte/doc/xml/dtd/w3c/xhtml-notations-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-qname-1.mod", "/io/sf/carte/doc/xml/dtd/w3c/xhtml-qname-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-attribs-1.mod", "/io/sf/carte/doc/xml/dtd/w3c/xhtml-attribs-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-charent-1.mod", "/io/sf/carte/doc/xml/dtd/w3c/xhtml-charent-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-basic11-model-1.mod", "/io/sf/carte/doc/xml/dtd/w3c/xhtml-basic11-model-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/MarkUp/DTD/xhtml-inputmode-1.mod", "/io/sf/carte/doc/xml/dtd/w3c/xhtml-inputmode-1.mod");
        this.systemIdToFilename.put("http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd", "/io/sf/carte/doc/xml/dtd/w3c/svg11.dtd");
        this.systemIdToFilename.put("http://www.w3.org/TR/2001/REC-SVG-20010904/DTD/svg10.dtd", "/io/sf/carte/doc/xml/dtd/w3c/svg10.dtd");
        this.systemIdToPublicId.put("http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd", "-//W3C//DTD XHTML 1.0 Strict//EN");
        this.systemIdToPublicId.put(XHTML1_TRA_SYSTEMID, XHTML1_TRA_PUBLICID);
        this.systemIdToPublicId.put("http://www.w3.org/MarkUp/DTD/xhtml11.dtd", "-//W3C//DTD XHTML 1.1//EN");
        this.systemIdToPublicId.put("http://www.w3.org/TR/xhtml11/DTD/xhtml-lat1.ent", "-//W3C//ENTITIES Latin 1 for XHTML//EN");
        this.systemIdToPublicId.put("http://www.w3.org/TR/xhtml11/DTD/xhtml-symbol.ent", "-//W3C//ENTITIES Symbols for XHTML//EN");
        this.systemIdToPublicId.put("http://www.w3.org/TR/xhtml11/DTD/xhtml-special.ent", "-//W3C//ENTITIES Special for XHTML//EN");
        this.systemIdToPublicId.put("http://www.w3.org/TR/html4/strict.dtd", "-//W3C//DTD HTML 4.01//EN");
        this.systemIdToPublicId.put("http://www.w3.org/TR/html4/loose.dtd", "-//W3C//DTD HTML 4.01 Transitional//EN");
        this.systemIdToPublicId.put("http://www.w3.org/TR/html4/frameset.dtd", "-//W3C//DTD HTML 4.01 Frameset//EN");
        this.systemIdToPublicId.put("http://www.w3.org/Math/DTD/mathml2/mathml2.dtd", "-//W3C//DTD MathML 2.0//EN");
        this.systemIdToPublicId.put("http://www.w3.org/Math/DTD/mathml1/mathml.dtd", "math");
        this.systemIdToPublicId.put("http://www.w3.org/2002/04/xhtml-math-svg/xhtml-math-svg.dtd", "-//W3C//DTD XHTML 1.1 plus MathML 2.0 plus SVG 1.1//EN");
        this.systemIdToPublicId.put("http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd", "-//W3C//DTD SVG 1.1//EN");
        this.systemIdToPublicId.put("http://www.w3.org/TR/2001/REC-SVG-20010904/DTD/svg10.dtd", "-//W3C//DTD SVG 1.0//EN");
        if (bl) {
            this.whitelist = new HashSet(1);
        }
    }

    public void addHostToWhiteList(String string) {
        if (string != null) {
            if (this.whitelist == null) {
                this.whitelist = new HashSet(4);
            }
            this.whitelist.add(string.toLowerCase(Locale.ROOT));
        }
    }

    @Override
    public InputSource getExternalSubset(String string, String string2) throws SAXException, IOException {
        InputSource inputSource = this.findExternalSubset(string, string2);
        if (inputSource == null) {
            String string3 = this.systemIdToFilename.get("https://www.w3.org/TR/html5/entities.dtd");
            Reader reader = dtdLoader.loadDTDfromClasspath(this.loader, string3);
            if (reader != null) {
                inputSource = new InputSource(reader);
            } else {
                throw new IOException("Could not find resource: " + string3);
            }
        }
        return inputSource;
    }

    private InputSource findExternalSubset(String string, String string2) throws SAXException, IOException {
        InputSource inputSource;
        if ("html".equalsIgnoreCase(string)) {
            inputSource = this.resolveEntity("[dtd]", XHTML1_TRA_PUBLICID, string2, XHTML1_TRA_SYSTEMID);
            inputSource.setPublicId(null);
            inputSource.setSystemId(null);
        } else {
            inputSource = null;
        }
        return inputSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean registerSystemIdFilename(String string, String string2) {
        String string3;
        if (string2 == null || string == null) {
            throw new NullPointerException("Null SystemId or filename.");
        }
        if (this.isInvalidPath(string2)) {
            throw new IllegalArgumentException("Bad DTD filename.");
        }
        HashMap<String, String> hashMap = this.systemIdToFilename;
        synchronized (hashMap) {
            string3 = this.systemIdToFilename.putIfAbsent(string, string2);
        }
        return string3 == null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public InputSource resolveEntity(String string, String string2, String string3, String object) throws SAXException, IOException {
        Object object2;
        if (string2 == null) {
            string2 = this.systemIdToPublicId.get(object);
        } else if (object == null) {
            object = this.getSystemIdFromPublicId(string2);
        }
        String string4 = this.systemIdToFilename.get(object);
        if (string4 == null && string2 != null && (object2 = this.getSystemIdFromPublicId(string2)) != null) {
            string4 = this.systemIdToFilename.get(object2);
            object = object2;
        }
        object2 = null;
        if (string4 != null) {
            Reader reader = dtdLoader.loadDTDfromClasspath(this.loader, string4);
            if (reader == null) throw new SAXException("Could not find resource: " + string4);
            object2 = new InputSource(reader);
            ((InputSource)object2).setPublicId(string2);
            if (object == null) return object2;
            ((InputSource)object2).setSystemId((String)object);
            return object2;
        } else {
            int n;
            URL uRL;
            if (object == null) return this.findExternalSubset(string, string3);
            if (string3 != null) {
                URL uRL2 = new URL(string3);
                uRL = new URL(uRL2, (String)object);
            } else {
                uRL = new URL((String)object);
            }
            if (this.isInvalidProtocol(uRL.getProtocol())) {
                throw new SAXException("Invalid url protocol: " + uRL.getProtocol());
            }
            if (this.isWhitelistEnabled() && !this.isWhitelistedHost(uRL.getHost())) {
                throw new SAXException("Whitelist is enabled, and attempted to retrieve data from " + uRL.toExternalForm());
            }
            boolean bl = this.isInvalidPath(uRL.getPath());
            String string5 = "UTF-8";
            URLConnection uRLConnection = this.openConnection(uRL);
            this.connect(uRLConnection);
            String string6 = uRLConnection.getContentType();
            if (string6 != null && (n = string6.indexOf(59)) != -1 && n < string6.length()) {
                string6 = string6.substring(0, n);
                string5 = AgentUtil.findCharset((String)string6, (int)(n + 1));
            }
            if (bl && !this.isValidContentType(string6)) {
                if (uRLConnection instanceof HttpURLConnection) {
                    ((HttpURLConnection)uRLConnection).disconnect();
                }
                String string7 = uRL.toExternalForm();
                if (string6 != null) {
                    string6 = string6.replaceAll("\\p{Cc}", "*CTRL*");
                    string7 = "URL served with invalid type (" + string6 + "): " + string7;
                    throw new SAXException(string7);
                } else {
                    string7 = "URL served with invalid type: " + string7;
                }
                throw new SAXException(string7);
            }
            object2 = new InputSource();
            ((InputSource)object2).setSystemId(uRL.toExternalForm());
            if (string2 != null) {
                ((InputSource)object2).setPublicId(string2);
            }
            ((InputSource)object2).setEncoding(string5);
            InputStream inputStream = uRLConnection.getInputStream();
            ((InputSource)object2).setCharacterStream(new InputStreamReader(inputStream, string5));
        }
        return object2;
    }

    private String getSystemIdFromPublicId(String string) {
        for (Map.Entry<String, String> entry : this.systemIdToPublicId.entrySet()) {
            if (!string.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    protected boolean isInvalidPath(String string) {
        String string2;
        int n = string.length();
        return n < 5 || !(string2 = string.substring(n - 4)).equalsIgnoreCase(".dtd") && !string2.equalsIgnoreCase(".ent") && !string2.equalsIgnoreCase(".mod");
    }

    protected boolean isWhitelistEnabled() {
        return this.whitelist != null;
    }

    protected boolean isInvalidProtocol(String string) {
        return !string.equals("http") && !string.equals("https");
    }

    protected boolean isWhitelistedHost(String string) {
        return this.whitelist.contains(string.toLowerCase(Locale.ROOT));
    }

    protected URLConnection openConnection(URL uRL) throws IOException {
        return uRL.openConnection();
    }

    protected void connect(URLConnection uRLConnection) throws IOException {
        uRLConnection.setConnectTimeout(60000);
        dtdLoader.connect(uRLConnection);
    }

    protected boolean isValidContentType(String string) {
        return string != null && (string.equals("application/xml-dtd") || string.equals("text/xml-external-parsed-entity") || string.equals("application/xml-external-parsed-entity"));
    }

    @Override
    public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
        return this.resolveEntity(null, string, null, string2);
    }

    public InputSource resolveEntity(DocumentType documentType) throws SAXException, IOException {
        return this.resolveEntity(documentType.getName(), documentType.getPublicId(), documentType.getBaseURI(), documentType.getSystemId());
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.loader = classLoader;
    }

    private static DTDLoader createDTDLoader() {
        DTDLoader dTDLoader;
        try {
            Class<?> clazz = Class.forName("io.sf.carte.doc.xml.dtd.SMDTDLoader");
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            dTDLoader = (DTDLoader)constructor.newInstance(new Object[0]);
        }
        catch (Exception exception) {
            dTDLoader = new SimpleDTDLoader();
        }
        return dTDLoader;
    }

    static abstract class DTDLoader {
        DTDLoader() {
        }

        abstract void connect(URLConnection var1) throws IOException;

        abstract Reader loadDTDfromClasspath(ClassLoader var1, String var2);
    }

    private static class SimpleDTDLoader
    extends DTDLoader {
        private SimpleDTDLoader() {
        }

        @Override
        void connect(URLConnection uRLConnection) throws IOException {
            uRLConnection.connect();
        }

        @Override
        Reader loadDTDfromClasspath(ClassLoader classLoader, String string) {
            InputStream inputStream = classLoader != null ? classLoader.getResourceAsStream(string) : DefaultEntityResolver.class.getResourceAsStream(string);
            if (inputStream == null) {
                inputStream = ClassLoader.getSystemResourceAsStream(string);
            }
            InputStreamReader inputStreamReader = null;
            if (inputStream != null) {
                inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
            }
            return inputStreamReader;
        }
    }
}

