/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.shell;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.nio.charset.Charset;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.tools.shell.FlexibleCompletor;

public abstract class ShellConsole {
    private static final Class[] NO_ARG = new Class[0];
    private static final Class[] BOOLEAN_ARG = new Class[]{Boolean.TYPE};
    private static final Class[] STRING_ARG = new Class[]{String.class};
    private static final Class[] CHARSEQ_ARG = new Class[]{CharSequence.class};

    protected ShellConsole() {
    }

    public abstract InputStream getIn();

    public abstract String readLine() throws IOException;

    public abstract String readLine(String var1) throws IOException;

    public abstract void flush() throws IOException;

    public abstract void print(String var1) throws IOException;

    public abstract void println() throws IOException;

    public abstract void println(String var1) throws IOException;

    private static Object tryInvoke(Object object, String string, Class[] classArray, Object ... objectArray) {
        try {
            Method method = object.getClass().getDeclaredMethod(string, classArray);
            if (method != null) {
                return method.invoke(object, objectArray);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return null;
    }

    public static ShellConsole getConsole(InputStream inputStream, PrintStream printStream, Charset charset) {
        return new SimpleShellConsole(inputStream, printStream, charset);
    }

    public static ShellConsole getConsole(Scriptable scriptable, Charset charset) {
        ClassLoader classLoader = ShellConsole.class.getClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        if (classLoader == null) {
            return null;
        }
        try {
            Class<?> clazz = Kit.classOrNull(classLoader, "jline.console.ConsoleReader");
            if (clazz != null) {
                return ShellConsole.getJLineShellConsoleV2(classLoader, clazz, scriptable, charset);
            }
            clazz = Kit.classOrNull(classLoader, "jline.ConsoleReader");
            if (clazz != null) {
                return ShellConsole.getJLineShellConsoleV1(classLoader, clazz, scriptable, charset);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return null;
    }

    private static JLineShellConsoleV1 getJLineShellConsoleV1(ClassLoader classLoader, Class<?> clazz, Scriptable scriptable, Charset charset) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<?> constructor = clazz.getConstructor(new Class[0]);
        Object obj = constructor.newInstance(new Object[0]);
        ShellConsole.tryInvoke(obj, "setBellEnabled", BOOLEAN_ARG, Boolean.FALSE);
        Class<?> clazz2 = Kit.classOrNull(classLoader, "jline.Completor");
        Object object = Proxy.newProxyInstance(classLoader, new Class[]{clazz2}, (InvocationHandler)new FlexibleCompletor(clazz2, scriptable));
        ShellConsole.tryInvoke(obj, "addCompletor", new Class[]{clazz2}, object);
        return new JLineShellConsoleV1(obj, charset);
    }

    private static JLineShellConsoleV2 getJLineShellConsoleV2(ClassLoader classLoader, Class<?> clazz, Scriptable scriptable, Charset charset) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<?> constructor = clazz.getConstructor(new Class[0]);
        Object obj = constructor.newInstance(new Object[0]);
        ShellConsole.tryInvoke(obj, "setBellEnabled", BOOLEAN_ARG, Boolean.FALSE);
        Class<?> clazz2 = Kit.classOrNull(classLoader, "jline.console.completer.Completer");
        Object object = Proxy.newProxyInstance(classLoader, new Class[]{clazz2}, (InvocationHandler)new FlexibleCompletor(clazz2, scriptable));
        ShellConsole.tryInvoke(obj, "addCompleter", new Class[]{clazz2}, object);
        return new JLineShellConsoleV2(obj, charset);
    }

    private static class ConsoleInputStream
    extends InputStream {
        private static final byte[] EMPTY = new byte[0];
        private final ShellConsole console;
        private final Charset cs;
        private byte[] buffer = EMPTY;
        private int cursor = -1;
        private boolean atEOF = false;

        public ConsoleInputStream(ShellConsole shellConsole, Charset charset) {
            this.console = shellConsole;
            this.cs = charset;
        }

        @Override
        public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
            if (byArray == null) {
                throw new NullPointerException();
            }
            if (n < 0 || n2 < 0 || n2 > byArray.length - n) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return 0;
            }
            if (!this.ensureInput()) {
                return -1;
            }
            int n3 = Math.min(n2, this.buffer.length - this.cursor);
            for (int i = 0; i < n3; ++i) {
                byArray[n + i] = this.buffer[this.cursor + i];
            }
            if (n3 < n2) {
                byArray[n + n3++] = 10;
            }
            this.cursor += n3;
            return n3;
        }

        @Override
        public synchronized int read() throws IOException {
            if (!this.ensureInput()) {
                return -1;
            }
            if (this.cursor == this.buffer.length) {
                ++this.cursor;
                return 10;
            }
            return this.buffer[this.cursor++];
        }

        private boolean ensureInput() throws IOException {
            if (this.atEOF) {
                return false;
            }
            if (this.cursor < 0 || this.cursor > this.buffer.length) {
                if (this.readNextLine() == -1) {
                    this.atEOF = true;
                    return false;
                }
                this.cursor = 0;
            }
            return true;
        }

        private int readNextLine() throws IOException {
            String string = this.console.readLine(null);
            if (string != null) {
                this.buffer = string.getBytes(this.cs);
                return this.buffer.length;
            }
            this.buffer = EMPTY;
            return -1;
        }
    }

    private static class JLineShellConsoleV1
    extends ShellConsole {
        private final Object reader;
        private final InputStream in;

        JLineShellConsoleV1(Object object, Charset charset) {
            this.reader = object;
            this.in = new ConsoleInputStream(this, charset);
        }

        @Override
        public InputStream getIn() {
            return this.in;
        }

        @Override
        public String readLine() throws IOException {
            return (String)ShellConsole.tryInvoke(this.reader, "readLine", NO_ARG, new Object[0]);
        }

        @Override
        public String readLine(String string) throws IOException {
            return (String)ShellConsole.tryInvoke(this.reader, "readLine", STRING_ARG, new Object[]{string});
        }

        @Override
        public void flush() throws IOException {
            ShellConsole.tryInvoke(this.reader, "flushConsole", NO_ARG, new Object[0]);
        }

        @Override
        public void print(String string) throws IOException {
            ShellConsole.tryInvoke(this.reader, "printString", STRING_ARG, new Object[]{string});
        }

        @Override
        public void println() throws IOException {
            ShellConsole.tryInvoke(this.reader, "printNewline", NO_ARG, new Object[0]);
        }

        @Override
        public void println(String string) throws IOException {
            ShellConsole.tryInvoke(this.reader, "printString", STRING_ARG, new Object[]{string});
            ShellConsole.tryInvoke(this.reader, "printNewline", NO_ARG, new Object[0]);
        }
    }

    private static class JLineShellConsoleV2
    extends ShellConsole {
        private final Object reader;
        private final InputStream in;

        JLineShellConsoleV2(Object object, Charset charset) {
            this.reader = object;
            this.in = new ConsoleInputStream(this, charset);
        }

        @Override
        public InputStream getIn() {
            return this.in;
        }

        @Override
        public String readLine() throws IOException {
            return (String)ShellConsole.tryInvoke(this.reader, "readLine", NO_ARG, new Object[0]);
        }

        @Override
        public String readLine(String string) throws IOException {
            return (String)ShellConsole.tryInvoke(this.reader, "readLine", STRING_ARG, new Object[]{string});
        }

        @Override
        public void flush() throws IOException {
            ShellConsole.tryInvoke(this.reader, "flush", NO_ARG, new Object[0]);
        }

        @Override
        public void print(String string) throws IOException {
            ShellConsole.tryInvoke(this.reader, "print", CHARSEQ_ARG, new Object[]{string});
        }

        @Override
        public void println() throws IOException {
            ShellConsole.tryInvoke(this.reader, "println", NO_ARG, new Object[0]);
        }

        @Override
        public void println(String string) throws IOException {
            ShellConsole.tryInvoke(this.reader, "println", CHARSEQ_ARG, new Object[]{string});
        }
    }

    private static class SimpleShellConsole
    extends ShellConsole {
        private final InputStream in;
        private final PrintWriter out;
        private final BufferedReader reader;

        SimpleShellConsole(InputStream inputStream, PrintStream printStream, Charset charset) {
            this.in = inputStream;
            this.out = new PrintWriter(printStream);
            this.reader = new BufferedReader(new InputStreamReader(inputStream, charset));
        }

        @Override
        public InputStream getIn() {
            return this.in;
        }

        @Override
        public String readLine() throws IOException {
            return this.reader.readLine();
        }

        @Override
        public String readLine(String string) throws IOException {
            if (string != null) {
                this.out.write(string);
                this.out.flush();
            }
            return this.reader.readLine();
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public void print(String string) throws IOException {
            this.out.print(string);
        }

        @Override
        public void println() throws IOException {
            this.out.println();
        }

        @Override
        public void println(String string) throws IOException {
            this.out.println(string);
        }
    }
}

