/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.shell;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.GeneratedClassLoader;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.SecurityController;
import org.mozilla.javascript.commonjs.module.ModuleScope;
import org.mozilla.javascript.commonjs.module.Require;
import org.mozilla.javascript.tools.SourceReader;
import org.mozilla.javascript.tools.ToolErrorReporter;
import org.mozilla.javascript.tools.shell.Global;
import org.mozilla.javascript.tools.shell.QuitAction;
import org.mozilla.javascript.tools.shell.SecurityProxy;
import org.mozilla.javascript.tools.shell.ShellConsole;
import org.mozilla.javascript.tools.shell.ShellContextFactory;
import org.mozilla.javascript.tools.shell.Timers;

public class Main {
    public static ShellContextFactory shellContextFactory = new ShellContextFactory();
    public static Global global = new Global();
    protected static ToolErrorReporter errorReporter;
    protected static int exitCode;
    private static final int EXITCODE_RUNTIME_ERROR = 3;
    private static final int EXITCODE_FILE_NOT_FOUND = 4;
    static boolean processStdin;
    static List<String> fileList;
    static List<String> modulePath;
    static String mainModule;
    static boolean sandboxed;
    static boolean useRequire;
    static Require require;
    private static SecurityProxy securityImpl;
    private static final ScriptCache scriptCache;

    public static void main(String[] stringArray) {
        try {
            if (Boolean.getBoolean("rhino.use_java_policy_security")) {
                Main.initJavaPolicySecuritySupport();
            }
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace(System.err);
        }
        int n = Main.exec(stringArray);
        if (n != 0) {
            System.exit(n);
        }
    }

    public static int exec(String[] stringArray) {
        errorReporter = new ToolErrorReporter(false, global.getErr());
        shellContextFactory.setErrorReporter(errorReporter);
        String[] stringArray2 = Main.processOptions(stringArray);
        if (exitCode > 0) {
            return exitCode;
        }
        if (processStdin) {
            fileList.add(null);
        }
        if (!Main.global.initialized) {
            global.init(shellContextFactory);
        }
        IProxy iProxy = new IProxy(1);
        iProxy.args = stringArray2;
        shellContextFactory.call(iProxy);
        return exitCode;
    }

    static void processFiles(Context context, String[] stringArray) {
        Object[] objectArray = new Object[stringArray.length];
        System.arraycopy(stringArray, 0, objectArray, 0, stringArray.length);
        Scriptable scriptable = context.newArray((Scriptable)global, objectArray);
        global.defineProperty("arguments", (Object)scriptable, 2);
        for (String string : fileList) {
            try {
                Main.processSource(context, string);
            }
            catch (IOException iOException) {
                Context.reportError(ToolErrorReporter.getMessage("msg.couldnt.read.source", string, iOException.getMessage()));
                exitCode = 4;
            }
            catch (RhinoException rhinoException) {
                ToolErrorReporter.reportException(context.getErrorReporter(), rhinoException);
                exitCode = 3;
            }
            catch (VirtualMachineError virtualMachineError) {
                virtualMachineError.printStackTrace();
                String string2 = ToolErrorReporter.getMessage("msg.uncaughtJSException", virtualMachineError.toString());
                Context.reportError(string2);
                exitCode = 3;
            }
        }
    }

    static void evalInlineScript(Context context, String string) {
        try {
            Script script = context.compileString(string, "<command>", 1, null);
            if (script != null) {
                script.exec(context, Main.getShellScope());
            }
        }
        catch (RhinoException rhinoException) {
            ToolErrorReporter.reportException(context.getErrorReporter(), rhinoException);
            exitCode = 3;
        }
        catch (VirtualMachineError virtualMachineError) {
            virtualMachineError.printStackTrace();
            String string2 = ToolErrorReporter.getMessage("msg.uncaughtJSException", virtualMachineError.toString());
            Context.reportError(string2);
            exitCode = 3;
        }
    }

    public static Global getGlobal() {
        return global;
    }

    static Scriptable getShellScope() {
        return Main.getScope(null);
    }

    static Scriptable getScope(String string) {
        if (useRequire) {
            URI uRI;
            if (string == null) {
                uRI = new File(System.getProperty("user.dir")).toURI();
            } else if (SourceReader.toUrl(string) != null) {
                try {
                    uRI = new URI(string);
                }
                catch (URISyntaxException uRISyntaxException) {
                    uRI = new File(string).toURI();
                }
            } else {
                uRI = new File(string).toURI();
            }
            return new ModuleScope(global, uRI, null);
        }
        return global;
    }

    public static String[] processOptions(String[] stringArray) {
        String string;
        int n = 0;
        while (true) {
            if (n == stringArray.length) {
                return new String[0];
            }
            String string2 = stringArray[n];
            if (!string2.startsWith("-")) {
                processStdin = false;
                fileList.add(string2);
                mainModule = string2;
                String[] stringArray2 = new String[stringArray.length - n - 1];
                System.arraycopy(stringArray, n + 1, stringArray2, 0, stringArray.length - n - 1);
                return stringArray2;
            }
            if (string2.equals("-version")) {
                int n2;
                if (++n == stringArray.length) {
                    string = string2;
                    break;
                }
                try {
                    n2 = Integer.parseInt(stringArray[n]);
                }
                catch (NumberFormatException numberFormatException) {
                    string = stringArray[n];
                    break;
                }
                if (!Context.isValidLanguageVersion(n2)) {
                    string = stringArray[n];
                    break;
                }
                shellContextFactory.setLanguageVersion(n2);
            } else if (string2.equals("-opt") || string2.equals("-O")) {
                int n3;
                if (++n == stringArray.length) {
                    string = string2;
                    break;
                }
                try {
                    n3 = Integer.parseInt(stringArray[n]);
                }
                catch (NumberFormatException numberFormatException) {
                    string = stringArray[n];
                    break;
                }
                if (n3 == -2) {
                    n3 = -1;
                } else if (!Context.isValidOptimizationLevel(n3)) {
                    string = stringArray[n];
                    break;
                }
                shellContextFactory.setOptimizationLevel(n3);
            } else if (string2.equals("-encoding")) {
                if (++n == stringArray.length) {
                    string = string2;
                    break;
                }
                String string3 = stringArray[n];
                shellContextFactory.setCharacterEncoding(string3);
            } else if (string2.equals("-strict")) {
                shellContextFactory.setStrictMode(true);
                shellContextFactory.setAllowReservedKeywords(false);
                errorReporter.setIsReportingWarnings(true);
            } else if (string2.equals("-fatal-warnings")) {
                shellContextFactory.setWarningAsError(true);
            } else if (string2.equals("-e")) {
                processStdin = false;
                if (++n == stringArray.length) {
                    string = string2;
                    break;
                }
                if (!Main.global.initialized) {
                    global.init(shellContextFactory);
                }
                IProxy iProxy = new IProxy(2);
                iProxy.scriptText = stringArray[n];
                shellContextFactory.call(iProxy);
            } else if (string2.equals("-require")) {
                useRequire = true;
            } else if (string2.equals("-sandbox")) {
                sandboxed = true;
                useRequire = true;
            } else if (string2.equals("-modules")) {
                if (++n == stringArray.length) {
                    string = string2;
                    break;
                }
                if (modulePath == null) {
                    modulePath = new ArrayList<String>();
                }
                modulePath.add(stringArray[n]);
                useRequire = true;
            } else if (string2.equals("-w")) {
                errorReporter.setIsReportingWarnings(true);
            } else if (string2.equals("-f")) {
                processStdin = false;
                if (++n == stringArray.length) {
                    string = string2;
                    break;
                }
                if (stringArray[n].equals("-")) {
                    fileList.add(null);
                } else {
                    fileList.add(stringArray[n]);
                    mainModule = stringArray[n];
                }
            } else if (string2.equals("-sealedlib")) {
                global.setSealedStdLib(true);
            } else if (string2.equals("-debug")) {
                shellContextFactory.setGeneratingDebug(true);
            } else {
                if (string2.equals("-?") || string2.equals("-help")) {
                    global.getOut().println(ToolErrorReporter.getMessage("msg.shell.usage", Main.class.getName()));
                    exitCode = 1;
                    return null;
                }
                string = string2;
                break;
            }
            ++n;
        }
        global.getOut().println(ToolErrorReporter.getMessage("msg.shell.invalid", string));
        global.getOut().println(ToolErrorReporter.getMessage("msg.shell.usage", Main.class.getName()));
        exitCode = 1;
        return null;
    }

    private static void initJavaPolicySecuritySupport() {
        try {
            Class<?> clazz = Class.forName("org.mozilla.javascript.tools.shell.JavaPolicySecurity");
            securityImpl = (SecurityProxy)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            SecurityController.initGlobal(securityImpl);
            return;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | LinkageError | NoSuchMethodException | InvocationTargetException throwable) {
            Throwable throwable2 = throwable;
            throw new IllegalStateException("Can not load security support: " + throwable2, throwable2);
        }
    }

    public static void processSource(Context context, String string) throws IOException {
        if (string == null || string.equals("-")) {
            Scriptable scriptable = Main.getShellScope();
            String string2 = shellContextFactory.getCharacterEncoding();
            Charset charset = string2 != null ? Charset.forName(string2) : Charset.defaultCharset();
            ShellConsole shellConsole = global.getConsole(charset);
            if (string == null) {
                shellConsole.println(context.getImplementationVersion());
            }
            int n = 1;
            boolean bl = false;
            while (!bl) {
                Object object;
                String string3;
                String[] stringArray = global.getPrompts(context);
                String string4 = null;
                if (string == null) {
                    string4 = stringArray[0];
                }
                shellConsole.flush();
                StringBuilder stringBuilder = new StringBuilder();
                while (true) {
                    try {
                        string3 = shellConsole.readLine(string4);
                    }
                    catch (IOException iOException) {
                        shellConsole.println(iOException.toString());
                        break;
                    }
                    if (string3 == null) {
                        bl = true;
                        break;
                    }
                    stringBuilder.append(string3).append('\n');
                    ++n;
                    if (context.stringIsCompilableUnit(stringBuilder.toString())) break;
                    string4 = stringArray[1];
                }
                try {
                    string3 = stringBuilder.toString();
                    object = context.compileString(string3, "<stdin>", n, null);
                    if (object != null) {
                        Object object2 = object.exec(context, scriptable);
                        if (!(object2 == Context.getUndefinedValue() || object2 instanceof Function && string3.trim().startsWith("function"))) {
                            try {
                                shellConsole.println(Context.toString(object2));
                            }
                            catch (RhinoException rhinoException) {
                                ToolErrorReporter.reportException(context.getErrorReporter(), rhinoException);
                            }
                        }
                        NativeArray nativeArray = Main.global.history;
                        nativeArray.put((int)nativeArray.getLength(), (Scriptable)nativeArray, (Object)stringBuilder);
                    }
                    Main.printPromiseWarnings(context);
                }
                catch (RhinoException rhinoException) {
                    ToolErrorReporter.reportException(context.getErrorReporter(), rhinoException);
                    exitCode = 3;
                }
                catch (VirtualMachineError virtualMachineError) {
                    virtualMachineError.printStackTrace();
                    object = ToolErrorReporter.getMessage("msg.uncaughtJSException", virtualMachineError.toString());
                    Context.reportError((String)object);
                    exitCode = 3;
                }
            }
            shellConsole.println();
            shellConsole.flush();
        } else if (useRequire && string.equals(mainModule)) {
            require.requireMain(context, string);
        } else {
            Main.processFile(context, Main.getScope(string), string);
        }
    }

    public static void processFileNoThrow(Context context, Scriptable scriptable, String string) {
        try {
            Main.processFile(context, scriptable, string);
        }
        catch (IOException iOException) {
            Context.reportError(ToolErrorReporter.getMessage("msg.couldnt.read.source", string, iOException.getMessage()));
            exitCode = 4;
        }
        catch (RhinoException rhinoException) {
            ToolErrorReporter.reportException(context.getErrorReporter(), rhinoException);
            exitCode = 3;
        }
        catch (VirtualMachineError virtualMachineError) {
            virtualMachineError.printStackTrace();
            String string2 = ToolErrorReporter.getMessage("msg.uncaughtJSException", virtualMachineError.toString());
            Context.reportError(string2);
            exitCode = 3;
        }
    }

    public static void processFile(Context context, Scriptable scriptable, String string) throws IOException {
        if (securityImpl == null) {
            Main.processFileSecure(context, scriptable, string, null);
        } else {
            securityImpl.callProcessFileSecure(context, scriptable, string);
        }
    }

    static void processFileSecure(Context context, Scriptable scriptable, String string, Object object) throws IOException {
        Script script;
        boolean bl = string.endsWith(".class");
        Object object2 = Main.readFileOrUrl(string, !bl);
        byte[] byArray = Main.getDigest(object2);
        String string2 = string + "_" + context.getOptimizationLevel();
        ScriptReference scriptReference = scriptCache.get(string2, byArray);
        Script script2 = script = scriptReference != null ? (Script)scriptReference.get() : null;
        if (script == null) {
            if (bl) {
                script = Main.loadCompiledScript(context, string, (byte[])object2, object);
            } else {
                String string3 = (String)object2;
                if (string3.length() > 0 && string3.charAt(0) == '#') {
                    for (int i = 1; i != string3.length(); ++i) {
                        char c = string3.charAt(i);
                        if (c != '\n' && c != '\r') continue;
                        string3 = string3.substring(i);
                        break;
                    }
                }
                script = context.compileString(string3, string, 1, object);
            }
            scriptCache.put(string2, byArray, script);
        }
        if (script != null) {
            script.exec(context, scriptable);
        }
    }

    private static byte[] getDigest(Object object) {
        byte[] byArray = null;
        if (object != null) {
            byte[] byArray2 = object instanceof String ? ((String)object).getBytes(StandardCharsets.UTF_8) : (byte[])object;
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                byArray = messageDigest.digest(byArray2);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new RuntimeException(noSuchAlgorithmException);
            }
        }
        return byArray;
    }

    private static Script loadCompiledScript(Context context, String string, byte[] byArray, Object object) throws FileNotFoundException {
        if (byArray == null) {
            throw new FileNotFoundException(string);
        }
        int n = string.lastIndexOf(47);
        n = n < 0 ? 0 : ++n;
        int n2 = string.lastIndexOf(46);
        if (n2 < n) {
            n2 = string.length();
        }
        String string2 = string.substring(n, n2);
        try {
            GeneratedClassLoader generatedClassLoader = SecurityController.createLoader(context.getApplicationClassLoader(), object);
            Class<?> clazz = generatedClassLoader.defineClass(string2, byArray);
            generatedClassLoader.linkClass(clazz);
            if (!Script.class.isAssignableFrom(clazz)) {
                throw Context.reportRuntimeError("msg.must.implement.Script");
            }
            return (Script)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            Context.reportError(reflectiveOperationException.toString());
            throw new RuntimeException(reflectiveOperationException);
        }
    }

    private static void printPromiseWarnings(Context context) {
        List<Object> list = context.getUnhandledPromiseTracker().enumerate();
        if (!list.isEmpty()) {
            Object object;
            Object object2 = list.get(0);
            String string = "Unhandled rejected promise: " + Context.toString(object2);
            if (object2 instanceof Scriptable && (object = ScriptableObject.getProperty((Scriptable)object2, "stack")) != null && object != Scriptable.NOT_FOUND) {
                string = string + '\n' + Context.toString(object);
            }
            System.out.println(string);
            if (list.size() > 1) {
                System.out.println("  and " + (list.size() - 1) + " other unhandled rejected promises");
            }
        }
    }

    public static InputStream getIn() {
        return Main.getGlobal().getIn();
    }

    public static void setIn(InputStream inputStream) {
        Main.getGlobal().setIn(inputStream);
    }

    public static PrintStream getOut() {
        return Main.getGlobal().getOut();
    }

    public static void setOut(PrintStream printStream) {
        Main.getGlobal().setOut(printStream);
    }

    public static PrintStream getErr() {
        return Main.getGlobal().getErr();
    }

    public static void setErr(PrintStream printStream) {
        Main.getGlobal().setErr(printStream);
    }

    private static Object readFileOrUrl(String string, boolean bl) throws IOException {
        return SourceReader.readFileOrUrl(string, bl, shellContextFactory.getCharacterEncoding());
    }

    static {
        exitCode = 0;
        processStdin = true;
        fileList = new ArrayList<String>();
        sandboxed = false;
        useRequire = false;
        scriptCache = new ScriptCache(32);
        global.initQuitAction(new IProxy(3));
    }

    private static class IProxy
    implements ContextAction<Object>,
    QuitAction {
        private static final int PROCESS_FILES = 1;
        private static final int EVAL_INLINE_SCRIPT = 2;
        private static final int SYSTEM_EXIT = 3;
        private int type;
        String[] args;
        String scriptText;
        private final Timers timers = new Timers();

        IProxy(int n) {
            this.type = n;
        }

        @Override
        public Object run(Context context) {
            context.setTrackUnhandledPromiseRejections(true);
            this.timers.install(global);
            if (useRequire) {
                require = global.installRequire(context, modulePath, sandboxed);
            }
            if (this.type == 1) {
                Main.processFiles(context, this.args);
                Main.printPromiseWarnings(context);
            } else if (this.type == 2) {
                Main.evalInlineScript(context, this.scriptText);
            } else {
                throw Kit.codeBug();
            }
            try {
                this.timers.runAllTimers(context, global);
            }
            catch (JavaScriptException javaScriptException) {
                ToolErrorReporter.reportException(context.getErrorReporter(), javaScriptException);
                exitCode = 3;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return null;
        }

        @Override
        public void quit(Context context, int n) {
            if (this.type == 3) {
                System.exit(n);
                return;
            }
            throw Kit.codeBug();
        }
    }

    static class ScriptCache
    extends LinkedHashMap<String, ScriptReference> {
        private static final long serialVersionUID = -6866856136258508615L;
        ReferenceQueue<Script> queue;
        int capacity;

        ScriptCache(int n) {
            super(n + 1, 2.0f, true);
            this.capacity = n;
            this.queue = new ReferenceQueue();
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, ScriptReference> entry) {
            return this.size() > this.capacity;
        }

        ScriptReference get(String string, byte[] byArray) {
            ScriptReference scriptReference;
            while ((scriptReference = (ScriptReference)this.queue.poll()) != null) {
                this.remove(scriptReference.path);
            }
            scriptReference = (ScriptReference)this.get(string);
            if (scriptReference != null && !Arrays.equals(byArray, scriptReference.digest)) {
                this.remove(scriptReference.path);
                scriptReference = null;
            }
            return scriptReference;
        }

        void put(String string, byte[] byArray, Script script) {
            this.put(string, new ScriptReference(string, byArray, script, this.queue));
        }
    }

    static class ScriptReference
    extends SoftReference<Script> {
        String path;
        byte[] digest;

        ScriptReference(String string, byte[] byArray, Script script, ReferenceQueue<Script> referenceQueue) {
            super(script, referenceQueue);
            this.path = string;
            this.digest = byArray;
        }
    }
}

