/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.ast;

import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.NodeVisitor;

public class ElementGet
extends AstNode {
    private AstNode target;
    private AstNode element;
    private int lb = -1;
    private int rb = -1;

    public ElementGet() {
        this.type = 36;
    }

    public ElementGet(int n) {
        super(n);
        this.type = 36;
    }

    public ElementGet(int n, int n2) {
        super(n, n2);
        this.type = 36;
    }

    public ElementGet(AstNode astNode, AstNode astNode2) {
        this.type = 36;
        this.setTarget(astNode);
        this.setElement(astNode2);
    }

    public AstNode getTarget() {
        return this.target;
    }

    public void setTarget(AstNode astNode) {
        this.assertNotNull(astNode);
        this.target = astNode;
        astNode.setParent(this);
    }

    public AstNode getElement() {
        return this.element;
    }

    public void setElement(AstNode astNode) {
        this.assertNotNull(astNode);
        this.element = astNode;
        astNode.setParent(this);
    }

    public int getLb() {
        return this.lb;
    }

    public void setLb(int n) {
        this.lb = n;
    }

    public int getRb() {
        return this.rb;
    }

    public void setRb(int n) {
        this.rb = n;
    }

    public void setParens(int n, int n2) {
        this.lb = n;
        this.rb = n2;
    }

    @Override
    public String toSource(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.makeIndent(n));
        stringBuilder.append(this.target.toSource(0));
        stringBuilder.append("[");
        stringBuilder.append(this.element.toSource(0));
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public void visit(NodeVisitor nodeVisitor) {
        if (nodeVisitor.visit(this)) {
            this.target.visit(nodeVisitor);
            this.element.visit(nodeVisitor);
        }
    }
}

