/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.CharArrayWriter;
import java.io.FilenameFilter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Evaluator;
import org.mozilla.javascript.Interpreter;
import org.mozilla.javascript.ScriptStackElement;
import org.mozilla.javascript.SecurityUtilities;
import org.mozilla.javascript.StackStyle;

public abstract class RhinoException
extends RuntimeException {
    private static final Pattern JAVA_STACK_PATTERN = Pattern.compile("_c_(.*)_\\d+");
    private static final long serialVersionUID = 1883500631321581169L;
    private static StackStyle stackStyle = StackStyle.RHINO;
    private String sourceName;
    private int lineNumber;
    private String lineSource;
    private int columnNumber;
    Object interpreterStackInfo;
    int[] interpreterLineData;

    RhinoException() {
        Evaluator evaluator = Context.createInterpreter();
        if (evaluator != null) {
            evaluator.captureStackInfo(this);
        }
    }

    RhinoException(String string) {
        super(string);
        Evaluator evaluator = Context.createInterpreter();
        if (evaluator != null) {
            evaluator.captureStackInfo(this);
        }
    }

    @Override
    public final String getMessage() {
        String string = this.details();
        if (this.sourceName == null || this.lineNumber <= 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append(" (");
        stringBuilder.append(this.sourceName);
        if (this.lineNumber > 0) {
            stringBuilder.append('#');
            stringBuilder.append(this.lineNumber);
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    public String details() {
        return super.getMessage();
    }

    public final String sourceName() {
        return this.sourceName;
    }

    public final void initSourceName(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (this.sourceName != null) {
            throw new IllegalStateException();
        }
        this.sourceName = string;
    }

    public final int lineNumber() {
        return this.lineNumber;
    }

    public final void initLineNumber(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        if (this.lineNumber > 0) {
            throw new IllegalStateException();
        }
        this.lineNumber = n;
    }

    public final int columnNumber() {
        return this.columnNumber;
    }

    public final void initColumnNumber(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        if (this.columnNumber > 0) {
            throw new IllegalStateException();
        }
        this.columnNumber = n;
    }

    public final String lineSource() {
        return this.lineSource;
    }

    public final void initLineSource(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (this.lineSource != null) {
            throw new IllegalStateException();
        }
        this.lineSource = string;
    }

    final void recordErrorOrigin(String string, int n, String string2, int n2) {
        if (n == -1) {
            n = 0;
        }
        if (string != null) {
            this.initSourceName(string);
        }
        if (n != 0) {
            this.initLineNumber(n);
        }
        if (string2 != null) {
            this.initLineSource(string2);
        }
        if (n2 != 0) {
            this.initColumnNumber(n2);
        }
    }

    private String generateStackTrace() {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        super.printStackTrace(new PrintWriter(charArrayWriter));
        String string = charArrayWriter.toString();
        Evaluator evaluator = Context.createInterpreter();
        if (evaluator != null) {
            return evaluator.getPatchedStack(this, string);
        }
        return null;
    }

    public String getScriptStackTrace() {
        return this.getScriptStackTrace(-1, null);
    }

    public String getScriptStackTrace(int n, String string) {
        ScriptStackElement[] scriptStackElementArray = this.getScriptStack(n, string);
        return RhinoException.formatStackTrace(scriptStackElementArray, this.details());
    }

    static String formatStackTrace(ScriptStackElement[] scriptStackElementArray, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = SecurityUtilities.getSystemProperty("line.separator");
        if (stackStyle == StackStyle.V8 && !"null".equals(string)) {
            stringBuilder.append(string);
            stringBuilder.append(string2);
        }
        block6: for (ScriptStackElement scriptStackElement : scriptStackElementArray) {
            switch (stackStyle) {
                case MOZILLA: {
                    scriptStackElement.renderMozillaStyle(stringBuilder);
                    stringBuilder.append(string2);
                    continue block6;
                }
                case MOZILLA_LF: {
                    scriptStackElement.renderMozillaStyle(stringBuilder);
                    stringBuilder.append('\n');
                    continue block6;
                }
                case V8: {
                    scriptStackElement.renderV8Style(stringBuilder);
                    stringBuilder.append(string2);
                    continue block6;
                }
                case RHINO: {
                    scriptStackElement.renderJavaStyle(stringBuilder);
                    stringBuilder.append(string2);
                }
            }
        }
        return stringBuilder.toString();
    }

    @Deprecated
    public String getScriptStackTrace(FilenameFilter filenameFilter) {
        return this.getScriptStackTrace();
    }

    public ScriptStackElement[] getScriptStack() {
        return this.getScriptStack(-1, null);
    }

    public ScriptStackElement[] getScriptStack(int n, String string) {
        Evaluator evaluator;
        ArrayList<ScriptStackElement> arrayList = new ArrayList<ScriptStackElement>();
        ScriptStackElement[][] scriptStackElementArray = null;
        if (this.interpreterStackInfo != null && (evaluator = Context.createInterpreter()) instanceof Interpreter) {
            scriptStackElementArray = ((Interpreter)evaluator).getScriptStackElements(this);
        }
        int n2 = 0;
        StackTraceElement[] stackTraceElementArray = this.getStackTrace();
        int n3 = 0;
        boolean bl = string == null;
        for (StackTraceElement stackTraceElement : stackTraceElementArray) {
            String string2 = stackTraceElement.getFileName();
            if (stackTraceElement.getMethodName().startsWith("_c_") && stackTraceElement.getLineNumber() > -1 && (string2 == null || !string2.endsWith(".java"))) {
                ScriptStackElement[] scriptStackElementArray2 = stackTraceElement.getMethodName();
                Matcher matcher = JAVA_STACK_PATTERN.matcher((CharSequence)scriptStackElementArray2);
                ScriptStackElement[] scriptStackElementArray3 = scriptStackElementArray2 = !"_c_script_0".equals(scriptStackElementArray2) && matcher.find() ? matcher.group(1) : null;
                if (!bl && string.equals(scriptStackElementArray2)) {
                    bl = true;
                    continue;
                }
                if (!bl || n >= 0 && n3 >= n) continue;
                String string3 = string2 == null ? "(unknown)" : string2;
                arrayList.add(new ScriptStackElement(string3, (String)scriptStackElementArray2, stackTraceElement.getLineNumber()));
                ++n3;
                continue;
            }
            if (!"org.mozilla.javascript.Interpreter".equals(stackTraceElement.getClassName()) || !"interpretLoop".equals(stackTraceElement.getMethodName()) || scriptStackElementArray == null || scriptStackElementArray.length <= n2) continue;
            for (ScriptStackElement scriptStackElement : scriptStackElementArray[n2++]) {
                if (!bl && string.equals(scriptStackElement.functionName)) {
                    bl = true;
                    continue;
                }
                if (!bl || n >= 0 && n3 >= n) continue;
                arrayList.add(scriptStackElement);
                ++n3;
            }
        }
        return arrayList.toArray(new ScriptStackElement[0]);
    }

    @Override
    public void printStackTrace(PrintWriter printWriter) {
        if (this.interpreterStackInfo == null) {
            super.printStackTrace(printWriter);
        } else {
            printWriter.print(this.generateStackTrace());
        }
    }

    @Override
    public void printStackTrace(PrintStream printStream) {
        if (this.interpreterStackInfo == null) {
            super.printStackTrace(printStream);
        } else {
            printStream.print(this.generateStackTrace());
        }
    }

    public static boolean usesMozillaStackStyle() {
        return stackStyle == StackStyle.MOZILLA;
    }

    public static void useMozillaStackStyle(boolean bl) {
        stackStyle = bl ? StackStyle.MOZILLA : StackStyle.RHINO;
    }

    public static void setStackStyle(StackStyle stackStyle) {
        RhinoException.stackStyle = stackStyle;
    }

    public static StackStyle getStackStyle() {
        return stackStyle;
    }

    static {
        String string = System.getProperty("rhino.stack.style");
        if (string != null) {
            if ("Rhino".equalsIgnoreCase(string)) {
                stackStyle = StackStyle.RHINO;
            } else if ("Mozilla".equalsIgnoreCase(string)) {
                stackStyle = StackStyle.MOZILLA;
            } else if ("V8".equalsIgnoreCase(string)) {
                stackStyle = StackStyle.V8;
            }
        }
    }
}

