/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ES6Iterator;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Symbol;
import org.mozilla.javascript.SymbolKey;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.WrapFactory;

public class NativeJavaMap
extends NativeJavaObject {
    private static final long serialVersionUID = -3786257752907047381L;
    private Map<Object, Object> map;
    private static Callable symbol_iterator = (context, scriptable, scriptable2, objectArray) -> {
        if (!(scriptable2 instanceof NativeJavaMap)) {
            throw ScriptRuntime.typeErrorById("msg.incompat.call", SymbolKey.ITERATOR);
        }
        return new NativeJavaMapIterator(scriptable, ((NativeJavaMap)scriptable2).map);
    };

    static void init(ScriptableObject scriptableObject, boolean bl) {
        NativeJavaMapIterator.init(scriptableObject, bl);
    }

    public NativeJavaMap(Scriptable scriptable, Object object) {
        super(scriptable, object, object.getClass());
        assert (object instanceof Map);
        this.map = (Map)object;
    }

    @Override
    public String getClassName() {
        return "JavaMap";
    }

    @Override
    public boolean has(String string, Scriptable scriptable) {
        Context context = Context.getCurrentContext();
        if (context != null && context.hasFeature(21) && this.map.containsKey(string)) {
            return true;
        }
        return super.has(string, scriptable);
    }

    @Override
    public boolean has(int n, Scriptable scriptable) {
        Context context = Context.getCurrentContext();
        if (context != null && context.hasFeature(21) && this.map.containsKey(n)) {
            return true;
        }
        return super.has(n, scriptable);
    }

    @Override
    public boolean has(Symbol symbol, Scriptable scriptable) {
        return SymbolKey.ITERATOR.equals(symbol);
    }

    @Override
    public Object get(String string, Scriptable scriptable) {
        Context context = Context.getCurrentContext();
        if (context != null && context.hasFeature(21) && this.map.containsKey(string)) {
            Object object = this.map.get(string);
            return context.getWrapFactory().wrap(context, this, object, object == null ? null : object.getClass());
        }
        return super.get(string, scriptable);
    }

    @Override
    public Object get(int n, Scriptable scriptable) {
        Context context = Context.getCurrentContext();
        if (context != null && context.hasFeature(21) && this.map.containsKey(n)) {
            Object object = this.map.get(n);
            return context.getWrapFactory().wrap(context, this, object, object == null ? null : object.getClass());
        }
        return super.get(n, scriptable);
    }

    @Override
    public Object get(Symbol symbol, Scriptable scriptable) {
        if (SymbolKey.ITERATOR.equals(symbol)) {
            return symbol_iterator;
        }
        return super.get(symbol, scriptable);
    }

    @Override
    public void put(String string, Scriptable scriptable, Object object) {
        Context context = Context.getCurrentContext();
        if (context != null && context.hasFeature(21)) {
            this.map.put(string, Context.jsToJava(object, Object.class));
        } else {
            super.put(string, scriptable, object);
        }
    }

    @Override
    public void put(int n, Scriptable scriptable, Object object) {
        Context context = Context.getContext();
        if (context != null && context.hasFeature(21)) {
            this.map.put(n, Context.jsToJava(object, Object.class));
        } else {
            super.put(n, scriptable, object);
        }
    }

    @Override
    public Object[] getIds() {
        Context context = Context.getCurrentContext();
        if (context != null && context.hasFeature(21)) {
            ArrayList<Object> arrayList = new ArrayList<Object>(this.map.size());
            for (Object object : this.map.keySet()) {
                if (object instanceof Integer) {
                    arrayList.add(object);
                    continue;
                }
                arrayList.add(ScriptRuntime.toString(object));
            }
            return arrayList.toArray();
        }
        return super.getIds();
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    private static final class NativeJavaMapIterator
    extends ES6Iterator {
        private static final long serialVersionUID = 1L;
        private static final String ITERATOR_TAG = "JavaMapIterator";
        private Iterator<Map.Entry<Object, Object>> iterator;

        static void init(ScriptableObject scriptableObject, boolean bl) {
            ES6Iterator.init(scriptableObject, bl, new NativeJavaMapIterator(), ITERATOR_TAG);
        }

        private NativeJavaMapIterator() {
        }

        NativeJavaMapIterator(Scriptable scriptable, Map<Object, Object> map) {
            super(scriptable, ITERATOR_TAG);
            this.iterator = map.entrySet().iterator();
        }

        @Override
        public String getClassName() {
            return "Java Map Iterator";
        }

        @Override
        protected boolean isDone(Context context, Scriptable scriptable) {
            return !this.iterator.hasNext();
        }

        @Override
        protected Object nextValue(Context context, Scriptable scriptable) {
            if (!this.iterator.hasNext()) {
                return context.newArray(scriptable, new Object[]{Undefined.instance, Undefined.instance});
            }
            Map.Entry<Object, Object> entry = this.iterator.next();
            Object object = entry.getKey();
            Object object2 = entry.getValue();
            WrapFactory wrapFactory = context.getWrapFactory();
            object = wrapFactory.wrap(context, this, object, object == null ? null : object.getClass());
            object2 = wrapFactory.wrap(context, this, object2, object2 == null ? null : object2.getClass());
            return context.newArray(scriptable, new Object[]{object, object2});
        }

        @Override
        protected String getTag() {
            return ITERATOR_TAG;
        }
    }
}

