/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import org.mozilla.javascript.ArrowFunction;
import org.mozilla.javascript.BoundFunction;
import org.mozilla.javascript.ConsString;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.InterpretedFunction;
import org.mozilla.javascript.JavaAdapter;
import org.mozilla.javascript.NativeContinuation;
import org.mozilla.javascript.NativeGlobal;
import org.mozilla.javascript.NativeJavaPackage;
import org.mozilla.javascript.NativeJavaTopPackage;
import org.mozilla.javascript.NativeSymbol;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Symbol;
import org.mozilla.javascript.SymbolKey;
import org.mozilla.javascript.Wrapper;
import org.mozilla.javascript.debug.DebuggableObject;

final class EqualObjectGraphs {
    private static final ThreadLocal<EqualObjectGraphs> instance = new ThreadLocal();
    private static final Set<Class<?>> valueClasses = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(Boolean.class, Byte.class, Character.class, Double.class, Float.class, Integer.class, Long.class, Short.class)));
    private final Map<Object, Object> knownEquals = new IdentityHashMap<Object, Object>();
    private final Map<Object, Object> currentlyCompared = new IdentityHashMap<Object, Object>();

    EqualObjectGraphs() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> T withThreadLocal(Function<EqualObjectGraphs, T> function) {
        EqualObjectGraphs equalObjectGraphs = instance.get();
        if (equalObjectGraphs == null) {
            EqualObjectGraphs equalObjectGraphs2 = new EqualObjectGraphs();
            instance.set(equalObjectGraphs2);
            try {
                T t = function.apply(equalObjectGraphs2);
                return t;
            }
            finally {
                instance.set(null);
            }
        }
        return function.apply(equalObjectGraphs);
    }

    boolean equalGraphs(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        if (object instanceof String) {
            if (object2 instanceof ConsString) {
                return object.equals(object2.toString());
            }
            return object.equals(object2);
        }
        if (object instanceof ConsString) {
            if (object2 instanceof String || object2 instanceof ConsString) {
                return object.toString().equals(object2.toString());
            }
            return false;
        }
        if (valueClasses.contains(object.getClass())) {
            return object.equals(object2);
        }
        Object object3 = this.currentlyCompared.get(object);
        if (object3 == object2) {
            return true;
        }
        if (object3 != null) {
            return false;
        }
        Object object4 = this.knownEquals.get(object);
        if (object4 == object2) {
            return true;
        }
        if (object4 != null) {
            return false;
        }
        Object object5 = this.knownEquals.get(object2);
        assert (object5 != object);
        if (object5 != null) {
            return false;
        }
        this.currentlyCompared.put(object, object2);
        boolean bl = this.equalGraphsNoMemo(object, object2);
        if (bl) {
            this.knownEquals.put(object, object2);
            this.knownEquals.put(object2, object);
        }
        this.currentlyCompared.remove(object);
        return bl;
    }

    private boolean equalGraphsNoMemo(Object object, Object object2) {
        if (object instanceof Wrapper) {
            return object2 instanceof Wrapper && this.equalGraphs(((Wrapper)object).unwrap(), ((Wrapper)object2).unwrap());
        }
        if (object instanceof NativeJavaTopPackage) {
            return object2 instanceof NativeJavaTopPackage;
        }
        if (object instanceof Scriptable) {
            return object2 instanceof Scriptable && this.equalScriptables((Scriptable)object, (Scriptable)object2);
        }
        if (object instanceof SymbolKey) {
            return object2 instanceof SymbolKey && this.equalGraphs(((SymbolKey)object).getName(), ((SymbolKey)object2).getName());
        }
        if (object instanceof Object[]) {
            return object2 instanceof Object[] && this.equalObjectArrays((Object[])object, (Object[])object2);
        }
        if (object.getClass().isArray()) {
            return Objects.deepEquals(object, object2);
        }
        if (object instanceof List) {
            return object2 instanceof List && this.equalLists((List)object, (List)object2);
        }
        if (object instanceof Map) {
            return object2 instanceof Map && this.equalMaps((Map)object, (Map)object2);
        }
        if (object instanceof Set) {
            return object2 instanceof Set && this.equalSets((Set)object, (Set)object2);
        }
        if (object instanceof NativeGlobal) {
            return object2 instanceof NativeGlobal;
        }
        if (object instanceof JavaAdapter) {
            return object2 instanceof JavaAdapter;
        }
        return object.equals(object2);
    }

    private boolean equalScriptables(Scriptable scriptable, Scriptable scriptable2) {
        Object[] objectArray;
        Object[] objectArray2 = EqualObjectGraphs.getSortedIds(scriptable);
        if (!this.equalObjectArrays(objectArray2, objectArray = EqualObjectGraphs.getSortedIds(scriptable2))) {
            return false;
        }
        int n = objectArray2.length;
        for (int i = 0; i < n; ++i) {
            if (this.equalGraphs(EqualObjectGraphs.getValue(scriptable, objectArray2[i]), EqualObjectGraphs.getValue(scriptable2, objectArray[i]))) continue;
            return false;
        }
        if (!this.equalGraphs(scriptable.getPrototype(), scriptable2.getPrototype())) {
            return false;
        }
        if (!this.equalGraphs(scriptable.getParentScope(), scriptable2.getParentScope())) {
            return false;
        }
        if (scriptable instanceof NativeContinuation) {
            return scriptable2 instanceof NativeContinuation && NativeContinuation.equalImplementations((NativeContinuation)scriptable, (NativeContinuation)scriptable2);
        }
        if (scriptable instanceof NativeJavaPackage) {
            return scriptable.equals(scriptable2);
        }
        if (scriptable instanceof IdFunctionObject) {
            return scriptable2 instanceof IdFunctionObject && IdFunctionObject.equalObjectGraphs((IdFunctionObject)scriptable, (IdFunctionObject)scriptable2, this);
        }
        if (scriptable instanceof InterpretedFunction) {
            return scriptable2 instanceof InterpretedFunction && EqualObjectGraphs.equalInterpretedFunctions((InterpretedFunction)scriptable, (InterpretedFunction)scriptable2);
        }
        if (scriptable instanceof ArrowFunction) {
            return scriptable2 instanceof ArrowFunction && ArrowFunction.equalObjectGraphs((ArrowFunction)scriptable, (ArrowFunction)scriptable2, this);
        }
        if (scriptable instanceof BoundFunction) {
            return scriptable2 instanceof BoundFunction && BoundFunction.equalObjectGraphs((BoundFunction)scriptable, (BoundFunction)scriptable2, this);
        }
        if (scriptable instanceof NativeSymbol) {
            return scriptable2 instanceof NativeSymbol && this.equalGraphs(((NativeSymbol)scriptable).getKey(), ((NativeSymbol)scriptable2).getKey());
        }
        return true;
    }

    private boolean equalObjectArrays(Object[] objectArray, Object[] objectArray2) {
        if (objectArray.length != objectArray2.length) {
            return false;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (this.equalGraphs(objectArray[i], objectArray2[i])) continue;
            return false;
        }
        return true;
    }

    private boolean equalLists(List<?> list, List<?> list2) {
        if (list.size() != list2.size()) {
            return false;
        }
        Iterator<?> iterator = list.iterator();
        Iterator<?> iterator2 = list2.iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            if (this.equalGraphs(iterator.next(), iterator2.next())) continue;
            return false;
        }
        assert (!iterator.hasNext() && !iterator2.hasNext());
        return true;
    }

    private boolean equalMaps(Map<?, ?> map, Map<?, ?> map2) {
        if (map.size() != map2.size()) {
            return false;
        }
        Iterator<Map.Entry> iterator = EqualObjectGraphs.sortedEntries(map);
        Iterator<Map.Entry> iterator2 = EqualObjectGraphs.sortedEntries(map2);
        while (iterator.hasNext() && iterator2.hasNext()) {
            Map.Entry entry = iterator.next();
            Map.Entry entry2 = iterator2.next();
            if (this.equalGraphs(entry.getKey(), entry2.getKey()) && this.equalGraphs(entry.getValue(), entry2.getValue())) continue;
            return false;
        }
        assert (!iterator.hasNext() && !iterator2.hasNext());
        return true;
    }

    private static Iterator<Map.Entry> sortedEntries(Map map) {
        Map map2 = map instanceof SortedMap ? map : new TreeMap(map);
        return map2.entrySet().iterator();
    }

    private boolean equalSets(Set<?> set, Set<?> set2) {
        return this.equalObjectArrays(EqualObjectGraphs.sortedSet(set), EqualObjectGraphs.sortedSet(set2));
    }

    private static Object[] sortedSet(Set<?> set) {
        Object[] objectArray = set.toArray();
        Arrays.sort(objectArray);
        return objectArray;
    }

    private static boolean equalInterpretedFunctions(InterpretedFunction interpretedFunction, InterpretedFunction interpretedFunction2) {
        return Objects.equals(interpretedFunction.getEncodedSource(), interpretedFunction2.getEncodedSource());
    }

    private static Object[] getSortedIds(Scriptable scriptable) {
        Object[] objectArray = EqualObjectGraphs.getIds(scriptable);
        Arrays.sort(objectArray, (object, object2) -> {
            if (object instanceof Integer) {
                if (object2 instanceof Integer) {
                    return ((Integer)object).compareTo((Integer)object2);
                }
                if (object2 instanceof String || object2 instanceof Symbol) {
                    return -1;
                }
            } else if (object instanceof String) {
                if (object2 instanceof String) {
                    return ((String)object).compareTo((String)object2);
                }
                if (object2 instanceof Integer) {
                    return 1;
                }
                if (object2 instanceof Symbol) {
                    return -1;
                }
            } else if (object instanceof Symbol) {
                if (object2 instanceof Symbol) {
                    return EqualObjectGraphs.getSymbolName((Symbol)object).compareTo(EqualObjectGraphs.getSymbolName((Symbol)object2));
                }
                if (object2 instanceof Integer || object2 instanceof String) {
                    return 1;
                }
            }
            throw new ClassCastException();
        });
        return objectArray;
    }

    private static String getSymbolName(Symbol symbol) {
        if (symbol instanceof SymbolKey) {
            return ((SymbolKey)symbol).getName();
        }
        if (symbol instanceof NativeSymbol) {
            return ((NativeSymbol)symbol).getKey().getName();
        }
        throw new ClassCastException();
    }

    private static Object[] getIds(Scriptable scriptable) {
        if (scriptable instanceof ScriptableObject) {
            return ((ScriptableObject)scriptable).getIds(true, true);
        }
        if (scriptable instanceof DebuggableObject) {
            return ((DebuggableObject)((Object)scriptable)).getAllIds();
        }
        return scriptable.getIds();
    }

    private static Object getValue(Scriptable scriptable, Object object) {
        if (object instanceof Symbol) {
            return ScriptableObject.getProperty(scriptable, (Symbol)object);
        }
        if (object instanceof Integer) {
            return ScriptableObject.getProperty(scriptable, (Integer)object);
        }
        if (object instanceof String) {
            return ScriptableObject.getProperty(scriptable, (String)object);
        }
        throw new ClassCastException();
    }
}

