/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Constructable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Symbol;
import org.mozilla.javascript.SymbolKey;
import org.mozilla.javascript.Undefined;

class AbstractEcmaObjectOperations {
    AbstractEcmaObjectOperations() {
    }

    static boolean hasOwnProperty(Context context, Object object, Object object2) {
        boolean bl;
        Scriptable scriptable = ScriptableObject.ensureScriptable(object);
        if (object2 instanceof Symbol) {
            bl = ScriptableObject.ensureSymbolScriptable(object).has((Symbol)object2, scriptable);
        } else {
            ScriptRuntime.StringIdOrIndex stringIdOrIndex = ScriptRuntime.toStringIdOrIndex(object2);
            bl = stringIdOrIndex.stringId == null ? scriptable.has(stringIdOrIndex.index, scriptable) : scriptable.has(stringIdOrIndex.stringId, scriptable);
        }
        return bl;
    }

    static boolean testIntegrityLevel(Context context, Object object, INTEGRITY_LEVEL iNTEGRITY_LEVEL) {
        ScriptableObject scriptableObject = ScriptableObject.ensureScriptableObject(object);
        if (scriptableObject.isExtensible()) {
            return false;
        }
        for (Object object2 : scriptableObject.getIds(true, true)) {
            ScriptableObject scriptableObject2 = scriptableObject.getOwnPropertyDescriptor(context, object2);
            if (Boolean.TRUE.equals(scriptableObject2.get("configurable"))) {
                return false;
            }
            if (iNTEGRITY_LEVEL != INTEGRITY_LEVEL.FROZEN || !ScriptableObject.isDataDescriptor(scriptableObject2) || !Boolean.TRUE.equals(scriptableObject2.get("writable"))) continue;
            return false;
        }
        return true;
    }

    static boolean setIntegrityLevel(Context context, Object object, INTEGRITY_LEVEL iNTEGRITY_LEVEL) {
        ScriptableObject scriptableObject = ScriptableObject.ensureScriptableObject(object);
        scriptableObject.preventExtensions();
        for (Object object2 : scriptableObject.getIds(true, true)) {
            ScriptableObject scriptableObject2 = scriptableObject.getOwnPropertyDescriptor(context, object2);
            if (iNTEGRITY_LEVEL == INTEGRITY_LEVEL.SEALED) {
                if (!Boolean.TRUE.equals(scriptableObject2.get("configurable"))) continue;
                scriptableObject2.put("configurable", (Scriptable)scriptableObject2, (Object)Boolean.FALSE);
                scriptableObject.defineOwnProperty(context, object2, scriptableObject2, false);
                continue;
            }
            if (ScriptableObject.isDataDescriptor(scriptableObject2) && Boolean.TRUE.equals(scriptableObject2.get("writable"))) {
                scriptableObject2.put("writable", (Scriptable)scriptableObject2, (Object)Boolean.FALSE);
            }
            if (Boolean.TRUE.equals(scriptableObject2.get("configurable"))) {
                scriptableObject2.put("configurable", (Scriptable)scriptableObject2, (Object)Boolean.FALSE);
            }
            scriptableObject.defineOwnProperty(context, object2, scriptableObject2, false);
        }
        return true;
    }

    static Constructable speciesConstructor(Context context, Scriptable scriptable, Constructable constructable) {
        Object object = ScriptableObject.getProperty(scriptable, "constructor");
        if (object == Scriptable.NOT_FOUND || Undefined.isUndefined(object)) {
            return constructable;
        }
        if (!ScriptRuntime.isObject(object)) {
            throw ScriptRuntime.typeErrorById("msg.arg.not.object", ScriptRuntime.typeof(object));
        }
        Object object2 = ScriptableObject.getProperty((Scriptable)object, SymbolKey.SPECIES);
        if (object2 == Scriptable.NOT_FOUND || object2 == null || Undefined.isUndefined(object2)) {
            return constructable;
        }
        if (!(object2 instanceof Constructable)) {
            throw ScriptRuntime.typeErrorById("msg.not.ctor", ScriptRuntime.typeof(object2));
        }
        return (Constructable)object2;
    }

    static void put(Context context, Scriptable scriptable, String string, Object object, boolean bl) {
        Scriptable scriptable2 = ScriptableObject.getBase(scriptable, string);
        if (scriptable2 == null) {
            scriptable2 = scriptable;
        }
        if (scriptable2 instanceof ScriptableObject) {
            if (((ScriptableObject)scriptable2).putImpl(string, 0, scriptable, object, bl)) {
                return;
            }
            scriptable.put(string, scriptable, object);
        } else {
            scriptable2.put(string, scriptable, object);
        }
    }

    static void put(Context context, Scriptable scriptable, int n, Object object, boolean bl) {
        Scriptable scriptable2 = ScriptableObject.getBase(scriptable, n);
        if (scriptable2 == null) {
            scriptable2 = scriptable;
        }
        if (scriptable2 instanceof ScriptableObject) {
            if (((ScriptableObject)scriptable2).putImpl(null, n, scriptable, object, bl)) {
                return;
            }
            scriptable.put(n, scriptable, object);
        } else {
            scriptable2.put(n, scriptable, object);
        }
    }

    static enum INTEGRITY_LEVEL {
        FROZEN,
        SEALED;

    }
}

