/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSColorValue;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.LCHColor;
import io.sf.carte.doc.style.css.RGBAColor;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.property.BaseColor;
import io.sf.carte.doc.style.css.property.ColorUtil;
import io.sf.carte.doc.style.css.property.ColorValue;
import io.sf.carte.doc.style.css.property.LABColorValue;
import io.sf.carte.doc.style.css.property.LCHColorImpl;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.RGBColor;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.doc.style.css.property.XYZColorImpl;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import org.w3c.dom.DOMException;

public class LCHColorValue
extends ColorValue
implements io.sf.carte.doc.style.css.LCHColorValue {
    private static final long serialVersionUID = 2L;
    private final LCHColorImpl lchColor;

    public LCHColorValue() {
        this(new LCHColorImpl(BaseColor.Space.CIE_LCh, "lch"));
    }

    LCHColorValue(LCHColorImpl lCHColorImpl) {
        this.lchColor = lCHColorImpl;
    }

    LCHColorValue(LCHColorValue lCHColorValue) {
        super(lCHColorValue);
        this.lchColor = lCHColorValue.lchColor.clone();
    }

    @Override
    public CSSColorValue.ColorModel getColorModel() {
        return CSSColorValue.ColorModel.LCH;
    }

    @Override
    void set(StyleValue styleValue) {
        super.set(styleValue);
        LCHColorValue lCHColorValue = (LCHColorValue)styleValue;
        this.lchColor.set(lCHColorValue.lchColor);
    }

    @Override
    public String getCssText() {
        return this.lchColor.toString();
    }

    @Override
    public String getMinifiedCssText(String string) {
        return this.lchColor.toMinifiedString();
    }

    @Override
    public void writeCssText(SimpleWriter simpleWriter) throws IOException {
        this.lchColor.writeCssText(simpleWriter);
    }

    @Override
    public PrimitiveValue getComponent(int n) {
        return this.lchColor.item(n);
    }

    @Override
    public void setComponent(int n, StyleValue styleValue) {
        this.lchColor.setComponent(n, (PrimitiveValue)styleValue);
    }

    @Override
    public RGBAColor toRGBColor() throws DOMException {
        return this.toRGBColor(true);
    }

    @Override
    public RGBAColor toRGBColor(boolean bl) throws DOMException {
        double[] dArray = this.lchColor.toSRGB(bl);
        ColorValue.CSSRGBColor cSSRGBColor = new ColorValue.CSSRGBColor();
        cSSRGBColor.setColorComponents(dArray);
        cSSRGBColor.setAlpha(this.lchColor.getAlpha().clone());
        return cSSRGBColor;
    }

    @Override
    public LABColorValue toLABColorValue() throws DOMException {
        float f;
        if (!this.lchColor.hasConvertibleComponents()) {
            throw new DOMException(11, "Cannot convert.");
        }
        CSSTypedValue cSSTypedValue = (CSSTypedValue)((Object)this.lchColor.getHue());
        float f2 = ((CSSTypedValue)((Object)this.lchColor.getChroma())).getFloatValue((short)0);
        short s = cSSTypedValue.getUnitType();
        if (s == 0) {
            f = cSSTypedValue.getFloatValue((short)0);
            f = NumberValue.floatValueConversion(f, (short)80, (short)81);
        } else {
            f = cSSTypedValue.getFloatValue((short)81);
        }
        float f3 = (float)((double)f2 * Math.cos(f));
        float f4 = (float)((double)f2 * Math.sin(f));
        NumberValue numberValue = NumberValue.createCSSNumberValue((short)0, f3);
        NumberValue numberValue2 = NumberValue.createCSSNumberValue((short)0, f4);
        numberValue.setAbsolutizedUnit();
        numberValue2.setAbsolutizedUnit();
        LABColorValue lABColorValue = new LABColorValue();
        lABColorValue.setComponent(0, this.lchColor.getAlpha().clone());
        lABColorValue.setComponent(1, this.lchColor.getLightness().clone());
        lABColorValue.setComponent(2, numberValue);
        lABColorValue.setComponent(3, numberValue2);
        return lABColorValue;
    }

    @Override
    public LCHColorValue toLCHColorValue() throws DOMException {
        return this;
    }

    @Override
    public LCHColor getColor() {
        return this.lchColor;
    }

    @Override
    boolean hasConvertibleComponents() {
        return this.lchColor.hasConvertibleComponents();
    }

    @Override
    public float deltaE2000(CSSColorValue cSSColorValue) {
        LCHColor lCHColor;
        if (!this.lchColor.hasConvertibleComponents() || !((ColorValue)cSSColorValue).hasConvertibleComponents()) {
            throw new DOMException(11, "Cannot compute delta.");
        }
        switch (cSSColorValue.getColorModel()) {
            case LCH: {
                lCHColor = (LCHColor)cSSColorValue.getColor();
                if (!"oklch".equals(lCHColor.getColorSpace())) break;
                lCHColor = cSSColorValue.toLCHColorValue().getColor();
                break;
            }
            case LAB: {
                lCHColor = cSSColorValue.toLCHColorValue().getColor();
                break;
            }
            case RGB: {
                RGBColor rGBColor = (RGBColor)cSSColorValue.getColor();
                LABColorValue lABColorValue = new LABColorValue();
                rGBColor.toLABColor(lABColorValue.getLABColorImpl());
                lCHColor = lABColorValue.toLCHColorValue().getColor();
                break;
            }
            case XYZ: {
                XYZColorImpl xYZColorImpl = (XYZColorImpl)cSSColorValue.getColor();
                LABColorValue lABColorValue = new LABColorValue();
                xYZColorImpl.toLABColor(lABColorValue.getLABColorImpl());
                lCHColor = lABColorValue.toLCHColorValue().getColor();
                break;
            }
            default: {
                RGBAColor rGBAColor = cSSColorValue.toRGBColor(false);
                CSSColorValue cSSColorValue2 = rGBAColor.packInValue();
                lCHColor = cSSColorValue2.toLABColorValue().toLCHColorValue().getColor();
            }
        }
        return ColorUtil.deltaE2000LCh(((CSSTypedValue)((Object)this.lchColor.getLightness())).getFloatValue((short)0), ((CSSTypedValue)((Object)this.lchColor.getChroma())).getFloatValue((short)0), ColorUtil.hueRadians((CSSTypedValue)((Object)this.lchColor.getHue())), ((CSSTypedValue)lCHColor.getLightness()).getFloatValue((short)0), ((CSSTypedValue)lCHColor.getChroma()).getFloatValue((short)0), ColorUtil.hueRadians((CSSTypedValue)lCHColor.getHue()));
    }

    @Override
    PrimitiveValue.LexicalSetter newLexicalSetter() {
        return new MyLexicalSetter();
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = super.hashCode();
        n2 = 31 * n2 + this.lchColor.hashCode();
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        LCHColorValue lCHColorValue = (LCHColorValue)object;
        return this.lchColor.equals(lCHColorValue.lchColor);
    }

    @Override
    public LCHColorValue clone() {
        return new LCHColorValue(this);
    }

    class MyLexicalSetter
    extends PrimitiveValue.LexicalSetter {
        MyLexicalSetter() {
            super(LCHColorValue.this);
        }

        @Override
        void setLexicalUnit(LexicalUnit lexicalUnit) {
            try {
                if (lexicalUnit.getLexicalUnitType() != LexicalUnit.LexicalType.LCHCOLOR) {
                    throw new DOMException(13, "No lch() value: " + lexicalUnit.toString());
                }
                this.setLexicalLCH(lexicalUnit);
            }
            catch (DOMException dOMException) {
                throw dOMException;
            }
            catch (RuntimeException runtimeException) {
                throw new DOMException(12, "Bad value: " + lexicalUnit.toString());
            }
            this.nextLexicalUnit = lexicalUnit.getNextLexicalUnit();
        }

        private void setLexicalLCH(LexicalUnit lexicalUnit) {
            LexicalUnit lexicalUnit2 = lexicalUnit.getParameters();
            ValueFactory valueFactory = new ValueFactory();
            PrimitiveValue primitiveValue = valueFactory.createCSSPrimitiveValue(lexicalUnit2, true);
            lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
            PrimitiveValue primitiveValue2 = valueFactory.createCSSPrimitiveValue(lexicalUnit2, true);
            lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
            PrimitiveValue primitiveValue3 = valueFactory.createCSSPrimitiveValue(lexicalUnit2, true);
            if ((lexicalUnit2 = lexicalUnit2.getNextLexicalUnit()) != null) {
                if (lexicalUnit2.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_SLASH) {
                    throw new DOMException(12, "Expected slash in: " + lexicalUnit.toString());
                }
                lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
                PrimitiveValue primitiveValue4 = valueFactory.createCSSPrimitiveValue(lexicalUnit2, true);
                LCHColorValue.this.lchColor.setAlpha(primitiveValue4);
                lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
                if (lexicalUnit2 != null) {
                    throw new DOMException(12, "Bad value: " + lexicalUnit.toString());
                }
            }
            LCHColorValue.this.lchColor.setLightness(primitiveValue);
            LCHColorValue.this.lchColor.setChroma(primitiveValue2);
            LCHColorValue.this.lchColor.setHue(primitiveValue3);
        }
    }
}

