/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.BooleanCondition;
import io.sf.carte.doc.style.css.CSSCanvas;
import io.sf.carte.doc.style.css.CSSExpressionValue;
import io.sf.carte.doc.style.css.CSSNumberValue;
import io.sf.carte.doc.style.css.CSSPrimitiveValue;
import io.sf.carte.doc.style.css.CSSRatioValue;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.StyleDatabase;
import io.sf.carte.doc.style.css.om.BooleanConditionImpl;
import io.sf.carte.doc.style.css.om.MediaFeature;
import io.sf.carte.doc.style.css.om.MediaPredicate;
import io.sf.carte.doc.style.css.parser.AbstractMediaQuery;
import io.sf.carte.doc.style.css.property.Evaluator;
import io.sf.carte.doc.style.css.property.NumberValue;
import org.w3c.dom.DOMException;

abstract class MediaQueryImpl
extends AbstractMediaQuery {
    private static final long serialVersionUID = 1L;

    MediaQueryImpl() {
    }

    @Override
    protected void setMediaType(String string) {
        super.setMediaType(string);
    }

    @Override
    protected void setFeaturePredicate(BooleanCondition booleanCondition) {
        super.setFeaturePredicate(booleanCondition);
    }

    @Override
    protected void setNegative(boolean bl) {
        super.setNegative(bl);
    }

    @Override
    protected void setOnlyPrefix(boolean bl) {
        super.setOnlyPrefix(bl);
    }

    @Override
    protected boolean matches(AbstractMediaQuery abstractMediaQuery) {
        return super.matches(abstractMediaQuery);
    }

    @Override
    protected boolean matchesPredicate(BooleanCondition booleanCondition, CSSCanvas cSSCanvas) {
        if (((BooleanConditionImpl.Predicate)booleanCondition).getPredicateType() == 1) {
            return this.matchesFeaturePredicate((MediaFeature)booleanCondition, cSSCanvas);
        }
        return true;
    }

    private boolean matchesFeaturePredicate(MediaFeature mediaFeature, CSSCanvas cSSCanvas) {
        String string = mediaFeature.getName();
        CSSTypedValue cSSTypedValue = mediaFeature.getValue();
        mediaFeature.getRangeSecondValue();
        byte by = mediaFeature.getRangeType();
        if (by == 0 && cSSTypedValue == null) {
            return MediaQueryImpl.featureBooleanMatch(string, cSSCanvas);
        }
        if (by == 0) {
            if (string.startsWith("min-")) {
                if ((string = string.substring(4)).startsWith("device-")) {
                    string = string.substring(7);
                }
                return this.featureRangeMatch(string, (byte)5, cSSTypedValue, null, cSSCanvas);
            }
            if (string.startsWith("max-")) {
                if ((string = string.substring(4)).startsWith("device-")) {
                    string = string.substring(7);
                }
                return this.featureRangeMatch(string, (byte)3, cSSTypedValue, null, cSSCanvas);
            }
            if (string.startsWith("device-")) {
                string = string.substring(7);
            }
            if (!MediaQueryImpl.isRangeFeature(string)) {
                return cSSCanvas.matchesFeature(string, cSSTypedValue);
            }
            return this.featureRangeMatch(string, (byte)1, cSSTypedValue, null, cSSCanvas);
        }
        return this.featureRangeMatch(string, by, cSSTypedValue, mediaFeature.getRangeSecondValue(), cSSCanvas);
    }

    private static boolean featureBooleanMatch(String string, CSSCanvas cSSCanvas) {
        if (MediaQueryImpl.isRangeFeature(string)) {
            CSSTypedValue cSSTypedValue = cSSCanvas.getFeatureValue(string);
            return !cSSTypedValue.isNumberZero();
        }
        return cSSCanvas.matchesFeature(string, null);
    }

    private boolean featureRangeMatch(String string, byte by, CSSTypedValue cSSTypedValue, CSSTypedValue cSSTypedValue2, CSSCanvas cSSCanvas) {
        float f;
        CSSTypedValue cSSTypedValue3 = cSSCanvas.getFeatureValue(string);
        if (cSSTypedValue3 == null) {
            return false;
        }
        short s = cSSTypedValue3.getUnitType();
        float f2 = cSSTypedValue3.getFloatValue(s);
        float f3 = 0.0f;
        try {
            f = this.valueInUnit(cSSTypedValue, cSSCanvas, s);
        }
        catch (DOMException dOMException) {
            return false;
        }
        if (by >= 6) {
            if (cSSTypedValue2 == null) {
                return false;
            }
            try {
                f3 = this.valueInUnit(cSSTypedValue2, cSSCanvas, s);
            }
            catch (DOMException dOMException) {
                return false;
            }
        }
        switch (by) {
            case 1: {
                return MediaQueryImpl.floatEquals(f, f2);
            }
            case 2: {
                return f > f2;
            }
            case 3: {
                return f >= f2;
            }
            case 4: {
                return f < f2;
            }
            case 5: {
                return f <= f2;
            }
            case 18: {
                return f < f2 && f2 < f3;
            }
            case 19: {
                return f <= f2 && f2 < f3;
            }
            case 26: {
                return f < f2 && f2 <= f3;
            }
            case 27: {
                return f <= f2 && f2 <= f3;
            }
            case 36: {
                return f > f2 && f2 > f3;
            }
            case 37: {
                return f >= f2 && f2 > f3;
            }
            case 44: {
                return f > f2 && f2 >= f3;
            }
            case 45: {
                return f >= f2 && f2 >= f3;
            }
        }
        return false;
    }

    private float valueInUnit(CSSTypedValue cSSTypedValue, CSSCanvas cSSCanvas, short s) throws DOMException {
        float f;
        switch (cSSTypedValue.getPrimitiveType()) {
            case EXPRESSION: {
                CSSExpressionValue cSSExpressionValue = (CSSExpressionValue)cSSTypedValue;
                MQEvaluator mQEvaluator = new MQEvaluator(cSSCanvas);
                f = mQEvaluator.evaluateExpression(cSSExpressionValue).getFloatValue(s);
                break;
            }
            case RATIO: {
                float f2;
                MQEvaluator mQEvaluator;
                float f3;
                CSSRatioValue cSSRatioValue = (CSSRatioValue)cSSTypedValue;
                CSSPrimitiveValue cSSPrimitiveValue = cSSRatioValue.getAntecedentValue();
                CSSPrimitiveValue cSSPrimitiveValue2 = cSSRatioValue.getConsequentValue();
                if (cSSPrimitiveValue.getUnitType() == 0) {
                    f3 = ((CSSTypedValue)cSSPrimitiveValue).getFloatValue((short)0);
                } else {
                    mQEvaluator = new MQEvaluator(cSSCanvas);
                    f3 = mQEvaluator.evaluateExpression((CSSExpressionValue)cSSPrimitiveValue).getFloatValue((short)0);
                }
                if (cSSPrimitiveValue2.getUnitType() == 0) {
                    f2 = ((CSSTypedValue)cSSPrimitiveValue2).getFloatValue((short)0);
                } else {
                    mQEvaluator = new MQEvaluator(cSSCanvas);
                    f2 = mQEvaluator.evaluateExpression((CSSExpressionValue)cSSPrimitiveValue2).getFloatValue((short)0);
                }
                f = f3 / f2;
                break;
            }
            case NUMERIC: {
                return MediaQueryImpl.numericValueInUnit(cSSTypedValue, cSSCanvas, s);
            }
            default: {
                throw new DOMException(15, "Unsupported type: " + (Object)((Object)cSSTypedValue.getPrimitiveType()));
            }
        }
        return f;
    }

    private static float numericValueInUnit(CSSTypedValue cSSTypedValue, CSSCanvas cSSCanvas, short s) throws DOMException {
        float f;
        switch (cSSTypedValue.getUnitType()) {
            case 20: {
                f = cSSTypedValue.getFloatValue((short)20);
                StyleDatabase styleDatabase = cSSCanvas.getStyleDatabase();
                float f2 = styleDatabase.getFontSizeFromIdentifier(null, "medium");
                f2 = NumberValue.floatValueConversion(f2, styleDatabase.getNaturalUnit(), s);
                f *= f2;
                break;
            }
            case 21: {
                f = cSSTypedValue.getFloatValue((short)21);
                StyleDatabase styleDatabase = cSSCanvas.getStyleDatabase();
                float f3 = styleDatabase.getFontSizeFromIdentifier(null, "medium");
                float f4 = styleDatabase.getExSizeInPt(null, f3);
                f4 = NumberValue.floatValueConversion(f4, (short)6, s);
                f *= f4;
                break;
            }
            default: {
                f = cSSTypedValue.getFloatValue(s);
            }
        }
        return f;
    }

    static boolean floatEquals(float f, float f2) {
        return (double)Math.abs(f2 - f) < 7.0E-6;
    }

    protected abstract CSSNumberValue createNumberValue(short var1, float var2, boolean var3);

    @Override
    protected byte matches(BooleanCondition booleanCondition, BooleanCondition booleanCondition2, byte by) {
        switch (booleanCondition.getType()) {
            case AND: {
                for (BooleanCondition booleanCondition3 : booleanCondition.getSubConditions()) {
                    if (this.matches(booleanCondition3, booleanCondition2, by) != 0) continue;
                    return 0;
                }
                return 1;
            }
            case OR: {
                for (BooleanCondition booleanCondition4 : booleanCondition.getSubConditions()) {
                    if (this.matches(booleanCondition4, booleanCondition2, by) != 1) continue;
                    return 1;
                }
                break;
            }
            case PREDICATE: {
                MediaPredicate mediaPredicate = (MediaPredicate)booleanCondition;
                if (mediaPredicate.getPredicateType() == 0) {
                    return 2;
                }
                switch (booleanCondition2.getType()) {
                    case PREDICATE: {
                        MediaPredicate mediaPredicate2 = (MediaPredicate)booleanCondition2;
                        if (mediaPredicate2.getPredicateType() == 0) {
                            return 2;
                        }
                        if (mediaPredicate.matches(mediaPredicate2, by)) {
                            return 1;
                        }
                        return 0;
                    }
                    case AND: {
                        for (BooleanCondition booleanCondition5 : booleanCondition2.getSubConditions()) {
                            if (this.matches(booleanCondition, booleanCondition5, by) != 1) continue;
                            return 1;
                        }
                        break;
                    }
                    case OR: {
                        for (BooleanCondition booleanCondition6 : booleanCondition2.getSubConditions()) {
                            if (this.matches(booleanCondition, booleanCondition6, by) != 0) continue;
                            return 0;
                        }
                        return 1;
                    }
                    case NOT: {
                        by = by == 0 ? (byte)2 : (by == 1 ? (byte)3 : (by == 2 ? (byte)0 : 1));
                        return this.matches(booleanCondition, booleanCondition2.getNestedCondition(), by);
                    }
                    case SELECTOR_FUNCTION: {
                        return 1;
                    }
                    case OTHER: {
                        return 0;
                    }
                }
                break;
            }
            case NOT: {
                by = by == 0 ? (byte)1 : (by == 1 ? (byte)0 : (by == 2 ? (byte)3 : (byte)2));
                return this.matches(booleanCondition.getNestedCondition(), booleanCondition2, by);
            }
            case SELECTOR_FUNCTION: {
                return 1;
            }
        }
        return 0;
    }

    private class MQEvaluator
    extends Evaluator {
        private final CSSCanvas canvas;
        private final short expectedUnit;

        private MQEvaluator(CSSCanvas cSSCanvas) {
            this.canvas = cSSCanvas;
            this.expectedUnit = cSSCanvas.getStyleDatabase().getNaturalUnit();
        }

        @Override
        protected CSSTypedValue absoluteTypedValue(CSSTypedValue cSSTypedValue) {
            if (cSSTypedValue.getUnitType() != 0) {
                float f = MediaQueryImpl.this.valueInUnit(cSSTypedValue, this.canvas, this.expectedUnit);
                return this.createNumberValue(this.expectedUnit, f, true);
            }
            return cSSTypedValue;
        }

        @Override
        protected CSSNumberValue createNumberValue(short s, float f, boolean bl) {
            return MediaQueryImpl.this.createNumberValue(s, f, bl);
        }
    }
}

