/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSMarginRule;
import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSDeclarationRule;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.PageRule;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.util.StringTokenizer;
import org.w3c.dom.DOMException;

public class MarginRule
extends BaseCSSDeclarationRule
implements CSSMarginRule {
    private static final long serialVersionUID = 1L;
    private String ruleName = null;

    protected MarginRule(AbstractCSSStyleSheet abstractCSSStyleSheet, byte by, String string) {
        super(abstractCSSStyleSheet, (short)9, by);
        this.ruleName = string;
    }

    @Override
    public PageRule getParentRule() {
        return (PageRule)super.getParentRule();
    }

    @Override
    public String getCssText() {
        StyleFormattingContext styleFormattingContext = this.getStyleFormattingContext();
        styleFormattingContext.setParentContext(this.getParentRule());
        BufferSimpleWriter bufferSimpleWriter = new BufferSimpleWriter(32 + this.getStyle().getLength() * 24);
        try {
            this.writeCssText((SimpleWriter)bufferSimpleWriter, styleFormattingContext);
        }
        catch (IOException iOException) {
            throw new DOMException(11, iOException.getMessage());
        }
        return bufferSimpleWriter.toString();
    }

    @Override
    public String getMinifiedCssText() {
        StringBuilder stringBuilder = new StringBuilder(96);
        stringBuilder.append('@').append(this.ruleName).append('{');
        stringBuilder.append(this.getStyle().getMinifiedCssText()).append('}');
        return stringBuilder.toString();
    }

    @Override
    public void writeCssText(SimpleWriter simpleWriter, StyleFormattingContext styleFormattingContext) throws IOException {
        styleFormattingContext.startRule(simpleWriter, this.getPrecedingComments());
        simpleWriter.write('@');
        simpleWriter.write((CharSequence)this.ruleName);
        styleFormattingContext.updateContext(this);
        styleFormattingContext.writeLeftCurlyBracket(simpleWriter);
        styleFormattingContext.startStyleDeclaration(simpleWriter);
        this.getStyle().writeCssText(simpleWriter, styleFormattingContext);
        styleFormattingContext.endCurrentContext(this);
        styleFormattingContext.endStyleDeclaration(simpleWriter);
        styleFormattingContext.writeRightCurlyBracket(simpleWriter);
        styleFormattingContext.endRule(simpleWriter, this.getTrailingComments());
    }

    @Override
    public String getName() {
        return this.ruleName;
    }

    @Override
    void startAtRule(String string, String string2) {
        if (!this.isMarginRuleName(string)) {
            throw new DOMException(13, "Cannot set rule of type: " + string);
        }
    }

    private boolean isMarginRuleName(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "-");
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken();
            if ("top".equals(string2) || "left".equals(string2) || "center".equals(string2) || "right".equals(string2) || "corner".equals(string2) || "bottom".equals(string2) || "middle".equals(string2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = super.hashCode();
        n2 = 31 * n2 + (this.ruleName == null ? 0 : this.ruleName.hashCode());
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MarginRule marginRule = (MarginRule)object;
        return !(this.ruleName == null ? marginRule.ruleName != null : !this.ruleName.equals(marginRule.ruleName));
    }

    @Override
    public MarginRule clone(AbstractCSSStyleSheet abstractCSSStyleSheet) {
        MarginRule marginRule = new MarginRule(abstractCSSStyleSheet, this.getOrigin(), this.ruleName);
        marginRule.setParentRule(this.getParentRule());
        String string = this.getParentStyleSheet().getHref();
        marginRule.setWrappedStyle((BaseCSSStyleDeclaration)this.getStyle(), string);
        return marginRule;
    }
}

