/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.ShorthandBuilder;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueList;
import java.util.Set;

class GridPlacementShorthandBuilder
extends ShorthandBuilder {
    GridPlacementShorthandBuilder(String string, BaseCSSStyleDeclaration baseCSSStyleDeclaration) {
        super(string, baseCSSStyleDeclaration);
    }

    @Override
    protected int getMinimumSetSize() {
        return 2;
    }

    @Override
    int appendShorthandSet(StringBuilder stringBuilder, Set<String> set, boolean bl) {
        if (this.hasPropertiesToExclude(set)) {
            return 1;
        }
        stringBuilder.append(this.getShorthandName()).append(':');
        byte by = this.checkValuesForInherit(set);
        if (by == 1) {
            stringBuilder.append("inherit");
            this.appendPriority(stringBuilder, bl);
            return 0;
        }
        if (by == 2) {
            return 1;
        }
        by = this.checkValuesForType(CSSValue.Type.UNSET, set);
        if (by == 1) {
            stringBuilder.append("unset");
            this.appendPriority(stringBuilder, bl);
            return 0;
        }
        by = this.checkValuesForType(CSSValue.Type.REVERT, set);
        if (by == 1) {
            stringBuilder.append("revert");
            this.appendPriority(stringBuilder, bl);
            return 0;
        }
        if (by == 2) {
            return 1;
        }
        if (this.checkValuesForType(CSSValue.Type.INTERNAL, set) != 0) {
            return 1;
        }
        String[] stringArray = this.getSubproperties();
        StyleValue styleValue = this.getCSSValue(stringArray[0]);
        if (styleValue.getCssValueType() == CSSValue.CssType.LIST && ((ValueList)styleValue).isCommaSeparated()) {
            return 1;
        }
        this.appendValueText(stringBuilder, styleValue);
        if (stringArray.length == 2) {
            StyleValue styleValue2 = this.getCSSValue(stringArray[1]);
            if (this.isPrintValue(stringArray[1], styleValue2, styleValue)) {
                stringBuilder.append('/');
                this.appendValueText(stringBuilder, styleValue2);
            }
        } else {
            boolean bl2;
            StyleValue styleValue3 = this.getCSSValue(stringArray[3]);
            StyleValue styleValue4 = this.getCSSValue(stringArray[2]);
            StyleValue styleValue5 = this.getCSSValue(stringArray[1]);
            boolean bl3 = this.isPrintValue(stringArray[3], styleValue3, styleValue5);
            boolean bl4 = bl2 = this.isPrintValue(stringArray[2], styleValue4, styleValue) || bl3;
            if (this.isPrintValue(stringArray[1], styleValue5, styleValue) || bl2) {
                stringBuilder.append('/');
                this.appendValueText(stringBuilder, styleValue5);
                if (bl2) {
                    stringBuilder.append('/');
                    this.appendValueText(stringBuilder, styleValue4);
                    if (bl3) {
                        stringBuilder.append('/');
                        this.appendValueText(stringBuilder, styleValue3);
                    }
                }
            }
        }
        this.appendPriority(stringBuilder, bl);
        return 0;
    }

    private boolean isPrintValue(String string, StyleValue styleValue, StyleValue styleValue2) {
        if (styleValue.getCssValueType() != CSSValue.CssType.KEYWORD) {
            if (styleValue.getPrimitiveType() != CSSValue.Type.IDENT) {
                return true;
            }
            if (styleValue2.getPrimitiveType() == CSSValue.Type.IDENT) {
                return !this.valueEquals(styleValue2, styleValue);
            }
        }
        return this.isNotInitialValue(styleValue, string) && this.isNotInitialValue(styleValue2, string);
    }

    @Override
    protected boolean isNotInitialValue(StyleValue styleValue, String string) {
        return styleValue != null && !this.isEffectiveInitialKeyword(styleValue) && !this.valueEquals(this.getInitialPropertyValue(string), styleValue);
    }

    private void appendValueText(StringBuilder stringBuilder, StyleValue styleValue) {
        if (!this.isEffectiveInitialKeyword(styleValue)) {
            stringBuilder.append(styleValue.getMinifiedCssText(this.getShorthandName()));
        } else {
            stringBuilder.append("auto");
        }
    }
}

