/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.DeclarationFormattingContext;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.ShorthandBuilder;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.TypedValue;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.util.Set;

class FlexShorthandBuilder
extends ShorthandBuilder {
    private final String FLEX_GROW = "flex-grow";
    private final String FLEX_SHRINK = "flex-shrink";
    private final String FLEX_BASIS = "flex-basis";

    FlexShorthandBuilder(BaseCSSStyleDeclaration baseCSSStyleDeclaration) {
        super("flex", baseCSSStyleDeclaration);
    }

    @Override
    int appendShorthandSet(StringBuilder stringBuilder, Set<String> set, boolean bl) {
        Object object;
        Object object2;
        TypedValue typedValue;
        if (this.hasPropertiesToExclude(set)) {
            return 1;
        }
        stringBuilder.append(this.getShorthandName()).append(':');
        byte by = this.checkValuesForInherit(set);
        if (by == 1) {
            stringBuilder.append("inherit");
            this.appendPriority(stringBuilder, bl);
            return 0;
        }
        if (by == 2) {
            return 1;
        }
        by = this.checkValuesForType(CSSValue.Type.REVERT, set);
        if (by == 1) {
            stringBuilder.append("revert");
            this.appendPriority(stringBuilder, bl);
            return 0;
        }
        if (by == 2) {
            return 1;
        }
        StyleValue styleValue = null;
        if ((set.contains("flex-grow") || set.contains("flex-shrink")) && ((styleValue = this.getCSSValue("flex-grow")).getCssValueType() == CSSValue.CssType.TYPED ? this.invalidFlexGrowShrink((CSSTypedValue)((Object)styleValue)) : styleValue.getCssValueType() != CSSValue.CssType.KEYWORD)) {
            return 1;
        }
        StyleValue styleValue2 = null;
        if (set.contains("flex-shrink") && ((styleValue2 = this.getCSSValue("flex-shrink")).getCssValueType() == CSSValue.CssType.TYPED ? this.invalidFlexGrowShrink((CSSTypedValue)((Object)styleValue2)) : styleValue.getCssValueType() != CSSValue.CssType.KEYWORD)) {
            return 1;
        }
        StyleValue styleValue3 = null;
        if (set.contains("flex-basis") && ((styleValue3 = this.getCSSValue("flex-basis")).getCssValueType() == CSSValue.CssType.TYPED ? this.invalidFlexBasis((CSSTypedValue)((Object)styleValue3)) : styleValue.getCssValueType() != CSSValue.CssType.KEYWORD)) {
            return 1;
        }
        if (styleValue3 != null && styleValue3.getPrimitiveType() == CSSValue.Type.IDENT && "auto".equalsIgnoreCase((typedValue = (TypedValue)styleValue3).getStringValue())) {
            float f;
            float f2;
            object2 = (CSSTypedValue)((Object)styleValue);
            object = (CSSTypedValue)((Object)styleValue2);
            if (object != null) {
                f2 = object.getFloatValue((short)0);
                f = object2 != null ? object2.getFloatValue((short)0) : f2;
            } else {
                f = object2 != null ? object2.getFloatValue((short)0) : 1.0f;
                f2 = f;
            }
            if (f == 1.0f && f2 == 1.0f) {
                stringBuilder.append("auto");
                this.appendPriority(stringBuilder, bl);
                return 0;
            }
            if (f == 0.0f && f2 == 0.0f) {
                stringBuilder.append("none");
                this.appendPriority(stringBuilder, bl);
                return 0;
            }
            if (f == 0.0f && f2 == 1.0f) {
                stringBuilder.append("0");
                this.appendPriority(stringBuilder, bl);
                return 0;
            }
        }
        object2 = new BufferSimpleWriter(stringBuilder);
        object = this.getParentStyle().getFormattingContext();
        boolean bl2 = false;
        boolean bl3 = this.isNotInitialValue(styleValue2, "flex-shrink");
        if (bl3 || this.isNotInitialValue(styleValue, "flex-grow")) {
            this.appendValueText((BufferSimpleWriter)object2, (DeclarationFormattingContext)object, styleValue, false);
            bl2 = true;
        }
        if (bl3) {
            this.appendValueText((BufferSimpleWriter)object2, (DeclarationFormattingContext)object, styleValue2, bl2);
            bl2 = true;
        }
        if (this.isNotInitialValue(styleValue3, "flex-basis")) {
            typedValue = (TypedValue)styleValue3;
            if (typedValue.getUnitType() == 0 || typedValue.isNumberZero()) {
                if (bl2) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append("0px");
            } else {
                this.appendValueText((BufferSimpleWriter)object2, (DeclarationFormattingContext)object, styleValue3, bl2);
            }
            bl2 = true;
        }
        if (!bl2) {
            stringBuilder.append("0");
        }
        this.appendPriority(stringBuilder, bl);
        return 0;
    }

    private boolean invalidFlexGrowShrink(CSSTypedValue cSSTypedValue) {
        if (cSSTypedValue.getUnitType() == 0) {
            return cSSTypedValue.getFloatValue((short)0) < 0.0f;
        }
        return true;
    }

    private boolean invalidFlexBasis(CSSTypedValue cSSTypedValue) {
        if (cSSTypedValue.getPrimitiveType() == CSSValue.Type.IDENT) {
            String string = cSSTypedValue.getStringValue();
            return !"auto".equalsIgnoreCase(string) && !"content".equalsIgnoreCase(string);
        }
        if (cSSTypedValue.getUnitType() == 0) {
            return cSSTypedValue.getFloatValue((short)0) != 0.0f;
        }
        return false;
    }

    @Override
    protected boolean isNotInitialValue(StyleValue styleValue, String string) {
        return styleValue != null && !this.isEffectiveInitialKeyword(styleValue) && !this.valueEquals(this.getInitialPropertyValue(string), styleValue);
    }

    private void appendValueText(BufferSimpleWriter bufferSimpleWriter, DeclarationFormattingContext declarationFormattingContext, StyleValue styleValue, boolean bl) {
        if (bl) {
            bufferSimpleWriter.getBuffer().append(' ');
        }
        try {
            declarationFormattingContext.writeMinifiedValue((SimpleWriter)bufferSimpleWriter, "flex", styleValue);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

