/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.StyleDeclarationErrorHandler;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.ShorthandSetter;
import io.sf.carte.doc.style.css.property.InheritValue;
import io.sf.carte.doc.style.css.property.KeywordValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import java.util.Locale;
import org.w3c.dom.DOMException;

class BoxShorthandSetter
extends ShorthandSetter {
    boolean nonmixed = true;

    BoxShorthandSetter(BaseCSSStyleDeclaration baseCSSStyleDeclaration, String string) {
        super(baseCSSStyleDeclaration, string);
    }

    boolean scanForInherited(LexicalUnit lexicalUnit) {
        while (lexicalUnit != null) {
            if (lexicalUnit.getLexicalUnitType() != LexicalUnit.LexicalType.INHERIT) {
                return false;
            }
            lexicalUnit = lexicalUnit.getNextLexicalUnit();
        }
        KeywordValue keywordValue = InheritValue.getValue().asSubproperty();
        this.setSubpropertiesToKeyword(keywordValue);
        this.initValueString();
        this.appendValueItemString(keywordValue);
        return true;
    }

    @Override
    public boolean assignSubproperties() {
        if (this.scanForInherited(this.currentValue)) {
            return true;
        }
        String[] stringArray = this.getShorthandSubproperties();
        short s = this.boxValueCount(this.currentValue);
        if (s == 0 || s > 4) {
            StyleDeclarationErrorHandler styleDeclarationErrorHandler = this.styleDeclaration.getStyleDeclarationErrorHandler();
            if (styleDeclarationErrorHandler != null && !this.hasCompatValue()) {
                styleDeclarationErrorHandler.wrongSubpropertyCount(this.getShorthandName(), s);
            }
            return false;
        }
        switch (s) {
            case 1: {
                StyleValue styleValue = this.createCSSValue(this.getShorthandName(), this.currentValue);
                for (String string : stringArray) {
                    this.setSubpropertyValue(string, styleValue);
                }
                break;
            }
            case 2: {
                StyleValue styleValue = this.createCSSValue(stringArray[0], this.currentValue);
                this.nextCurrentValue();
                StyleValue styleValue2 = this.createCSSValue(stringArray[1], this.currentValue);
                this.setSubpropertyValue(stringArray[0], styleValue);
                this.setSubpropertyValue(stringArray[1], styleValue2);
                this.setSubpropertyValue(stringArray[2], styleValue);
                this.setSubpropertyValue(stringArray[3], styleValue2);
                break;
            }
            case 3: {
                StyleValue styleValue = this.createCSSValue(stringArray[0], this.currentValue);
                this.nextCurrentValue();
                StyleValue styleValue3 = this.createCSSValue(stringArray[1], this.currentValue);
                this.nextCurrentValue();
                StyleValue styleValue4 = this.createCSSValue(stringArray[2], this.currentValue);
                this.setSubpropertyValue(stringArray[0], styleValue);
                this.setSubpropertyValue(stringArray[1], styleValue3);
                this.setSubpropertyValue(stringArray[2], styleValue4);
                this.setSubpropertyValue(stringArray[3], styleValue3);
                break;
            }
            case 4: {
                for (String string : stringArray) {
                    StyleValue styleValue = this.createCSSValue(string, this.currentValue);
                    this.setSubpropertyValue(string, styleValue);
                    this.nextCurrentValue();
                }
                break;
            }
        }
        if (!this.nonmixed) {
            this.initValueString();
        }
        return true;
    }

    short boxValueCount(LexicalUnit lexicalUnit) {
        int n = 0;
        for (LexicalUnit lexicalUnit2 = lexicalUnit; lexicalUnit2 != null; lexicalUnit2 = lexicalUnit2.getNextLexicalUnit()) {
            if (this.isValueOfType(lexicalUnit2)) {
                n = (short)(n + 1);
                continue;
            }
            LexicalUnit.LexicalType lexicalType = lexicalUnit2.getLexicalUnitType();
            if (lexicalType == LexicalUnit.LexicalType.IDENT) {
                String string = lexicalUnit2.getStringValue();
                String string2 = string.toLowerCase(Locale.ROOT).intern();
                if (this.isIdentifierValue(string2)) {
                    n = (short)(n + 1);
                    continue;
                }
            } else {
                if (lexicalType == LexicalUnit.LexicalType.INHERIT || lexicalType == LexicalUnit.LexicalType.INITIAL || lexicalType == LexicalUnit.LexicalType.UNSET || lexicalType == LexicalUnit.LexicalType.REVERT) {
                    this.nonmixed = false;
                    n = (short)(n + 1);
                    continue;
                }
                if (lexicalUnit2.getLexicalUnitType() == LexicalUnit.LexicalType.VAR) {
                    n = (short)(n + 1);
                    continue;
                }
            }
            n = 5;
            break;
        }
        if (!this.nonmixed && n == 1) {
            this.nonmixed = true;
        }
        return (short)n;
    }

    boolean isValueOfType(LexicalUnit lexicalUnit) {
        return ValueFactory.isSizeSACUnit(lexicalUnit);
    }

    boolean isIdentifierValue(String string) {
        return "auto".equals(string);
    }

    @Override
    protected StyleValue createCSSValue(String string, LexicalUnit lexicalUnit) throws DOMException {
        return this.createCSSValue(string, lexicalUnit, this.nonmixed);
    }

    @Override
    protected void setSubpropertyValue(String string, StyleValue styleValue) {
        this.styleDeclaration.setProperty(string, styleValue, this.isPriorityImportant());
    }
}

