/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.ShorthandBuilder;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueList;
import java.util.Locale;
import java.util.Set;

class BorderImageBuilder
extends ShorthandBuilder {
    private final StringBuilder bibuf = new StringBuilder(64);
    private boolean noslice = true;

    BorderImageBuilder(BaseCSSStyleDeclaration baseCSSStyleDeclaration) {
        super("border-image", baseCSSStyleDeclaration);
    }

    @Override
    protected int getMinimumSetSize() {
        return 5;
    }

    @Override
    protected boolean isResponsibleShorthand(String string) {
        return false;
    }

    @Override
    int appendShorthandSet(StringBuilder stringBuilder, Set<String> set, boolean bl) {
        if (this.hasPropertiesToExclude(set)) {
            return 1;
        }
        stringBuilder.append(this.getShorthandName()).append(':');
        StyleValue styleValue = this.getCSSValue("border-image-source");
        StyleValue styleValue2 = this.getCSSValue("border-image-slice");
        StyleValue styleValue3 = this.getCSSValue("border-image-width");
        StyleValue styleValue4 = this.getCSSValue("border-image-outset");
        StyleValue styleValue5 = this.getCSSValue("border-image-repeat");
        byte by = this.checkValuesForInherit(set, styleValue, styleValue2, styleValue3, styleValue4, styleValue5);
        if (by == 1) {
            stringBuilder.append("inherit");
            this.appendPriority(stringBuilder, bl);
            return 0;
        }
        if (by == 2) {
            return 1;
        }
        if (this.allValuesAreInitial(set, styleValue, styleValue2, styleValue3, styleValue4, styleValue5)) {
            stringBuilder.append("none");
            this.appendPriority(stringBuilder, bl);
            return 0;
        }
        byte by2 = this.checkValuesForRevert(set, styleValue, styleValue2, styleValue3, styleValue4, styleValue5);
        if (by2 == 1) {
            stringBuilder.append("revert");
            this.appendPriority(stringBuilder, bl);
            return 0;
        }
        if (by2 == 2) {
            return 1;
        }
        if (this.checkValuesForType(CSSValue.Type.INTERNAL, set) != 0) {
            return 1;
        }
        if (set.contains("border-image-source")) {
            this.appendBorderImageSource(styleValue);
        }
        if (set.contains("border-image-slice") && !this.appendBorderImageSlice(styleValue2)) {
            return 1;
        }
        if (set.contains("border-image-width") && !this.appendBorderImageWidth(styleValue3)) {
            return 1;
        }
        if (set.contains("border-image-outset") && !this.appendBorderImageOutset(styleValue4)) {
            return 1;
        }
        if (set.contains("border-image-repeat") && !this.appendBorderImageRepeat(styleValue5)) {
            return 1;
        }
        if (this.bibuf.length() == 0) {
            this.bibuf.append("none");
        }
        if (bl) {
            this.bibuf.append("!important");
        }
        stringBuilder.append((CharSequence)this.bibuf).append(';');
        return 0;
    }

    private byte checkValuesForInherit(Set<String> set, StyleValue styleValue, StyleValue styleValue2, StyleValue styleValue3, StyleValue styleValue4, StyleValue styleValue5) {
        byte by = 0;
        byte by2 = (byte)set.size();
        if (set.contains("border-image-source") && this.isInherit(styleValue)) {
            by = (byte)(by + 1);
        }
        if (set.contains("border-image-slice") && this.isInherit(styleValue2)) {
            by = (byte)(by + 1);
        }
        if (set.contains("border-image-width") && this.isInherit(styleValue3)) {
            by = (byte)(by + 1);
        }
        if (set.contains("border-image-outset") && this.isInherit(styleValue4)) {
            by = (byte)(by + 1);
        }
        if (set.contains("border-image-repeat") && this.isInherit(styleValue5)) {
            by = (byte)(by + 1);
        }
        if (by == 0) {
            return 0;
        }
        if (by == by2) {
            return 1;
        }
        return 2;
    }

    private boolean allValuesAreInitial(Set<String> set, StyleValue styleValue, StyleValue styleValue2, StyleValue styleValue3, StyleValue styleValue4, StyleValue styleValue5) {
        if (set.contains("border-image-source") && !this.isEffectiveInitialKeyword(styleValue) && this.isNotInitialValue(styleValue, "border-image-source")) {
            return false;
        }
        if (set.contains("border-image-slice") && !this.isEffectiveInitialKeyword(styleValue2) && this.isNotInitialValue(styleValue2, "border-image-slice")) {
            return false;
        }
        if (set.contains("border-image-width") && !this.isEffectiveInitialKeyword(styleValue3) && this.isNotInitialValue(styleValue3, "border-image-width")) {
            return false;
        }
        if (set.contains("border-image-outset") && !this.isEffectiveInitialKeyword(styleValue4) && this.isNotInitialValue(styleValue4, "border-image-outset")) {
            return false;
        }
        return !set.contains("border-image-repeat") || this.isEffectiveInitialKeyword(styleValue5) || !this.isNotInitialValue(styleValue5, "border-image-repeat");
    }

    private byte checkValuesForRevert(Set<String> set, StyleValue styleValue, StyleValue styleValue2, StyleValue styleValue3, StyleValue styleValue4, StyleValue styleValue5) {
        byte by = 0;
        byte by2 = (byte)set.size();
        if (set.contains("border-image-source") && BorderImageBuilder.isCssValueOfType(CSSValue.Type.REVERT, styleValue)) {
            by = (byte)(by + 1);
        }
        if (set.contains("border-image-slice") && BorderImageBuilder.isCssValueOfType(CSSValue.Type.REVERT, styleValue2)) {
            by = (byte)(by + 1);
        }
        if (set.contains("border-image-width") && BorderImageBuilder.isCssValueOfType(CSSValue.Type.REVERT, styleValue3)) {
            by = (byte)(by + 1);
        }
        if (set.contains("border-image-outset") && BorderImageBuilder.isCssValueOfType(CSSValue.Type.REVERT, styleValue4)) {
            by = (byte)(by + 1);
        }
        if (set.contains("border-image-repeat") && BorderImageBuilder.isCssValueOfType(CSSValue.Type.REVERT, styleValue5)) {
            by = (byte)(by + 1);
        }
        if (by == 0) {
            return 0;
        }
        if (by == by2) {
            return 1;
        }
        return 2;
    }

    private boolean appendValueIfNotInitial(String string, StyleValue styleValue) {
        String string2 = this.getValueTextIfNotInitial(string, styleValue);
        if (string2 != null) {
            this.appendText(string2);
            return true;
        }
        return false;
    }

    private void appendText(CharSequence charSequence) {
        BorderImageBuilder.appendText(charSequence, this.bibuf);
    }

    private static void appendText(CharSequence charSequence, StringBuilder stringBuilder) {
        if (stringBuilder.length() != 0) {
            stringBuilder.append(' ');
        }
        stringBuilder.append(charSequence);
    }

    private void appendBorderImageSource(StyleValue styleValue) {
        if (this.isNotInitialValue(styleValue, "border-image-source")) {
            this.appendImage(this.bibuf, false, styleValue);
        }
    }

    private boolean appendBorderImageSlice(StyleValue styleValue) {
        CSSValue.CssType cssType = styleValue.getCssValueType();
        if (cssType == CSSValue.CssType.TYPED) {
            this.appendBorderImageSide1Value(this.bibuf, "100%", styleValue);
        } else if (cssType == CSSValue.CssType.LIST) {
            ValueList valueList = (ValueList)styleValue;
            if (valueList.isCommaSeparated()) {
                return false;
            }
            boolean bl = false;
            int n = valueList.getLength();
            StyleValue styleValue2 = valueList.item(n - 1);
            if (styleValue2.getPrimitiveType() == CSSValue.Type.IDENT) {
                if ("fill".equals(((CSSTypedValue)((Object)styleValue2)).getStringValue().toLowerCase(Locale.ROOT))) {
                    --n;
                    bl = true;
                } else {
                    return false;
                }
            }
            if (n > 4) {
                return false;
            }
            boolean bl2 = this.appendBorderImageSides(this.bibuf, "100%", valueList, n);
            if (bl2 || bl) {
                this.noslice = false;
            }
            if (bl) {
                this.appendText("fill");
            }
        } else if (cssType == CSSValue.CssType.PROXY) {
            return false;
        }
        return true;
    }

    private boolean appendBorderImageWidth(StyleValue styleValue) {
        StringBuilder stringBuilder = new StringBuilder();
        CSSValue.CssType cssType = styleValue.getCssValueType();
        if (cssType == CSSValue.CssType.TYPED) {
            this.appendBorderImageSide1Value(stringBuilder, "1", styleValue);
        } else if (cssType == CSSValue.CssType.LIST) {
            ValueList valueList = (ValueList)styleValue;
            if (valueList.isCommaSeparated()) {
                return false;
            }
            int n = valueList.getLength();
            if (n > 4) {
                return false;
            }
            this.appendBorderImageSides(stringBuilder, "1", valueList, n);
        } else if (cssType == CSSValue.CssType.PROXY) {
            return false;
        }
        if (stringBuilder.length() != 0) {
            if (this.noslice) {
                this.bibuf.append(this.getInitialPropertyValue("border-image-slice").getMinifiedCssText(""));
            }
            this.bibuf.append('/').append((CharSequence)stringBuilder);
        }
        return true;
    }

    private boolean appendBorderImageOutset(StyleValue styleValue) {
        StringBuilder stringBuilder = new StringBuilder();
        CSSValue.CssType cssType = styleValue.getCssValueType();
        if (cssType == CSSValue.CssType.TYPED) {
            this.appendBorderImageSide1Value(stringBuilder, "0", styleValue);
        } else if (cssType == CSSValue.CssType.LIST) {
            ValueList valueList = (ValueList)styleValue;
            if (valueList.isCommaSeparated()) {
                return false;
            }
            this.appendBorderImageSides(stringBuilder, "0", valueList, valueList.getLength());
        } else if (cssType == CSSValue.CssType.PROXY) {
            return false;
        }
        if (stringBuilder.length() != 0) {
            this.bibuf.append('/').append((CharSequence)stringBuilder);
        }
        return true;
    }

    private boolean appendBorderImageSides(StringBuilder stringBuilder, String string, ValueList valueList, int n) {
        switch (n) {
            case 1: {
                return this.appendBorderImageSide1Value(stringBuilder, string, valueList.item(0));
            }
            case 2: {
                return this.appendBorderImageSide2Values(stringBuilder, string, valueList.item(0), valueList.item(1));
            }
            case 3: {
                return this.appendBorderImageSide3Values(stringBuilder, string, valueList.item(0), valueList.item(1), valueList.item(2));
            }
            case 4: {
                return this.appendBorderImageSide4Values(stringBuilder, string, valueList.item(0), valueList.item(1), valueList.item(2), valueList.item(3));
            }
        }
        return false;
    }

    private boolean appendBorderImageSide1Value(StringBuilder stringBuilder, String string, StyleValue styleValue) {
        String string2 = styleValue.getMinifiedCssText("");
        if (!string.equals(string2)) {
            BorderImageBuilder.appendText(string2, stringBuilder);
            return true;
        }
        return false;
    }

    private boolean appendBorderImageSide2Values(StringBuilder stringBuilder, String string, StyleValue styleValue, StyleValue styleValue2) {
        if (styleValue.equals(styleValue2)) {
            return this.appendBorderImageSide1Value(stringBuilder, string, styleValue);
        }
        BorderImageBuilder.appendText(styleValue.getMinifiedCssText(""), stringBuilder);
        stringBuilder.append(' ');
        stringBuilder.append(styleValue2.getMinifiedCssText(""));
        return true;
    }

    private boolean appendBorderImageSide3Values(StringBuilder stringBuilder, String string, StyleValue styleValue, StyleValue styleValue2, StyleValue styleValue3) {
        if (styleValue.equals(styleValue3)) {
            return this.appendBorderImageSide2Values(stringBuilder, string, styleValue, styleValue2);
        }
        BorderImageBuilder.appendText(styleValue.getMinifiedCssText(""), stringBuilder);
        BorderImageBuilder.appendText(styleValue2.getMinifiedCssText(""), stringBuilder);
        BorderImageBuilder.appendText(styleValue3.getMinifiedCssText(""), stringBuilder);
        return true;
    }

    private boolean appendBorderImageSide4Values(StringBuilder stringBuilder, String string, StyleValue styleValue, StyleValue styleValue2, StyleValue styleValue3, StyleValue styleValue4) {
        if (styleValue2.equals(styleValue4)) {
            return this.appendBorderImageSide3Values(stringBuilder, string, styleValue, styleValue2, styleValue3);
        }
        BorderImageBuilder.appendText(styleValue.getMinifiedCssText(""), stringBuilder);
        BorderImageBuilder.appendText(styleValue2.getMinifiedCssText(""), stringBuilder);
        BorderImageBuilder.appendText(styleValue3.getMinifiedCssText(""), stringBuilder);
        BorderImageBuilder.appendText(styleValue4.getMinifiedCssText(""), stringBuilder);
        return true;
    }

    private boolean appendBorderImageRepeat(StyleValue styleValue) {
        CSSValue.CssType cssType = styleValue.getCssValueType();
        if (cssType == CSSValue.CssType.TYPED) {
            this.appendValueIfNotInitial("border-image-repeat", styleValue);
        } else if (cssType == CSSValue.CssType.LIST) {
            StyleValue styleValue2;
            ValueList valueList = (ValueList)styleValue;
            if (valueList.isCommaSeparated() || valueList.getLength() != 2) {
                return false;
            }
            StyleValue styleValue3 = valueList.item(0);
            if (styleValue3.equals(styleValue2 = valueList.item(1))) {
                this.appendValueIfNotInitial("border-image-repeat", styleValue3);
            } else {
                this.appendText(styleValue3.getCssText());
                this.bibuf.append(styleValue2.getCssText());
            }
        } else if (cssType == CSSValue.CssType.PROXY) {
            return false;
        }
        return true;
    }
}

