/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom;

import io.sf.carte.doc.dom.DOMDocument;
import io.sf.carte.doc.dom.DOMElement;
import io.sf.carte.doc.dom.DOMNode;
import io.sf.carte.doc.dom.DOMNodeList;
import io.sf.carte.doc.dom.ElementList;
import io.sf.carte.doc.dom.EmptyNodeList;
import io.sf.carte.doc.dom.NodeFilter;
import io.sf.carte.doc.dom.NodeListIterator;
import io.sf.carte.doc.style.css.CSSDocument;
import java.io.Serializable;
import java.text.Normalizer;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.UserDataHandler;

abstract class AbstractDOMNode
implements DOMNode,
Serializable {
    private static final long serialVersionUID = 1L;
    private final short nodeType;
    private AbstractDOMNode parentNode = null;
    AbstractDOMNode previousSibling = null;
    AbstractDOMNode nextSibling = null;
    private Map<String, Object> userData = null;
    private Map<String, UserDataHandler> userDataHandler = null;
    static final RawNodeList emptyNodeList = new EmptyNodeList();

    AbstractDOMNode(short s) {
        this.nodeType = s;
    }

    @Override
    public String getNodeValue() throws DOMException {
        return null;
    }

    @Override
    public void setNodeValue(String string) throws DOMException {
    }

    @Override
    public short getNodeType() {
        return this.nodeType;
    }

    @Override
    public String getLocalName() {
        return null;
    }

    @Override
    public NamedNodeMap getAttributes() {
        return null;
    }

    @Override
    public boolean hasAttributes() {
        return false;
    }

    void setParentNode(AbstractDOMNode abstractDOMNode) {
        this.parentNode = abstractDOMNode;
    }

    void setAttributeOwner(DOMElement dOMElement) {
        this.parentNode = dOMElement;
    }

    @Override
    public DOMNode getParentNode() {
        return this.parentNode;
    }

    AbstractDOMNode parentNode() {
        return this.parentNode;
    }

    boolean isDocumentDescendant() {
        AbstractDOMNode abstractDOMNode = this;
        AbstractDOMNode abstractDOMNode2;
        while ((abstractDOMNode2 = abstractDOMNode.parentNode) != null) {
            abstractDOMNode = abstractDOMNode2;
        }
        return abstractDOMNode.getNodeType() == 9;
    }

    @Override
    public DOMNodeList getChildNodes() {
        return this.getNodeList();
    }

    RawNodeList getNodeList() {
        return emptyNodeList;
    }

    @Override
    public boolean hasChildNodes() {
        return false;
    }

    @Override
    public DOMNode getFirstChild() {
        return this.getNodeList().getFirst();
    }

    @Override
    public DOMNode getLastChild() {
        return this.getNodeList().getLast();
    }

    @Override
    public DOMNode getPreviousSibling() {
        return this.previousSibling;
    }

    @Override
    public DOMNode getNextSibling() {
        return this.nextSibling;
    }

    @Override
    public DOMNode appendChild(Node node) throws DOMException {
        AbstractDOMNode abstractDOMNode = (AbstractDOMNode)node;
        if (node.getNodeType() != 11) {
            this.preAddChild(node);
            this.getNodeList().add(abstractDOMNode);
            this.postAddChild(abstractDOMNode);
        } else {
            this.appendDocumentFragment(node);
        }
        return abstractDOMNode;
    }

    void preAddChild(Node node) {
        this.checkAppendNode(node);
        Node node2 = node.getParentNode();
        if (node2 != null) {
            node2.removeChild(node);
        }
    }

    void checkAppendNode(Node node) {
        if (node.getNodeType() == 9) {
            throw new DOMException(3, "Cannot append a document.");
        }
        this.checkAppendNodeHierarchy(node);
        this.checkDocumentOwner(node);
    }

    void checkAppendNodeHierarchy(Node node) {
        if (node.getNodeType() == 2) {
            throw new DOMException(3, "Use setAttributeNode to add attribute nodes.");
        }
        for (Node node2 = this; node2 != null; node2 = node2.getParentNode()) {
            if (!node2.isSameNode(node)) continue;
            throw new DOMException(3, "Cannot insert itself or an ancestor.");
        }
    }

    void checkDocumentOwner(Node node) {
        if (node.getOwnerDocument() != this.getOwnerDocument()) {
            throw new DOMException(4, "Different document owners.");
        }
    }

    void postAddChild(AbstractDOMNode abstractDOMNode) {
        abstractDOMNode.setParentNode(this);
    }

    private void appendDocumentFragment(Node node) {
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            Node node3 = node2.getNextSibling();
            this.appendChild(node2);
            node2 = node3;
        }
    }

    @Override
    public DOMNode insertBefore(Node node, Node node2) throws DOMException {
        AbstractDOMNode abstractDOMNode = (AbstractDOMNode)node;
        AbstractDOMNode abstractDOMNode2 = (AbstractDOMNode)node2;
        if (abstractDOMNode2 != null) {
            if (abstractDOMNode2 != abstractDOMNode) {
                if (!this.getNodeList().contains(abstractDOMNode2)) {
                    throw new DOMException(8, "Not a child of this node.");
                }
                if (abstractDOMNode.getNodeType() == 11) {
                    this.insertDocumentFragment(abstractDOMNode, abstractDOMNode2);
                    return abstractDOMNode;
                }
                this.preAddChild(abstractDOMNode);
                this.getNodeList().insertBefore(abstractDOMNode, abstractDOMNode2);
                this.postAddChild(abstractDOMNode);
            }
        } else {
            this.appendChild(abstractDOMNode);
        }
        return abstractDOMNode;
    }

    private void insertDocumentFragment(AbstractDOMNode abstractDOMNode, AbstractDOMNode abstractDOMNode2) {
        AbstractDOMNode abstractDOMNode3 = (AbstractDOMNode)abstractDOMNode.getFirstChild();
        while (abstractDOMNode3 != null) {
            AbstractDOMNode abstractDOMNode4 = abstractDOMNode3.nextSibling;
            this.insertBefore(abstractDOMNode3, abstractDOMNode2);
            abstractDOMNode3 = abstractDOMNode4;
        }
    }

    @Override
    public DOMNode replaceChild(Node node, Node node2) throws DOMException {
        int n = this.getNodeList().indexOf(node2);
        if (n == -1) {
            throw new DOMException(8, "Not a child of this node.");
        }
        AbstractDOMNode abstractDOMNode = (AbstractDOMNode)node2;
        AbstractDOMNode abstractDOMNode2 = (AbstractDOMNode)node;
        if (abstractDOMNode != abstractDOMNode2) {
            if (node.getNodeType() == 11) {
                this.replaceWithDocumentFragment(abstractDOMNode2, abstractDOMNode);
            } else {
                this.replaceWithNonDocumentFragment(abstractDOMNode2, abstractDOMNode);
            }
            abstractDOMNode.setParentNode(null);
            this.postRemoveChild(abstractDOMNode);
        }
        return abstractDOMNode;
    }

    private void replaceWithNonDocumentFragment(AbstractDOMNode abstractDOMNode, AbstractDOMNode abstractDOMNode2) {
        this.preReplaceChild(abstractDOMNode, abstractDOMNode2);
        abstractDOMNode2 = this.getNodeList().replace(abstractDOMNode, abstractDOMNode2);
        AbstractDOMNode.callUserHandlers((short)3, abstractDOMNode2, null);
        abstractDOMNode.setParentNode(this);
    }

    void preReplaceChild(AbstractDOMNode abstractDOMNode, AbstractDOMNode abstractDOMNode2) {
        this.preAddChild(abstractDOMNode);
    }

    private void replaceWithDocumentFragment(AbstractDOMNode abstractDOMNode, AbstractDOMNode abstractDOMNode2) {
        AbstractDOMNode abstractDOMNode3 = (AbstractDOMNode)abstractDOMNode.getFirstChild();
        if (abstractDOMNode3 != null) {
            AbstractDOMNode abstractDOMNode4 = abstractDOMNode3.nextSibling;
            this.replaceWithNonDocumentFragment(abstractDOMNode3, abstractDOMNode2);
            AbstractDOMNode abstractDOMNode5 = abstractDOMNode3;
            abstractDOMNode3 = abstractDOMNode4;
            while (abstractDOMNode3 != null) {
                abstractDOMNode4 = abstractDOMNode3.nextSibling;
                this.insertAfter(abstractDOMNode3, abstractDOMNode5);
                abstractDOMNode5 = abstractDOMNode3;
                abstractDOMNode3 = abstractDOMNode4;
            }
        }
    }

    void insertAfter(AbstractDOMNode abstractDOMNode, AbstractDOMNode abstractDOMNode2) {
        this.preAddChild(abstractDOMNode);
        AbstractDOMNode abstractDOMNode3 = abstractDOMNode2.nextSibling;
        if (abstractDOMNode3 != null) {
            this.getNodeList().insertBefore(abstractDOMNode, abstractDOMNode3);
        } else {
            this.getNodeList().add(abstractDOMNode);
        }
        this.postAddChild(abstractDOMNode);
    }

    @Override
    public DOMNode removeChild(Node node) throws DOMException {
        if (!this.getNodeList().contains(node)) {
            throw new DOMException(8, "Not a child.");
        }
        AbstractDOMNode abstractDOMNode = (AbstractDOMNode)node;
        abstractDOMNode.removeFromParent(this.getNodeList());
        this.postRemoveChild(abstractDOMNode);
        return abstractDOMNode;
    }

    void postRemoveChild(AbstractDOMNode abstractDOMNode) {
    }

    void removeFromParent(RawNodeList rawNodeList) {
        this.setParentNode(null);
        rawNodeList.remove(this);
        AbstractDOMNode.callUserHandlers((short)3, this, null);
    }

    @Override
    public void removeAllChild() {
        if (this.hasChildNodes()) {
            RawNodeList rawNodeList = this.getNodeList();
            for (AbstractDOMNode abstractDOMNode : rawNodeList) {
                abstractDOMNode.removeFromParent(rawNodeList);
                this.postRemoveChild(abstractDOMNode);
            }
        }
    }

    static void callUserHandlers(short s, AbstractDOMNode abstractDOMNode, Node node) {
        if (abstractDOMNode.userDataHandler != null) {
            for (Map.Entry<String, UserDataHandler> entry : abstractDOMNode.userDataHandler.entrySet()) {
                String string = entry.getKey();
                UserDataHandler userDataHandler = entry.getValue();
                if (userDataHandler == null) continue;
                userDataHandler.handle(s, string, abstractDOMNode.userData.get(string), abstractDOMNode, node);
            }
        }
    }

    @Override
    public Object setUserData(String string, Object object, UserDataHandler userDataHandler) {
        this.lazyUserData();
        Object object2 = this.userData.get(string);
        this.userData.put(string, object);
        this.userDataHandler.put(string, userDataHandler);
        return object2;
    }

    private void lazyUserData() {
        if (this.userData == null) {
            this.userData = new HashMap<String, Object>(2);
            this.userDataHandler = new HashMap<String, UserDataHandler>(2);
        }
    }

    @Override
    public Object getUserData(String string) {
        return this.userData != null ? this.userData.get(string) : null;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public void normalize() {
        var1_1 /* !! */  = this.getFirstChild();
        var2_2 = 1;
        var3_3 = this.getOwnerDocument().domConfig;
        var4_4 = 0;
        if (!var3_3.useComputedStyles) {
            var4_4 = 2;
        }
        if (!var3_3.cssWhitespaceProcessing) {
            var4_4 = 1;
        }
        var5_5 /* !! */  = null;
        while (var1_1 /* !! */  != null) {
            block22: {
                block21: {
                    var6_6 = var1_1 /* !! */ .getNextSibling();
                    var7_7 = var1_1 /* !! */ .getNodeType();
                    if (var7_7 != 3) break block21;
                    var8_8 = (Text)var1_1 /* !! */ ;
                    var9_9 = var8_8.getData();
                    if (var9_9.length() == 0) {
                        ((AbstractDOMNode)var8_8).removeFromParent(this.getNodeList());
                        var1_1 /* !! */  = var6_6;
                        continue;
                    }
                    v0 = var10_10 = var3_3.cssWhitespaceProcessing != false && var8_8.isElementContentWhitespace() != false;
                    if (var10_10 && var4_4 == 0) {
                        if (this.isWhitespacePreserving()) {
                            var4_4 = 1;
                            var10_10 = false;
                        } else {
                            var4_4 = 2;
                        }
                    }
                    if (var10_10) {
                        if (var5_5 /* !! */  == null) {
                            ((AbstractDOMNode)var1_1 /* !! */ ).removeFromParent(this.getNodeList());
                            var1_1 /* !! */  = var6_6;
                            continue;
                        }
                        if (var6_6 == null) {
                            ((AbstractDOMNode)var1_1 /* !! */ ).removeFromParent(this.getNodeList());
                            while (var5_5 /* !! */  != null && var5_5 /* !! */ .getNodeType() == 3 && ((Text)var5_5 /* !! */ ).isElementContentWhitespace()) {
                                ((AbstractDOMNode)var5_5 /* !! */ ).removeFromParent(this.getNodeList());
                                var5_5 /* !! */  = var5_5 /* !! */ .getPreviousSibling();
                            }
                            break;
                        }
                        var8_8.setData(" ");
                        var9_9 = " ";
                    } else if (var3_3.normalizeCharacters && var9_9 != (var11_11 = Normalizer.normalize((CharSequence)var9_9, Normalizer.Form.NFC))) {
                        var8_8.setData((String)var11_11);
                        var9_9 = var11_11;
                    }
                    if (var2_2 != 3) break block22;
                    var11_11 = (Text)var5_5 /* !! */ ;
                    if (!var11_11.isElementContentWhitespace() || var4_4 == 1) ** GOTO lbl-1000
                    if (var4_4 == 0) {
                        v1 = this.whitespacePreserving();
                        var4_4 = v1;
                        ** if (v1 != 1) goto lbl-1000
                    }
                    ** GOTO lbl-1000
lbl-1000:
                    // 2 sources

                    {
                        if (!var10_10 || var6_6 != null && (var6_6.getNodeType() != 3 || !((Text)var6_6).isElementContentWhitespace())) {
                            var11_11.setData(var11_11.getData() + (String)var9_9);
                        }
                        ** GOTO lbl58
                    }
lbl-1000:
                    // 2 sources

                    {
                        if (!var10_10) {
                            var11_11.setData(" " + (String)var9_9);
                        }
                    }
lbl58:
                    // 4 sources

                    ((AbstractDOMNode)var1_1 /* !! */ ).removeFromParent(this.getNodeList());
                    var1_1 /* !! */  = var6_6;
                    continue;
                }
                if (var7_7 == 1) {
                    var1_1 /* !! */ .normalize();
                } else if (var7_7 == 8 && !var3_3.keepComments) {
                    ((AbstractDOMNode)var1_1 /* !! */ ).removeFromParent(this.getNodeList());
                }
            }
            var2_2 = var7_7;
            var5_5 /* !! */  = var1_1 /* !! */ ;
            var1_1 /* !! */  = var6_6;
        }
    }

    private byte whitespacePreserving() {
        return this.isWhitespacePreserving() ? (byte)1 : 2;
    }

    private boolean isWhitespacePreserving() {
        if (this.getNodeType() == 1) {
            String string = ((DOMElement)this).getComputedStyle(null).getPropertyValue("white-space");
            return "pre".equalsIgnoreCase(string) || "pre-wrap".equalsIgnoreCase(string) || "break-spaces".equalsIgnoreCase(string);
        }
        return false;
    }

    @Override
    @Deprecated
    public Object getFeature(String string, String string2) {
        return null;
    }

    @Override
    @Deprecated
    public boolean isSupported(String string, String string2) {
        return true;
    }

    @Override
    public short compareDocumentPosition(Node node) throws DOMException {
        Node node2;
        if (node == this) {
            return 0;
        }
        if (this.getOwnerDocument() != node.getOwnerDocument()) {
            return 1;
        }
        short s = 0;
        int n = 1;
        int n2 = 1;
        for (node2 = this.getParentNode(); node2 != null; node2 = node2.getParentNode()) {
            if (node2.equals(node)) {
                s = (short)(s + 16);
                s = (short)(s + 4);
                break;
            }
            n = (short)(n + 1);
        }
        if (s == 0) {
            for (node2 = node.getParentNode(); node2 != null; node2 = node2.getParentNode()) {
                if (node2.equals(this)) {
                    s = (short)(s + 8);
                    s = (short)(s + 2);
                    break;
                }
                n2 = (short)(n2 + 1);
            }
        }
        if (s == 0) {
            int n3 = n > n2 ? n2 : n;
            int[] nArray = new int[n3];
            int[] nArray2 = new int[n3];
            this.computeIndexArray(this, nArray);
            this.computeIndexArray((AbstractDOMNode)node, nArray2);
            for (int n4 = 0; n4 < n3; n4 = (int)((short)(n4 + 1))) {
                if (nArray[n4] == nArray2[n4]) continue;
                if (nArray[n4] > nArray2[n4]) {
                    return 4;
                }
                return 2;
            }
        }
        return s;
    }

    private void computeIndexArray(AbstractDOMNode abstractDOMNode, int[] nArray) {
        AbstractDOMNode abstractDOMNode2 = (AbstractDOMNode)abstractDOMNode.getParentNode();
        int n = nArray.length - 1;
        while (abstractDOMNode2 != null) {
            nArray[n] = abstractDOMNode2.getNodeList().indexOf(abstractDOMNode);
            abstractDOMNode = abstractDOMNode2;
            abstractDOMNode2 = (AbstractDOMNode)abstractDOMNode.getParentNode();
            --n;
        }
    }

    @Override
    public String getTextContent() throws DOMException {
        String string;
        switch (this.getNodeType()) {
            case 1: 
            case 5: 
            case 6: 
            case 11: {
                if (this.getNodeList().isEmpty()) {
                    string = "";
                    break;
                }
                StringBuilder stringBuilder = new StringBuilder(64);
                this.appendTextContent(stringBuilder);
                string = stringBuilder.toString();
                break;
            }
            case 3: {
                string = this.getNodeValue();
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: {
                string = this.getNodeValue();
                break;
            }
            default: {
                string = null;
            }
        }
        return string;
    }

    void appendTextContent(StringBuilder stringBuilder) {
        switch (this.getNodeType()) {
            case 1: 
            case 5: 
            case 6: 
            case 11: {
                AbstractDOMNode abstractDOMNode = this.getNodeList().getFirst();
                while (abstractDOMNode != null) {
                    short s = abstractDOMNode.getNodeType();
                    if (s == 8 || s == 7) {
                        abstractDOMNode = abstractDOMNode.nextSibling;
                        continue;
                    }
                    abstractDOMNode.appendTextContent(stringBuilder);
                    abstractDOMNode = abstractDOMNode.nextSibling;
                }
                break;
            }
            case 3: {
                String string = this.getNodeValue();
                stringBuilder.append(string);
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: {
                String string = this.getNodeValue();
                stringBuilder.append(string);
                break;
            }
        }
    }

    @Override
    public void setTextContent(String string) throws DOMException {
        this.getNodeList().clear();
        if (string != null && string.length() != 0) {
            AbstractDOMNode abstractDOMNode = (AbstractDOMNode)((Object)this.getOwnerDocument().createTextNode(string));
            this.getNodeList().add(abstractDOMNode);
            abstractDOMNode.setParentNode(this);
        }
    }

    @Override
    public String getNamespaceURI() {
        return null;
    }

    @Override
    public String getPrefix() {
        return null;
    }

    @Override
    public void setPrefix(String string) throws DOMException {
    }

    @Override
    public String lookupNamespaceURI(String string) {
        return null;
    }

    @Override
    public String lookupPrefix(String string) {
        return null;
    }

    @Override
    public boolean isDefaultNamespace(String string) {
        return this.getOwnerDocument().isDefaultNamespace(string);
    }

    @Override
    public boolean isEqualNode(Node node) {
        if (node != null && this.getNodeType() == node.getNodeType() && this.getNodeName().equals(node.getNodeName()) && this.stringEquals(this.getLocalName(), node.getLocalName()) && this.stringEquals(this.getNamespaceURI(), node.getNamespaceURI()) && this.stringEquals(this.getPrefix(), node.getPrefix()) && this.stringEquals(this.getNodeValue(), node.getNodeValue()) && this.getNodeList().getLength() == node.getChildNodes().getLength()) {
            Node node2 = this.getFirstChild();
            Node node3 = node.getFirstChild();
            while (node2 != null) {
                if (!node2.isEqualNode(node3)) {
                    return false;
                }
                node2 = node2.getNextSibling();
                node3 = node3.getNextSibling();
            }
            NamedNodeMap namedNodeMap = this.getAttributes();
            NamedNodeMap namedNodeMap2 = node.getAttributes();
            if (namedNodeMap == null) {
                return namedNodeMap2 == null;
            }
            int n = namedNodeMap.getLength();
            if (n == namedNodeMap2.getLength()) {
                block1: for (int i = 0; i < n; ++i) {
                    Attr attr = (Attr)namedNodeMap.item(i);
                    for (int j = 0; j < n; ++j) {
                        Attr attr2 = (Attr)namedNodeMap2.item(j);
                        if (attr.isEqualNode(attr2) && attr.isId() == attr2.isId()) continue block1;
                    }
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private boolean stringEquals(String string, String string2) {
        if (string == string2) {
            return true;
        }
        if (string == null) {
            return false;
        }
        return string.equals(string2);
    }

    @Override
    public boolean isSameNode(Node node) {
        return node == this;
    }

    public boolean contains(Node node) {
        Node node2 = node;
        do {
            if (node2 != this) continue;
            return true;
        } while ((node2 = node2.getParentNode()) != null);
        return false;
    }

    @Override
    public abstract DOMDocument getOwnerDocument();

    static interface ChildCollections
    extends RawNodeList {
        public ElementList getChildren();

        public Iterator<DOMNode> createDescendingIterator();

        public Iterator<DOMNode> createIterator(BitSet var1);

        public Iterator<DOMNode> createIterator(int var1, NodeFilter var2);

        public NodeListIterator createListIterator();

        public ElementList getElementsByTagNameNS(String var1, String var2);

        public ElementList getElementsByTagName(String var1, boolean var2);

        public ElementList getElementsByClassName(String var1, CSSDocument.ComplianceMode var2);
    }

    static interface RawNodeList
    extends DOMNodeList {
        public void add(AbstractDOMNode var1) throws DOMException;

        public void insertBefore(AbstractDOMNode var1, AbstractDOMNode var2);

        public void clear();

        public AbstractDOMNode getFirst();

        public AbstractDOMNode getLast();

        public int indexOf(Node var1);

        public void remove(AbstractDOMNode var1);

        public AbstractDOMNode replace(AbstractDOMNode var1, AbstractDOMNode var2);

        public Iterator<DOMElement> elementIterator();

        public Iterator<DOMElement> elementIterator(String var1) throws DOMException;

        public Iterator<DOMElement> elementIteratorNS(String var1, String var2);

        public Iterator<Attr> attributeIterator();
    }
}

