/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value.css;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.CSSStylableElement;
import io.sf.carte.echosvg.css.engine.StyleMap;
import io.sf.carte.echosvg.css.engine.value.AbstractValueManager;
import io.sf.carte.echosvg.css.engine.value.ListValue;
import io.sf.carte.echosvg.css.engine.value.RevertValue;
import io.sf.carte.echosvg.css.engine.value.StringMap;
import io.sf.carte.echosvg.css.engine.value.URIValue;
import io.sf.carte.echosvg.css.engine.value.UnsetValue;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.css.engine.value.ValueConstants;
import java.util.Locale;
import org.w3c.dom.DOMException;

public class CursorManager
extends AbstractValueManager {
    protected static final StringMap values = new StringMap();

    @Override
    public boolean isInheritedProperty() {
        return true;
    }

    @Override
    public boolean isAnimatableProperty() {
        return true;
    }

    @Override
    public boolean isAdditiveProperty() {
        return false;
    }

    @Override
    public int getPropertyType() {
        return 21;
    }

    @Override
    public String getPropertyName() {
        return "cursor";
    }

    @Override
    public Value getDefaultValue() {
        return ValueConstants.AUTO_VALUE;
    }

    @Override
    public Value createValue(LexicalUnit lexicalUnit, CSSEngine cSSEngine) throws DOMException {
        ListValue listValue = new ListValue();
        LexicalUnit lexicalUnit2 = lexicalUnit;
        switch (lexicalUnit.getLexicalUnitType()) {
            case URI: {
                do {
                    listValue.append(new URIValue(lexicalUnit2.getStringValue(), CursorManager.resolveURI(cSSEngine.getCSSBaseURI(), lexicalUnit2.getStringValue())));
                    lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
                    if (lexicalUnit2 == null) {
                        throw this.createMalformedLexicalUnitDOMException();
                    }
                    if (lexicalUnit2.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                        if (lexicalUnit2.getLexicalUnitType() == LexicalUnit.LexicalType.VAR) {
                            return this.createLexicalValue(lexicalUnit);
                        }
                        throw this.createInvalidLexicalUnitDOMException(lexicalUnit2.getLexicalUnitType());
                    }
                    if ((lexicalUnit2 = lexicalUnit2.getNextLexicalUnit()) != null) continue;
                    throw this.createMalformedLexicalUnitDOMException();
                } while (lexicalUnit2.getLexicalUnitType() == LexicalUnit.LexicalType.URI);
                if (lexicalUnit2.getLexicalUnitType() != LexicalUnit.LexicalType.IDENT) {
                    if (lexicalUnit2.getLexicalUnitType() == LexicalUnit.LexicalType.VAR) {
                        return this.createLexicalValue(lexicalUnit);
                    }
                    throw this.createInvalidLexicalUnitDOMException(lexicalUnit2.getLexicalUnitType());
                }
            }
            case IDENT: {
                String string = lexicalUnit2.getStringValue().toLowerCase(Locale.ROOT).intern();
                Object object = values.get(string);
                if (object == null) {
                    throw this.createInvalidIdentifierDOMException(lexicalUnit2.getStringValue());
                }
                listValue.append((Value)object);
                lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
                break;
            }
            case INHERIT: {
                return ValueConstants.INHERIT_VALUE;
            }
            case UNSET: {
                return UnsetValue.getInstance();
            }
            case REVERT: {
                return RevertValue.getInstance();
            }
            case INITIAL: {
                return this.getDefaultValue();
            }
            case VAR: {
                return this.createLexicalValue(lexicalUnit);
            }
        }
        if (lexicalUnit2 != null) {
            throw this.createInvalidLexicalUnitDOMException(lexicalUnit2.getLexicalUnitType());
        }
        return listValue;
    }

    @Override
    public Value computeValue(CSSStylableElement cSSStylableElement, String string, CSSEngine cSSEngine, int n, StyleMap styleMap, Value value) {
        if (value.getCssValueType() == CSSValue.CssType.LIST) {
            int n2 = value.getLength();
            ListValue listValue = new ListValue(' ');
            for (int i = 0; i < n2; ++i) {
                Value value2 = value.item(i);
                if (value2.getPrimitiveType() == CSSValue.Type.URI) {
                    Object object;
                    if (styleMap.isAttrTainted(n)) {
                        object = cSSEngine.getCSSEngineUserAgent();
                        if (object != null) {
                            object.displayMessage("attr()-tainted value: " + value.getCssText());
                        }
                        return null;
                    }
                    object = value2.getURIValue();
                    listValue.append(new URIValue((String)object, (String)object));
                    continue;
                }
                listValue.append(value2);
            }
            return listValue;
        }
        return super.computeValue(cSSStylableElement, string, cSSEngine, n, styleMap, value);
    }

    static {
        values.put("auto", ValueConstants.AUTO_VALUE);
        values.put("crosshair", ValueConstants.CROSSHAIR_VALUE);
        values.put("default", ValueConstants.DEFAULT_VALUE);
        values.put("e-resize", ValueConstants.E_RESIZE_VALUE);
        values.put("help", ValueConstants.HELP_VALUE);
        values.put("move", ValueConstants.MOVE_VALUE);
        values.put("n-resize", ValueConstants.N_RESIZE_VALUE);
        values.put("ne-resize", ValueConstants.NE_RESIZE_VALUE);
        values.put("nw-resize", ValueConstants.NW_RESIZE_VALUE);
        values.put("pointer", ValueConstants.POINTER_VALUE);
        values.put("s-resize", ValueConstants.S_RESIZE_VALUE);
        values.put("se-resize", ValueConstants.SE_RESIZE_VALUE);
        values.put("sw-resize", ValueConstants.SW_RESIZE_VALUE);
        values.put("text", ValueConstants.TEXT_VALUE);
        values.put("w-resize", ValueConstants.W_RESIZE_VALUE);
        values.put("wait", ValueConstants.WAIT_VALUE);
    }
}

