/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.echosvg.css.engine.value.ComponentValue;
import io.sf.carte.echosvg.css.engine.value.Value;
import java.util.ArrayList;
import java.util.Iterator;
import org.w3c.css.om.typed.CSSStyleValueList;

public class AbstractValueList<V extends Value>
extends ComponentValue
implements CSSStyleValueList<V> {
    private static final long serialVersionUID = 1L;
    ArrayList<V> items;
    private char separator;

    public AbstractValueList() {
        this(',');
    }

    public AbstractValueList(char c) {
        this(c, 5);
    }

    public AbstractValueList(char c, int n) {
        this.separator = c;
        this.items = new ArrayList(n);
    }

    @Override
    public AbstractValueList<V> clone() {
        AbstractValueList abstractValueList = (AbstractValueList)super.clone();
        for (Value value : this.items) {
            abstractValueList.items.add(value.clone());
        }
        abstractValueList.separator = this.separator;
        return abstractValueList;
    }

    public char getSeparatorChar() {
        return this.separator;
    }

    @Override
    public CSSValue.CssType getCssValueType() {
        return CSSValue.CssType.LIST;
    }

    public CSSValue.Type getPrimitiveType() {
        return CSSValue.Type.INVALID;
    }

    public boolean add(V v) {
        boolean bl = this.items.add(v);
        this.componentAdded((Value)v);
        return bl;
    }

    public String getCssText() {
        int n = this.items.size();
        StringBuilder stringBuilder = new StringBuilder(n * 8);
        if (n > 0) {
            stringBuilder.append(((Value)this.items.get(0)).toString());
        }
        for (int i = 1; i < n; ++i) {
            stringBuilder.append(this.separator);
            stringBuilder.append(((Value)this.items.get(i)).toString());
        }
        return stringBuilder.toString();
    }

    public V item(int n) {
        return (V)((Value)this.items.get(n));
    }

    @Override
    public int getLength() {
        return this.items.size();
    }

    public Iterator<V> iterator() {
        return this.items.iterator();
    }

    public void clear() {
        this.items.clear();
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public V remove(int n) {
        Value value = (Value)this.items.remove(n);
        this.componentRemoved(value);
        return (V)value;
    }

    public V set(int n, V v) {
        Value value = (Value)this.items.set(n, v);
        this.getComponentHandler().listValueChanged(n, (Value)v);
        return (V)value;
    }
}

