/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine;

import io.sf.carte.doc.style.css.BooleanCondition;
import io.sf.carte.doc.style.css.nsac.CSSBudgetException;
import io.sf.carte.doc.style.css.nsac.CSSException;
import io.sf.carte.doc.style.css.om.CSSOMParser;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.Rule;
import io.sf.carte.echosvg.css.engine.StyleSheet;
import org.w3c.dom.DOMException;

public class SupportsRule
extends StyleSheet
implements Rule {
    public static final short TYPE = 12;
    private BooleanCondition condition;
    boolean supports;

    public SupportsRule(BooleanCondition booleanCondition) {
        this.condition = booleanCondition;
    }

    @Override
    public short getType() {
        return 12;
    }

    public BooleanCondition getCondition() {
        return this.condition;
    }

    public String getConditionText() {
        return this.condition != null ? this.condition.toString() : "";
    }

    public void setConditionText(String string) throws DOMException {
        this.parseConditionText(string);
    }

    private void parseConditionText(String string) throws DOMException {
        CSSOMParser cSSOMParser = new CSSOMParser();
        try {
            this.condition = cSSOMParser.parseSupportsCondition(string, null);
        }
        catch (CSSBudgetException cSSBudgetException) {
            DOMException dOMException = new DOMException(9, "Limit found while parsing condition " + string);
            dOMException.initCause(cSSBudgetException);
            throw dOMException;
        }
        catch (CSSException cSSException) {
            DOMException dOMException = new DOMException(12, "Error parsing condition: " + string);
            dOMException.initCause(cSSException);
            throw dOMException;
        }
    }

    @Override
    public String toString(CSSEngine cSSEngine) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("@supports");
        if (this.condition != null) {
            stringBuilder.append(this.condition.toString());
        }
        stringBuilder.append(" {\n");
        for (int i = 0; i < this.size; ++i) {
            stringBuilder.append(this.rules[i].toString(cSSEngine));
        }
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }
}

