/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.bridge;

import io.sf.carte.echosvg.bridge.BridgeContext;
import io.sf.carte.echosvg.bridge.BridgeException;
import io.sf.carte.echosvg.bridge.CSSFontFace;
import io.sf.carte.echosvg.bridge.CSSUtilities;
import io.sf.carte.echosvg.bridge.ErrorConstants;
import io.sf.carte.echosvg.bridge.FontFamilyResolver;
import io.sf.carte.echosvg.bridge.SVGFontFace;
import io.sf.carte.echosvg.bridge.SVGFontFaceElementBridge;
import io.sf.carte.echosvg.bridge.SVGFontFamily;
import io.sf.carte.echosvg.bridge.UserAgent;
import io.sf.carte.echosvg.dom.AbstractNode;
import io.sf.carte.echosvg.gvt.font.GVTFontFace;
import io.sf.carte.echosvg.gvt.font.GVTFontFamily;
import io.sf.carte.echosvg.util.ParsedURL;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGDocument;

public abstract class FontFace
extends GVTFontFace
implements ErrorConstants {
    List<Object> srcs;

    public FontFace(List<Object> list, String string, float f, String string2, String string3, String string4, String string5, float f2, String string6, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10) {
        super(string, f, string2, string3, string4, string5, f2, string6, f3, f4, f5, f6, f7, f8, f9, f10);
        this.srcs = list;
    }

    protected FontFace(String string) {
        super(string);
    }

    public static CSSFontFace createFontFace(String string, FontFace fontFace) {
        return new CSSFontFace(new LinkedList<Object>(fontFace.srcs), string, fontFace.unitsPerEm, fontFace.fontWeight, fontFace.fontStyle, fontFace.fontVariant, fontFace.fontStretch, fontFace.slope, fontFace.panose1, fontFace.ascent, fontFace.descent, fontFace.strikethroughPosition, fontFace.strikethroughThickness, fontFace.underlinePosition, fontFace.underlineThickness, fontFace.overlinePosition, fontFace.overlineThickness);
    }

    public GVTFontFamily getFontFamily(BridgeContext bridgeContext) {
        FontFamilyResolver fontFamilyResolver = bridgeContext.getFontFamilyResolver();
        GVTFontFamily gVTFontFamily = fontFamilyResolver.resolve(this.familyName, this);
        if (gVTFontFamily != null) {
            return gVTFontFamily;
        }
        for (Object object : this.srcs) {
            if (object instanceof String) {
                gVTFontFamily = fontFamilyResolver.resolve((String)object, this);
                if (gVTFontFamily == null) continue;
                return gVTFontFamily;
            }
            if (!(object instanceof ParsedURL)) continue;
            try {
                GVTFontFamily gVTFontFamily2 = this.getFontFamily(bridgeContext, (ParsedURL)object);
                if (gVTFontFamily2 == null) continue;
                return gVTFontFamily2;
            }
            catch (SecurityException securityException) {
                bridgeContext.getUserAgent().displayError(securityException);
            }
            catch (BridgeException bridgeException) {
                if (!"uri.unsecure".equals(bridgeException.getCode())) continue;
                bridgeContext.getUserAgent().displayError(bridgeException);
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    protected GVTFontFamily getFontFamily(BridgeContext bridgeContext, ParsedURL parsedURL) {
        String string = parsedURL.toString();
        Element element = this.getBaseElement(bridgeContext);
        SVGDocument sVGDocument = (SVGDocument)element.getOwnerDocument();
        String string2 = sVGDocument.getURL();
        ParsedURL parsedURL2 = null;
        if (string2 != null) {
            parsedURL2 = new ParsedURL(string2);
        }
        String string3 = AbstractNode.getBaseURI((Node)element);
        parsedURL = new ParsedURL(string3, string);
        UserAgent userAgent = bridgeContext.getUserAgent();
        try {
            userAgent.checkLoadExternalResource(parsedURL, parsedURL2);
        }
        catch (SecurityException securityException) {
            userAgent.displayError(securityException);
            return null;
        }
        if (parsedURL.getRef() != null) {
            Object object;
            Object object2;
            Element element2 = bridgeContext.getReferencedElement(element, string);
            if (element2 == null || !element2.getNamespaceURI().equals("http://www.w3.org/2000/svg") || !element2.getLocalName().equals("font")) {
                return null;
            }
            SVGDocument sVGDocument2 = (SVGDocument)element.getOwnerDocument();
            SVGDocument sVGDocument3 = (SVGDocument)element2.getOwnerDocument();
            Element element3 = element2;
            if (sVGDocument2 != sVGDocument3) {
                element3 = (Element)sVGDocument2.importNode((Node)element2, true);
                object2 = AbstractNode.getBaseURI((Node)element2);
                object = sVGDocument2.createElementNS("http://www.w3.org/2000/svg", "g");
                object.appendChild(element3);
                object.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:base", (String)object2);
                CSSUtilities.computeStyleAndURIs(element2, element3, string);
            }
            object2 = null;
            for (object = element3.getFirstChild(); object != null; object = object.getNextSibling()) {
                if (object.getNodeType() != 1 || !object.getNamespaceURI().equals("http://www.w3.org/2000/svg") || !object.getLocalName().equals("font-face")) continue;
                object2 = (Element)object;
                break;
            }
            if ((object = (SVGFontFaceElementBridge)bridgeContext.getBridge("http://www.w3.org/2000/svg", "font-face")) == null || object2 == null) {
                return null;
            }
            SVGFontFace sVGFontFace = ((SVGFontFaceElementBridge)object).createFontFace(bridgeContext, (Element)object2);
            return new SVGFontFamily(sVGFontFace, element3, bridgeContext);
        }
        try {
            return bridgeContext.getFontFamilyResolver().loadFont(parsedURL.openStream(), this);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected Element getBaseElement(BridgeContext bridgeContext) {
        SVGDocument sVGDocument = (SVGDocument)bridgeContext.getDocument();
        return sVGDocument.getRootElement();
    }
}

