/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.uparser;

import io.sf.carte.uparser.ContentHandler;
import io.sf.carte.uparser.ControlHandler;
import io.sf.carte.uparser.LocatorAccess;
import io.sf.carte.uparser.SmallWhitelistCharacterCheck;
import io.sf.carte.uparser.TokenControl;
import io.sf.carte.uparser.TokenErrorHandler;
import io.sf.carte.uparser.TokenHandler3;
import io.sf.carte.uparser.TokenProducer3;
import io.sf.carte.uparser.WhitelistCharacterCheck;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;

public class TokenProducer3<E extends Exception> {
    public static final byte ERR_UNEXPECTED_END_QUOTED = 1;
    public static final byte ERR_LASTCHAR_BACKSLASH = 2;
    public static final byte ERR_UNEXPECTED_END_COMMENTED = 3;
    public static final byte ERR_UNEXPECTED_CONTROL = 4;
    public static final int CHAR_EXCLAMATION = 33;
    public static final int CHAR_NUMBER_SIGN = 35;
    public static final int CHAR_DOLLAR = 36;
    public static final int CHAR_PERCENT_SIGN = 37;
    public static final int CHAR_AMPERSAND = 38;
    public static final int CHAR_LEFT_PAREN = 40;
    public static final int CHAR_RIGHT_PAREN = 41;
    public static final int CHAR_ASTERISK = 42;
    public static final int CHAR_PLUS = 43;
    public static final int CHAR_COMMA = 44;
    public static final int CHAR_HYPHEN_MINUS = 45;
    public static final int CHAR_FULL_STOP = 46;
    public static final int CHAR_SLASH = 47;
    public static final int CHAR_COLON = 58;
    public static final int CHAR_SEMICOLON = 59;
    public static final int CHAR_LESS_THAN = 60;
    public static final int CHAR_EQUALS = 61;
    public static final int CHAR_GREATER_THAN = 62;
    public static final int CHAR_QUESTION_MARK = 63;
    public static final int CHAR_COMMERCIAL_AT = 64;
    public static final int CHAR_LEFT_SQ_BRACKET = 91;
    public static final int CHAR_RIGHT_SQ_BRACKET = 93;
    public static final int CHAR_CIRCUMFLEX_ACCENT = 94;
    public static final int CHAR_LOW_LINE = 95;
    public static final int CHAR_LEFT_CURLY_BRACKET = 123;
    public static final int CHAR_VERTICAL_LINE = 124;
    public static final int CHAR_RIGHT_CURLY_BRACKET = 125;
    public static final int CHAR_TILDE = 126;
    private static final int CHARACTER_PROCESSING_LIMIT_DEFAULT = 0x40000000;
    private ContentHandler<E> handler;
    private ControlHandler<E> controlHandler;
    private TokenErrorHandler<E> errorHandler;
    private final CharacterCheck charCheck;
    private boolean handleAllSeparators = true;
    private boolean acceptNewlineEndingQuote = false;
    private boolean acceptEofEndingQuoted = false;
    private final int characterIndexLimit;

    public TokenProducer3(TokenHandler3<E> tokenHandler3) {
        this(tokenHandler3, 0x40000000);
    }

    public TokenProducer3(TokenHandler3<E> tokenHandler3, int n) {
        this.characterIndexLimit = n;
        this.handler = tokenHandler3;
        this.controlHandler = tokenHandler3;
        this.errorHandler = tokenHandler3;
        this.charCheck = new DisallowCharacterCheck();
    }

    public TokenProducer3(TokenHandler3<E> tokenHandler3, CharacterCheck characterCheck) {
        this(tokenHandler3, characterCheck, 0x40000000);
    }

    public TokenProducer3(TokenHandler3<E> tokenHandler3, CharacterCheck characterCheck, int n) {
        this.handler = tokenHandler3;
        this.controlHandler = tokenHandler3;
        this.errorHandler = tokenHandler3;
        this.charCheck = characterCheck;
        this.characterIndexLimit = n;
    }

    public TokenProducer3(TokenHandler3<E> tokenHandler3, int[] nArray) {
        this(tokenHandler3, nArray, 0x40000000);
    }

    public TokenProducer3(TokenHandler3<E> tokenHandler3, int[] nArray, int n) {
        this.handler = tokenHandler3;
        this.controlHandler = tokenHandler3;
        this.errorHandler = tokenHandler3;
        this.charCheck = nArray.length < 4 ? new SmallWhitelistCharacterCheck(nArray) : new WhitelistCharacterCheck(nArray);
        this.characterIndexLimit = n;
    }

    public TokenProducer3(CharacterCheck characterCheck, int n) {
        this.charCheck = characterCheck;
        this.characterIndexLimit = n;
    }

    public void setContentHandler(ContentHandler<E> contentHandler) {
        this.handler = contentHandler;
    }

    public void setControlHandler(ControlHandler<E> controlHandler) {
        this.controlHandler = controlHandler;
    }

    public void setErrorHandler(TokenErrorHandler<E> tokenErrorHandler) {
        this.errorHandler = tokenErrorHandler;
    }

    public void setHandleAllSeparators(boolean bl) {
        this.handleAllSeparators = bl;
    }

    public void setAcceptNewlineEndingQuote(boolean bl) {
        this.acceptNewlineEndingQuote = bl;
    }

    public void setAcceptEofEndingQuoted(boolean bl) {
        this.acceptEofEndingQuoted = bl;
    }

    public void parse(String string) throws E {
        if (string == null) {
            throw new NullPointerException("Null argument");
        }
        StringParser stringParser = new StringParser(string);
        try {
            stringParser.parse();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void parse(String string, String string2, String string3) throws E {
        if (string == null) {
            throw new NullPointerException("Null argument");
        }
        StringParser stringParser = new StringParser(string, string2, string3);
        try {
            stringParser.parse();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void parse(Reader reader) throws E, IOException {
        if (reader == null) {
            throw new NullPointerException("Null character stream");
        }
        ReaderParser readerParser = new ReaderParser(reader);
        readerParser.parse();
    }

    public void parse(Reader reader, int n) throws E, IOException {
        if (reader == null) {
            throw new NullPointerException("Null character stream");
        }
        ReaderParser readerParser = new ReaderParser(reader, n);
        readerParser.parse();
    }

    public void parse(Reader reader, String string, String string2) throws E, IOException {
        if (reader == null) {
            throw new NullPointerException("Null character stream");
        }
        ReaderParser readerParser = new ReaderParser(reader, string, string2);
        readerParser.parse();
    }

    public void parseMultiComment(Reader reader, String[] stringArray, String[] stringArray2) throws E, IOException {
        if (reader == null) {
            throw new NullPointerException("Null character stream");
        }
        ReaderMultiCommentParser readerMultiCommentParser = new ReaderMultiCommentParser(reader, stringArray, stringArray2);
        readerMultiCommentParser.parse();
    }

    private abstract class AbstractReaderParser
    extends AbstractSequenceParser {
        Reader reader;
        StringBuilder buffer;

        AbstractReaderParser(Reader reader, int n) {
            this.reader = reader;
            this.buffer = new StringBuilder(n);
        }

        @Override
        protected void checkResourceUsage() {
            if (this.rootIndex > TokenProducer3.this.characterIndexLimit) {
                throw new SecurityException("Exceeded maximum allowed stream size: " + TokenProducer3.this.characterIndexLimit);
            }
        }

        @Override
        public CharSequence currentSequence() {
            return this.buffer;
        }

        @Override
        public void resetCurrentSequence() {
            this.buffer.setLength(0);
        }

        @Override
        protected int nextCodepoint() throws IOException {
            int n = this.reader.read();
            this.rootIndex += Character.charCount(n);
            return n;
        }

        @Override
        protected CharSequence quotedSequence(int n) throws Exception, IOException {
            int n2;
            boolean bl = false;
            boolean bl2 = false;
            int n3 = this.rootIndex;
            int n4 = -1;
            while ((n2 = this.nextCodepoint()) != -1) {
                this.checkResourceUsage();
                if (n2 == n) {
                    if (n4 != 92) {
                        if (!bl) {
                            return this.buffer;
                        }
                        TokenProducer3.this.handler.quotedWithControl(this.rootIndex, this.buffer, n);
                        return null;
                    }
                    ++n3;
                    this.buffer.appendCodePoint(n);
                } else if (Character.isISOControl(n2)) {
                    if (n2 == 10 || n2 == 12 || n2 == 13) {
                        if (n4 != 92) {
                            if (n2 != 10 || !bl2) {
                                TokenProducer3.this.errorHandler.error(this.rootIndex, (byte)1, this.buffer);
                                this.handleControl(n2);
                                String string = !TokenProducer3.this.acceptNewlineEndingQuote ? null : this.buffer.toString();
                                this.buffer.setLength(0);
                                return string;
                            }
                        } else {
                            this.buffer.setLength(this.buffer.length() - 1);
                            TokenProducer3.this.controlHandler.quotedNewlineChar(n3, n2);
                        }
                        if (!bl2) {
                            this.buffer.append('\n');
                        }
                        bl2 = n2 == 13;
                        n4 = n2;
                        continue;
                    }
                    this.buffer.appendCodePoint(n2);
                    ++n3;
                    bl = true;
                } else {
                    this.buffer.appendCodePoint(n2);
                    if (n2 == 92 && n4 == 92) {
                        n2 = 65;
                    }
                    ++n3;
                }
                n4 = n2;
                bl2 = false;
            }
            if (TokenProducer3.this.acceptEofEndingQuoted) {
                if (!bl) {
                    return this.buffer;
                }
                TokenProducer3.this.handler.quotedWithControl(this.rootIndex, this.buffer, n);
            } else {
                this.error(this.rootIndex, (byte)1);
            }
            return null;
        }

        @Override
        protected void word() throws Exception {
            super.word();
            this.buffer.setLength(0);
        }

        @Override
        protected void quoted(int n) throws Exception, IOException {
            super.quoted(n);
            this.buffer.setLength(0);
        }

        @Override
        protected void error(int n, byte by) throws Exception {
            TokenProducer3.this.errorHandler.error(n, by, this.buffer);
        }
    }

    abstract class AbstractSequenceParser
    implements SequenceParser<E> {
        int prevtype = 12;
        int rootIndex = 0;
        int previdx = 0;
        int prevlinelength = -1;
        int line = 1;
        private boolean foundCp13andNotYet10or12 = false;
        boolean externalControlHandling = true;
        io.sf.carte.uparser.TokenProducer3$AbstractSequenceParser.CommentManager commentManager;

        AbstractSequenceParser() {
        }

        int processCodePoint(int n, boolean bl) throws Exception, IOException {
            int n2;
            this.checkResourceUsage();
            if (!bl && (n2 = this.commentManager.verifyComment(n)) != 1) {
                return n2;
            }
            n2 = Character.getType(n);
            block0 : switch (n2) {
                case 12: 
                case 13: 
                case 14: {
                    if (TokenProducer3.this.handleAllSeparators || this.prevtype != 12) {
                        this.checkPreviousWord();
                        TokenProducer3.this.handler.separator(this.rootIndex, n);
                        this.prevtype = 12;
                    }
                    this.previdx = this.rootIndex + 1;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 16: 
                case 23: {
                    this.prevtype = 2;
                    break;
                }
                case 15: {
                    this.checkPreviousWord();
                    this.prevtype = 15;
                    this.handleControl(n);
                    this.previdx = this.rootIndex + 1;
                    break;
                }
                case 21: {
                    if (TokenProducer3.this.charCheck.isAllowedCharacter(n, this)) {
                        this.prevtype = 1;
                        break;
                    }
                    this.checkPreviousWord();
                    switch (n) {
                        case 40: {
                            TokenProducer3.this.handler.leftParenthesis(this.rootIndex);
                            this.previdx = this.rootIndex + 1;
                            this.prevtype = 24;
                            break block0;
                        }
                        case 91: {
                            TokenProducer3.this.handler.leftSquareBracket(this.rootIndex);
                            this.previdx = this.rootIndex + 1;
                            this.prevtype = 24;
                            break block0;
                        }
                        case 123: {
                            TokenProducer3.this.handler.leftCurlyBracket(this.rootIndex);
                            this.previdx = this.rootIndex + 1;
                            this.prevtype = 24;
                            break block0;
                        }
                    }
                    TokenProducer3.this.handler.startPunctuation(this.rootIndex, n);
                    this.updatePrev(n);
                    break;
                }
                case 22: {
                    if (TokenProducer3.this.charCheck.isAllowedCharacter(n, this)) {
                        this.prevtype = 1;
                        break;
                    }
                    this.checkPreviousWord();
                    switch (n) {
                        case 41: {
                            TokenProducer3.this.handler.rightParenthesis(this.rootIndex);
                            this.previdx = this.rootIndex + 1;
                            this.prevtype = 24;
                            break block0;
                        }
                        case 93: {
                            TokenProducer3.this.handler.rightSquareBracket(this.rootIndex);
                            this.previdx = this.rootIndex + 1;
                            this.prevtype = 24;
                            break block0;
                        }
                        case 125: {
                            TokenProducer3.this.handler.rightCurlyBracket(this.rootIndex);
                            this.previdx = this.rootIndex + 1;
                            this.prevtype = 24;
                            break block0;
                        }
                    }
                    TokenProducer3.this.handler.endPunctuation(this.rootIndex, n);
                    this.updatePrev(n);
                    break;
                }
                case 24: {
                    if (TokenProducer3.this.charCheck.isAllowedCharacter(n, this)) {
                        this.prevtype = 1;
                        break;
                    }
                    this.checkPreviousWord();
                    if (n == 34 || n == 39) {
                        this.quoted(n);
                    } else if (n == 92) {
                        int n3 = this.nextCodepoint();
                        if (n3 != -1) {
                            TokenProducer3.this.handler.escaped(this.rootIndex, n3);
                        } else {
                            this.error(this.rootIndex - 1, (byte)2);
                        }
                    } else {
                        this.handleCharacter(n);
                    }
                    this.updatePrev(n);
                    break;
                }
                case 19: 
                case 20: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: {
                    if (TokenProducer3.this.charCheck.isAllowedCharacter(n, this)) {
                        this.prevtype = 1;
                        break;
                    }
                    this.checkPreviousWord();
                    this.handleCharacter(n);
                }
                default: {
                    this.updatePrev(n);
                }
            }
            return 1;
        }

        protected void checkResourceUsage() {
        }

        private void updatePrev(int n) {
            this.previdx = this.rootIndex + Character.charCount(n);
            this.prevtype = 24;
        }

        private void checkPreviousWord() throws Exception {
            if (this.isWordPreviousCodepoint()) {
                this.word();
            }
        }

        boolean isWordPreviousCodepoint() throws Exception {
            if (this.prevtype == 2) {
                return true;
            }
            if (this.isPreviousCpWCharacter()) {
                if (this.currentSequence().length() == 1) {
                    TokenProducer3.this.handler.character(this.previdx, Character.codePointAt(this.currentSequence(), 0));
                    this.resetCurrentSequence();
                } else {
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean isPreviousCpWCharacter() {
            return this.prevtype == 1;
        }

        protected void word() throws Exception {
            CharSequence charSequence = this.currentSequence();
            if (charSequence.length() != 1 || !this.isPreviousCpWCharacter()) {
                TokenProducer3.this.handler.word(this.previdx, charSequence);
            } else {
                TokenProducer3.this.handler.character(this.previdx, charSequence.charAt(0));
            }
        }

        private void handleCharacter(int n) throws Exception {
            TokenProducer3.this.handler.character(this.rootIndex, n);
        }

        void handleControl(int n) throws Exception {
            if (this.externalControlHandling) {
                TokenProducer3.this.controlHandler.control(this.rootIndex, n);
                return;
            }
            if (n == 10) {
                TokenProducer3.this.handler.separator(this.rootIndex, 10);
                if (!this.foundCp13andNotYet10or12) {
                    ++this.line;
                    this.prevlinelength = this.rootIndex;
                } else {
                    this.foundCp13andNotYet10or12 = false;
                    if (this.rootIndex - this.prevlinelength == 1) {
                        ++this.prevlinelength;
                    } else {
                        TokenProducer3.this.errorHandler.error(this.rootIndex, (byte)4, "Unexpected codepoint: " + Integer.toHexString(n));
                    }
                }
            } else if (n == 12) {
                TokenProducer3.this.handler.separator(this.rootIndex, 10);
                if (!this.foundCp13andNotYet10or12) {
                    ++this.line;
                } else {
                    this.foundCp13andNotYet10or12 = false;
                    if (this.rootIndex - this.prevlinelength != 1) {
                        ++this.line;
                    }
                }
                this.prevlinelength = this.rootIndex;
            } else if (n == 13) {
                ++this.line;
                this.prevlinelength = this.rootIndex;
                this.foundCp13andNotYet10or12 = true;
            } else if (n == 9) {
                TokenProducer3.this.handler.separator(this.rootIndex, 9);
            } else if (n < 128) {
                TokenProducer3.this.errorHandler.error(this.rootIndex, (byte)4, "Unexpected codepoint: " + Integer.toHexString(n));
            } else {
                TokenProducer3.this.controlHandler.control(this.rootIndex, n);
            }
        }

        protected void quoted(int n) throws Exception, IOException {
            CharSequence charSequence = this.quotedSequence(n);
            if (charSequence != null) {
                TokenProducer3.this.handler.quoted(this.previdx, charSequence, n);
            }
        }

        public void parse() throws Exception, IOException {
            this.commentManager.parse();
        }

        @Override
        public TokenControl getTokenControl() {
            return this.commentManager;
        }

        protected abstract int nextCodepoint() throws IOException;

        protected abstract CharSequence quotedSequence(int var1) throws Exception, IOException;

        protected abstract void error(int var1, byte var2) throws Exception;

        abstract class CommentManager
        implements TokenControl {
            int commentIndex = 0;
            int commentprevtype = 0;

            CommentManager() {
            }

            void parse() throws Exception, IOException {
                TokenProducer3.this.controlHandler.tokenStart(this);
            }

            @Override
            public void setAcceptNewlineEndingQuote(boolean bl) {
                TokenProducer3.this.setAcceptNewlineEndingQuote(bl);
            }

            @Override
            public void setAcceptEofEndingQuoted(boolean bl) {
                TokenProducer3.this.setAcceptEofEndingQuoted(bl);
            }

            @Override
            public void setExternalLocationHandling(boolean bl) {
                AbstractSequenceParser.this.externalControlHandling = bl;
            }

            @Override
            public int skipNextCodepoint() throws IOException {
                return AbstractSequenceParser.this.nextCodepoint();
            }

            @Override
            public ContentHandler<?> getContentHandler() {
                return TokenProducer3.this.handler;
            }

            @Override
            public void setContentHandler(ContentHandler<?> contentHandler) {
                TokenProducer3.this.handler = contentHandler;
            }

            @Override
            public ControlHandler<?> getControlHandler() {
                return TokenProducer3.this.controlHandler;
            }

            @Override
            public void setControlHandler(ControlHandler<?> controlHandler) {
                TokenProducer3.this.controlHandler = controlHandler;
            }

            @Override
            public TokenErrorHandler<?> getErrorHandler() {
                return TokenProducer3.this.errorHandler;
            }

            @Override
            public void setErrorHandler(TokenErrorHandler<?> tokenErrorHandler) {
                TokenProducer3.this.errorHandler = tokenErrorHandler;
            }

            public TokenHandler3<E> getTokenHandler() {
                return (TokenHandler3)TokenProducer3.this.handler;
            }

            @Override
            public void setTokenHandler(TokenHandler3<?> tokenHandler3) {
                TokenHandler3<?> tokenHandler32 = tokenHandler3;
                TokenProducer3.this.handler = tokenHandler32;
                TokenProducer3.this.controlHandler = tokenHandler32;
                TokenProducer3.this.errorHandler = tokenHandler32;
            }

            @Override
            public void setLocationTo(LocatorAccess locatorAccess) {
                locatorAccess.setLocation(AbstractSequenceParser.this.line, AbstractSequenceParser.this.rootIndex - AbstractSequenceParser.this.prevlinelength);
            }

            @Override
            public void setLocationTo(LocatorAccess locatorAccess, int n) {
                locatorAccess.setLocation(AbstractSequenceParser.this.line, n - AbstractSequenceParser.this.prevlinelength);
            }

            int verifyComment(int n) throws Exception, IOException {
                if (this.matchesExpectedOpening(n)) {
                    if (this.commentIndex == 0) {
                        this.commentprevtype = AbstractSequenceParser.this.prevtype;
                    }
                    ++this.commentIndex;
                    if (this.commentIndex == this.expectedOpeningLength()) {
                        AbstractSequenceParser.this.prevtype = this.commentprevtype;
                        if (AbstractSequenceParser.this.isWordPreviousCodepoint()) {
                            this.wordPrecedingComment();
                        }
                        int n2 = this.expectedOpeningLength();
                        this.commentIndex = 0;
                        ++AbstractSequenceParser.this.rootIndex;
                        AbstractSequenceParser.this.previdx = AbstractSequenceParser.this.rootIndex--;
                        String string = this.commentedSequence();
                        TokenProducer3.this.handler.commented(AbstractSequenceParser.this.previdx - n2, this.getLastCommentClass(), string);
                        AbstractSequenceParser.this.resetCurrentSequence();
                        AbstractSequenceParser.this.prevtype = -1;
                        return 2;
                    }
                    return 0;
                }
                if (this.commentIndex != 0) {
                    this.commentIndex = 0;
                    this.commentprevtype = 0;
                    return this.matchesExpectedOpening(n) ? -2 : -1;
                }
                return 1;
            }

            void wordPrecedingComment() throws Exception {
                AbstractSequenceParser.this.word();
            }

            abstract boolean matchesExpectedOpening(int var1);

            abstract int expectedOpeningLength();

            abstract int closingLength();

            abstract int getLastCommentClass();

            abstract String commentedSequence() throws Exception, IOException;
        }

        /*
         * Signature claims super is io.sf.carte.uparser.TokenProducer3$AbstractSequenceParser.CommentManager, not io.sf.carte.uparser.TokenProducer3$AbstractSequenceParser$CommentManager - discarding signature.
         */
        abstract class MultiCommentManager
        extends CommentManager {
            private int delimcount = 0;
            private int[][] commentStart;
            private int[][] commentEnd;
            private boolean[] disabledComments;
            private int commentClass = -1;

            MultiCommentManager(String[] stringArray, String[] stringArray2) {
                if (stringArray == null || stringArray2 == null) {
                    throw new NullPointerException("Null comment token arrays.");
                }
                this.setCommentDelimiters(stringArray, stringArray2);
            }

            @Override
            boolean matchesExpectedOpening(int n) {
                if (this.isBeginningOfOpening()) {
                    for (int i = 0; i < this.delimcount; ++i) {
                        if (this.commentStart[i][0] != n || this.disabledComments[i]) continue;
                        this.commentClass = i;
                        return true;
                    }
                    return false;
                }
                if (this.commentStart[this.commentClass][this.commentIndex] == n && !this.disabledComments[this.commentClass]) {
                    return true;
                }
                block1: for (int i = this.commentClass + 1; i < this.delimcount; ++i) {
                    int n2 = this.commentStart[i].length;
                    if (this.commentIndex >= n2 || this.commentStart[i][this.commentIndex] != n || this.disabledComments[i]) continue;
                    for (int j = this.commentIndex - 1; j != -1; --j) {
                        if (this.commentStart[i][j] != n) continue block1;
                    }
                    this.commentClass = i;
                    return true;
                }
                return false;
            }

            @Override
            int expectedOpeningLength() {
                return this.commentIndex == 0 ? -1 : this.commentStart[this.commentClass].length;
            }

            boolean isBeginningOfOpening() {
                return this.commentIndex == 0;
            }

            @Override
            int getLastCommentClass() {
                return this.commentClass;
            }

            int getMaxOpeningLength() {
                int n = this.commentStart[0].length;
                for (int i = 1; i < this.delimcount; ++i) {
                    int n2 = this.commentStart[i].length;
                    if (n2 <= n) continue;
                    n = n2;
                }
                return n;
            }

            @Override
            int closingLength() {
                return this.commentEnd[this.commentClass].length;
            }

            boolean closingEndsWithLF() {
                return this.closingEndsWith(13);
            }

            boolean closingEndsWith(int n) {
                return this.closingCodepointAt(this.closingLength() - 1) == n;
            }

            int closingCodepointAt(int n) {
                return this.commentEnd[this.commentClass][n];
            }

            private void setCommentDelimiters(String[] stringArray, String[] stringArray2) {
                this.delimcount = stringArray.length;
                if (this.delimcount != stringArray2.length) {
                    throw new IllegalArgumentException("Unmatched begin/end comment delimiters");
                }
                this.disabledComments = new boolean[this.delimcount];
                int[][] nArrayArray = new int[this.delimcount][];
                int[][] nArrayArray2 = new int[this.delimcount][];
                for (int i = 0; i < this.delimcount; ++i) {
                    int n;
                    int n2;
                    String string = stringArray[i];
                    int n3 = string.length();
                    nArrayArray[i] = new int[n3];
                    for (n2 = 0; n2 < n3; ++n2) {
                        nArrayArray[i][n2] = n = string.codePointAt(n2);
                        if (n != 92) continue;
                        throw new IllegalArgumentException("Not an allowed comment delimiter");
                    }
                    string = stringArray2[i];
                    n3 = string.length();
                    nArrayArray2[i] = new int[n3];
                    for (n2 = 0; n2 < n3; ++n2) {
                        nArrayArray2[i][n2] = n = string.codePointAt(n2);
                        if (n != 92) continue;
                        throw new IllegalArgumentException("Not an allowed comment delimiter");
                    }
                }
                this.commentStart = nArrayArray;
                this.commentEnd = nArrayArray2;
            }

            @Override
            public void enableAllComments() {
                Arrays.fill(this.disabledComments, false);
            }

            @Override
            public void disableAllComments() {
                Arrays.fill(this.disabledComments, true);
            }

            @Override
            public void enableComments(int n) {
                this.disabledComments[n] = false;
            }

            @Override
            public void disableComments(int n) {
                this.disabledComments[n] = true;
            }
        }

        /*
         * Signature claims super is io.sf.carte.uparser.TokenProducer3$AbstractSequenceParser.CommentManager, not io.sf.carte.uparser.TokenProducer3$AbstractSequenceParser$CommentManager - discarding signature.
         */
        abstract class NoCommentManager
        extends CommentManager {
            NoCommentManager() {
            }

            @Override
            public void enableAllComments() {
            }

            @Override
            public void disableAllComments() {
            }

            @Override
            public void enableComments(int n) {
            }

            @Override
            public void disableComments(int n) {
            }

            @Override
            boolean matchesExpectedOpening(int n) {
                return false;
            }

            @Override
            int verifyComment(int n) throws IOException {
                return 1;
            }

            @Override
            int expectedOpeningLength() {
                return 0;
            }

            @Override
            int closingLength() {
                return 0;
            }

            @Override
            int getLastCommentClass() {
                return 0;
            }

            @Override
            String commentedSequence() throws IOException {
                return "";
            }
        }

        /*
         * Signature claims super is io.sf.carte.uparser.TokenProducer3$AbstractSequenceParser.CommentManager, not io.sf.carte.uparser.TokenProducer3$AbstractSequenceParser$CommentManager - discarding signature.
         */
        abstract class SingleCommentManager
        extends CommentManager {
            int[] commentStart;
            int[] commentEnd;
            private boolean disabledComments = false;

            SingleCommentManager(String string, String string2) {
                this.setCommentDelimiters(string, string2);
            }

            @Override
            boolean matchesExpectedOpening(int n) {
                return this.commentStart[this.commentIndex] == n && !this.disabledComments;
            }

            @Override
            int expectedOpeningLength() {
                return this.commentStart.length;
            }

            @Override
            int getLastCommentClass() {
                return 0;
            }

            @Override
            int closingLength() {
                return this.commentEnd.length;
            }

            boolean closingEndsWithLF() {
                return this.closingEndsWith(13);
            }

            boolean closingEndsWith(int n) {
                return this.closingCodepointAt(this.closingLength() - 1) == n;
            }

            int closingCodepointAt(int n) {
                return this.commentEnd[n];
            }

            private void setCommentDelimiters(String string, String string2) {
                int n;
                int n2 = string.length();
                int n3 = string2.length();
                int[] nArray = new int[n2];
                int[] nArray2 = new int[n3];
                for (n = 0; n < n2; ++n) {
                    nArray[n] = string.codePointAt(n);
                    if (nArray[n] != 92) continue;
                    throw new IllegalArgumentException("Not an allowed comment delimiter");
                }
                for (n = 0; n < n3; ++n) {
                    nArray2[n] = string2.codePointAt(n);
                    if (nArray2[n] != 92) continue;
                    throw new IllegalArgumentException("Not an allowed comment delimiter");
                }
                this.commentStart = nArray;
                this.commentEnd = nArray2;
            }

            @Override
            public void enableAllComments() {
                this.disabledComments = false;
            }

            @Override
            public void disableAllComments() {
                this.disabledComments = true;
            }

            @Override
            public void enableComments(int n) {
                if (n == 0) {
                    this.disabledComments = false;
                }
            }

            @Override
            public void disableComments(int n) {
                if (n == 0) {
                    this.disabledComments = true;
                }
            }
        }
    }

    public static interface CharacterCheck {
        public boolean isAllowedCharacter(int var1, SequenceParser<? extends Exception> var2);
    }

    static class DisallowCharacterCheck
    implements CharacterCheck {
        DisallowCharacterCheck() {
        }

        @Override
        public boolean isAllowedCharacter(int n, SequenceParser<? extends Exception> sequenceParser) {
            return false;
        }
    }

    private class ReaderMultiCommentParser
    extends AbstractReaderParser {
        ReaderMultiCommentParser(Reader reader, String[] stringArray, String[] stringArray2) {
            this(reader, stringArray, stringArray2, 256);
        }

        ReaderMultiCommentParser(Reader reader, String[] stringArray, String[] stringArray2, int n) {
            super(reader, n);
            this.commentManager = new ReaderMultiCommentManager(stringArray, stringArray2);
        }

        /*
         * Signature claims super is io.sf.carte.uparser.TokenProducer3$AbstractSequenceParser.MultiCommentManager, not io.sf.carte.uparser.TokenProducer3$AbstractSequenceParser$MultiCommentManager - discarding signature.
         */
        private class ReaderMultiCommentManager
        extends AbstractSequenceParser.MultiCommentManager {
            ReaderMultiCommentManager(String[] stringArray, String[] stringArray2) {
                super(stringArray, stringArray2);
            }

            @Override
            void parse() throws Exception, IOException {
                int n;
                int n2;
                super.parse();
                int n3 = -1;
                int[] nArray = new int[this.getMaxOpeningLength()];
                ReaderMultiCommentParser.this.rootIndex = 0;
                int n4 = 0;
                while ((n4 = ReaderMultiCommentParser.this.reader.read()) != -1) {
                    int n5;
                    if (n3 == -2) {
                        n3 = -1;
                        if (n4 == 10) continue;
                    }
                    if ((n2 = ReaderMultiCommentParser.this.processCodePoint(n4, false)) == 0) {
                        nArray[++n3] = n4;
                    } else if (n2 == 2) {
                        n3 = this.closingEndsWithLF() ? -2 : -1;
                    } else if (n2 == -1) {
                        ReaderMultiCommentParser.this.rootIndex -= n3 + 1;
                        for (n = 0; n <= n3; ++n) {
                            n5 = nArray[n];
                            ReaderMultiCommentParser.this.processCodePoint(n5, true);
                            ++ReaderMultiCommentParser.this.rootIndex;
                            if (ReaderMultiCommentParser.this.prevtype != 2 && ReaderMultiCommentParser.this.prevtype != 1) continue;
                            ReaderMultiCommentParser.this.buffer.appendCodePoint(n5);
                        }
                        ReaderMultiCommentParser.this.processCodePoint(n4, true);
                        n3 = -1;
                        if (ReaderMultiCommentParser.this.prevtype == 2 || ReaderMultiCommentParser.this.prevtype == 1) {
                            ReaderMultiCommentParser.this.buffer.appendCodePoint(n4);
                        }
                    } else if (n2 == -2) {
                        ReaderMultiCommentParser.this.rootIndex -= n3 + 1;
                        for (n = 0; n <= n3; ++n) {
                            n5 = nArray[n];
                            ReaderMultiCommentParser.this.processCodePoint(n5, true);
                            ++ReaderMultiCommentParser.this.rootIndex;
                            if (ReaderMultiCommentParser.this.prevtype != 2 && ReaderMultiCommentParser.this.prevtype != 1) continue;
                            ReaderMultiCommentParser.this.buffer.appendCodePoint(n5);
                        }
                        n3 = -1;
                        if (ReaderMultiCommentParser.this.processCodePoint(n4, false) != -2) {
                            n3 = 0;
                            nArray[0] = n4;
                        }
                    } else if (ReaderMultiCommentParser.this.prevtype == 2 || ReaderMultiCommentParser.this.prevtype == 1) {
                        ReaderMultiCommentParser.this.buffer.appendCodePoint(n4);
                    }
                    ReaderMultiCommentParser.this.rootIndex += Character.charCount(n4);
                }
                n2 = ReaderMultiCommentParser.this.currentSequence().length();
                if (n2 != 0) {
                    if (n2 != 1 || !ReaderMultiCommentParser.this.isPreviousCpWCharacter()) {
                        TokenProducer3.this.handler.word(ReaderMultiCommentParser.this.previdx, ReaderMultiCommentParser.this.currentSequence());
                    } else {
                        TokenProducer3.this.handler.character(ReaderMultiCommentParser.this.previdx, ReaderMultiCommentParser.this.currentSequence().charAt(0));
                    }
                }
                if (n3 != -1) {
                    ReaderMultiCommentParser.this.previdx = ReaderMultiCommentParser.this.rootIndex - n3 - 1;
                    for (n = 0; n <= n3; ++n) {
                        TokenProducer3.this.handler.character(ReaderMultiCommentParser.this.previdx + n, nArray[n]);
                    }
                }
                TokenProducer3.this.handler.endOfStream(ReaderMultiCommentParser.this.rootIndex);
            }

            @Override
            protected String commentedSequence() throws Exception, IOException {
                int n;
                boolean bl = false;
                int n2 = 0;
                while ((n = ReaderMultiCommentParser.this.nextCodepoint()) != -1) {
                    ReaderMultiCommentParser.this.checkResourceUsage();
                    boolean bl2 = n == 10 || n == 12 || n == 13;
                    if (bl2) {
                        if (ReaderMultiCommentParser.this.externalControlHandling && (n != 10 || !bl)) {
                            TokenProducer3.this.controlHandler.control(ReaderMultiCommentParser.this.rootIndex - 1, n);
                        }
                        boolean bl3 = bl = n == 13;
                        if (bl2) {
                            ++ReaderMultiCommentParser.this.line;
                            ReaderMultiCommentParser.this.prevlinelength = ReaderMultiCommentParser.this.rootIndex - 1;
                        }
                    } else {
                        bl = false;
                    }
                    if (this.closingCodepointAt(n2) == n) {
                        if (++n2 != this.closingLength()) continue;
                        return ReaderMultiCommentParser.this.buffer.toString();
                    }
                    if (n2 != 0) {
                        if ((n2 = this.commentEndIndex(n2, n)) != 0) continue;
                        ReaderMultiCommentParser.this.buffer.appendCodePoint(n);
                        continue;
                    }
                    ReaderMultiCommentParser.this.buffer.appendCodePoint(n);
                }
                if (!this.closingEndsWith(10)) {
                    ReaderMultiCommentParser.this.error(ReaderMultiCommentParser.this.rootIndex, (byte)3);
                }
                return ReaderMultiCommentParser.this.buffer.toString();
            }

            private int commentEndIndex(int n, int n2) {
                int n3 = n - 1;
                if (this.closingCodepointAt(n3) != n2 || !this.repeatedEndCp(n3)) {
                    for (int i = 0; i < n; ++i) {
                        ReaderMultiCommentParser.this.buffer.appendCodePoint(this.closingCodepointAt(i));
                    }
                    n = 0;
                } else {
                    ReaderMultiCommentParser.this.buffer.appendCodePoint(this.closingCodepointAt(0));
                }
                return n;
            }

            private boolean repeatedEndCp(int n) {
                for (int i = n; i > 0; --i) {
                    if (this.closingCodepointAt(i) == this.closingCodepointAt(i - 1)) continue;
                    return false;
                }
                return true;
            }
        }
    }

    private class ReaderParser
    extends AbstractReaderParser {
        ReaderParser(Reader reader) {
            this(reader, 256);
        }

        ReaderParser(Reader reader, int n) {
            super(reader, n);
            this.commentManager = new ReaderNoCommentManager();
        }

        ReaderParser(Reader reader, String string, String string2) {
            this(reader, 256, string, string2);
        }

        ReaderParser(Reader reader, int n, String string, String string2) {
            super(reader, n);
            this.commentManager = new ReaderSingleCommentManager(string, string2);
        }

        /*
         * Signature claims super is io.sf.carte.uparser.TokenProducer3$AbstractSequenceParser.NoCommentManager, not io.sf.carte.uparser.TokenProducer3$AbstractSequenceParser$NoCommentManager - discarding signature.
         */
        private class ReaderNoCommentManager
        extends AbstractSequenceParser.NoCommentManager {
            private ReaderNoCommentManager() {
            }

            @Override
            void parse() throws Exception, IOException {
                super.parse();
                ReaderParser.this.rootIndex = 0;
                int n = 0;
                while ((n = ReaderParser.this.reader.read()) != -1) {
                    ReaderParser.this.processCodePoint(n, true);
                    if (ReaderParser.this.prevtype == 2 || ReaderParser.this.prevtype == 1) {
                        ReaderParser.this.buffer.appendCodePoint(n);
                    }
                    ReaderParser.this.rootIndex += Character.charCount(n);
                }
                int n2 = ReaderParser.this.currentSequence().length();
                if (n2 != 0) {
                    if (n2 != 1 || !ReaderParser.this.isPreviousCpWCharacter()) {
                        TokenProducer3.this.handler.word(ReaderParser.this.previdx, ReaderParser.this.currentSequence());
                    } else {
                        TokenProducer3.this.handler.character(ReaderParser.this.previdx, ReaderParser.this.currentSequence().charAt(0));
                    }
                }
                TokenProducer3.this.handler.endOfStream(ReaderParser.this.rootIndex);
            }
        }

        /*
         * Signature claims super is io.sf.carte.uparser.TokenProducer3$AbstractSequenceParser.SingleCommentManager, not io.sf.carte.uparser.TokenProducer3$AbstractSequenceParser$SingleCommentManager - discarding signature.
         */
        private class ReaderSingleCommentManager
        extends AbstractSequenceParser.SingleCommentManager {
            ReaderSingleCommentManager(String string, String string2) {
                super(string, string2);
            }

            @Override
            void parse() throws Exception, IOException {
                int n;
                int n2;
                super.parse();
                int n3 = -1;
                int[] nArray = new int[this.commentStart.length];
                ReaderParser.this.rootIndex = 0;
                int n4 = 0;
                while ((n4 = ReaderParser.this.reader.read()) != -1) {
                    int n5;
                    if (n3 == -2) {
                        n3 = -1;
                        if (n4 == 10) continue;
                    }
                    if ((n2 = ReaderParser.this.processCodePoint(n4, false)) == 0) {
                        nArray[++n3] = n4;
                    } else if (n2 == 2) {
                        n3 = this.commentEnd[this.commentEnd.length - 1] == 13 ? -2 : -1;
                    } else if (n2 == -1) {
                        for (n = 0; n <= n3; ++n) {
                            n5 = nArray[n];
                            ReaderParser.this.processCodePoint(n5, true);
                            if (ReaderParser.this.prevtype != 2 && ReaderParser.this.prevtype != 1) continue;
                            ReaderParser.this.buffer.appendCodePoint(n5);
                        }
                        ReaderParser.this.processCodePoint(n4, true);
                        n3 = -1;
                        if (ReaderParser.this.prevtype == 2 || ReaderParser.this.prevtype == 1) {
                            ReaderParser.this.buffer.appendCodePoint(n4);
                        }
                    } else if (n2 == -2) {
                        for (n = 0; n <= n3; ++n) {
                            n5 = nArray[n];
                            ReaderParser.this.processCodePoint(n5, true);
                            if (ReaderParser.this.prevtype != 2 && ReaderParser.this.prevtype != 1) continue;
                            ReaderParser.this.buffer.appendCodePoint(n5);
                        }
                        n3 = -1;
                        if (ReaderParser.this.processCodePoint(n4, false) != -2) {
                            n3 = 0;
                            nArray[0] = n4;
                        }
                    } else if (ReaderParser.this.prevtype == 2 || ReaderParser.this.prevtype == 1) {
                        ReaderParser.this.buffer.appendCodePoint(n4);
                    }
                    ReaderParser.this.rootIndex += Character.charCount(n4);
                }
                n2 = ReaderParser.this.currentSequence().length();
                if (n2 != 0) {
                    if (n2 != 1 || !ReaderParser.this.isPreviousCpWCharacter()) {
                        TokenProducer3.this.handler.word(ReaderParser.this.previdx, ReaderParser.this.currentSequence());
                    } else {
                        TokenProducer3.this.handler.character(ReaderParser.this.previdx, ReaderParser.this.currentSequence().charAt(0));
                    }
                }
                if (n3 != -1) {
                    ReaderParser.this.previdx = ReaderParser.this.rootIndex - n3 - 1;
                    for (n = 0; n <= n3; ++n) {
                        TokenProducer3.this.handler.character(ReaderParser.this.previdx + n, nArray[n]);
                    }
                }
                TokenProducer3.this.handler.endOfStream(ReaderParser.this.rootIndex);
            }

            @Override
            protected String commentedSequence() throws Exception, IOException {
                int n;
                boolean bl = false;
                int n2 = 0;
                while ((n = ReaderParser.this.nextCodepoint()) != -1) {
                    ReaderParser.this.checkResourceUsage();
                    boolean bl2 = n == 10 || n == 12 || n == 13;
                    if (bl2) {
                        if (ReaderParser.this.externalControlHandling && (n != 10 || !bl)) {
                            TokenProducer3.this.controlHandler.control(ReaderParser.this.rootIndex - 1, n);
                        }
                        boolean bl3 = bl = n == 13;
                        if (bl2) {
                            ++ReaderParser.this.line;
                            ReaderParser.this.prevlinelength = ReaderParser.this.rootIndex - 1;
                        }
                    } else {
                        bl = false;
                    }
                    if (this.commentEnd[n2] == n) {
                        if (++n2 != this.commentEnd.length) continue;
                        return ReaderParser.this.buffer.toString();
                    }
                    if (n2 != 0) {
                        if ((n2 = this.commentEndIndex(n2, n)) != 0) continue;
                        ReaderParser.this.buffer.appendCodePoint(n);
                        continue;
                    }
                    ReaderParser.this.buffer.appendCodePoint(n);
                }
                if (!this.closingEndsWith(10)) {
                    ReaderParser.this.error(ReaderParser.this.rootIndex, (byte)3);
                }
                return ReaderParser.this.buffer.toString();
            }

            private int commentEndIndex(int n, int n2) {
                int n3 = n - 1;
                if (this.commentEnd[n3] != n2 || !this.repeatedEndCp(n3)) {
                    for (int i = 0; i < n; ++i) {
                        ReaderParser.this.buffer.appendCodePoint(this.commentEnd[i]);
                    }
                    n = 0;
                } else {
                    ReaderParser.this.buffer.appendCodePoint(this.commentEnd[0]);
                }
                return n;
            }

            private boolean repeatedEndCp(int n) {
                for (int i = n; i > 0; --i) {
                    if (this.commentEnd[i] == this.commentEnd[i - 1]) continue;
                    return false;
                }
                return true;
            }
        }
    }

    public static interface SequenceParser<E extends Exception> {
        public CharSequence currentSequence();

        public boolean isPreviousCpWCharacter();

        public TokenControl getTokenControl();

        public void resetCurrentSequence();
    }

    private class StringParser
    extends AbstractSequenceParser {
        private final String string;
        private final int len;

        StringParser(String string) {
            this.commentManager = new StringNoCommentManager();
            this.string = string;
            this.len = string.length();
        }

        StringParser(String string, String string2, String string3) {
            this.commentManager = new StringSingleCommentManager(string2, string3);
            this.string = string;
            this.len = string.length();
        }

        @Override
        public CharSequence currentSequence() {
            return this.string.subSequence(this.previdx, this.rootIndex);
        }

        @Override
        public void resetCurrentSequence() {
            this.previdx = this.rootIndex;
        }

        @Override
        protected int nextCodepoint() throws IOException {
            if (this.rootIndex < this.len - 1) {
                this.rootIndex = this.string.offsetByCodePoints(this.rootIndex, 1);
                return this.string.codePointAt(this.rootIndex);
            }
            return -1;
        }

        @Override
        protected CharSequence quotedSequence(int n) throws Exception {
            boolean bl = false;
            boolean bl2 = false;
            int n2 = this.rootIndex + 1;
            int n3 = -1;
            StringBuilder stringBuilder = new StringBuilder(this.len - n2);
            for (int i = n2; i < this.len; ++i) {
                int n4 = this.string.codePointAt(i);
                if (n4 == n) {
                    if (n3 != 92) {
                        if (bl) {
                            TokenProducer3.this.handler.quotedWithControl(this.rootIndex, stringBuilder, n);
                            stringBuilder = null;
                        }
                        this.rootIndex = i;
                        return stringBuilder;
                    }
                    stringBuilder.appendCodePoint(n);
                } else if (Character.isISOControl(n4)) {
                    if (n4 == 10 || n4 == 12 || n4 == 13) {
                        if (n3 != 92) {
                            if (n4 != 10 || !bl2) {
                                TokenProducer3.this.errorHandler.error(i, (byte)1, stringBuilder);
                                this.rootIndex = i;
                                this.handleControl(n4);
                                if (!TokenProducer3.this.acceptNewlineEndingQuote) {
                                    return null;
                                }
                                return stringBuilder;
                            }
                        } else {
                            stringBuilder.setLength(stringBuilder.length() - 1);
                            TokenProducer3.this.controlHandler.quotedNewlineChar(i, n4);
                        }
                        if (!bl2) {
                            stringBuilder.append('\n');
                        }
                        bl2 = n4 == 13;
                        n3 = n4;
                        continue;
                    }
                    stringBuilder.appendCodePoint(n4);
                    bl = true;
                } else {
                    stringBuilder.appendCodePoint(n4);
                    if (n4 == 92 && n3 == 92) {
                        n4 = 65;
                    }
                }
                n3 = n4;
                bl2 = false;
            }
            this.rootIndex = this.len;
            if (TokenProducer3.this.acceptEofEndingQuoted) {
                if (!bl) {
                    return stringBuilder;
                }
                TokenProducer3.this.handler.quotedWithControl(this.rootIndex, stringBuilder, n);
            } else {
                this.error(n2, (byte)1);
            }
            return null;
        }

        @Override
        protected void error(int n, byte by) throws Exception {
            int n2;
            int n3 = n - 16;
            if (n3 < 0) {
                n3 = 0;
            }
            if ((n2 = n + 16) > this.string.length()) {
                n2 = this.string.length();
            }
            TokenProducer3.this.errorHandler.error(n, by, this.string.substring(n3, n2));
        }

        /*
         * Signature claims super is io.sf.carte.uparser.TokenProducer3$AbstractSequenceParser.NoCommentManager, not io.sf.carte.uparser.TokenProducer3$AbstractSequenceParser$NoCommentManager - discarding signature.
         */
        class StringNoCommentManager
        extends AbstractSequenceParser.NoCommentManager {
            StringNoCommentManager() {
            }

            @Override
            void parse() throws IOException, Exception {
                super.parse();
                StringParser.this.rootIndex = 0;
                while (StringParser.this.rootIndex < StringParser.this.len) {
                    int n = StringParser.this.string.codePointAt(StringParser.this.rootIndex);
                    StringParser.this.processCodePoint(n, true);
                    StringParser.this.rootIndex += Character.charCount(n);
                }
                int n = StringParser.this.len - StringParser.this.previdx;
                if (n > 0) {
                    if (n != 1 || !StringParser.this.isPreviousCpWCharacter()) {
                        TokenProducer3.this.handler.word(StringParser.this.previdx, StringParser.this.currentSequence());
                    } else {
                        TokenProducer3.this.handler.character(StringParser.this.previdx, StringParser.this.string.charAt(StringParser.this.previdx));
                    }
                }
                TokenProducer3.this.handler.endOfStream(StringParser.this.len);
            }
        }

        /*
         * Signature claims super is io.sf.carte.uparser.TokenProducer3$AbstractSequenceParser.SingleCommentManager, not io.sf.carte.uparser.TokenProducer3$AbstractSequenceParser$SingleCommentManager - discarding signature.
         */
        class StringSingleCommentManager
        extends AbstractSequenceParser.SingleCommentManager {
            StringSingleCommentManager(String string, String string2) {
                super(string, string2);
            }

            @Override
            void parse() throws Exception, IOException {
                int n;
                int n2;
                super.parse();
                int n3 = -1;
                int[] nArray = new int[this.commentStart.length];
                StringParser.this.rootIndex = 0;
                while (StringParser.this.rootIndex < StringParser.this.len) {
                    int n4;
                    block21: {
                        block20: {
                            n4 = StringParser.this.string.codePointAt(StringParser.this.rootIndex);
                            if (n3 != -2) break block20;
                            n3 = -1;
                            if (n4 == 10) break block21;
                        }
                        if ((n2 = StringParser.this.processCodePoint(n4, false)) == 0) {
                            nArray[++n3] = n4;
                        } else if (n2 == 2) {
                            n3 = this.commentEnd[this.commentEnd.length - 1] == 13 ? -2 : -1;
                        } else if (n2 == -1) {
                            StringParser.this.rootIndex = StringParser.this.rootIndex - n3 - 1;
                            for (n = 0; n <= n3; ++n) {
                                StringParser.this.processCodePoint(nArray[n], true);
                                ++StringParser.this.rootIndex;
                            }
                            StringParser.this.processCodePoint(n4, true);
                            n3 = -1;
                        } else if (n2 == -2) {
                            StringParser.this.rootIndex = StringParser.this.rootIndex - n3 - 1;
                            for (n = 0; n <= n3; ++n) {
                                StringParser.this.processCodePoint(nArray[n], true);
                                ++StringParser.this.rootIndex;
                            }
                            n3 = -1;
                            if (StringParser.this.processCodePoint(n4, false) != -2) {
                                n3 = 0;
                                nArray[0] = n4;
                            }
                        }
                    }
                    StringParser.this.rootIndex += Character.charCount(n4);
                }
                n2 = StringParser.this.len - StringParser.this.previdx;
                if (n3 != -1) {
                    StringParser.this.rootIndex -= n3 + 1;
                    n2 -= n3 + 1;
                }
                if (n2 > 0) {
                    if (n2 != 1 || !StringParser.this.isPreviousCpWCharacter()) {
                        TokenProducer3.this.handler.word(StringParser.this.previdx, StringParser.this.currentSequence());
                        StringParser.this.previdx = StringParser.this.rootIndex;
                    } else {
                        TokenProducer3.this.handler.character(StringParser.this.previdx, StringParser.this.string.charAt(StringParser.this.previdx));
                        ++StringParser.this.previdx;
                    }
                }
                if (n3 != -1) {
                    for (n = 0; n <= n3; ++n) {
                        TokenProducer3.this.handler.character(StringParser.this.previdx + n, nArray[n]);
                    }
                }
                TokenProducer3.this.handler.endOfStream(StringParser.this.len);
            }

            @Override
            protected String commentedSequence() throws Exception, IOException {
                boolean bl = false;
                int n = 0;
                StringBuilder stringBuilder = new StringBuilder(StringParser.this.len - StringParser.this.rootIndex);
                for (int i = StringParser.this.rootIndex; i < StringParser.this.len; ++i) {
                    int n2 = StringParser.this.string.codePointAt(i);
                    if (n2 == 10 || n2 == 12 || n2 == 13) {
                        if (StringParser.this.externalControlHandling && (n2 != 10 || !bl)) {
                            TokenProducer3.this.controlHandler.control(i, n2);
                        }
                        bl = n2 == 13;
                    } else {
                        bl = false;
                    }
                    if (this.commentEnd[n] == n2) {
                        if (++n != this.commentEnd.length) continue;
                        StringParser.this.rootIndex = i + 1;
                        return stringBuilder.toString();
                    }
                    if (n != 0) {
                        for (int j = 0; j <= n; ++j) {
                            stringBuilder.append(this.commentEnd[j]);
                        }
                        n = 0;
                    }
                    stringBuilder.appendCodePoint(n2);
                }
                StringParser.this.rootIndex = StringParser.this.len;
                if (!this.closingEndsWith(10)) {
                    StringParser.this.error(StringParser.this.rootIndex, (byte)3);
                }
                return stringBuilder.toString();
            }

            @Override
            void wordPrecedingComment() throws Exception {
                int n = StringParser.this.rootIndex - this.commentIndex + 1;
                if (n - StringParser.this.previdx != 1 || !StringParser.this.isPreviousCpWCharacter()) {
                    TokenProducer3.this.handler.word(StringParser.this.previdx, StringParser.this.string.subSequence(StringParser.this.previdx, n));
                } else {
                    TokenProducer3.this.handler.character(StringParser.this.previdx, StringParser.this.string.charAt(StringParser.this.previdx));
                }
            }
        }
    }
}

