/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSColor;
import io.sf.carte.doc.style.css.CSSColorValue;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.LCHColor;
import io.sf.carte.doc.style.css.RGBAColor;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.property.BaseColor;
import io.sf.carte.doc.style.css.property.ColorUtil;
import io.sf.carte.doc.style.css.property.ColorValue;
import io.sf.carte.doc.style.css.property.LABColorValue;
import io.sf.carte.doc.style.css.property.LCHColorImpl;
import io.sf.carte.doc.style.css.property.LCHColorValue;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.RGBColor;
import io.sf.carte.doc.style.css.property.SRGBColorProfile;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.doc.style.css.property.XYZColorImpl;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import org.w3c.dom.DOMException;

class OKLCHColorValue
extends ColorValue
implements io.sf.carte.doc.style.css.LCHColorValue {
    private static final long serialVersionUID = 1L;
    private final LCHColorImpl lchColor;

    public OKLCHColorValue() {
        this(new LCHColorImpl(BaseColor.Space.OK_LCh, "oklch"));
    }

    OKLCHColorValue(LCHColorImpl lCHColorImpl) {
        this.lchColor = lCHColorImpl;
    }

    OKLCHColorValue(OKLCHColorValue oKLCHColorValue) {
        super(oKLCHColorValue);
        this.lchColor = oKLCHColorValue.lchColor.clone();
    }

    @Override
    public CSSColorValue.ColorModel getColorModel() {
        return CSSColorValue.ColorModel.LCH;
    }

    @Override
    void set(StyleValue styleValue) {
        super.set(styleValue);
        OKLCHColorValue oKLCHColorValue = (OKLCHColorValue)styleValue;
        this.lchColor.set(oKLCHColorValue.lchColor);
    }

    @Override
    public String getCssText() {
        return this.lchColor.toString();
    }

    @Override
    public String getMinifiedCssText(String string) {
        return this.lchColor.toMinifiedString();
    }

    @Override
    public void writeCssText(SimpleWriter simpleWriter) throws IOException {
        this.lchColor.writeCssText(simpleWriter);
    }

    @Override
    public PrimitiveValue getComponent(int n) {
        return this.lchColor.item(n);
    }

    @Override
    public void setComponent(int n, StyleValue styleValue) {
        this.lchColor.setComponent(n, (PrimitiveValue)styleValue);
    }

    @Override
    public RGBAColor toRGBColor() throws DOMException {
        return this.toRGBColor(true);
    }

    @Override
    public RGBAColor toRGBColor(boolean bl) throws DOMException {
        if (!this.lchColor.hasConvertibleComponents()) {
            throw new DOMException(11, "Cannot convert.");
        }
        CSSTypedValue cSSTypedValue = (CSSTypedValue)((Object)this.lchColor.getHue());
        float f = ((CSSTypedValue)((Object)this.lchColor.getChroma())).getFloatValue((short)0);
        double d = ColorUtil.hueRadians(cSSTypedValue);
        double d2 = (double)f * Math.cos(d);
        double d3 = (double)f * Math.sin(d);
        float f2 = ((CSSTypedValue)((Object)this.lchColor.getLightness())).getFloatValue((short)0);
        SRGBColorProfile sRGBColorProfile = new SRGBColorProfile();
        double[] dArray = new double[3];
        ColorUtil.oklabToRGB(f2, d2, d3, bl, sRGBColorProfile, dArray);
        ColorValue.CSSRGBColor cSSRGBColor = new ColorValue.CSSRGBColor();
        cSSRGBColor.setColorComponents(dArray);
        cSSRGBColor.setAlpha(this.lchColor.getAlpha().clone());
        return cSSRGBColor;
    }

    @Override
    public LABColorValue toLABColorValue() throws DOMException {
        float f;
        if (!this.lchColor.hasConvertibleComponents()) {
            throw new DOMException(11, "Cannot convert.");
        }
        float f2 = ((CSSTypedValue)((Object)this.lchColor.getLightness())).getFloatValue((short)0);
        float f3 = ((CSSTypedValue)((Object)this.lchColor.getChroma())).getFloatValue((short)0);
        CSSTypedValue cSSTypedValue = (CSSTypedValue)((Object)this.lchColor.getHue());
        short s = cSSTypedValue.getUnitType();
        if (s == 0) {
            f = cSSTypedValue.getFloatValue((short)0);
            f = NumberValue.floatValueConversion(f, (short)80, (short)81);
        } else {
            f = cSSTypedValue.getFloatValue((short)81);
        }
        double d = (double)f3 * Math.cos(f);
        double d2 = (double)f3 * Math.sin(f);
        double[] dArray = new double[3];
        ColorUtil.oklabToLab(f2, d, d2, dArray);
        NumberValue numberValue = NumberValue.createCSSNumberValue((short)0, (float)dArray[0]);
        NumberValue numberValue2 = NumberValue.createCSSNumberValue((short)0, (float)dArray[1]);
        NumberValue numberValue3 = NumberValue.createCSSNumberValue((short)0, (float)dArray[2]);
        numberValue.setAbsolutizedUnit();
        numberValue2.setAbsolutizedUnit();
        numberValue3.setAbsolutizedUnit();
        LABColorValue lABColorValue = new LABColorValue();
        lABColorValue.setComponent(0, this.lchColor.getAlpha().clone());
        lABColorValue.setComponent(1, numberValue);
        lABColorValue.setComponent(2, numberValue2);
        lABColorValue.setComponent(3, numberValue3);
        return lABColorValue;
    }

    @Override
    public LCHColorValue toLCHColorValue() throws DOMException {
        float f;
        if (!this.lchColor.hasConvertibleComponents()) {
            throw new DOMException(11, "Cannot convert.");
        }
        float f2 = ((CSSTypedValue)((Object)this.lchColor.getLightness())).getFloatValue((short)0);
        float f3 = ((CSSTypedValue)((Object)this.lchColor.getChroma())).getFloatValue((short)0);
        CSSTypedValue cSSTypedValue = (CSSTypedValue)((Object)this.lchColor.getHue());
        short s = cSSTypedValue.getUnitType();
        if (s == 0) {
            f = cSSTypedValue.getFloatValue((short)0);
            f = NumberValue.floatValueConversion(f, (short)80, (short)81);
        } else {
            f = cSSTypedValue.getFloatValue((short)81);
        }
        double d = (double)f3 * Math.cos(f);
        double d2 = (double)f3 * Math.sin(f);
        double[] dArray = new double[3];
        ColorUtil.oklabToLab(f2, d, d2, dArray);
        f3 = (float)Math.sqrt(dArray[1] * dArray[1] + dArray[2] * dArray[2]);
        f = (float)(Math.atan2(dArray[2], dArray[1]) * 180.0 / Math.PI);
        if (f < 0.0f) {
            f += 360.0f;
        }
        NumberValue numberValue = NumberValue.createCSSNumberValue((short)0, (float)dArray[0]);
        NumberValue numberValue2 = NumberValue.createCSSNumberValue((short)0, f3);
        NumberValue numberValue3 = NumberValue.createCSSNumberValue((short)0, f);
        numberValue.setAbsolutizedUnit();
        numberValue2.setAbsolutizedUnit();
        numberValue3.setAbsolutizedUnit();
        LCHColorValue lCHColorValue = new LCHColorValue();
        lCHColorValue.setComponent(0, this.lchColor.getAlpha().clone());
        lCHColorValue.setComponent(1, numberValue);
        lCHColorValue.setComponent(2, numberValue2);
        lCHColorValue.setComponent(3, numberValue3);
        return lCHColorValue;
    }

    @Override
    public LCHColor getColor() {
        return this.lchColor;
    }

    @Override
    boolean hasConvertibleComponents() {
        return this.lchColor.hasConvertibleComponents();
    }

    @Override
    public float deltaE2000(CSSColorValue cSSColorValue) {
        CSSColor cSSColor;
        LCHColor lCHColor;
        if (!this.lchColor.hasConvertibleComponents() || !((ColorValue)cSSColorValue).hasConvertibleComponents()) {
            throw new DOMException(11, "Cannot compute delta.");
        }
        switch (cSSColorValue.getColorModel()) {
            case LCH: {
                lCHColor = (LCHColor)cSSColorValue.getColor();
                if (!"oklch".equals(lCHColor.getColorSpace())) break;
                lCHColor = cSSColorValue.toLCHColorValue().getColor();
                break;
            }
            case LAB: {
                lCHColor = cSSColorValue.toLCHColorValue().getColor();
                break;
            }
            case RGB: {
                cSSColor = (RGBColor)cSSColorValue.getColor();
                LABColorValue lABColorValue = new LABColorValue();
                ((BaseColor)cSSColor).toLABColor(lABColorValue.getLABColorImpl());
                lCHColor = lABColorValue.toLCHColorValue().getColor();
                break;
            }
            case XYZ: {
                XYZColorImpl xYZColorImpl = (XYZColorImpl)cSSColorValue.getColor();
                LABColorValue lABColorValue = new LABColorValue();
                xYZColorImpl.toLABColor(lABColorValue.getLABColorImpl());
                lCHColor = lABColorValue.toLCHColorValue().getColor();
                break;
            }
            default: {
                RGBAColor rGBAColor = cSSColorValue.toRGBColor(false);
                CSSColorValue cSSColorValue2 = rGBAColor.packInValue();
                lCHColor = cSSColorValue2.toLABColorValue().toLCHColorValue().getColor();
            }
        }
        cSSColor = this.toLCHColorValue().getColor();
        return ColorUtil.deltaE2000LCh(((CSSTypedValue)cSSColor.getLightness()).getFloatValue((short)0), ((CSSTypedValue)cSSColor.getChroma()).getFloatValue((short)0), ColorUtil.hueRadians((CSSTypedValue)cSSColor.getHue()), ((CSSTypedValue)lCHColor.getLightness()).getFloatValue((short)0), ((CSSTypedValue)lCHColor.getChroma()).getFloatValue((short)0), ColorUtil.hueRadians((CSSTypedValue)lCHColor.getHue()));
    }

    @Override
    PrimitiveValue.LexicalSetter newLexicalSetter() {
        return new MyLexicalSetter();
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = super.hashCode();
        n2 = 31 * n2 + this.lchColor.hashCode();
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        OKLCHColorValue oKLCHColorValue = (OKLCHColorValue)object;
        return this.lchColor.equals(oKLCHColorValue.lchColor);
    }

    @Override
    public OKLCHColorValue clone() {
        return new OKLCHColorValue(this);
    }

    class MyLexicalSetter
    extends PrimitiveValue.LexicalSetter {
        MyLexicalSetter() {
            super(OKLCHColorValue.this);
        }

        @Override
        void setLexicalUnit(LexicalUnit lexicalUnit) {
            try {
                if (lexicalUnit.getLexicalUnitType() != LexicalUnit.LexicalType.OKLCHCOLOR) {
                    throw new DOMException(13, "No oklch() value: " + lexicalUnit.toString());
                }
                this.setLexicalLCH(lexicalUnit);
            }
            catch (DOMException dOMException) {
                throw dOMException;
            }
            catch (RuntimeException runtimeException) {
                throw new DOMException(12, "Bad value: " + lexicalUnit.toString());
            }
            this.nextLexicalUnit = lexicalUnit.getNextLexicalUnit();
        }

        private void setLexicalLCH(LexicalUnit lexicalUnit) {
            LexicalUnit lexicalUnit2 = lexicalUnit.getParameters();
            ValueFactory valueFactory = new ValueFactory();
            PrimitiveValue primitiveValue = valueFactory.createCSSPrimitiveValue(lexicalUnit2, true);
            lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
            PrimitiveValue primitiveValue2 = valueFactory.createCSSPrimitiveValue(lexicalUnit2, true);
            lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
            PrimitiveValue primitiveValue3 = valueFactory.createCSSPrimitiveValue(lexicalUnit2, true);
            if ((lexicalUnit2 = lexicalUnit2.getNextLexicalUnit()) != null) {
                if (lexicalUnit2.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_SLASH) {
                    throw new DOMException(12, "Expected slash in: " + lexicalUnit.toString());
                }
                lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
                PrimitiveValue primitiveValue4 = valueFactory.createCSSPrimitiveValue(lexicalUnit2, true);
                OKLCHColorValue.this.lchColor.setAlpha(primitiveValue4);
                lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
                if (lexicalUnit2 != null) {
                    throw new DOMException(12, "Bad value: " + lexicalUnit.toString());
                }
            }
            OKLCHColorValue.this.lchColor.setLightness(primitiveValue);
            OKLCHColorValue.this.lchColor.setChroma(primitiveValue2);
            OKLCHColorValue.this.lchColor.setHue(primitiveValue3);
        }
    }
}

