/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.xmlimpl;

import java.io.Serializable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.Ref;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;
import org.mozilla.javascript.xml.XMLLib;
import org.mozilla.javascript.xml.XMLObject;
import org.mozilla.javascript.xmlimpl.Namespace;
import org.mozilla.javascript.xmlimpl.QName;
import org.mozilla.javascript.xmlimpl.XML;
import org.mozilla.javascript.xmlimpl.XMLList;
import org.mozilla.javascript.xmlimpl.XMLName;
import org.mozilla.javascript.xmlimpl.XMLObjectImpl;
import org.mozilla.javascript.xmlimpl.XMLWithScope;
import org.mozilla.javascript.xmlimpl.XmlNode;
import org.mozilla.javascript.xmlimpl.XmlProcessor;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public final class XMLLibImpl
extends XMLLib
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Scriptable globalScope;
    private XML xmlPrototype;
    private XMLList xmlListPrototype;
    private Namespace namespacePrototype;
    private QName qnamePrototype;
    private XmlProcessor options = new XmlProcessor();

    public static Node toDomNode(Object object) {
        if (object instanceof XML) {
            return ((XML)object).toDomNode();
        }
        throw new IllegalArgumentException("xmlObject is not an XML object in JavaScript.");
    }

    public static void init(Context context, Scriptable scriptable, boolean bl) {
        XMLLibImpl xMLLibImpl = new XMLLibImpl(scriptable);
        XMLLib xMLLib = xMLLibImpl.bindToScope(scriptable);
        if (xMLLib == xMLLibImpl) {
            xMLLibImpl.exportToScope(bl);
        }
    }

    @Override
    public void setIgnoreComments(boolean bl) {
        this.options.setIgnoreComments(bl);
    }

    @Override
    public void setIgnoreWhitespace(boolean bl) {
        this.options.setIgnoreWhitespace(bl);
    }

    @Override
    public void setIgnoreProcessingInstructions(boolean bl) {
        this.options.setIgnoreProcessingInstructions(bl);
    }

    @Override
    public void setPrettyPrinting(boolean bl) {
        this.options.setPrettyPrinting(bl);
    }

    @Override
    public void setPrettyIndent(int n) {
        this.options.setPrettyIndent(n);
    }

    @Override
    public boolean isIgnoreComments() {
        return this.options.isIgnoreComments();
    }

    @Override
    public boolean isIgnoreProcessingInstructions() {
        return this.options.isIgnoreProcessingInstructions();
    }

    @Override
    public boolean isIgnoreWhitespace() {
        return this.options.isIgnoreWhitespace();
    }

    @Override
    public boolean isPrettyPrinting() {
        return this.options.isPrettyPrinting();
    }

    @Override
    public int getPrettyIndent() {
        return this.options.getPrettyIndent();
    }

    private XMLLibImpl(Scriptable scriptable) {
        this.globalScope = scriptable;
    }

    @Deprecated
    QName qnamePrototype() {
        return this.qnamePrototype;
    }

    @Deprecated
    Scriptable globalScope() {
        return this.globalScope;
    }

    XmlProcessor getProcessor() {
        return this.options;
    }

    private void exportToScope(boolean bl) {
        this.xmlPrototype = this.newXML(XmlNode.createText(this.options, ""));
        this.xmlListPrototype = this.newXMLList();
        this.namespacePrototype = Namespace.create(this.globalScope, null, XmlNode.Namespace.GLOBAL);
        this.qnamePrototype = QName.create(this, this.globalScope, null, XmlNode.QName.create(XmlNode.Namespace.create(""), ""));
        this.xmlPrototype.exportAsJSClass(bl);
        this.xmlListPrototype.exportAsJSClass(bl);
        this.namespacePrototype.exportAsJSClass(bl);
        this.qnamePrototype.exportAsJSClass(bl);
    }

    @Deprecated
    XMLName toAttributeName(Context context, Object object) {
        if (object instanceof XMLName) {
            return (XMLName)object;
        }
        if (object instanceof QName) {
            return XMLName.create(((QName)object).getDelegate(), true, false);
        }
        if (object instanceof Boolean || object instanceof Number || object == Undefined.instance || object == null) {
            throw XMLLibImpl.badXMLName(object);
        }
        String string = null;
        string = object instanceof String ? (String)object : ScriptRuntime.toString(object);
        if (string != null && string.equals("*")) {
            string = null;
        }
        return XMLName.create(XmlNode.QName.create(XmlNode.Namespace.create(""), string), true, false);
    }

    private static RuntimeException badXMLName(Object object) {
        String string;
        if (object instanceof Number) {
            string = "Can not construct XML name from number: ";
        } else if (object instanceof Boolean) {
            string = "Can not construct XML name from boolean: ";
        } else if (object == Undefined.instance || object == null) {
            string = "Can not construct XML name from ";
        } else {
            throw new IllegalArgumentException(object.toString());
        }
        return ScriptRuntime.typeError(string + ScriptRuntime.toString(object));
    }

    XMLName toXMLNameFromString(Context context, String string) {
        return XMLName.create(this.getDefaultNamespaceURI(context), string);
    }

    XMLName toXMLName(Context context, Object object) {
        XMLName xMLName;
        if (object instanceof XMLName) {
            xMLName = (XMLName)object;
        } else if (object instanceof QName) {
            QName qName = (QName)object;
            xMLName = XMLName.formProperty(qName.uri(), qName.localName());
        } else if (object instanceof String) {
            xMLName = this.toXMLNameFromString(context, (String)object);
        } else {
            if (object instanceof Boolean || object instanceof Number || object == Undefined.instance || object == null) {
                throw XMLLibImpl.badXMLName(object);
            }
            String string = ScriptRuntime.toString(object);
            xMLName = this.toXMLNameFromString(context, string);
        }
        return xMLName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    XMLName toXMLNameOrIndex(Context context, Object object) {
        if (object instanceof XMLName) {
            return (XMLName)object;
        }
        if (object instanceof String) {
            String string = (String)object;
            long l = ScriptRuntime.testUint32String(string);
            if (l < 0L) return this.toXMLNameFromString(context, string);
            ScriptRuntime.storeUint32Result(context, l);
            return null;
        }
        if (object instanceof Number) {
            double d = ((Number)object).doubleValue();
            long l = (long)d;
            if ((double)l != d) throw XMLLibImpl.badXMLName(object);
            if (0L > l) throw XMLLibImpl.badXMLName(object);
            if (l > 0xFFFFFFFFL) throw XMLLibImpl.badXMLName(object);
            ScriptRuntime.storeUint32Result(context, l);
            return null;
        }
        if (object instanceof QName) {
            long l;
            QName qName = (QName)object;
            String string = qName.uri();
            boolean bl = false;
            XMLName xMLName = null;
            if (string != null && string.length() == 0 && (l = ScriptRuntime.testUint32String(string)) >= 0L) {
                ScriptRuntime.storeUint32Result(context, l);
                bl = true;
            }
            if (bl) return xMLName;
            return XMLName.formProperty(string, qName.localName());
        }
        if (object instanceof Boolean) throw XMLLibImpl.badXMLName(object);
        if (object == Undefined.instance) throw XMLLibImpl.badXMLName(object);
        if (object == null) {
            throw XMLLibImpl.badXMLName(object);
        }
        String string = ScriptRuntime.toString(object);
        long l = ScriptRuntime.testUint32String(string);
        if (l < 0L) return this.toXMLNameFromString(context, string);
        ScriptRuntime.storeUint32Result(context, l);
        return null;
    }

    Object addXMLObjects(Context context, XMLObject xMLObject, XMLObject xMLObject2) {
        XMLList xMLList;
        XMLList xMLList2 = this.newXMLList();
        if (xMLObject instanceof XMLList) {
            xMLList = (XMLList)xMLObject;
            if (xMLList.length() == 1) {
                xMLList2.addToList(xMLList.item(0));
            } else {
                xMLList2 = this.newXMLListFrom(xMLObject);
            }
        } else {
            xMLList2.addToList(xMLObject);
        }
        if (xMLObject2 instanceof XMLList) {
            xMLList = (XMLList)xMLObject2;
            for (int i = 0; i < xMLList.length(); ++i) {
                xMLList2.addToList(xMLList.item(i));
            }
        } else if (xMLObject2 instanceof XML) {
            xMLList2.addToList(xMLObject2);
        }
        return xMLList2;
    }

    private Ref xmlPrimaryReference(Context context, XMLName xMLName, Scriptable scriptable) {
        XMLObjectImpl xMLObjectImpl;
        block2: {
            XMLObjectImpl xMLObjectImpl2 = null;
            do {
                if (!(scriptable instanceof XMLWithScope)) continue;
                xMLObjectImpl = (XMLObjectImpl)scriptable.getPrototype();
                if (xMLObjectImpl.hasXMLProperty(xMLName)) break block2;
                if (xMLObjectImpl2 != null) continue;
                xMLObjectImpl2 = xMLObjectImpl;
            } while ((scriptable = scriptable.getParentScope()) != null);
            xMLObjectImpl = xMLObjectImpl2;
        }
        if (xMLObjectImpl != null) {
            xMLName.initXMLObject(xMLObjectImpl);
        }
        return xMLName;
    }

    Namespace castToNamespace(Context context, Object object) {
        return this.namespacePrototype.castToNamespace(object);
    }

    private String getDefaultNamespaceURI(Context context) {
        return this.getDefaultNamespace(context).uri();
    }

    Namespace newNamespace(String string) {
        return this.namespacePrototype.newNamespace(string);
    }

    Namespace getDefaultNamespace(Context context) {
        if (context == null && (context = Context.getCurrentContext()) == null) {
            return this.namespacePrototype;
        }
        Object object = ScriptRuntime.searchDefaultNamespace(context);
        if (object == null) {
            return this.namespacePrototype;
        }
        if (object instanceof Namespace) {
            return (Namespace)object;
        }
        return this.namespacePrototype;
    }

    Namespace[] createNamespaces(XmlNode.Namespace[] namespaceArray) {
        Namespace[] namespaceArray2 = new Namespace[namespaceArray.length];
        for (int i = 0; i < namespaceArray.length; ++i) {
            namespaceArray2[i] = this.namespacePrototype.newNamespace(namespaceArray[i].getPrefix(), namespaceArray[i].getUri());
        }
        return namespaceArray2;
    }

    QName constructQName(Context context, Object object, Object object2) {
        return this.qnamePrototype.constructQName(this, context, object, object2);
    }

    QName newQName(String string, String string2, String string3) {
        return this.qnamePrototype.newQName(this, string, string2, string3);
    }

    QName constructQName(Context context, Object object) {
        return this.qnamePrototype.constructQName(this, context, object);
    }

    QName castToQName(Context context, Object object) {
        return this.qnamePrototype.castToQName(this, context, object);
    }

    QName newQName(XmlNode.QName qName) {
        return QName.create(this, this.globalScope, this.qnamePrototype, qName);
    }

    XML newXML(XmlNode xmlNode) {
        return new XML(this, this.globalScope, this.xmlPrototype, xmlNode);
    }

    final XML newXMLFromJs(Object object) {
        String string = object == null || object == Undefined.instance ? "" : (object instanceof XMLObjectImpl ? ((XMLObjectImpl)object).toXMLString() : ScriptRuntime.toString(object));
        if (string.trim().startsWith("<>")) {
            throw ScriptRuntime.typeError("Invalid use of XML object anonymous tags <></>.");
        }
        if (string.indexOf("<") == -1) {
            return this.newXML(XmlNode.createText(this.options, string));
        }
        return this.parse(string);
    }

    private XML parse(String string) {
        try {
            return this.newXML(XmlNode.createElement(this.options, this.getDefaultNamespaceURI(Context.getCurrentContext()), string));
        }
        catch (SAXException sAXException) {
            throw ScriptRuntime.typeError("Cannot parse XML: " + sAXException.getMessage());
        }
    }

    final XML ecmaToXml(Object object) {
        if (object == null || object == Undefined.instance) {
            throw ScriptRuntime.typeError("Cannot convert " + object + " to XML");
        }
        if (object instanceof XML) {
            return (XML)object;
        }
        if (object instanceof XMLList) {
            XMLList xMLList = (XMLList)object;
            if (xMLList.getXML() != null) {
                return xMLList.getXML();
            }
            throw ScriptRuntime.typeError("Cannot convert list of >1 element to XML");
        }
        if (object instanceof Wrapper) {
            object = ((Wrapper)object).unwrap();
        }
        if (object instanceof Node) {
            Node node = (Node)object;
            return this.newXML(XmlNode.createElementFromNode(node));
        }
        String string = ScriptRuntime.toString(object);
        if (string.length() > 0 && string.charAt(0) == '<') {
            return this.parse(string);
        }
        return this.newXML(XmlNode.createText(this.options, string));
    }

    final XML newTextElementXML(XmlNode xmlNode, XmlNode.QName qName, String string) {
        return this.newXML(XmlNode.newElementWithText(this.options, xmlNode, qName, string));
    }

    XMLList newXMLList() {
        return new XMLList(this, this.globalScope, this.xmlListPrototype);
    }

    final XMLList newXMLListFrom(Object object) {
        XMLList xMLList = this.newXMLList();
        if (object == null || object instanceof Undefined) {
            return xMLList;
        }
        if (object instanceof XML) {
            XML xML = (XML)object;
            xMLList.getNodeList().add(xML);
            return xMLList;
        }
        if (object instanceof XMLList) {
            XMLList xMLList2 = (XMLList)object;
            xMLList.getNodeList().add(xMLList2.getNodeList());
            return xMLList;
        }
        String string = ScriptRuntime.toString(object).trim();
        if (!string.startsWith("<>")) {
            string = "<>" + string + "</>";
        }
        if (!(string = "<fragment>" + string.substring(2)).endsWith("</>")) {
            throw ScriptRuntime.typeError("XML with anonymous tag missing end anonymous tag");
        }
        string = string.substring(0, string.length() - 3) + "</fragment>";
        XML xML = this.newXMLFromJs(string);
        XMLList xMLList3 = xML.children();
        for (int i = 0; i < xMLList3.getNodeList().length(); ++i) {
            xMLList.getNodeList().add((XML)xMLList3.item(i).copy());
        }
        return xMLList;
    }

    XmlNode.QName toNodeQName(Context context, Object object, Object object2) {
        String string;
        Serializable serializable;
        if (object2 instanceof QName) {
            serializable = (QName)object2;
            string = serializable.localName();
        } else {
            string = ScriptRuntime.toString(object2);
        }
        serializable = object == Undefined.instance ? ("*".equals(string) ? null : this.getDefaultNamespace(context).getDelegate()) : (object == null ? null : (object instanceof Namespace ? ((Namespace)object).getDelegate() : this.namespacePrototype.constructNamespace(object).getDelegate()));
        if (string != null && string.equals("*")) {
            string = null;
        }
        return XmlNode.QName.create((XmlNode.Namespace)serializable, string);
    }

    XmlNode.QName toNodeQName(Context context, String string, boolean bl) {
        XmlNode.Namespace namespace = this.getDefaultNamespace(context).getDelegate();
        if (string != null && string.equals("*")) {
            return XmlNode.QName.create(null, null);
        }
        if (bl) {
            return XmlNode.QName.create(XmlNode.Namespace.GLOBAL, string);
        }
        return XmlNode.QName.create(namespace, string);
    }

    XmlNode.QName toNodeQName(Context context, Object object, boolean bl) {
        if (object instanceof XMLName) {
            return ((XMLName)object).toQname();
        }
        if (object instanceof QName) {
            QName qName = (QName)object;
            return qName.getDelegate();
        }
        if (object instanceof Boolean || object instanceof Number || object == Undefined.instance || object == null) {
            throw XMLLibImpl.badXMLName(object);
        }
        String string = null;
        string = object instanceof String ? (String)object : ScriptRuntime.toString(object);
        return this.toNodeQName(context, string, bl);
    }

    @Override
    public boolean isXMLName(Context context, Object object) {
        return XMLName.accept(object);
    }

    @Override
    public Object toDefaultXmlNamespace(Context context, Object object) {
        return this.namespacePrototype.constructNamespace(object);
    }

    @Override
    public String escapeTextValue(Object object) {
        return this.options.escapeTextValue(object);
    }

    @Override
    public String escapeAttributeValue(Object object) {
        return this.options.escapeAttributeValue(object);
    }

    @Override
    public Ref nameRef(Context context, Object object, Scriptable scriptable, int n) {
        if ((n & 2) == 0) {
            throw Kit.codeBug();
        }
        XMLName xMLName = this.toAttributeName(context, object);
        return this.xmlPrimaryReference(context, xMLName, scriptable);
    }

    @Override
    public Ref nameRef(Context context, Object object, Object object2, Scriptable scriptable, int n) {
        XMLName xMLName = XMLName.create(this.toNodeQName(context, object, object2), false, false);
        if ((n & 2) != 0 && !xMLName.isAttributeName()) {
            xMLName.setAttributeName();
        }
        return this.xmlPrimaryReference(context, xMLName, scriptable);
    }
}

