/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.MenuComponent;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.SecurityUtilities;
import org.mozilla.javascript.tools.debugger.ContextWindow;
import org.mozilla.javascript.tools.debugger.Dim;
import org.mozilla.javascript.tools.debugger.FileTextArea;
import org.mozilla.javascript.tools.debugger.FileWindow;
import org.mozilla.javascript.tools.debugger.FindFunction;
import org.mozilla.javascript.tools.debugger.GuiCallback;
import org.mozilla.javascript.tools.debugger.JSInternalConsole;
import org.mozilla.javascript.tools.debugger.Menubar;
import org.mozilla.javascript.tools.debugger.MessageDialogWrapper;
import org.mozilla.javascript.tools.debugger.MoreWindows;
import org.mozilla.javascript.tools.debugger.RunProxy;

public class SwingGui
extends JFrame
implements GuiCallback {
    private static final long serialVersionUID = -8217029773456711621L;
    Dim dim;
    private Runnable exitAction;
    private JDesktopPane desk;
    private ContextWindow context;
    private Menubar menubar;
    private JToolBar toolBar;
    private JSInternalConsole console;
    private JSplitPane split1;
    private JLabel statusBar;
    private final Map<String, JFrame> toplevels = Collections.synchronizedMap(new HashMap());
    private final Map<String, FileWindow> fileWindows = Collections.synchronizedMap(new TreeMap());
    private FileWindow currentWindow;
    JFileChooser dlg;
    private EventQueue awtEventQueue;

    public SwingGui(Dim dim, String string) {
        super(string);
        this.dim = dim;
        this.init();
        dim.setGuiCallback(this);
    }

    public Menubar getMenubar() {
        return this.menubar;
    }

    public void setExitAction(Runnable runnable) {
        this.exitAction = runnable;
    }

    public JSInternalConsole getConsole() {
        return this.console;
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.console.consoleTextArea.requestFocus();
            this.context.split.setDividerLocation(0.5);
            try {
                this.console.setMaximum(true);
                this.console.setSelected(true);
                this.console.show();
                this.console.consoleTextArea.requestFocus();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void addTopLevel(String string, JFrame jFrame) {
        if (jFrame != this) {
            this.toplevels.put(string, jFrame);
        }
    }

    private void init() {
        JButton jButton;
        JButton jButton2;
        JButton jButton3;
        JButton jButton4;
        JButton jButton5;
        this.menubar = new Menubar(this);
        this.setJMenuBar(this.menubar);
        this.toolBar = new JToolBar();
        String[] stringArray = new String[]{"Break (Pause)", "Go (F5)", "Step Into (F11)", "Step Over (F7)", "Step Out (F8)"};
        int n = 0;
        JButton jButton6 = jButton5 = new JButton("Break");
        jButton6.setToolTipText("Break");
        jButton6.setActionCommand("Break");
        jButton6.addActionListener(this.menubar);
        jButton6.setEnabled(true);
        jButton6.setToolTipText(stringArray[n++]);
        jButton6 = jButton4 = new JButton("Go");
        jButton6.setToolTipText("Go");
        jButton6.setActionCommand("Go");
        jButton6.addActionListener(this.menubar);
        jButton6.setEnabled(false);
        jButton6.setToolTipText(stringArray[n++]);
        jButton6 = jButton3 = new JButton("Step Into");
        jButton6.setToolTipText("Step Into");
        jButton6.setActionCommand("Step Into");
        jButton6.addActionListener(this.menubar);
        jButton6.setEnabled(false);
        jButton6.setToolTipText(stringArray[n++]);
        jButton6 = jButton2 = new JButton("Step Over");
        jButton6.setToolTipText("Step Over");
        jButton6.setActionCommand("Step Over");
        jButton6.setEnabled(false);
        jButton6.addActionListener(this.menubar);
        jButton6.setToolTipText(stringArray[n++]);
        jButton6 = jButton = new JButton("Step Out");
        jButton6.setToolTipText("Step Out");
        jButton6.setActionCommand("Step Out");
        jButton6.setEnabled(false);
        jButton6.addActionListener(this.menubar);
        jButton6.setToolTipText(stringArray[n++]);
        Dimension dimension = jButton2.getPreferredSize();
        jButton5.setPreferredSize(dimension);
        jButton5.setMinimumSize(dimension);
        jButton5.setMaximumSize(dimension);
        jButton5.setSize(dimension);
        jButton4.setPreferredSize(dimension);
        jButton4.setMinimumSize(dimension);
        jButton4.setMaximumSize(dimension);
        jButton3.setPreferredSize(dimension);
        jButton3.setMinimumSize(dimension);
        jButton3.setMaximumSize(dimension);
        jButton2.setPreferredSize(dimension);
        jButton2.setMinimumSize(dimension);
        jButton2.setMaximumSize(dimension);
        jButton.setPreferredSize(dimension);
        jButton.setMinimumSize(dimension);
        jButton.setMaximumSize(dimension);
        this.toolBar.add(jButton5);
        this.toolBar.add(jButton4);
        this.toolBar.add(jButton3);
        this.toolBar.add(jButton2);
        this.toolBar.add(jButton);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.toolBar, "North");
        this.getContentPane().add((Component)jPanel, "Center");
        this.desk = new JDesktopPane();
        this.desk.setPreferredSize(new Dimension(600, 300));
        this.desk.setMinimumSize(new Dimension(150, 50));
        this.console = new JSInternalConsole("JavaScript Console");
        this.desk.add(this.console);
        this.context = new ContextWindow(this);
        this.context.setPreferredSize(new Dimension(600, 120));
        this.context.setMinimumSize(new Dimension(50, 50));
        this.split1 = new JSplitPane(0, this.desk, this.context);
        this.split1.setOneTouchExpandable(true);
        SwingGui.setResizeWeight(this.split1, 0.66);
        jPanel.add((Component)this.split1, "Center");
        this.statusBar = new JLabel();
        this.statusBar.setText("Thread: ");
        jPanel.add((Component)this.statusBar, "South");
        this.dlg = new JFileChooser();
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                String string;
                if (file.isDirectory()) {
                    return true;
                }
                String string2 = file.getName();
                int n = string2.lastIndexOf(46);
                return n > 0 && n < string2.length() - 1 && (string = string2.substring(n + 1).toLowerCase()).equals("js");
            }

            @Override
            public String getDescription() {
                return "JavaScript Files (*.js)";
            }
        };
        this.dlg.addChoosableFileFilter(fileFilter);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                SwingGui.this.exit();
            }
        });
    }

    private void exit() {
        if (this.exitAction != null) {
            SwingUtilities.invokeLater(this.exitAction);
        }
        this.dim.setReturnValue(5);
    }

    FileWindow getFileWindow(String string) {
        if (string == null || string.equals("<stdin>")) {
            return null;
        }
        return this.fileWindows.get(string);
    }

    static String getShortName(String string) {
        int n = string.lastIndexOf(47);
        if (n < 0) {
            n = string.lastIndexOf(92);
        }
        String string2 = string;
        if (n >= 0 && n + 1 < string.length()) {
            string2 = string.substring(n + 1);
        }
        return string2;
    }

    void removeWindow(FileWindow fileWindow) {
        this.fileWindows.remove(fileWindow.getUrl());
        JMenu jMenu = this.getWindowMenu();
        int n = jMenu.getItemCount();
        JMenuItem jMenuItem = jMenu.getItem(n - 1);
        String string = SwingGui.getShortName(fileWindow.getUrl());
        for (int i = 5; i < n; ++i) {
            int n2;
            String string2;
            JMenuItem jMenuItem2 = jMenu.getItem(i);
            if (jMenuItem2 == null || !(string2 = jMenuItem2.getText()).substring((n2 = string2.indexOf(32)) + 1).equals(string)) continue;
            jMenu.remove(jMenuItem2);
            if (n == 6) {
                jMenu.remove(4);
                break;
            }
            int n3 = i - 4;
            while (i < n - 1) {
                JMenuItem jMenuItem3 = jMenu.getItem(i);
                if (jMenuItem3 != null) {
                    string2 = jMenuItem3.getText();
                    if (string2.equals("More Windows...")) break;
                    n2 = string2.indexOf(32);
                    jMenuItem3.setText((char)(48 + n3) + " " + string2.substring(n2 + 1));
                    jMenuItem3.setMnemonic(48 + n3);
                    ++n3;
                }
                ++i;
            }
            if (n - 6 != 0 || jMenuItem == jMenuItem2 || !jMenuItem.getText().equals("More Windows...")) break;
            jMenu.remove(jMenuItem);
            break;
        }
        jMenu.revalidate();
    }

    void showStopLine(Dim.StackFrame stackFrame) {
        String string = stackFrame.getUrl();
        if (string == null || string.equals("<stdin>")) {
            if (this.console.isVisible()) {
                this.console.show();
            }
        } else {
            this.showFileWindow(string, -1);
            int n = stackFrame.getLineNumber();
            FileWindow fileWindow = this.getFileWindow(string);
            if (fileWindow != null) {
                this.setFilePosition(fileWindow, n);
            }
        }
    }

    protected void showFileWindow(String string, int n) {
        Object object;
        FileWindow fileWindow = string != null ? this.getFileWindow(string) : ((object = this.getSelectedFrame()) != null && object instanceof FileWindow ? (FileWindow)object : this.currentWindow);
        if (fileWindow == null && string != null) {
            object = this.dim.sourceInfo(string);
            this.createFileWindow((Dim.SourceInfo)object, -1);
            fileWindow = this.getFileWindow(string);
        }
        if (fileWindow == null) {
            return;
        }
        if (n > -1) {
            int n2 = fileWindow.getPosition(n - 1);
            int n3 = fileWindow.getPosition(n) - 1;
            if (n2 <= 0) {
                return;
            }
            fileWindow.textArea.select(n2);
            fileWindow.textArea.setCaretPosition(n2);
            fileWindow.textArea.moveCaretPosition(n3);
        }
        try {
            if (fileWindow.isIcon()) {
                fileWindow.setIcon(false);
            }
            fileWindow.setVisible(true);
            fileWindow.moveToFront();
            fileWindow.setSelected(true);
            this.requestFocus();
            fileWindow.requestFocus();
            fileWindow.textArea.requestFocus();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void createFileWindow(Dim.SourceInfo sourceInfo, int n) {
        boolean bl = true;
        String string = sourceInfo.url();
        FileWindow fileWindow = new FileWindow(this, sourceInfo);
        this.fileWindows.put(string, fileWindow);
        if (n != -1) {
            if (this.currentWindow != null) {
                this.currentWindow.setPosition(-1);
            }
            try {
                fileWindow.setPosition(fileWindow.textArea.getLineStartOffset(n - 1));
            }
            catch (BadLocationException badLocationException) {
                try {
                    fileWindow.setPosition(fileWindow.textArea.getLineStartOffset(0));
                }
                catch (BadLocationException badLocationException2) {
                    fileWindow.setPosition(-1);
                }
            }
        }
        this.desk.add(fileWindow);
        if (n != -1) {
            this.currentWindow = fileWindow;
        }
        this.menubar.addFile(string);
        fileWindow.setVisible(true);
        if (bl) {
            try {
                fileWindow.setMaximum(true);
                fileWindow.setSelected(true);
                fileWindow.moveToFront();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected boolean updateFileWindow(Dim.SourceInfo sourceInfo) {
        String string = sourceInfo.url();
        FileWindow fileWindow = this.getFileWindow(string);
        if (fileWindow != null) {
            fileWindow.updateText(sourceInfo);
            fileWindow.show();
            return true;
        }
        return false;
    }

    private void setFilePosition(FileWindow fileWindow, int n) {
        boolean bl = true;
        FileTextArea fileTextArea = fileWindow.textArea;
        try {
            if (n == -1) {
                fileWindow.setPosition(-1);
                if (this.currentWindow == fileWindow) {
                    this.currentWindow = null;
                }
            } else {
                int n2 = fileTextArea.getLineStartOffset(n - 1);
                if (this.currentWindow != null && this.currentWindow != fileWindow) {
                    this.currentWindow.setPosition(-1);
                }
                fileWindow.setPosition(n2);
                this.currentWindow = fileWindow;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        if (bl) {
            if (fileWindow.isIcon()) {
                this.desk.getDesktopManager().deiconifyFrame(fileWindow);
            }
            this.desk.getDesktopManager().activateFrame(fileWindow);
            try {
                fileWindow.show();
                fileWindow.toFront();
                fileWindow.setSelected(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void enterInterruptImpl(Dim.StackFrame stackFrame, String string, String string2) {
        this.statusBar.setText("Thread: " + string);
        this.showStopLine(stackFrame);
        if (string2 != null) {
            MessageDialogWrapper.showMessageDialog(this, string2, "Exception in Script", 0);
        }
        this.updateEnabled(true);
        Dim.ContextData contextData = stackFrame.contextData();
        JComboBox<String> jComboBox = this.context.context;
        List<String> list = this.context.toolTips;
        this.context.disableUpdate();
        int n = contextData.frameCount();
        jComboBox.removeAllItems();
        jComboBox.setSelectedItem(null);
        list.clear();
        for (int i = 0; i < n; ++i) {
            Dim.StackFrame stackFrame2 = contextData.getFrame(i);
            String string3 = stackFrame2.getUrl();
            int n2 = stackFrame2.getLineNumber();
            String string4 = string3;
            if (string3.length() > 20) {
                string4 = "..." + string3.substring(string3.length() - 17);
            }
            String string5 = "\"" + string4 + "\", line " + n2;
            jComboBox.insertItemAt(string5, i);
            string5 = "\"" + string3 + "\", line " + n2;
            list.add(string5);
        }
        this.context.enableUpdate();
        jComboBox.setSelectedIndex(0);
        jComboBox.setMinimumSize(new Dimension(50, jComboBox.getMinimumSize().height));
    }

    private JMenu getWindowMenu() {
        return this.menubar.getMenu(3);
    }

    private String chooseFile(String string) {
        int n;
        this.dlg.setDialogTitle(string);
        File file = null;
        String string2 = SecurityUtilities.getSystemProperty("user.dir");
        if (string2 != null) {
            file = new File(string2);
        }
        if (file != null) {
            this.dlg.setCurrentDirectory(file);
        }
        if ((n = this.dlg.showOpenDialog(this)) == 0) {
            try {
                String string3 = this.dlg.getSelectedFile().getCanonicalPath();
                file = this.dlg.getSelectedFile().getParentFile();
                Properties properties = System.getProperties();
                properties.put("user.dir", file.getPath());
                System.setProperties(properties);
                return string3;
            }
            catch (IOException iOException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return null;
    }

    private JInternalFrame getSelectedFrame() {
        JInternalFrame[] jInternalFrameArray = this.desk.getAllFrames();
        for (int i = 0; i < jInternalFrameArray.length; ++i) {
            if (!jInternalFrameArray[i].isShowing()) continue;
            return jInternalFrameArray[i];
        }
        return jInternalFrameArray[jInternalFrameArray.length - 1];
    }

    private void updateEnabled(boolean bl) {
        int n;
        ((Menubar)this.getJMenuBar()).updateEnabled(bl);
        int n2 = this.toolBar.getComponentCount();
        for (n = 0; n < n2; ++n) {
            boolean bl2 = n == 0 ? !bl : bl;
            this.toolBar.getComponent(n).setEnabled(bl2);
        }
        if (bl) {
            this.toolBar.setEnabled(true);
            n = this.getExtendedState();
            if (n == 1) {
                this.setExtendedState(0);
            }
            this.toFront();
            this.context.setEnabled(true);
        } else {
            if (this.currentWindow != null) {
                this.currentWindow.setPosition(-1);
            }
            this.context.setEnabled(false);
        }
    }

    static void setResizeWeight(JSplitPane jSplitPane, double d) {
        try {
            Method method = JSplitPane.class.getMethod("setResizeWeight", Double.TYPE);
            method.invoke((Object)jSplitPane, d);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    private String readFile(String string) {
        String string2;
        try (FileReader fileReader = new FileReader(string);){
            string2 = Kit.readReader(fileReader);
        }
        catch (IOException iOException) {
            MessageDialogWrapper.showMessageDialog(this, iOException.getMessage(), "Error reading " + string, 0);
            string2 = null;
        }
        return string2;
    }

    @Override
    public void updateSourceText(Dim.SourceInfo sourceInfo) {
        RunProxy runProxy = new RunProxy(this, 3);
        runProxy.sourceInfo = sourceInfo;
        SwingUtilities.invokeLater(runProxy);
    }

    @Override
    public void enterInterrupt(Dim.StackFrame stackFrame, String string, String string2) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.enterInterruptImpl(stackFrame, string, string2);
        } else {
            RunProxy runProxy = new RunProxy(this, 4);
            runProxy.lastFrame = stackFrame;
            runProxy.threadTitle = string;
            runProxy.alertMessage = string2;
            SwingUtilities.invokeLater(runProxy);
        }
    }

    @Override
    public boolean isGuiEventThread() {
        return SwingUtilities.isEventDispatchThread();
    }

    @Override
    public void dispatchNextGuiEvent() throws InterruptedException {
        AWTEvent aWTEvent;
        EventQueue eventQueue = this.awtEventQueue;
        if (eventQueue == null) {
            this.awtEventQueue = eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        }
        if ((aWTEvent = eventQueue.getNextEvent()) instanceof ActiveEvent) {
            ((ActiveEvent)((Object)aWTEvent)).dispatch();
        } else {
            Object object = aWTEvent.getSource();
            if (object instanceof Component) {
                Component component = (Component)object;
                component.dispatchEvent(aWTEvent);
            } else if (object instanceof MenuComponent) {
                ((MenuComponent)object).dispatchEvent(aWTEvent);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        int n = -1;
        if (string.equals("Cut") || string.equals("Copy") || string.equals("Paste")) {
            JInternalFrame jInternalFrame = this.getSelectedFrame();
            if (jInternalFrame != null && jInternalFrame instanceof ActionListener) {
                ((ActionListener)((Object)jInternalFrame)).actionPerformed(actionEvent);
            }
        } else if (string.equals("Step Over")) {
            n = 0;
        } else if (string.equals("Step Into")) {
            n = 1;
        } else if (string.equals("Step Out")) {
            n = 2;
        } else if (string.equals("Go")) {
            n = 3;
        } else if (string.equals("Break")) {
            this.dim.setBreak();
        } else if (string.equals("Exit")) {
            this.exit();
        } else if (string.equals("Open")) {
            String string2;
            String string3 = this.chooseFile("Select a file to compile");
            if (string3 != null && (string2 = this.readFile(string3)) != null) {
                RunProxy runProxy = new RunProxy(this, 1);
                runProxy.fileName = string3;
                runProxy.text = string2;
                new Thread(runProxy).start();
            }
        } else if (string.equals("Load")) {
            String string4;
            String string5 = this.chooseFile("Select a file to execute");
            if (string5 != null && (string4 = this.readFile(string5)) != null) {
                RunProxy runProxy = new RunProxy(this, 2);
                runProxy.fileName = string5;
                runProxy.text = string4;
                new Thread(runProxy).start();
            }
        } else if (string.equals("More Windows...")) {
            MoreWindows moreWindows = new MoreWindows(this, this.fileWindows, "Window", "Files");
            moreWindows.showDialog(this);
        } else if (string.equals("Console")) {
            if (this.console.isIcon()) {
                this.desk.getDesktopManager().deiconifyFrame(this.console);
            }
            this.console.show();
            this.desk.getDesktopManager().activateFrame(this.console);
            this.console.consoleTextArea.requestFocus();
        } else if (!(string.equals("Cut") || string.equals("Copy") || string.equals("Paste"))) {
            if (string.equals("Go to function...")) {
                FindFunction findFunction = new FindFunction(this, "Go to function", "Function");
                findFunction.showDialog(this);
            } else if (string.equals("Go to line...")) {
                String string6 = (String)JOptionPane.showInputDialog(this, "Line number", "Go to line...", 3, null, null, null);
                if (string6 == null || string6.trim().length() == 0) {
                    return;
                }
                try {
                    int n2 = Integer.parseInt(string6);
                    this.showFileWindow(null, n2);
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (string.equals("Tile")) {
                JInternalFrame[] jInternalFrameArray = this.desk.getAllFrames();
                int n3 = jInternalFrameArray.length;
                int n4 = (int)Math.sqrt(n3);
                int n5 = n4;
                if (n5 * n4 < n3 && n5 * ++n4 < n3) {
                    ++n5;
                }
                Dimension dimension = this.desk.getSize();
                int n6 = dimension.width / n4;
                int n7 = dimension.height / n5;
                int n8 = 0;
                int n9 = 0;
                for (int i = 0; i < n5; ++i) {
                    int n10;
                    for (int j = 0; j < n4 && (n10 = i * n4 + j) < jInternalFrameArray.length; ++j) {
                        JInternalFrame jInternalFrame = jInternalFrameArray[n10];
                        try {
                            jInternalFrame.setIcon(false);
                            jInternalFrame.setMaximum(false);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.desk.getDesktopManager().setBoundsForFrame(jInternalFrame, n8, n9, n6, n7);
                        n8 += n6;
                    }
                    n9 += n7;
                    n8 = 0;
                }
            } else if (string.equals("Cascade")) {
                JInternalFrame[] jInternalFrameArray = this.desk.getAllFrames();
                int n11 = jInternalFrameArray.length;
                int n12 = 0;
                int n13 = 0;
                int n14 = this.desk.getHeight();
                int n15 = n14 / n11;
                if (n15 > 30) {
                    n15 = 30;
                }
                int n16 = n11 - 1;
                while (n16 >= 0) {
                    JInternalFrame jInternalFrame = jInternalFrameArray[n16];
                    try {
                        jInternalFrame.setIcon(false);
                        jInternalFrame.setMaximum(false);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    Dimension dimension = jInternalFrame.getPreferredSize();
                    int n17 = dimension.width;
                    n14 = dimension.height;
                    this.desk.getDesktopManager().setBoundsForFrame(jInternalFrame, n13, n12, n17, n14);
                    --n16;
                    n13 += n15;
                    n12 += n15;
                }
            } else {
                FileWindow fileWindow = this.getFileWindow(string);
                if (fileWindow != null) {
                    FileWindow fileWindow2 = fileWindow;
                    try {
                        if (fileWindow2.isIcon()) {
                            fileWindow2.setIcon(false);
                        }
                        fileWindow2.setVisible(true);
                        fileWindow2.moveToFront();
                        fileWindow2.setSelected(true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        if (n != -1) {
            this.updateEnabled(false);
            this.dim.setReturnValue(n);
        }
    }
}

