/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSGradientValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.parser.SyntaxParser;
import io.sf.carte.doc.style.css.property.CSSLexicalProcessingException;
import io.sf.carte.doc.style.css.property.FunctionValue;
import io.sf.carte.doc.style.css.property.LexicalValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.doc.style.css.property.ValueList;
import java.util.Locale;
import org.w3c.dom.DOMException;

public class GradientValue
extends FunctionValue
implements CSSGradientValue {
    private static final long serialVersionUID = 1L;
    private CSSGradientValue.GradientType gradientType = CSSGradientValue.GradientType.OTHER_GRADIENT;

    GradientValue() {
        super(CSSValue.Type.GRADIENT);
    }

    GradientValue(GradientValue gradientValue) {
        super(gradientValue);
        this.gradientType = gradientValue.gradientType;
    }

    @Override
    public CSSGradientValue.GradientType getGradientType() {
        return this.gradientType;
    }

    @Override
    public CSSValueSyntax.Match matches(CSSValueSyntax cSSValueSyntax) {
        if (cSSValueSyntax != null) {
            if (cSSValueSyntax.getCategory() == CSSValueSyntax.Category.universal) {
                return CSSValueSyntax.Match.TRUE;
            }
            do {
                CSSValueSyntax.Match match;
                if ((match = this.matchesComponent(cSSValueSyntax)) == CSSValueSyntax.Match.FALSE) continue;
                return match;
            } while ((cSSValueSyntax = cSSValueSyntax.getNext()) != null);
        }
        return CSSValueSyntax.Match.FALSE;
    }

    @Override
    CSSValueSyntax.Match matchesComponent(CSSValueSyntax cSSValueSyntax) {
        switch (cSSValueSyntax.getCategory()) {
            case image: 
            case universal: {
                return CSSValueSyntax.Match.TRUE;
            }
        }
        return CSSValueSyntax.Match.FALSE;
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = super.hashCode();
        n2 = 31 * n2 + (this.gradientType == null ? 0 : this.gradientType.hashCode());
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        GradientValue gradientValue = (GradientValue)object;
        return this.gradientType == gradientValue.gradientType;
    }

    private static LexicalUnit findCustomPropertyFallback(LexicalUnit lexicalUnit) {
        LexicalUnit lexicalUnit2 = lexicalUnit.getParameters();
        if (lexicalUnit2 != null) {
            if (lexicalUnit2.getLexicalUnitType() == LexicalUnit.LexicalType.IDENT) {
                if ((lexicalUnit2 = lexicalUnit2.getNextLexicalUnit()) != null) {
                    lexicalUnit2 = lexicalUnit2.getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_COMMA ? lexicalUnit2.getNextLexicalUnit() : null;
                }
            } else {
                lexicalUnit2 = null;
            }
        }
        return lexicalUnit2;
    }

    @Override
    PrimitiveValue.LexicalSetter newLexicalSetter() {
        return new MyLexicalSetter();
    }

    @Override
    public GradientValue clone() {
        return new GradientValue(this);
    }

    class MyLexicalSetter
    extends PrimitiveValue.LexicalSetter {
        MyLexicalSetter() {
            super(GradientValue.this);
        }

        @Override
        void setLexicalUnit(LexicalUnit lexicalUnit) throws DOMException {
            String string = lexicalUnit.getFunctionName();
            GradientValue.this.setFunctionName(string);
            string = string.toLowerCase(Locale.ROOT);
            LexicalUnit lexicalUnit2 = lexicalUnit.getParameters();
            if (lexicalUnit2 == null) {
                throw this.createDOMSyntaxException("Gradient without arguments");
            }
            if (string.endsWith("linear-gradient")) {
                if (string.equals("linear-gradient")) {
                    GradientValue.this.gradientType = CSSGradientValue.GradientType.LINEAR_GRADIENT;
                } else if (string.equals("repeating-linear-gradient")) {
                    GradientValue.this.gradientType = CSSGradientValue.GradientType.REPEATING_LINEAR_GRADIENT;
                } else {
                    GradientValue.this.gradientType = CSSGradientValue.GradientType.OTHER_GRADIENT;
                }
                this.setLinearGradient(lexicalUnit2, new ValueFactory());
            } else if (string.endsWith("radial-gradient")) {
                if (string.equals("radial-gradient")) {
                    GradientValue.this.gradientType = CSSGradientValue.GradientType.RADIAL_GRADIENT;
                } else if (string.equals("repeating-radial-gradient")) {
                    GradientValue.this.gradientType = CSSGradientValue.GradientType.REPEATING_RADIAL_GRADIENT;
                } else {
                    GradientValue.this.gradientType = CSSGradientValue.GradientType.OTHER_GRADIENT;
                }
                this.setRadialGradient(lexicalUnit2, new ValueFactory());
            } else if (string.endsWith("conic-gradient")) {
                if (string.equals("conic-gradient")) {
                    GradientValue.this.gradientType = CSSGradientValue.GradientType.CONIC_GRADIENT;
                } else if (string.equals("repeating-conic-gradient")) {
                    GradientValue.this.gradientType = CSSGradientValue.GradientType.REPEATING_CONIC_GRADIENT;
                } else {
                    GradientValue.this.gradientType = CSSGradientValue.GradientType.OTHER_GRADIENT;
                }
                this.setConicGradient(lexicalUnit2, new ValueFactory());
            } else {
                throw this.createDOMSyntaxException("Unknown gradient type");
            }
            this.nextLexicalUnit = lexicalUnit.getNextLexicalUnit();
        }

        private DOMException createDOMSyntaxException(String string) {
            return new DOMException(12, string);
        }

        private void setLinearGradient(LexicalUnit lexicalUnit, ValueFactory valueFactory) {
            int n = 0;
            LexicalUnit lexicalUnit2 = this.isLinearColorStop(lexicalUnit) ? lexicalUnit : this.setAngleArguments(lexicalUnit, valueFactory);
            if (lexicalUnit2 == null) {
                throw this.createDOMSyntaxException("Expected angle, side or color stop, found: " + lexicalUnit.toString());
            }
            do {
                lexicalUnit2 = this.processLinearColorStop(lexicalUnit2, valueFactory);
                ++n;
                if (lexicalUnit2 == null) continue;
                if (lexicalUnit2.getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_COMMA) {
                    lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
                    continue;
                }
                throw this.createDOMSyntaxException("Expected color stops, found: " + lexicalUnit.toString());
            } while (lexicalUnit2 != null);
            if (n < 2) {
                throw this.createDOMSyntaxException("Expected at least 2 color stops, found only one.");
            }
        }

        private LexicalUnit setAngleArguments(LexicalUnit lexicalUnit, ValueFactory valueFactory) {
            LexicalUnit lexicalUnit2 = null;
            if (lexicalUnit.getLexicalUnitType() == LexicalUnit.LexicalType.IDENT) {
                String string = lexicalUnit.getStringValue().toLowerCase(Locale.ROOT);
                ValueList valueList = ValueList.createWSValueList();
                if ("to".equals(string)) {
                    valueList.add(valueFactory.createCSSPrimitiveValue(lexicalUnit, true));
                    lexicalUnit = lexicalUnit.getNextLexicalUnit();
                } else {
                    if (!this.isSideValue(string)) {
                        return null;
                    }
                    this.reportSyntaxWarning("Missing 'to' in side/corner specification in gradient: " + lexicalUnit.toString());
                }
                if (lexicalUnit.getLexicalUnitType() == LexicalUnit.LexicalType.IDENT) {
                    string = lexicalUnit.getStringValue().toLowerCase(Locale.ROOT);
                    if (this.isSideValue(string)) {
                        valueList.add(valueFactory.createCSSPrimitiveValue(lexicalUnit, true));
                        lexicalUnit2 = lexicalUnit = lexicalUnit.getNextLexicalUnit();
                        if (lexicalUnit.getLexicalUnitType() == LexicalUnit.LexicalType.IDENT && this.isSideValue(string = lexicalUnit.getStringValue().toLowerCase(Locale.ROOT))) {
                            valueList.add(valueFactory.createCSSPrimitiveValue(lexicalUnit, true));
                            lexicalUnit2 = lexicalUnit.getNextLexicalUnit();
                        }
                        GradientValue.this.getArguments().add(valueList);
                    }
                } else {
                    this.checkProxyValue(lexicalUnit);
                }
            } else if (this.canBeAngleOrPercentage(lexicalUnit)) {
                GradientValue.this.getArguments().add(valueFactory.createCSSPrimitiveValue(lexicalUnit, true));
                lexicalUnit2 = lexicalUnit.getNextLexicalUnit();
            } else {
                this.checkProxyValue(lexicalUnit);
            }
            if (lexicalUnit2 != null) {
                lexicalUnit2 = lexicalUnit2.getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_COMMA ? lexicalUnit2.getNextLexicalUnit() : null;
            }
            return lexicalUnit2;
        }

        private boolean isSideValue(String string) {
            return "left".equals(string) || "right".equals(string) || "top".equals(string) || "bottom".equals(string);
        }

        private boolean isLinearColorStop(LexicalUnit lexicalUnit) {
            LexicalUnit lexicalUnit2 = lexicalUnit.getNextLexicalUnit();
            if (this.canBeColor(lexicalUnit)) {
                return true;
            }
            return lexicalUnit2 != null && this.canBeColor(lexicalUnit2) && this.canBeSizeOrPercentage(lexicalUnit);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private LexicalUnit processLinearColorStop(LexicalUnit lexicalUnit, ValueFactory valueFactory) {
            PrimitiveValue primitiveValue;
            LexicalUnit lexicalUnit2 = null;
            LexicalUnit lexicalUnit3 = lexicalUnit.getNextLexicalUnit();
            if (this.canBeColor(lexicalUnit)) {
                PrimitiveValue primitiveValue2;
                try {
                    primitiveValue2 = valueFactory.createCSSPrimitiveValue(lexicalUnit, true);
                }
                catch (CSSLexicalProcessingException cSSLexicalProcessingException) {
                    PrimitiveValue.LexicalSetter lexicalSetter = new LexicalValue().newLexicalSetter();
                    lexicalSetter.setLexicalUnit(lexicalUnit.shallowClone());
                    primitiveValue2 = lexicalSetter.getCSSValue();
                }
                if (lexicalUnit3 != null && this.canBeSizeOrPercentage(lexicalUnit3)) {
                    ValueList valueList = ValueList.createWSValueList();
                    valueList.add(primitiveValue2);
                    valueList.add(valueFactory.createCSSPrimitiveValue(lexicalUnit3, true));
                    GradientValue.this.getArguments().add(valueList);
                    lexicalUnit3 = lexicalUnit3.getNextLexicalUnit();
                    if (lexicalUnit3 == null) return lexicalUnit3;
                    if (!this.canBeSizeOrPercentage(lexicalUnit3)) return lexicalUnit3;
                    valueList.add(valueFactory.createCSSPrimitiveValue(lexicalUnit3, true));
                    lexicalUnit3 = lexicalUnit3.getNextLexicalUnit();
                    return lexicalUnit3;
                } else {
                    GradientValue.this.getArguments().add(primitiveValue2);
                }
                return lexicalUnit3;
            }
            if (!this.canBeSizeOrPercentage(lexicalUnit)) throw this.createDOMSyntaxException("Bad color stop");
            if (lexicalUnit3 != null && this.canBeColor(lexicalUnit3)) {
                PrimitiveValue primitiveValue3;
                ValueList valueList = ValueList.createWSValueList();
                try {
                    primitiveValue3 = valueFactory.createCSSPrimitiveValue(lexicalUnit3, true);
                }
                catch (CSSLexicalProcessingException cSSLexicalProcessingException) {
                    PrimitiveValue.LexicalSetter lexicalSetter = new LexicalValue().newLexicalSetter();
                    lexicalSetter.setLexicalUnit(lexicalUnit3.shallowClone());
                    primitiveValue3 = lexicalSetter.getCSSValue();
                }
                valueList.add(primitiveValue3);
                valueList.add(valueFactory.createCSSPrimitiveValue(lexicalUnit, true));
                GradientValue.this.getArguments().add(valueList);
                return lexicalUnit3.getNextLexicalUnit();
            }
            if (lexicalUnit3 != null) {
                if (lexicalUnit3.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_COMMA) throw this.createDOMSyntaxException("Bad color stop");
            }
            try {
                primitiveValue = valueFactory.createCSSPrimitiveValue(lexicalUnit, true);
            }
            catch (CSSLexicalProcessingException cSSLexicalProcessingException) {
                PrimitiveValue.LexicalSetter lexicalSetter = new LexicalValue().newLexicalSetter();
                lexicalSetter.setLexicalUnit(lexicalUnit.shallowClone());
                primitiveValue = lexicalSetter.getCSSValue();
            }
            GradientValue.this.getArguments().add(primitiveValue);
            return lexicalUnit3;
        }

        private boolean canBeColor(LexicalUnit lexicalUnit) {
            if (BaseCSSStyleDeclaration.testColor(lexicalUnit)) {
                return true;
            }
            if (LexicalUnit.LexicalType.VAR == lexicalUnit.getLexicalUnitType()) {
                LexicalUnit lexicalUnit2 = GradientValue.findCustomPropertyFallback(lexicalUnit);
                if (lexicalUnit2 != null) {
                    if (BaseCSSStyleDeclaration.testColor(lexicalUnit2)) {
                        return true;
                    }
                } else {
                    throw new CSSLexicalProcessingException("var() without fallback found.");
                }
            }
            return LexicalUnit.LexicalType.ATTR == lexicalUnit.getLexicalUnitType() && (lexicalUnit = lexicalUnit.getParameters().getNextLexicalUnit()) != null && lexicalUnit.getLexicalUnitType() == LexicalUnit.LexicalType.IDENT && "color".equalsIgnoreCase(lexicalUnit.getStringValue());
        }

        private boolean canBeSizeOrPercentage(LexicalUnit lexicalUnit) {
            return lexicalUnit.getLexicalUnitType() == LexicalUnit.LexicalType.PERCENTAGE || ValueFactory.isSizeSACUnit(lexicalUnit) || LexicalUnit.LexicalType.VAR == lexicalUnit.getLexicalUnitType() && this.isSizeOrPercentageVar(lexicalUnit) || LexicalUnit.LexicalType.ATTR == lexicalUnit.getLexicalUnitType() && lexicalUnit.shallowClone().matches(SyntaxParser.createSimpleSyntax("length-percentage")) != CSSValueSyntax.Match.FALSE;
        }

        private boolean isSizeOrPercentageVar(LexicalUnit lexicalUnit) {
            LexicalUnit lexicalUnit2 = GradientValue.findCustomPropertyFallback(lexicalUnit);
            if (lexicalUnit2 != null) {
                return lexicalUnit2.getLexicalUnitType() == LexicalUnit.LexicalType.PERCENTAGE || ValueFactory.isSizeSACUnit(lexicalUnit2);
            }
            throw new CSSLexicalProcessingException("var() without fallback found.");
        }

        private void setRadialGradient(LexicalUnit lexicalUnit, ValueFactory valueFactory) {
            LexicalUnit lexicalUnit2;
            int n = 0;
            if (!this.isLinearColorStop(lexicalUnit) && (lexicalUnit = this.processNonColorStop(lexicalUnit, valueFactory)) != null && !this.isLinearColorStop(lexicalUnit)) {
                lexicalUnit = this.processNonColorStop(lexicalUnit, valueFactory);
            }
            if ((lexicalUnit2 = lexicalUnit) == null) {
                throw this.createDOMSyntaxException("Missing color stop");
            }
            do {
                lexicalUnit2 = this.processLinearColorStop(lexicalUnit2, valueFactory);
                ++n;
                if (lexicalUnit2 == null) continue;
                if (lexicalUnit2.getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_COMMA) {
                    lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
                    continue;
                }
                throw this.createDOMSyntaxException("Expected color stops, found: " + lexicalUnit.toString());
            } while (lexicalUnit2 != null);
            if (n < 2) {
                throw this.createDOMSyntaxException("Expected at least 2 color stops, found only one.");
            }
        }

        private LexicalUnit processNonColorStop(LexicalUnit lexicalUnit, ValueFactory valueFactory) {
            ValueList valueList = ValueList.createWSValueList();
            do {
                if (lexicalUnit.getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_COMMA) {
                    if (valueList.isEmpty()) {
                        throw this.createDOMSyntaxException("Found empty argument: " + lexicalUnit.toString());
                    }
                    lexicalUnit = lexicalUnit.getNextLexicalUnit();
                    break;
                }
                valueList.add(valueFactory.createCSSPrimitiveValue(lexicalUnit, true));
            } while ((lexicalUnit = lexicalUnit.getNextLexicalUnit()) != null);
            if (valueList.getLength() != 1) {
                GradientValue.this.getArguments().add(valueList);
            } else {
                GradientValue.this.getArguments().add(valueList.item(0));
            }
            return lexicalUnit;
        }

        private void setConicGradient(LexicalUnit lexicalUnit, ValueFactory valueFactory) {
            LexicalUnit lexicalUnit2;
            int n = 0;
            if (!this.isAngularColorStop(lexicalUnit)) {
                ValueList valueList = ValueList.createWSValueList();
                do {
                    if (lexicalUnit.getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_COMMA) {
                        if (valueList.isEmpty()) {
                            throw this.createDOMSyntaxException("Found empty argument: " + lexicalUnit.toString());
                        }
                        lexicalUnit = lexicalUnit.getNextLexicalUnit();
                        break;
                    }
                    valueList.add(valueFactory.createCSSPrimitiveValue(lexicalUnit, true));
                } while ((lexicalUnit = lexicalUnit.getNextLexicalUnit()) != null);
                if (valueList.getLength() != 1) {
                    GradientValue.this.getArguments().add(valueList);
                } else {
                    GradientValue.this.getArguments().add(valueList.item(0));
                }
            }
            if ((lexicalUnit2 = lexicalUnit) == null) {
                throw this.createDOMSyntaxException("Missing angle, position or color stop in gradient");
            }
            do {
                lexicalUnit2 = this.processAngularColorStop(lexicalUnit2, valueFactory);
                ++n;
                if (lexicalUnit2 == null) continue;
                if (lexicalUnit2.getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_COMMA) {
                    lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
                    continue;
                }
                throw this.createDOMSyntaxException("Expected color stops, found: " + lexicalUnit.toString());
            } while (lexicalUnit2 != null);
            if (n < 2) {
                throw this.createDOMSyntaxException("Expected at least 2 color stops, found only one.");
            }
        }

        private boolean isAngularColorStop(LexicalUnit lexicalUnit) {
            LexicalUnit lexicalUnit2 = lexicalUnit.getNextLexicalUnit();
            if (this.canBeColor(lexicalUnit)) {
                return true;
            }
            return lexicalUnit2 != null && this.canBeColor(lexicalUnit2) && this.canBeAngleOrPercentage(lexicalUnit);
        }

        private boolean canBeAngleOrPercentage(LexicalUnit lexicalUnit) {
            LexicalUnit lexicalUnit2;
            return ValueFactory.isAngleSACUnit(lexicalUnit) || lexicalUnit.getLexicalUnitType() == LexicalUnit.LexicalType.PERCENTAGE || LexicalUnit.LexicalType.VAR == lexicalUnit.getLexicalUnitType() && this.isAngleOrPercentageVar(lexicalUnit) || LexicalUnit.LexicalType.ATTR == lexicalUnit.getLexicalUnitType() && ((lexicalUnit2 = lexicalUnit.shallowClone()).matches(SyntaxParser.createSimpleSyntax("angle")) != CSSValueSyntax.Match.FALSE || lexicalUnit2.matches(SyntaxParser.createSimpleSyntax("percentage")) != CSSValueSyntax.Match.FALSE);
        }

        private boolean isAngleOrPercentageVar(LexicalUnit lexicalUnit) {
            LexicalUnit lexicalUnit2 = GradientValue.findCustomPropertyFallback(lexicalUnit);
            if (lexicalUnit2 != null) {
                return ValueFactory.isAngleSACUnit(lexicalUnit2) || lexicalUnit2.getLexicalUnitType() == LexicalUnit.LexicalType.PERCENTAGE;
            }
            throw new CSSLexicalProcessingException("var() without fallback found.");
        }

        private LexicalUnit processAngularColorStop(LexicalUnit lexicalUnit, ValueFactory valueFactory) {
            LexicalUnit lexicalUnit2 = null;
            LexicalUnit lexicalUnit3 = lexicalUnit.getNextLexicalUnit();
            if (this.canBeColor(lexicalUnit)) {
                PrimitiveValue primitiveValue;
                try {
                    primitiveValue = valueFactory.createCSSPrimitiveValue(lexicalUnit, true);
                }
                catch (CSSLexicalProcessingException cSSLexicalProcessingException) {
                    PrimitiveValue.LexicalSetter lexicalSetter = new LexicalValue().newLexicalSetter();
                    lexicalSetter.setLexicalUnit(lexicalUnit.shallowClone());
                    primitiveValue = lexicalSetter.getCSSValue();
                }
                if (lexicalUnit3 != null && this.canBeAngleOrPercentage(lexicalUnit3)) {
                    ValueList valueList = ValueList.createWSValueList();
                    valueList.add(primitiveValue);
                    valueList.add(valueFactory.createCSSPrimitiveValue(lexicalUnit3, true));
                    GradientValue.this.getArguments().add(valueList);
                    lexicalUnit3 = lexicalUnit3.getNextLexicalUnit();
                    if (lexicalUnit3 != null && this.canBeAngleOrPercentage(lexicalUnit3)) {
                        valueList.add(valueFactory.createCSSPrimitiveValue(lexicalUnit3, true));
                        lexicalUnit3 = lexicalUnit3.getNextLexicalUnit();
                    }
                } else {
                    GradientValue.this.getArguments().add(primitiveValue);
                }
                lexicalUnit2 = lexicalUnit3;
            } else if (lexicalUnit3 != null && this.canBeColor(lexicalUnit3) && this.canBeAngleOrPercentage(lexicalUnit)) {
                PrimitiveValue primitiveValue;
                ValueList valueList = ValueList.createWSValueList();
                try {
                    primitiveValue = valueFactory.createCSSPrimitiveValue(lexicalUnit3, true);
                }
                catch (CSSLexicalProcessingException cSSLexicalProcessingException) {
                    PrimitiveValue.LexicalSetter lexicalSetter = new LexicalValue().newLexicalSetter();
                    lexicalSetter.setLexicalUnit(lexicalUnit3.shallowClone());
                    primitiveValue = lexicalSetter.getCSSValue();
                }
                valueList.add(primitiveValue);
                valueList.add(valueFactory.createCSSPrimitiveValue(lexicalUnit, true));
                GradientValue.this.getArguments().add(valueList);
                lexicalUnit2 = lexicalUnit3.getNextLexicalUnit();
            } else if (this.canBeAngleOrPercentage(lexicalUnit)) {
                GradientValue.this.getArguments().add(valueFactory.createCSSPrimitiveValue(lexicalUnit, true));
                lexicalUnit2 = lexicalUnit3;
            } else {
                throw this.createDOMSyntaxException("Bad angular color stop");
            }
            return lexicalUnit2;
        }
    }
}

