/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.os;

import com.jogamp.common.jvm.JNILibLoaderBase;
import com.jogamp.common.net.Uri;
import com.jogamp.common.os.Clock;
import com.jogamp.common.os.DynamicLibraryBundle;
import com.jogamp.common.os.MachineDataInfo;
import com.jogamp.common.util.JarUtil;
import com.jogamp.common.util.PropertyAccess;
import com.jogamp.common.util.ReflectionUtil;
import com.jogamp.common.util.SecurityUtil;
import com.jogamp.common.util.VersionNumber;
import com.jogamp.common.util.cache.TempJarCache;
import java.security.PrivilegedAction;
import java.util.concurrent.TimeUnit;
import jogamp.common.Debug;
import jogamp.common.jvm.JVMUtil;
import jogamp.common.os.MachineDataInfoRuntime;
import jogamp.common.os.PlatformPropsImpl;

public class Platform
extends PlatformPropsImpl {
    private static final String useTempJarCachePropName = "jogamp.gluegen.UseTempJarCache";
    private static final String libBaseName = "gluegen_rt";
    public static final boolean USE_TEMP_JAR_CACHE;
    private static final MachineDataInfo machineDescription;
    public static final boolean AWT_AVAILABLE;
    private static final boolean isRunningFromJarURL;

    private Platform() {
    }

    public static final boolean isRunningFromJarURL() {
        return isRunningFromJarURL;
    }

    public static void initSingleton() {
    }

    public static boolean isLittleEndian() {
        return LITTLE_ENDIAN;
    }

    public static String getOSName() {
        return OS;
    }

    public static String getOSVersion() {
        return OS_VERSION;
    }

    public static VersionNumber getOSVersionNumber() {
        return OS_VERSION_NUMBER;
    }

    public static String getArchName() {
        return ARCH;
    }

    public static OSType getOSType() {
        return OS_TYPE;
    }

    public static CPUFamily getCPUFamily() {
        return Platform.CPU_ARCH.family;
    }

    public static CPUType getCPUType() {
        return CPU_ARCH;
    }

    public static boolean is32Bit() {
        return Platform.CPU_ARCH.is32Bit;
    }

    public static boolean is64Bit() {
        return !Platform.CPU_ARCH.is32Bit;
    }

    public static ABIType getABIType() {
        return ABI_TYPE;
    }

    public static String getOSAndArch() {
        return os_and_arch;
    }

    public static String getJavaVendor() {
        return JAVA_VENDOR;
    }

    public static String getJavaVMName() {
        return JAVA_VM_NAME;
    }

    public static String getJavaRuntimeName() {
        return JAVA_RUNTIME_NAME;
    }

    public static String getJavaVendorURL() {
        return JAVA_VENDOR_URL;
    }

    public static String getJavaVersion() {
        return JAVA_VERSION;
    }

    public static VersionNumber getJavaVersionNumber() {
        return JAVA_VERSION_NUMBER;
    }

    public static String getNewline() {
        return NEWLINE;
    }

    public static MachineDataInfo getMachineDataInfo() {
        return machineDescription;
    }

    public static boolean isAWTAvailable() {
        return AWT_AVAILABLE;
    }

    public static long currentTimeMillis() {
        return Clock.currentTimeMillis();
    }

    public static synchronized long getCurrentSleepJitter() {
        Platform.getCurrentSleepJitterImpl(TimeUnit.MILLISECONDS.toNanos(10L), 10);
        return Platform.getCurrentSleepJitterImpl(TimeUnit.MILLISECONDS.toNanos(10L), 10);
    }

    private static long getCurrentSleepJitterImpl(long l, int n) {
        long l2 = l / (long)n;
        long l3 = Clock.currentNanos();
        for (int i = n; i > 0; --i) {
            try {
                TimeUnit.NANOSECONDS.sleep(l2);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return (Clock.currentNanos() - l3 - l) / (long)n;
    }

    static {
        final boolean[] blArray = new boolean[]{false};
        final boolean[] blArray2 = new boolean[]{false};
        final boolean[] blArray3 = new boolean[]{false};
        SecurityUtil.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                PlatformPropsImpl.initSingleton();
                ClassLoader classLoader = Platform.class.getClassLoader();
                Uri uri = null;
                try {
                    uri = JarUtil.getJarUri(Platform.class.getName(), classLoader);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Uri uri2 = uri;
                blArray[0] = null != uri2;
                boolean bl = blArray2[0] = PlatformPropsImpl.OS_TYPE != OSType.ANDROID && PlatformPropsImpl.OS_TYPE != OSType.IOS && null != uri2 && PropertyAccess.getBooleanProperty(Platform.useTempJarCachePropName, true, true);
                if (blArray2[0] && TempJarCache.initSingleton() && TempJarCache.isInitialized(true)) {
                    try {
                        JNILibLoaderBase.addNativeJarLibs(new Class[]{Debug.class}, null);
                    }
                    catch (Exception exception) {
                        System.err.println("Caught " + exception.getClass().getSimpleName() + ": " + exception.getMessage() + ", while JNILibLoaderBase.addNativeJarLibs(..)");
                    }
                }
                DynamicLibraryBundle.GlueJNILibLoader.loadLibrary(Platform.libBaseName, false, classLoader);
                JVMUtil.initSingleton();
                if (!PropertyAccess.getBooleanProperty("java.awt.headless", true) && ReflectionUtil.isClassAvailable("java.awt.Component", classLoader) && ReflectionUtil.isClassAvailable("java.awt.GraphicsEnvironment", classLoader)) {
                    try {
                        blArray3[0] = false == (Boolean)ReflectionUtil.callStaticMethod("java.awt.GraphicsEnvironment", "isHeadless", null, null, classLoader);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                return null;
            }
        });
        isRunningFromJarURL = blArray[0];
        USE_TEMP_JAR_CACHE = blArray2[0];
        AWT_AVAILABLE = blArray3[0];
        MachineDataInfoRuntime.initialize();
        machineDescription = MachineDataInfoRuntime.getRuntime();
    }

    public static enum ABIType {
        GENERIC_ABI(0),
        EABI_GNU_ARMEL(1),
        EABI_GNU_ARMHF(2),
        EABI_AARCH64(3);

        public final int id;

        private ABIType(int n2) {
            this.id = n2;
        }

        public final boolean isCompatible(ABIType aBIType) {
            if (null == aBIType) {
                return false;
            }
            return aBIType == this;
        }

        public static final ABIType query(CPUType cPUType, String string) {
            if (null == cPUType) {
                throw new IllegalArgumentException("Null cpuType");
            }
            if (null == string) {
                throw new IllegalArgumentException("Null cpuABILower");
            }
            if (CPUFamily.ARM == cPUType.family) {
                if (!cPUType.is32Bit) {
                    return EABI_AARCH64;
                }
                if (string.equals("armeabi-v7a-hard")) {
                    return EABI_GNU_ARMHF;
                }
                return EABI_GNU_ARMEL;
            }
            return GENERIC_ABI;
        }
    }

    public static enum CPUFamily {
        X86,
        ARM,
        PPC,
        SPARC,
        MIPS,
        PA_RISC,
        IA64,
        SuperH;

    }

    public static enum CPUType {
        ARM(CPUFamily.ARM, true),
        ARMv5(CPUFamily.ARM, true),
        ARMv6(CPUFamily.ARM, true),
        ARMv7(CPUFamily.ARM, true),
        X86_32(CPUFamily.X86, true),
        PPC(CPUFamily.PPC, true),
        MIPS_32(CPUFamily.MIPS, true),
        SuperH(CPUFamily.SuperH, true),
        SPARC_32(CPUFamily.SPARC, true),
        ARM64(CPUFamily.ARM, false),
        ARMv8_A(CPUFamily.ARM, false),
        X86_64(CPUFamily.X86, false),
        PPC64(CPUFamily.PPC, false),
        MIPS_64(CPUFamily.MIPS, false),
        IA64(CPUFamily.IA64, false),
        SPARCV9_64(CPUFamily.SPARC, false),
        PA_RISC2_0(CPUFamily.PA_RISC, false);

        public final CPUFamily family;
        public final boolean is32Bit;

        private CPUType(CPUFamily cPUFamily, boolean bl) {
            this.family = cPUFamily;
            this.is32Bit = bl;
        }

        public final boolean isCompatible(CPUType cPUType) {
            if (null == cPUType) {
                return false;
            }
            if (cPUType == this) {
                return true;
            }
            return this.family == cPUType.family && this.is32Bit == cPUType.is32Bit;
        }

        public static final CPUType query(String string) {
            if (null == string) {
                throw new IllegalArgumentException("Null cpuABILower arg");
            }
            if (string.equals("x86") || string.equals("i386") || string.equals("i486") || string.equals("i586") || string.equals("i686")) {
                return X86_32;
            }
            if (string.equals("x86_64") || string.equals("amd64")) {
                return X86_64;
            }
            if (string.equals("ia64")) {
                return IA64;
            }
            if (string.equals("aarch64")) {
                return ARM64;
            }
            if (string.startsWith("arm")) {
                if (string.equals("armv8-a") || string.equals("arm-v8-a") || string.equals("arm-8-a") || string.equals("arm64-v8a")) {
                    return ARMv8_A;
                }
                if (string.startsWith("arm64")) {
                    return ARM64;
                }
                if (string.startsWith("armv7") || string.startsWith("arm-v7") || string.startsWith("arm-7") || string.startsWith("armeabi-v7")) {
                    return ARMv7;
                }
                if (string.startsWith("armv5") || string.startsWith("arm-v5") || string.startsWith("arm-5")) {
                    return ARMv5;
                }
                if (string.startsWith("armv6") || string.startsWith("arm-v6") || string.startsWith("arm-6")) {
                    return ARMv6;
                }
                return ARM;
            }
            if (string.equals("sparcv9")) {
                return SPARCV9_64;
            }
            if (string.equals("sparc")) {
                return SPARC_32;
            }
            if (string.equals("pa_risc2.0")) {
                return PA_RISC2_0;
            }
            if (string.startsWith("ppc64")) {
                return PPC64;
            }
            if (string.startsWith("ppc")) {
                return PPC;
            }
            if (string.startsWith("mips64")) {
                return MIPS_64;
            }
            if (string.startsWith("mips")) {
                return MIPS_32;
            }
            if (string.startsWith("superh")) {
                return SuperH;
            }
            throw new RuntimeException("Please port CPUType detection to your platform (CPU_ABI string '" + string + "')");
        }
    }

    public static enum OSType {
        LINUX,
        FREEBSD,
        ANDROID,
        MACOS,
        SUNOS,
        HPUX,
        WINDOWS,
        OPENKODE,
        IOS;

    }
}

