/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.knopflerfish.framework.BundleArchive;
import org.knopflerfish.framework.BundleClassLoader;
import org.knopflerfish.framework.BundleContextImpl;
import org.knopflerfish.framework.BundleGeneration;
import org.knopflerfish.framework.BundlePackages;
import org.knopflerfish.framework.BundleResourceStream;
import org.knopflerfish.framework.BundleRevisionImpl;
import org.knopflerfish.framework.BundleRevisionsImpl;
import org.knopflerfish.framework.BundleThread;
import org.knopflerfish.framework.ExportPkg;
import org.knopflerfish.framework.FileTree;
import org.knopflerfish.framework.Fragment;
import org.knopflerfish.framework.FrameworkContext;
import org.knopflerfish.framework.HeaderDictionary;
import org.knopflerfish.framework.MainClassBundleActivator;
import org.knopflerfish.framework.PermissionOps;
import org.knopflerfish.framework.Resolver;
import org.knopflerfish.framework.ServiceRegistrationImpl;
import org.knopflerfish.framework.SystemBundle;
import org.knopflerfish.framework.Util;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.framework.dto.BundleDTO;
import org.osgi.framework.dto.ServiceReferenceDTO;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.startlevel.dto.BundleStartLevelDTO;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleRevisions;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.framework.wiring.dto.BundleRevisionDTO;
import org.osgi.framework.wiring.dto.BundleWiringDTO;

public class BundleImpl
implements Bundle {
    final FrameworkContext fwCtx;
    final long id;
    final String location;
    PermissionOps secure;
    volatile int state;
    protected final Vector<BundleGeneration> generations;
    protected FileTree bundleDir = null;
    protected BundleContextImpl bundleContext = null;
    protected BundleActivator bactivator = null;
    private volatile HeaderDictionary cachedHeaders = null;
    protected volatile int operation;
    static final int IDLE = 0;
    static final int ACTIVATING = 1;
    static final int DEACTIVATING = 2;
    static final int RESOLVING = 3;
    static final int UNINSTALLING = 4;
    static final int UNRESOLVING = 5;
    static final int UPDATING = 6;
    private BundleException resolveFailException;
    private boolean wasStarted;
    volatile Boolean aborted;
    private BundleThread bundleThread;

    BundleImpl(FrameworkContext fw) {
        this.fwCtx = fw;
        this.secure = this.fwCtx.perm;
        this.id = 0L;
        this.generations = new Vector(1);
        this.location = "System Bundle";
        this.state = 2;
        this.bundleDir = this.fwCtx.getDataStorage(this.id);
    }

    BundleImpl(FrameworkContext fw, BundleArchive ba, Object checkContext, Bundle caller) throws BundleException {
        this.fwCtx = fw;
        this.secure = this.fwCtx.perm;
        this.id = ba.getBundleId();
        this.location = ba.getBundleLocation();
        this.state = 2;
        this.generations = new Vector(2);
        BundleGeneration gen = new BundleGeneration(this, ba, null, caller);
        this.generations.add(gen);
        gen.checkPermissions(checkContext);
        this.doExportImport();
        this.bundleDir = this.fwCtx.getDataStorage(this.id);
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    public void start() throws BundleException {
        this.start(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(int options) throws BundleException {
        this.secure.checkExecuteAdminPerm(this);
        Resolver resolver = this.fwCtx.resolver;
        synchronized (resolver) {
            BundleGeneration current = this.current();
            if (current.isFragment()) {
                throw new BundleException("Bundle#" + this.id + ", cannot start a fragment bundle", 2);
            }
            if (this.state == 1) {
                throw new IllegalStateException("Bundle is uninstalled");
            }
            this.fwCtx.resolverHooks.checkResolveBlocked();
            options &= 0xFF;
            if (this.fwCtx.startLevelController != null && this.getStartLevel() > this.fwCtx.startLevelController.getStartLevel()) {
                if ((options & 1) != 0) {
                    throw new BundleException("Bundle#" + this.id + ", can not transiently activate bundle with start level " + this.getStartLevel() + " when running on start level " + this.fwCtx.startLevelController.getStartLevel(), 10);
                }
                this.setAutostartSetting(options);
                return;
            }
            this.waitOnOperation(this.fwCtx.resolver, "Bundle.start", false);
            if (this.state == 32) {
                return;
            }
            if ((options & 1) == 0) {
                this.setAutostartSetting(options);
            }
            if ((options & 2) != 0 && current.lazyActivation) {
                if (2 == this.getUpdatedState(new BundleImpl[]{this}, false)) {
                    throw this.resolveFailException;
                }
                if (8 == this.state) {
                    return;
                }
            } else {
                this.secure.callFinalizeActivation(this);
                return;
            }
            this.state = 8;
            this.bundleContext = new BundleContextImpl(this);
            this.operation = 1;
        }
        this.secure.callBundleChanged(this.fwCtx, new BundleEvent(512, this));
        resolver = this.fwCtx.resolver;
        synchronized (resolver) {
            this.operation = 0;
            this.fwCtx.resolver.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finalizeActivation() throws BundleException {
        Resolver resolver = this.fwCtx.resolver;
        synchronized (resolver) {
            switch (this.getUpdatedState(new BundleImpl[]{this}, false)) {
                case 2: {
                    throw this.resolveFailException;
                }
                case 8: {
                    if (this.operation == 1) {
                        return;
                    }
                }
                case 4: {
                    this.state = 8;
                    this.operation = 1;
                    if (this.fwCtx.debug.lazy_activation) {
                        this.fwCtx.debug.println("activating #" + this.getBundleId());
                    }
                    if (null == this.bundleContext) {
                        this.bundleContext = new BundleContextImpl(this);
                    }
                    BundleException e = this.bundleThread().callStart0(this);
                    this.operation = 0;
                    this.fwCtx.resolver.notifyAll();
                    if (e == null) break;
                    throw e;
                }
                case 32: {
                    break;
                }
                case 16: {
                    throw new BundleException("Bundle#" + this.id + ", start called from BundleActivator.stop", 5);
                }
                case 1: {
                    throw new IllegalStateException("Bundle is in UNINSTALLED state");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    BundleException start0() {
        BundleArchive archive = this.current().archive;
        String ba = archive.getAttribute("Bundle-Activator");
        boolean bStarted = false;
        BundleException res = null;
        this.fwCtx.listeners.bundleChanged(new BundleEvent(128, this));
        ClassLoader oldLoader = null;
        if (this.fwCtx.props.SETCONTEXTCLASSLOADER) {
            oldLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClassLoader());
        }
        int error_type = 3;
        try {
            if (ba != null) {
                Class<?> c = this.getClassLoader().loadClass(ba.trim());
                error_type = 5;
                this.bactivator = (BundleActivator)c.newInstance();
                this.bactivator.start(this.bundleContext);
                bStarted = true;
            } else {
                String mc;
                String locations = this.fwCtx.props.getProperty("org.knopflerfish.framework.main.class.activation");
                if (locations.length() > 0 && (mc = archive.getAttribute("Main-Class")) != null) {
                    String[] locs;
                    for (String loc : locs = Util.splitwords(locations, ",")) {
                        if (!loc.equals(this.location)) continue;
                        if (this.fwCtx.debug.resolver) {
                            this.fwCtx.debug.println("starting main class " + mc);
                        }
                        error_type = 5;
                        Class<?> mainClass = this.getClassLoader().loadClass(mc.trim());
                        this.bactivator = new MainClassBundleActivator(mainClass);
                        this.bactivator.start(this.bundleContext);
                        bStarted = true;
                        break;
                    }
                }
            }
            if (bStarted) {
                // empty if block
            }
        }
        catch (Throwable t) {
            res = new BundleException("Bundle#" + this.id + " start failed", error_type, t);
        }
        Resolver resolver = this.fwCtx.resolver;
        // MONITORENTER : resolver
        if (!this.isBundleThread(Thread.currentThread())) {
            throw new RuntimeException("Aborted bundle thread ending execution");
        }
        Exception cause = null;
        if (this.aborted == Boolean.TRUE) {
            cause = 1 == this.state ? new Exception("Bundle uninstalled during start()") : new Exception("Bundle activator start() time-out");
        } else {
            this.aborted = Boolean.FALSE;
            if (8 != this.state) {
                cause = new Exception("Bundle changed state because of refresh during start()");
            }
        }
        if (cause != null) {
            res = new BundleException("Bundle#" + this.id + " start failed", 7, cause);
        }
        // MONITOREXIT : resolver
        if (this.fwCtx.debug.lazy_activation) {
            this.fwCtx.debug.println("activating #" + this.getBundleId() + " completed.");
        }
        if (this.fwCtx.props.SETCONTEXTCLASSLOADER) {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
        if (res == null) {
            this.state = 32;
            this.fwCtx.listeners.bundleChanged(new BundleEvent(2, this));
            return res;
        }
        if (this.operation != 1) return res;
        this.startFailed();
        return res;
    }

    void startFailed() {
        this.state = 16;
        this.fwCtx.listeners.bundleChanged(new BundleEvent(256, this));
        this.removeBundleResources();
        this.bundleContext.invalidate();
        this.bundleContext = null;
        this.state = 4;
        this.fwCtx.listeners.bundleChanged(new BundleEvent(4, this));
    }

    @Override
    public void stop() throws BundleException {
        this.stop(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(int options) throws BundleException {
        Exception savedException = null;
        this.secure.checkExecuteAdminPerm(this);
        Resolver resolver = this.fwCtx.resolver;
        synchronized (resolver) {
            if (this.current().isFragment()) {
                throw new BundleException("Bundle#" + this.id + ", can not stop a fragment", 2);
            }
            if (this.state == 1) {
                throw new IllegalStateException("Bundle is uninstalled");
            }
            this.waitOnOperation(this.fwCtx.resolver, "Bundle.stop", false);
            if ((options & 1) == 0) {
                this.setAutostartSetting(-1);
            }
            switch (this.state) {
                case 1: 
                case 2: 
                case 4: 
                case 16: {
                    return;
                }
                case 8: 
                case 32: {
                    savedException = this.stop0();
                }
            }
        }
        if (savedException != null) {
            if (savedException instanceof BundleException) {
                throw (BundleException)savedException;
            }
            throw (RuntimeException)savedException;
        }
    }

    Exception stop0() {
        this.wasStarted = this.state == 32;
        this.state = 16;
        this.operation = 2;
        BundleException savedException = this.bundleThread().callStop1(this);
        if (this.state != 1) {
            this.state = 4;
            this.bundleThread().bundleChanged(new BundleEvent(4, this));
            this.fwCtx.resolver.notifyAll();
            this.operation = 0;
        }
        return savedException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Exception stop1() {
        BundleException res = null;
        this.fwCtx.listeners.bundleChanged(new BundleEvent(256, this));
        if (this.wasStarted && this.bactivator != null) {
            try {
                this.bactivator.stop(this.bundleContext);
            }
            catch (Throwable e) {
                res = new BundleException("Bundle#" + this.id + ", BundleActivator.stop() failed", 5, e);
            }
            Resolver resolver = this.fwCtx.resolver;
            synchronized (resolver) {
                Exception cause = null;
                if (this.aborted == Boolean.TRUE) {
                    cause = 1 == this.state ? new Exception("Bundle uninstalled during stop()") : new Exception("Bundle activator stop() time-out");
                } else {
                    this.aborted = Boolean.FALSE;
                    if (16 != this.state) {
                        cause = new Exception("Bundle changed state because of refresh during stop()");
                    }
                }
                if (cause != null) {
                    res = new BundleException("Bundle stop failed", 7, cause);
                }
            }
            this.bactivator = null;
        }
        if (this.operation == 2) {
            this.stop2();
        }
        return res;
    }

    void stop2() {
        if (null != this.bundleContext) {
            this.fwCtx.listeners.serviceListeners.hooksBundleStopped(this.bundleContext);
            this.removeBundleResources();
            this.bundleContext.invalidate();
            this.bundleContext = null;
        }
    }

    void waitOnOperation(Object lock, String src, boolean longWait) throws BundleException {
        if (this.operation != 0) {
            String op;
            long left = longWait ? 20000L : 500L;
            long waitUntil = Util.timeMillis() + left;
            do {
                try {
                    lock.wait(left);
                    if (this.operation == 0) {
                        return;
                    }
                }
                catch (InterruptedException _ie) {
                    // empty catch block
                }
            } while ((left = waitUntil - Util.timeMillis()) > 0L);
            switch (this.operation) {
                case 0: {
                    return;
                }
                case 1: {
                    op = "start";
                    break;
                }
                case 2: {
                    op = "stop";
                    break;
                }
                case 3: {
                    op = "resolve";
                    break;
                }
                case 4: {
                    op = "uninstall";
                    break;
                }
                case 5: {
                    op = "unresolve";
                    break;
                }
                case 6: {
                    op = "update";
                    break;
                }
                default: {
                    op = "unknown operation";
                }
            }
            throw new BundleException(src + " called during " + op + " of Bundle#" + this.id, 7);
        }
    }

    @Override
    public void update() throws BundleException {
        this.update(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(InputStream in) throws BundleException {
        try {
            this.secure.checkLifecycleAdminPerm(this);
            if (this.current().isExtension()) {
                this.secure.checkExtensionLifecycleAdminPerm(this);
            }
            Resolver resolver = this.fwCtx.resolver;
            synchronized (resolver) {
                boolean wasActive = this.state == 32;
                switch (this.getState()) {
                    case 32: {
                        this.stop(1);
                    }
                    case 2: 
                    case 4: {
                        this.secure.callUpdate0(this, in, wasActive);
                        break;
                    }
                    case 8: {
                        throw new IllegalStateException("Bundle is in STARTING state");
                    }
                    case 16: {
                        throw new IllegalStateException("Bundle is in STOPPING state");
                    }
                    case 1: {
                        throw new IllegalStateException("Bundle is in UNINSTALLED state");
                    }
                }
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    void update0(InputStream in, boolean wasActive, Object checkContext) throws BundleException {
        boolean saveZombie;
        boolean wasResolved = this.state == 4;
        BundleGeneration current = this.current();
        Fragment oldFragment = current.fragment;
        int oldStartLevel = this.getStartLevel();
        BundleArchive newArchive = null;
        BundleGeneration newGeneration = null;
        this.operation = 6;
        try {
            InputStream bin;
            BundleArchive archive = current.archive;
            if (in == null) {
                File file;
                URL url;
                String fname;
                String update;
                String string = update = archive != null ? archive.getAttribute("Bundle-UpdateLocation") : null;
                if (update == null) {
                    update = this.location;
                }
                if ((fname = (url = new URL(update)).getFile()).startsWith("file:")) {
                    fname = fname.substring(5);
                }
                bin = (file = new File(fname)).isDirectory() ? null : url.openStream();
            } else {
                bin = in;
            }
            newArchive = this.fwCtx.storage.updateBundleArchive(archive, bin);
            newGeneration = new BundleGeneration(this, newArchive, current, this);
            newGeneration.checkPermissions(checkContext);
            newArchive.setStartLevel(oldStartLevel);
            this.fwCtx.storage.replaceBundleArchive(archive, newGeneration.archive);
        }
        catch (Exception e) {
            if (newArchive != null) {
                newArchive.purge();
            }
            this.operation = 0;
            if (wasActive) {
                try {
                    this.start();
                }
                catch (BundleException be) {
                    this.fwCtx.frameworkError(this, (Throwable)be, new FrameworkListener[0]);
                }
            }
            if (e instanceof BundleException) {
                throw (BundleException)e;
            }
            throw new BundleException("Failed to get update Bundle#" + this.id, 0, e);
        }
        if (oldFragment != null) {
            saveZombie = oldFragment.hasHosts();
            if (saveZombie) {
                if (oldFragment.extension != null) {
                    if (oldFragment.extension.equals("bootclasspath")) {
                        this.fwCtx.systemBundle.bootClassPathHasChanged = true;
                    }
                } else {
                    for (BundleGeneration bundleGeneration : oldFragment.getHosts()) {
                        bundleGeneration.bpkgs.fragmentIsZombie(this);
                    }
                }
            }
        } else {
            boolean bl = saveZombie = !current.unregisterPackages(false);
            if (!saveZombie) {
                current.closeClassLoader();
            }
        }
        BundleGeneration oldGen = current;
        this.state = 2;
        if (saveZombie) {
            this.generations.add(0, newGeneration);
            this.fwCtx.bundles.addZombie(this);
        } else {
            this.generations.set(0, newGeneration);
        }
        this.doExportImport();
        if (!saveZombie) {
            oldGen.purge(false);
        }
        if (wasResolved) {
            this.bundleThread().bundleChanged(new BundleEvent(64, this));
        }
        this.bundleThread().bundleChanged(new BundleEvent(8, this));
        this.operation = 0;
        if (wasActive) {
            try {
                this.start();
            }
            catch (BundleException be) {
                this.fwCtx.frameworkError(this, (Throwable)be, new FrameworkListener[0]);
            }
        }
    }

    @Override
    public void uninstall() throws BundleException {
        this.secure.checkLifecycleAdminPerm(this);
        if (this.current().isExtension()) {
            this.secure.checkExtensionLifecycleAdminPerm(this);
        }
        this.secure.callUninstall0(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void uninstall0() {
        Resolver resolver = this.fwCtx.resolver;
        synchronized (resolver) {
            BundleGeneration current = this.current();
            if (!current.isUninstalled()) {
                try {
                    current.archive.setStartLevel(-2);
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
            boolean doPurge = false;
            switch (this.state) {
                case 1: {
                    throw new IllegalStateException("Bundle is in UNINSTALLED state");
                }
                case 8: 
                case 16: 
                case 32: {
                    Exception exception;
                    try {
                        this.waitOnOperation(this.fwCtx.resolver, "Bundle.uninstall", true);
                        exception = (this.state & 0x28) != 0 ? this.stop0() : null;
                    }
                    catch (Exception se) {
                        this.setStateInstalled(false);
                        this.fwCtx.resolver.notifyAll();
                        exception = se;
                    }
                    this.operation = 4;
                    if (exception != null) {
                        this.fwCtx.frameworkError(this, (Throwable)exception, new FrameworkListener[0]);
                    }
                }
                case 2: 
                case 4: {
                    this.fwCtx.bundles.remove(this.location);
                    if (this.operation != 4) {
                        try {
                            this.waitOnOperation(this.fwCtx.resolver, "Bundle.uninstall", true);
                            this.operation = 4;
                        }
                        catch (BundleException be) {
                            if (this.bundleContext != null) {
                                this.bundleContext.invalidate();
                                this.bundleContext = null;
                            }
                            this.operation = 4;
                            this.fwCtx.frameworkError(this, (Throwable)be, new FrameworkListener[0]);
                        }
                    }
                    if (this.state == 1) {
                        this.operation = 0;
                        throw new IllegalStateException("Bundle is in UNINSTALLED state");
                    }
                    boolean saveZombie = false;
                    if (current.isFragment()) {
                        if (!current.unregisterPackages(false)) {
                            throw new RuntimeException("Internal error! fragment packages shouldn't be used");
                        }
                        if (this.isAttached()) {
                            if (current.isExtension()) {
                                if (current.isBootClassPathExtension()) {
                                    this.fwCtx.systemBundle.bootClassPathHasChanged = true;
                                }
                            } else {
                                for (BundleGeneration hbg : current.getHosts()) {
                                    if (hbg.bpkgs == null) continue;
                                    hbg.bpkgs.fragmentIsZombie(this);
                                }
                            }
                            saveZombie = true;
                        } else {
                            doPurge = true;
                        }
                    } else {
                        boolean pkgsUnregistered = current.unregisterPackages(false);
                        if (pkgsUnregistered) {
                            current.closeClassLoader();
                            doPurge = true;
                        } else {
                            saveZombie = true;
                        }
                    }
                    this.state = 2;
                    this.bundleThread().bundleChanged(new BundleEvent(64, this));
                    this.cachedHeaders = current.getHeaders0(null);
                    this.bactivator = null;
                    this.state = 1;
                    BundleGeneration oldGen = current;
                    if (saveZombie) {
                        this.generations.add(0, new BundleGeneration(oldGen));
                        this.fwCtx.bundles.addZombie(this);
                    } else {
                        this.generations.set(0, new BundleGeneration(oldGen));
                    }
                    if (doPurge) {
                        oldGen.purge(false);
                    }
                    this.operation = 0;
                    if (this.bundleDir != null) {
                        if (this.bundleDir.exists() && !this.bundleDir.delete()) {
                            this.fwCtx.frameworkError(this, (Throwable)new IOException("Failed to delete bundle data"), new FrameworkListener[0]);
                        }
                        this.bundleDir = null;
                    }
                    this.fwCtx.resolver.notifyAll();
                }
            }
        }
        this.fwCtx.listeners.bundleChanged(new BundleEvent(16, this));
    }

    @Override
    public Dictionary<String, String> getHeaders() {
        return this.getHeaders(null);
    }

    @Override
    public long getBundleId() {
        return this.id;
    }

    @Override
    public String getLocation() {
        this.secure.checkMetadataAdminPerm(this);
        return this.location;
    }

    @Override
    public ServiceReference<?>[] getRegisteredServices() {
        this.checkUninstalled();
        Set<ServiceRegistrationImpl<?>> sr = this.fwCtx.services.getRegisteredByBundle(this);
        this.secure.filterGetServicePermission(sr);
        if (sr.size() > 0) {
            ServiceReference[] res = new ServiceReference[sr.size()];
            int pos = 0;
            for (ServiceRegistrationImpl<?> serviceRegistrationImpl : sr) {
                res[pos++] = serviceRegistrationImpl.getReference();
            }
            return res;
        }
        return null;
    }

    @Override
    public ServiceReference<?>[] getServicesInUse() {
        this.checkUninstalled();
        Set<ServiceRegistrationImpl<?>> sr = this.fwCtx.services.getUsedByBundle(this);
        this.secure.filterGetServicePermission(sr);
        if (sr.size() > 0) {
            ServiceReference[] res = new ServiceReference[sr.size()];
            int pos = 0;
            for (ServiceRegistrationImpl<?> serviceRegistrationImpl : sr) {
                res[pos++] = serviceRegistrationImpl.getReference();
            }
            return res;
        }
        return null;
    }

    @Override
    public boolean hasPermission(Object permission) {
        BundleGeneration fix = this.current();
        this.checkUninstalled();
        if (permission instanceof Permission) {
            if (this.secure.checkPermissions()) {
                PermissionCollection pc = fix.getProtectionDomain().getPermissions();
                return pc != null ? pc.implies((Permission)permission) : false;
            }
            return true;
        }
        return false;
    }

    @Override
    public BundleContext getBundleContext() {
        this.secure.checkContextAdminPerm(this);
        return this.bundleContext;
    }

    @Override
    public URL getResource(String name) {
        this.checkUninstalled();
        if (this.secure.okResourceAdminPerm(this) && !this.current().isFragment()) {
            if (this.getUpdatedState(new BundleImpl[]{this}, false) != 2) {
                ClassLoader cl0 = this.getClassLoader();
                if (cl0 != null) {
                    return cl0.getResource(name);
                }
            } else {
                Vector<URL> uv = this.secure.getBundleClassPathEntries(this.current(), name, true);
                if (uv != null) {
                    return uv.firstElement();
                }
            }
        }
        return null;
    }

    @Override
    public String getSymbolicName() {
        return this.current().symbolicName;
    }

    @Override
    public long getLastModified() {
        return this.current().timeStamp;
    }

    @Override
    public Map<X509Certificate, List<X509Certificate>> getSignerCertificates(int signersType) {
        ArrayList<List<X509Certificate>> cs;
        boolean onlyTrusted;
        if (signersType == 1) {
            onlyTrusted = false;
        } else if (signersType == 2) {
            onlyTrusted = true;
        } else {
            throw new IllegalArgumentException("signersType not SIGNER_ALL or SIGNERS_TRUSTED");
        }
        BundleArchive fix = this.current().archive;
        if (fix != null && (cs = fix.getCertificateChains(onlyTrusted)) != null) {
            HashMap<X509Certificate, List<X509Certificate>> res = new HashMap<X509Certificate, List<X509Certificate>>();
            for (List list : cs) {
                ArrayList copy = new ArrayList(list);
                res.put((X509Certificate)list.get(0), copy);
            }
            return res;
        }
        return Collections.EMPTY_MAP;
    }

    @Override
    public Version getVersion() {
        return this.current().version;
    }

    @Override
    public <A> A adapt(Class<A> type) {
        this.secure.checkAdaptPerm(this, type);
        return this.adaptSecure(type);
    }

    @Override
    public File getDataFile(String filename) {
        return this.bundleContext.getDataFile(filename);
    }

    @Override
    public int compareTo(Bundle bundle) {
        return new Long(this.getBundleId()).compareTo(new Long(bundle.getBundleId()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getUpdatedState(BundleImpl[] triggers, boolean isResolve) {
        block25: {
            if (this.state == 2) {
                try {
                    Resolver resolver = this.fwCtx.resolver;
                    synchronized (resolver) {
                        this.waitOnOperation(this.fwCtx.resolver, "Bundle.resolve", true);
                        BundleGeneration current = this.current();
                        if (this.state == 2 && (!this.fwCtx.isInit || current.isExtension())) {
                            if (triggers != null) {
                                this.fwCtx.resolverHooks.beginResolve(triggers);
                            }
                            if (current.isFragment()) {
                                List<Object> hosts;
                                if (isResolve) {
                                    hosts = new ArrayList();
                                    List<BundlePackages> bps = this.fwCtx.resolver.getFragBundlePackages(current.bpkgs);
                                    if (bps != null) {
                                        for (BundlePackages bp : bps) {
                                            hosts.add(bp.bg);
                                        }
                                    }
                                } else {
                                    hosts = current.fragment.targets();
                                }
                                if (!hosts.isEmpty()) {
                                    for (BundleGeneration bundleGeneration : hosts) {
                                        if (isResolve || bundleGeneration.bpkgs.isActive()) {
                                            if (current.fragment.isHost(bundleGeneration)) continue;
                                            this.attachToFragmentHost(bundleGeneration, isResolve);
                                            continue;
                                        }
                                        bundleGeneration.bundle.getUpdatedState(null, false);
                                    }
                                }
                                if (this.state == 2 && current.fragment.hasHosts()) {
                                    current.setWired();
                                    this.state = 4;
                                    this.operation = 3;
                                    if (current.isExtension()) {
                                        this.fwCtx.systemBundle.extensionCallStart(this);
                                    }
                                    this.bundleThread().bundleChanged(new BundleEvent(32, this));
                                    this.operation = 0;
                                }
                            } else if (current.resolvePackages(triggers, isResolve)) {
                                current.setWired();
                                this.state = 4;
                                this.operation = 3;
                                if (!isResolve) {
                                    current.updateStateFragments();
                                }
                                this.bundleThread().bundleChanged(new BundleEvent(32, this));
                                this.operation = 0;
                            } else {
                                String reason = current.bpkgs.getResolveFailReason();
                                throw new BundleException("Bundle#" + this.id + ", unable to resolve: " + reason, reason == "ResolverHook Veto" ? 12 : 4);
                            }
                            if (triggers != null && triggers.length == 1) {
                                BundleImpl[] t = triggers;
                                triggers = null;
                                this.fwCtx.resolverHooks.endResolve(t);
                            }
                        }
                    }
                }
                catch (BundleException be) {
                    this.resolveFailException = be;
                    this.fwCtx.frameworkError(this, (Throwable)be, new FrameworkListener[0]);
                    if (triggers == null || triggers.length != 1) break block25;
                    try {
                        this.fwCtx.resolverHooks.endResolve(triggers);
                    }
                    catch (BundleException be2) {
                        this.resolveFailException = be2;
                        this.fwCtx.frameworkError(this, (Throwable)be2, new FrameworkListener[0]);
                    }
                }
            }
        }
        return this.state;
    }

    boolean attachToFragmentHost(BundleGeneration host, boolean isResolve) throws BundleException {
        BundleGeneration fix = this.current();
        if (fix.isFragment() && this.secure.okFragmentBundlePerm(this)) {
            try {
                if (fix.isExtension()) {
                    this.fwCtx.systemBundle.attachExtension(fix);
                } else {
                    host.attachFragment(fix, isResolve);
                }
                fix.fragment.addHost(host);
                return true;
            }
            catch (BundleException be) {
                throw be;
            }
            catch (Exception e) {
                this.fwCtx.frameworkWarning(this, (Throwable)e, new FrameworkListener[0]);
            }
        }
        return false;
    }

    File getDataRoot() {
        return this.bundleDir;
    }

    ClassLoader getClassLoader() {
        return this.current().getClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setStateInstalled(boolean sendEvent) {
        Resolver resolver = this.fwCtx.resolver;
        synchronized (resolver) {
            BundleGeneration current;
            if (this.bundleContext != null) {
                this.bundleContext.invalidate();
                this.bundleContext = null;
            }
            if ((current = this.current()).isFragment()) {
                current.fragment.removeHost(null);
            } else {
                current.closeClassLoader();
                current.unregisterPackages(true);
                current.bpkgs.registerPackages();
            }
            current.clearWiring();
            this.state = 2;
            if (sendEvent) {
                this.operation = 5;
                this.bundleThread().bundleChanged(new BundleEvent(64, this));
            }
            this.operation = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void purge() {
        Vector<BundleGeneration> old;
        this.fwCtx.bundles.removeZombie(this);
        Vector<BundleGeneration> vector = this.generations;
        synchronized (vector) {
            List<BundleGeneration> sub = this.generations.subList(1, this.generations.size());
            old = new Vector<BundleGeneration>(sub);
            sub.clear();
        }
        for (BundleGeneration bg : old) {
            bg.purge(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BundleArchive getBundleArchive(long generation) {
        Vector<BundleGeneration> vector = this.generations;
        synchronized (vector) {
            for (BundleGeneration bg : this.generations) {
                if ((long)bg.generation != generation) continue;
                return bg.archive;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Iterator<ExportPkg> getExports() {
        Vector<BundleGeneration> vector = this.generations;
        synchronized (vector) {
            if (this.generations.size() > 1) {
                HashSet<ExportPkg> res = new HashSet<ExportPkg>();
                for (BundleGeneration bg : this.generations) {
                    BundlePackages bp = bg.bpkgs;
                    if (bp == null) continue;
                    Iterator<ExportPkg> j = bp.getExports();
                    while (j.hasNext()) {
                        res.add(j.next());
                    }
                }
                return res.iterator();
            }
            BundlePackages bp = this.generations.get((int)0).bpkgs;
            if (bp != null) {
                return bp.getExports();
            }
            return Collections.EMPTY_LIST.iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Vector<BundleGeneration> getHosts(boolean zombieHosts) {
        Vector<BundleGeneration> res = null;
        if (zombieHosts) {
            Vector<BundleGeneration> vector = this.generations;
            synchronized (vector) {
                for (BundleGeneration bg : this.generations) {
                    Vector<BundleGeneration> h = bg.getHosts();
                    if (h == null) continue;
                    if (res != null) {
                        res.addAll(h);
                        continue;
                    }
                    res = h;
                }
            }
        } else {
            res = this.current().getHosts();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<BundlePackages> getRequiredBy() {
        List<BundlePackages> res = null;
        Vector<BundleGeneration> vector = this.generations;
        synchronized (vector) {
            for (BundleGeneration bg : this.generations) {
                BundlePackages bp = bg.bpkgs;
                if (bp == null) continue;
                List<BundlePackages> rb = bp.getRequiredBy();
                if (res != null) {
                    res.addAll(rb);
                    continue;
                }
                res = rb;
            }
        }
        return res != null ? res : Collections.EMPTY_LIST;
    }

    void setAutostartSetting(int setting) {
        this.secure.callSetAutostartSetting(this, setting);
    }

    void setAutostartSetting0(int setting) {
        try {
            BundleArchive ba = this.current().archive;
            if (null != ba) {
                ba.setAutostartSetting(setting);
            }
        }
        catch (IOException e) {
            this.fwCtx.frameworkError(this, (Throwable)e, new FrameworkListener[0]);
        }
    }

    int getAutostartSetting() {
        BundleArchive ba = this.current().archive;
        return ba != null ? ba.getAutostartSetting() : -1;
    }

    int getStartLevel() {
        BundleArchive ba = this.current().archive;
        if (ba != null) {
            return ba.getStartLevel();
        }
        return 0;
    }

    void setStartLevel(int n) {
        BundleArchive ba = this.current().archive;
        if (ba != null) {
            try {
                ba.setStartLevel(n);
            }
            catch (Exception e) {
                this.fwCtx.frameworkError(this, (Throwable)new BundleException("Failed to set start level on #" + this.id, e), new FrameworkListener[0]);
            }
        }
    }

    public String toString() {
        return this.toString(0);
    }

    String toString(int detail) {
        StringBuffer sb = new StringBuffer();
        sb.append("Bundle[");
        sb.append("id=" + this.getBundleId());
        if (detail > 0) {
            sb.append(", state=" + this.getState());
        }
        if (detail > 1) {
            sb.append(", startlevel=" + this.getStartLevel());
        }
        if (detail > 3) {
            try {
                sb.append(", autostart setting=");
                sb.append(this.getAutostartSetting());
            }
            catch (Exception e) {
                sb.append(e.toString());
            }
        }
        if (detail > 4) {
            sb.append(", loc=" + this.location);
        }
        if (detail > 4) {
            sb.append(", symName=" + this.getSymbolicName());
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public Enumeration<URL> findEntries(String path, String filePattern, boolean recurse) {
        if (this.secure.okResourceAdminPerm(this)) {
            this.getUpdatedState(new BundleImpl[]{this}, false);
            Vector<URL> res = this.secure.callFindEntries(this.current(), path, filePattern, recurse);
            if (!res.isEmpty()) {
                return res.elements();
            }
        }
        return null;
    }

    @Override
    public URL getEntry(String name) {
        if (this.secure.okResourceAdminPerm(this)) {
            this.checkUninstalled();
            try {
                BundleGeneration fix = this.current();
                if ("/".equals(name)) {
                    return fix.getURL(0, "/");
                }
                BundleResourceStream is = this.secure.callGetBundleResourceStream(fix.archive, name, 0);
                if (is != null) {
                    ((InputStream)is).close();
                    return fix.getURL(0, name);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public Enumeration<String> getEntryPaths(String path) {
        if (this.secure.okResourceAdminPerm(this)) {
            this.checkUninstalled();
            return this.secure.callFindResourcesPath(this.current().archive, path);
        }
        return null;
    }

    @Override
    public Dictionary<String, String> getHeaders(String locale) {
        this.secure.checkMetadataAdminPerm(this);
        HeaderDictionary res = this.secure.callGetHeaders0(this.current(), locale);
        if (res == null && this.cachedHeaders != null) {
            res = this.cachedHeaders.cloneHD();
            if (this.cachedHeaders == null) {
                return this.getHeaders(locale);
            }
        }
        return res;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        this.checkUninstalled();
        BundleGeneration current = this.current();
        if (this.secure.okResourceAdminPerm(this) && !current.isFragment()) {
            Enumeration<URL> e = null;
            if (this.getUpdatedState(new BundleImpl[]{this}, false) != 2) {
                if (this instanceof SystemBundle) {
                    e = this.getClassLoader().getResources(name);
                } else {
                    BundleClassLoader cl0 = (BundleClassLoader)current.getClassLoader();
                    if (cl0 != null) {
                        e = cl0.getResourcesOSGi(name);
                    }
                }
            } else {
                Vector<URL> uv = this.secure.getBundleClassPathEntries(current, name, false);
                if (uv != null) {
                    e = uv.elements();
                }
            }
            if (e != null && e.hasMoreElements()) {
                return e;
            }
        }
        return null;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        if (this.secure.okClassAdminPerm(this)) {
            ClassLoader cl;
            this.checkUninstalled();
            BundleGeneration current = this.current();
            if (current.isFragment()) {
                throw new ClassNotFoundException("Can not load classes from fragment/extension bundles");
            }
            if (this.getUpdatedState(new BundleImpl[]{this}, false) == 2) {
                throw new ClassNotFoundException(this.resolveFailException.getMessage());
            }
            if (this instanceof SystemBundle) {
                cl = ((SystemBundle)this).getClassLoader();
            } else {
                cl = current.getClassLoader();
                if (cl == null) {
                    throw new IllegalStateException("state is uninstalled?");
                }
            }
            return cl.loadClass(name);
        }
        throw new ClassNotFoundException("No AdminPermission to get class: " + name);
    }

    BundleGeneration current() {
        return this.generations.get(0);
    }

    boolean extensionNeedsRestart() {
        return this.current().isExtension() && (this.state & 3) != 0;
    }

    boolean isAttached() {
        BundleGeneration fix = this.current();
        return fix.fragment != null && fix.fragment.hasHosts();
    }

    String getFragmentHostName() {
        BundleGeneration fix = this.current();
        if (fix.isFragment()) {
            return fix.fragment.hostName;
        }
        return null;
    }

    boolean triggersActivationPkg(String pkg) {
        return 16 != this.fwCtx.systemBundle.getState() && this.state == 8 && this.operation != 1 && this.current().isPkgActivationTrigger(pkg);
    }

    boolean triggersActivationCls(String name) {
        if (16 != this.fwCtx.systemBundle.getState() && this.state == 8 && this.operation != 1) {
            String pkg = "";
            int pos = name.lastIndexOf(46);
            if (pos != -1) {
                pkg = name.substring(0, pos);
            }
            return this.current().isPkgActivationTrigger(pkg);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BundleThread bundleThread() {
        LinkedList<BundleThread> linkedList = this.fwCtx.bundleThreads;
        synchronized (linkedList) {
            this.bundleThread = this.fwCtx.bundleThreads.isEmpty() ? this.secure.createBundleThread(this.fwCtx) : this.fwCtx.bundleThreads.removeFirst();
            return this.bundleThread;
        }
    }

    <A> A adaptSecure(Class<A> type) {
        Object res = null;
        if (BundleRevision.class.equals(type)) {
            res = this.current().bundleRevision;
        } else if (BundleRevisions.class.equals(type)) {
            res = new BundleRevisionsImpl(this.generations);
        } else if (BundleWiring.class.equals(type)) {
            BundleRevisionImpl bundleRevision = this.current().bundleRevision;
            if (bundleRevision != null) {
                res = bundleRevision.getWiring();
            }
        } else if (BundleStartLevel.class.equals(type)) {
            if (this.fwCtx.startLevelController != null) {
                res = this.fwCtx.startLevelController.bundleStartLevel(this);
            }
        } else if (BundleContext.class.equals(type)) {
            res = this.bundleContext;
        } else if (AccessControlContext.class.equals(type)) {
            res = this.secure.getAccessControlContext(this);
        } else if (BundleDTO.class.equals(type)) {
            res = this.getDTO();
        } else if (ServiceReferenceDTO[].class.equals(type)) {
            if (this.bundleContext != null) {
                Set<ServiceRegistrationImpl<?>> srs = this.fwCtx.services.getRegisteredByBundle(this);
                ArrayList<ServiceReferenceDTO> srdtos = new ArrayList<ServiceReferenceDTO>();
                for (ServiceRegistrationImpl<?> serviceRegistrationImpl : srs) {
                    ServiceReferenceDTO srdto = serviceRegistrationImpl.getDTO();
                    if (srdto == null) continue;
                    srdtos.add(srdto);
                }
                res = srdtos.toArray(new ServiceReferenceDTO[srdtos.size()]);
            }
        } else if (BundleRevisionDTO.class.equals(type)) {
            BundleRevisionImpl rev = this.current().bundleRevision;
            if (rev != null) {
                res = rev.getDTO();
            }
        } else if (BundleRevisionDTO[].class.equals(type)) {
            if (this.state != 1) {
                BundleGeneration[] gens = this.generations.toArray(new BundleGeneration[this.generations.size()]);
                ArrayList<BundleRevisionDTO> brdtos = new ArrayList<BundleRevisionDTO>();
                for (BundleGeneration bg : gens) {
                    if (bg.bundleRevision == null) continue;
                    brdtos.add(bg.bundleRevision.getDTO());
                }
                res = brdtos.toArray(new BundleRevisionDTO[brdtos.size()]);
            }
        } else if (BundleWiringDTO.class.equals(type)) {
            BundleRevisionImpl bundleRevision = this.current().bundleRevision;
            if (bundleRevision != null) {
                res = bundleRevision.getWiringImpl().getDTO();
            }
        } else if (BundleWiringDTO[].class.equals(type)) {
            if (this.state != 1) {
                BundleGeneration[] gens = this.generations.toArray(new BundleGeneration[this.generations.size()]);
                ArrayList<BundleWiringDTO> bwdtos = new ArrayList<BundleWiringDTO>();
                for (BundleGeneration bg : gens) {
                    if (bg.bundleRevision == null) continue;
                    bwdtos.add(bg.bundleRevision.getWiringImpl().getDTO());
                }
                res = bwdtos.toArray(new BundleWiringDTO[bwdtos.size()]);
            }
        } else if (BundleStartLevelDTO.class.equals(type) && this.state != 1 && this.fwCtx.startLevelController != null) {
            res = this.fwCtx.startLevelController.bundleStartLevel(this).getDTO();
        }
        return (A)res;
    }

    boolean usesBundleGeneration(BundleGeneration check) {
        return this.generations.contains(check);
    }

    boolean hasZombies() {
        return this.generations.size() > 1;
    }

    boolean isBundleThread(Thread t) {
        return this.bundleThread == t;
    }

    void resetBundleThread() {
        this.bundleThread = null;
    }

    BundleDTO getDTO() {
        BundleDTO res = new BundleDTO();
        res.id = this.id;
        res.lastModified = this.current().timeStamp;
        res.state = this.state;
        res.symbolicName = this.current().symbolicName;
        res.version = this.current().version.toString();
        return res;
    }

    private void doExportImport() {
        this.current().bpkgs.registerPackages();
    }

    private void removeBundleResources() {
        this.fwCtx.listeners.removeAllListeners(this.bundleContext);
        Set<ServiceRegistrationImpl<?>> srs = this.fwCtx.services.getRegisteredByBundle(this);
        for (ServiceRegistrationImpl<?> serviceRegistrationImpl : srs) {
            try {
                serviceRegistrationImpl.unregister();
            }
            catch (IllegalStateException ignore) {}
        }
        Set<ServiceRegistrationImpl<?>> s = this.fwCtx.services.getUsedByBundle(this);
        for (ServiceRegistrationImpl<?> sri : s) {
            sri.ungetService(this, false, null);
        }
    }

    private void checkUninstalled() {
        if (this.state == 1) {
            throw new IllegalStateException("Bundle is in UNINSTALLED state");
        }
    }

    boolean isResolved() {
        return (this.state & 0x3C) != 0;
    }
}

