/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.styles;

import org.freeplane.core.undo.IActor;
import org.freeplane.core.undo.IUndoHandler;
import org.freeplane.features.attribute.AttributeRegistry;
import org.freeplane.features.edge.AutomaticEdgeColorHook;
import org.freeplane.features.icon.IconRegistry;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.styles.AutomaticLayoutController;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.MapStyle;
import org.freeplane.features.styles.MapStyleModel;

class StyleExchange {
    private final MapModel sourceMap;
    private final MapModel targetMap;

    StyleExchange(MapModel sourceMap, MapModel targetMap) {
        this.sourceMap = sourceMap;
        this.targetMap = targetMap;
    }

    void replaceMapStylesAndAutomaticStyle() {
        ModeController modeController = Controller.getCurrentModeController();
        MapStyleModel oldStyleModel = this.targetMap.getRootNode().removeExtension(MapStyleModel.class);
        modeController.getExtension(MapStyle.class).onCreate(this.sourceMap);
        MapStyleModel source = MapStyleModel.getExtension(this.sourceMap);
        source.setNonStyleUserPropertiesFrom(oldStyleModel);
        this.moveStyle(true);
        this.targetMap.getRootNode().getExtension(MapStyleModel.class).setProperty("followedTemplateLocation", oldStyleModel.getProperty("followedTemplateLocation"));
        this.targetMap.getRootNode().getExtension(MapStyleModel.class).setProperty("associatedTemplateLocation", oldStyleModel.getProperty("associatedTemplateLocation"));
        this.targetMap.getRootNode().getExtension(MapStyleModel.class).setProperty("followedMapLastTime", oldStyleModel.getProperty("followedMapLastTime"));
        modeController.getExtension(AutomaticLayoutController.class).moveExtension(modeController, this.sourceMap, this.targetMap);
        modeController.getExtension(AutomaticEdgeColorHook.class).moveExtension(modeController, this.sourceMap, this.targetMap);
        this.makeUndoableAndRefreshView(oldStyleModel);
    }

    void copyMapStyles(boolean mergeConditionalStyles) {
        MapStyleModel oldStyleModel = this.targetMap.getRootNode().getExtension(MapStyleModel.class);
        this.copyMapStylesNoUndoNoRefresh(mergeConditionalStyles);
        this.makeUndoableAndRefreshView(oldStyleModel);
    }

    void copyMapStylesNoUndoNoRefresh(boolean mergeConditionalStyles) {
        ModeController modeController = Controller.getCurrentModeController();
        MapStyleModel oldStyleModel = this.targetMap.getRootNode().removeExtension(MapStyleModel.class);
        modeController.getExtension(MapStyle.class).onCreate(this.sourceMap);
        MapStyleModel source = MapStyleModel.getExtension(this.sourceMap);
        source.addUserStylesFrom(oldStyleModel);
        if (mergeConditionalStyles) {
            source.addConditionalStylesFrom(oldStyleModel);
        } else {
            source.setConditionalStylesIfEmpty(oldStyleModel);
        }
        source.setNonStyleUserPropertiesFrom(oldStyleModel);
        this.moveStyle(true);
        MapStyleModel styleModel = this.targetMap.getRootNode().getExtension(MapStyleModel.class);
        styleModel.setProperty("followedTemplateLocation", oldStyleModel.getProperty("followedTemplateLocation"));
        styleModel.setProperty("associatedTemplateLocation", oldStyleModel.getProperty("associatedTemplateLocation"));
        styleModel.setProperty("followedMapLastTime", oldStyleModel.getProperty("followedMapLastTime"));
    }

    private void makeUndoableAndRefreshView(final MapStyleModel oldStyleModel) {
        final MapStyleModel newStyleModel = this.targetMap.getRootNode().getExtension(MapStyleModel.class);
        IActor actor = new IActor(){

            @Override
            public void undo() {
                StyleExchange.this.targetMap.getRootNode().putExtension(oldStyleModel);
                LogicalStyleController.getController().refreshMapLaterUndoable(StyleExchange.this.targetMap);
            }

            @Override
            public String getDescription() {
                return "moveStyle";
            }

            @Override
            public void act() {
                StyleExchange.this.targetMap.getRootNode().putExtension(newStyleModel);
                LogicalStyleController.getController().refreshMapLaterUndoable(StyleExchange.this.targetMap);
            }
        };
        Controller.getCurrentModeController().execute(actor, this.targetMap);
    }

    void moveStyle(boolean overwrite) {
        MapStyleModel source = this.sourceMap.getRootNode().removeExtension(MapStyleModel.class);
        if (source == null) {
            return;
        }
        IUndoHandler undoHandler = this.targetMap.getExtension(IUndoHandler.class);
        MapModel styleMap = source.getStyleMap();
        styleMap.putExtension(IUndoHandler.class, undoHandler);
        IconRegistry iconRegistry = this.targetMap.getIconRegistry();
        styleMap.setIconRegistry(iconRegistry);
        iconRegistry.registryMapContent(styleMap);
        AttributeRegistry attributeRegistry = this.targetMap.getExtension(AttributeRegistry.class);
        if (attributeRegistry != null) {
            styleMap.putExtension(AttributeRegistry.class, attributeRegistry);
        } else {
            styleMap.removeExtension(AttributeRegistry.class);
        }
        NodeModel targetRoot = this.targetMap.getRootNode();
        MapStyleModel target = MapStyleModel.getExtensionOrNull(targetRoot);
        if (target == null) {
            targetRoot.addExtension(source);
        } else {
            target.setStylesFrom(source, overwrite);
        }
    }
}

