/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.map;

import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;

public class NodeIterator<T>
implements Iterator<T> {
    private final T node;
    private final Function<T, Iterable<T>> childrenGetter;
    private Algorithm algorithm;
    private Iterator<T> children;
    private Iterator<T> subtree;
    boolean nodeReturned;

    public static <T> NodeIterator<T> of(T node, Function<T, Iterable<T>> children) {
        return new NodeIterator<T>(node, children, Algorithm.TOP_DOWN);
    }

    public static <T> NodeIterator<T> bottomUpOf(T node, Function<T, Iterable<T>> children) {
        return new NodeIterator<T>(node, children, Algorithm.BOTTOM_UP);
    }

    private NodeIterator(T node, Function<T, Iterable<T>> childrenGetter, Algorithm algorithm) {
        this.node = node;
        this.childrenGetter = childrenGetter;
        this.algorithm = algorithm;
        this.children = childrenGetter.apply(node).iterator();
        this.subtree = Collections.emptyIterator();
        this.nodeReturned = false;
    }

    @Override
    public boolean hasNext() {
        return !this.nodeReturned || this.children.hasNext() || this.subtree.hasNext();
    }

    @Override
    public T next() {
        if (this.algorithm == Algorithm.TOP_DOWN && !this.nodeReturned) {
            this.nodeReturned = true;
            return this.node;
        }
        if (this.subtree.hasNext()) {
            return this.subtree.next();
        }
        if (this.children.hasNext()) {
            this.subtree = new NodeIterator<T>(this.children.next(), this.childrenGetter, this.algorithm);
            return this.subtree.next();
        }
        if (this.nodeReturned) {
            throw new NoSuchElementException();
        }
        this.nodeReturned = true;
        return this.node;
    }

    public static enum Algorithm {
        BOTTOM_UP,
        TOP_DOWN;

    }
}

