/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.junit;

import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.AbstractBaseJavaEntity;
import com.thoughtworks.qdox.model.AbstractJavaEntity;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaSource;
import com.thoughtworks.qdox.model.Type;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.StringTokenizer;
import junit.framework.TestCase;

public abstract class APITestCase
extends TestCase {
    private static Comparator ENTITY_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            AbstractBaseJavaEntity entity1 = (AbstractBaseJavaEntity)o1;
            AbstractBaseJavaEntity entity2 = (AbstractBaseJavaEntity)o2;
            return entity1.getName().compareTo(entity2.getName());
        }
    };

    public static void assertApiEquals(URL expected, URL actual) throws IOException {
        JavaDocBuilder builder = new JavaDocBuilder();
        builder.addSource(new InputStreamReader(expected.openStream()), expected.toExternalForm());
        builder.addSource(new InputStreamReader(actual.openStream()), actual.toExternalForm());
        JavaSource expectedSource = builder.getSources()[0];
        JavaSource actualsource = builder.getSources()[1];
        APITestCase.assertApiEquals(expectedSource, actualsource);
    }

    private static void assertApiEquals(JavaSource expected, JavaSource actual) {
        List<JavaClass> expectedClasses = Arrays.asList(expected.getClasses());
        Collections.sort(expectedClasses, ENTITY_COMPARATOR);
        List<JavaClass> actualClasses = Arrays.asList(actual.getClasses());
        Collections.sort(actualClasses, ENTITY_COMPARATOR);
        APITestCase.assertEquals((String)"Number of classes should be equal", (int)expectedClasses.size(), (int)actualClasses.size());
        for (int i = 0; i < expectedClasses.size(); ++i) {
            APITestCase.assertClassesEqual(expectedClasses.get(i), actualClasses.get(i));
        }
    }

    private static void assertClassesEqual(JavaClass expected, JavaClass actual) {
        APITestCase.assertEquals((String)"Package names should be equal", (Object)expected.getPackage(), (Object)actual.getPackage());
        APITestCase.assertModifiersEquals("Class modifiers should be equal", expected, actual);
        APITestCase.assertEquals((String)"Class names should be equal", (String)expected.getName(), (String)actual.getName());
        if (expected.getSuperJavaClass() != null && actual.getSuperJavaClass() != null) {
            APITestCase.assertEquals((String)"Super class should be equal", (String)expected.getSuperJavaClass().getName(), (String)actual.getSuperJavaClass().getName());
        }
        if (expected.getSuperJavaClass() == null ^ actual.getSuperJavaClass() == null) {
            APITestCase.fail((String)"Super class should be equal");
        }
        APITestCase.assertInterfacesEqual(expected, actual);
        APITestCase.assertInnerClassesEquals(expected, actual);
        APITestCase.assertFieldsEqual(expected, actual);
        APITestCase.assertMethodsEqual(expected, actual);
    }

    private static void assertFieldEquals(JavaField expected, JavaField actual) {
        StringBuffer message = new StringBuffer("-> assertFieldEquals");
        message.append("\n\tExcepted : ");
        message.append(expected);
        message.append("\n\tActual : ");
        message.append(actual);
        message.append("\n");
        APITestCase.assertEquals((String)(message.toString() + "Field types should be equal"), (Object)expected.getType(), (Object)actual.getType());
        APITestCase.assertEquals((String)(message.toString() + "Field names should be equal"), (String)expected.getName(), (String)actual.getName());
        APITestCase.assertModifiersEquals(message.toString() + "Field modifiers should be equal", expected, actual);
    }

    private static void assertFieldsEqual(JavaClass expected, JavaClass actual) {
        List<JavaField> expectedFields = Arrays.asList(expected.getFields());
        Collections.sort(expectedFields, ENTITY_COMPARATOR);
        List<JavaField> actualFields = Arrays.asList(actual.getFields());
        Collections.sort(actualFields, ENTITY_COMPARATOR);
        StringBuffer message = new StringBuffer("-> assertFieldsEqual");
        message.append("\n\tExcepted : ");
        message.append(expectedFields);
        message.append("\n\tActual : ");
        message.append(actualFields);
        message.append("\n");
        APITestCase.assertEquals((String)(message.toString() + "Number of fields should be equal"), (int)expectedFields.size(), (int)actualFields.size());
        for (int i = 0; i < expectedFields.size(); ++i) {
            APITestCase.assertFieldEquals(expectedFields.get(i), actualFields.get(i));
        }
    }

    private static void assertInnerClassesEquals(JavaClass expected, JavaClass actual) {
        List<JavaClass> expectedInnerClasses = Arrays.asList(expected.getNestedClasses());
        Collections.sort(expectedInnerClasses, ENTITY_COMPARATOR);
        List<JavaClass> actualInnerClasses = Arrays.asList(actual.getNestedClasses());
        Collections.sort(actualInnerClasses, ENTITY_COMPARATOR);
        StringBuffer message = new StringBuffer("-> assertInnerClassesEquals");
        message.append("\n\tExcepted : ");
        message.append(expectedInnerClasses);
        message.append("\n\tActual : ");
        message.append(actualInnerClasses);
        message.append("\n");
        APITestCase.assertEquals((String)(message.toString() + "Number of inner classes should be equal"), (int)expectedInnerClasses.size(), (int)actualInnerClasses.size());
        for (int i = 0; i < expectedInnerClasses.size(); ++i) {
            APITestCase.assertClassesEqual(expectedInnerClasses.get(i), actualInnerClasses.get(i));
        }
    }

    private static void assertInterfacesEqual(JavaClass expected, JavaClass actual) {
        List<Type> expectedImplements = Arrays.asList(expected.getImplements());
        Collections.sort(expectedImplements);
        List<Type> actualImplements = Arrays.asList(actual.getImplements());
        Collections.sort(actualImplements);
        StringBuffer message = new StringBuffer("-> assertInnerClassesEquals");
        message.append("\n\tExcepted : ");
        message.append(expectedImplements);
        message.append("\n\tActual : ");
        message.append(actualImplements);
        message.append("\n");
        APITestCase.assertEquals((String)(message.toString() + "Number of implemented interface should be equal"), (int)expectedImplements.size(), (int)actualImplements.size());
        for (int i = 0; i < expectedImplements.size(); ++i) {
            APITestCase.assertEquals((String)"Implemented interface should be equal", (Object)expectedImplements.get(i), (Object)actualImplements.get(i));
        }
    }

    private static void assertMethodsEqual(JavaClass expected, JavaClass actual) {
        List<JavaMethod> expectedMethods = Arrays.asList(expected.getMethods());
        Collections.sort(expectedMethods, ENTITY_COMPARATOR);
        List<JavaMethod> actualMethods = Arrays.asList(actual.getMethods());
        Collections.sort(actualMethods, ENTITY_COMPARATOR);
        StringBuffer message = new StringBuffer("-> assertMethodsEqual");
        message.append("\n\tExcepted : ");
        message.append(expectedMethods);
        message.append("\n\tActual : ");
        message.append(actualMethods);
        message.append("\n");
        APITestCase.assertEquals((String)(message.toString() + "Number of methods should be equal"), (int)expectedMethods.size(), (int)actualMethods.size());
        for (int i = 0; i < expectedMethods.size(); ++i) {
            APITestCase.assertEquals((String)"Method should be equal", (Object)expectedMethods.get(i), (Object)actualMethods.get(i));
        }
    }

    private static void assertModifiersEquals(String msg, AbstractJavaEntity expected, AbstractJavaEntity actual) {
        List<String> expectedModifiers = Arrays.asList(expected.getModifiers());
        Collections.sort(expectedModifiers);
        List<String> actualModifiers = Arrays.asList(actual.getModifiers());
        Collections.sort(actualModifiers);
        StringBuffer message = new StringBuffer("-> assertModifiersEquals");
        message.append("\n\tExcepted : ");
        message.append(expectedModifiers);
        message.append("\n\tActual : ");
        message.append(actualModifiers);
        message.append("\n");
        APITestCase.assertEquals((String)(message.toString() + msg + "\nNumber of modifiers should be equal"), (int)expectedModifiers.size(), (int)actualModifiers.size());
        for (int i = 0; i < expectedModifiers.size(); ++i) {
            APITestCase.assertEquals((String)(msg + "\n" + message.toString() + "\nModifier should be equal"), (Object)expectedModifiers.get(i), (Object)actualModifiers.get(i));
        }
    }

    private static void assertNotDir(File expected, File actual) {
        if (expected.isDirectory()) {
            APITestCase.fail((String)(expected.getAbsolutePath() + " - should not have been a directory"));
        }
        if (actual.isDirectory()) {
            APITestCase.fail((String)(actual.getAbsolutePath() + " - should not have been a directory"));
        }
    }

    protected File getDir() {
        return new File(((Object)((Object)this)).getClass().getResource("/" + ((Object)((Object)this)).getClass().getName().replace('.', '/') + ".class").getFile()).getParentFile();
    }

    protected File getRootDir() {
        File dir = this.getDir();
        StringTokenizer st = new StringTokenizer(((Object)((Object)this)).getClass().getName(), ".");
        for (int i = 0; i < st.countTokens() - 1; ++i) {
            dir = dir.getParentFile();
        }
        return dir;
    }
}

