/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.extensions.svg;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.net.URI;
import org.apache.batik.anim.dom.SVGOMDocument;
import org.apache.batik.anim.dom.SVGOMElement;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.dom.svg.SVGContext;
import org.apache.batik.parser.UnitProcessor;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.extensions.svg.SVGDOMContentHandlerFactory;
import org.apache.fop.fo.extensions.svg.SVGObj;
import org.apache.fop.util.ContentHandlerFactory;
import org.w3c.dom.Element;

public class SVGElement
extends SVGObj {
    public SVGElement(FONode parent) {
        super(parent);
    }

    @Override
    public ContentHandlerFactory getContentHandlerFactory() {
        return new SVGDOMContentHandlerFactory();
    }

    @Override
    public Point2D getDimension(final Point2D view) {
        Element svgRoot = this.element;
        try {
            URI baseUri = this.getUserAgent().getResourceResolver().getBaseURI();
            if (baseUri != null) {
                SVGOMDocument svgdoc = (SVGOMDocument)this.doc;
                svgdoc.setURLObject(baseUri.toURL());
            }
        }
        catch (Exception e) {
            log.error((Object)"Could not set base URL for svg", (Throwable)e);
        }
        final float ptmm = this.getUserAgent().getSourcePixelUnitToMillimeter();
        SVGContext dc = new SVGContext(){

            public float getPixelToMM() {
                return ptmm;
            }

            public float getPixelUnitToMillimeter() {
                return ptmm;
            }

            public Rectangle2D getBBox() {
                return new Rectangle2D.Double(0.0, 0.0, view.getX(), view.getY());
            }

            public AffineTransform getScreenTransform() {
                throw new UnsupportedOperationException("NYI");
            }

            public void setScreenTransform(AffineTransform at) {
                throw new UnsupportedOperationException("NYI");
            }

            public AffineTransform getCTM() {
                return new AffineTransform();
            }

            public AffineTransform getGlobalTransform() {
                return new AffineTransform();
            }

            public float getViewportWidth() {
                return (float)view.getX();
            }

            public float getViewportHeight() {
                return (float)view.getY();
            }

            public float getFontSize() {
                return 12.0f;
            }
        };
        SVGOMElement e = (SVGOMElement)svgRoot;
        e.setSVGContext(dc);
        e.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://www.w3.org/2000/svg");
        int fontSize = 12;
        Point2D p2d = SVGElement.getSize(fontSize, svgRoot, this.getUserAgent().getSourcePixelUnitToMillimeter());
        e.setSVGContext(null);
        double pixelToPoint = 72.0 / (double)this.getUserAgent().getSourceResolution();
        return new Point2D.Double(p2d.getX() * pixelToPoint, p2d.getY() * pixelToPoint);
    }

    public static Point2D getSize(int size, Element svgRoot, float ptmm) {
        PDFUnitContext ctx = new PDFUnitContext(size, svgRoot, ptmm);
        String str = svgRoot.getAttributeNS(null, "width");
        if (str.length() == 0) {
            str = "100%";
        }
        float width = UnitProcessor.svgHorizontalLengthToUserSpace((String)str, (String)"width", (UnitProcessor.Context)ctx);
        str = svgRoot.getAttributeNS(null, "height");
        if (str.length() == 0) {
            str = "100%";
        }
        float height = UnitProcessor.svgVerticalLengthToUserSpace((String)str, (String)"height", (UnitProcessor.Context)ctx);
        return new Point2D.Float(width, height);
    }

    public static class PDFUnitContext
    implements UnitProcessor.Context {
        private Element e;
        private int fontSize;
        private float pixeltoMM;

        public PDFUnitContext(int size, Element e, float ptmm) {
            this.e = e;
            this.fontSize = size;
            this.pixeltoMM = ptmm;
        }

        public Element getElement() {
            return this.e;
        }

        public UnitProcessor.Context getParentElementContext() {
            return null;
        }

        public float getPixelToMM() {
            return this.pixeltoMM;
        }

        public float getPixelUnitToMillimeter() {
            return this.pixeltoMM;
        }

        public float getFontSize() {
            return this.fontSize;
        }

        public float getXHeight() {
            return 0.5f;
        }

        public float getViewportWidth() {
            return 100.0f;
        }

        public float getViewportHeight() {
            return 100.0f;
        }
    }
}

