/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.modca;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.fop.afp.modca.AbstractTripletStructuredObject;
import org.apache.fop.afp.modca.triplets.AbstractTriplet;
import org.apache.fop.afp.modca.triplets.Triplet;
import org.apache.fop.afp.util.BinaryUtils;

public class MapDataResource
extends AbstractTripletStructuredObject {
    private List<List<AbstractTriplet>> tripletsList = new ArrayList<List<AbstractTriplet>>();

    public void finishElement() {
        this.tripletsList.add(this.triplets);
        this.triplets = new ArrayList();
    }

    @Override
    protected int getTripletDataLength() {
        int dataLength = 0;
        for (List<AbstractTriplet> l : this.tripletsList) {
            dataLength += this.getTripletDataLength(l) + 2;
        }
        return dataLength;
    }

    private int getTripletDataLength(List<AbstractTriplet> l) {
        int dataLength = 0;
        for (Triplet triplet : l) {
            dataLength += triplet.getDataLength();
        }
        return dataLength;
    }

    @Override
    public void writeToStream(OutputStream os) throws IOException {
        super.writeStart(os);
        byte[] data = new byte[9];
        this.copySF(data, (byte)-85, (byte)-61);
        int tripletDataLen = this.getTripletDataLength();
        byte[] len = BinaryUtils.convert(8 + tripletDataLen, 2);
        data[1] = len[0];
        data[2] = len[1];
        os.write(data);
        for (List<AbstractTriplet> l : this.tripletsList) {
            len = BinaryUtils.convert(2 + this.getTripletDataLength(l), 2);
            os.write(len);
            this.writeObjects(l, os);
        }
    }
}

