/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.styles.mindmapmode;

import java.util.function.Consumer;
import org.freeplane.features.map.IMapChangeListener;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.IMapSelectionListener;
import org.freeplane.features.map.INodeChangeListener;
import org.freeplane.features.map.INodeSelectionListener;
import org.freeplane.features.map.MapChangeEvent;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeChangeEvent;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.ui.IMapViewManager;

public class SelectedNodeChangeListener {
    public static void onSelectedNodeChange(final Consumer<NodeModel> callback) {
        ModeController modeController = Controller.getCurrentModeController();
        MapController mapController = modeController.getMapController();
        final Controller controller = Controller.getCurrentController();
        mapController.addNodeSelectionListener(new INodeSelectionListener(){

            public void onSelect(NodeModel node) {
                IMapSelection selection = controller.getSelection();
                if (selection == null) {
                    return;
                }
                if (selection.size() >= 1) {
                    callback.accept(selection.getSelected());
                }
            }
        });
        mapController.addUINodeChangeListener(new INodeChangeListener(){

            public void nodeChanged(NodeChangeEvent event) {
                IMapSelection selection = controller.getSelection();
                if (selection == null) {
                    return;
                }
                NodeModel node = event.getNode();
                if (selection.getSelected().equals(node)) {
                    callback.accept(selection.getSelected());
                }
            }
        });
        mapController.addUIMapChangeListener(new IMapChangeListener(){

            public void mapChanged(MapChangeEvent event) {
                Object property = event.getProperty();
                if (!"MAP_STYLES".equals(property) && !"MAP_LAYOUT".equals(property) && IMapViewManager.MapChangeEventProperty.MAP_VIEW_ROOT != property) {
                    return;
                }
                IMapSelection selection = controller.getSelection();
                if (selection == null) {
                    return;
                }
                callback.accept(selection.getSelected());
            }
        });
        IMapSelectionListener mapSelectionListener = new IMapSelectionListener(){

            public void afterMapChange(MapModel oldMap, MapModel newMap) {
                if (newMap == null) {
                    callback.accept(null);
                }
            }
        };
        controller.getMapViewManager().addMapSelectionListener(mapSelectionListener);
    }
}

