/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api.condition;

import org.junit.jupiter.api.condition.AbstractRepeatableAnnotationCondition;
import org.junit.jupiter.api.condition.EnabledIfEnvironmentVariable;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.platform.commons.util.Preconditions;

class EnabledIfEnvironmentVariableCondition
extends AbstractRepeatableAnnotationCondition<EnabledIfEnvironmentVariable> {
    private static final ConditionEvaluationResult ENABLED = ConditionEvaluationResult.enabled("No @EnabledIfEnvironmentVariable conditions resulting in 'disabled' execution encountered");

    EnabledIfEnvironmentVariableCondition() {
        super(EnabledIfEnvironmentVariable.class);
    }

    @Override
    protected ConditionEvaluationResult getNoDisabledConditionsEncounteredResult() {
        return ENABLED;
    }

    @Override
    protected ConditionEvaluationResult evaluate(EnabledIfEnvironmentVariable annotation) {
        String name = annotation.named().trim();
        String regex = annotation.matches();
        Preconditions.notBlank((String)name, () -> "The 'named' attribute must not be blank in " + annotation);
        Preconditions.notBlank((String)regex, () -> "The 'matches' attribute must not be blank in " + annotation);
        String actual = this.getEnvironmentVariable(name);
        if (actual == null) {
            return ConditionEvaluationResult.disabled(String.format("Environment variable [%s] does not exist", name), annotation.disabledReason());
        }
        if (actual.matches(regex)) {
            return ConditionEvaluationResult.enabled(String.format("Environment variable [%s] with value [%s] matches regular expression [%s]", name, actual, regex));
        }
        return ConditionEvaluationResult.disabled(String.format("Environment variable [%s] with value [%s] does not match regular expression [%s]", name, actual, regex), annotation.disabledReason());
    }

    protected String getEnvironmentVariable(String name) {
        return System.getenv(name);
    }
}

