/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui.hover.action;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.Timer;
import net.infonode.gui.hover.HoverEvent;
import net.infonode.gui.hover.HoverListener;

public class DelayedHoverExitAction
implements HoverListener {
    private HashMap timers = new HashMap();
    private HashMap exitEvents = new HashMap();
    private HoverListener action;
    private int delay;

    public DelayedHoverExitAction(HoverListener action, int delay) {
        this.action = action;
        this.delay = delay;
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public HoverListener getHoverAction() {
        return this.action;
    }

    public void forceExit(Component component) {
        if (this.timers.containsKey(component)) {
            ((Timer)this.timers.get(component)).stop();
            this.timers.remove(component);
            HoverEvent event = (HoverEvent)this.exitEvents.get(component);
            this.exitEvents.remove(component);
            this.action.mouseExited(event);
        }
    }

    @Override
    public void mouseEntered(HoverEvent event) {
        final Component c = event.getSource();
        if (this.timers.containsKey(c)) {
            ((Timer)this.timers.get(c)).stop();
        } else {
            Timer t = new Timer(this.delay, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DelayedHoverExitAction.this.forceExit(c);
                }
            });
            t.setRepeats(false);
            this.timers.put(c, t);
            this.action.mouseEntered(event);
        }
    }

    @Override
    public void mouseExited(HoverEvent event) {
        this.exitEvents.put(event.getSource(), event);
        ((Timer)this.timers.get(event.getSource())).restart();
    }
}

