/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.afp;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;
import org.apache.fop.afp.AFPBorderPainter;
import org.apache.fop.afp.AFPEventProducer;
import org.apache.fop.afp.AFPObjectAreaInfo;
import org.apache.fop.afp.AFPPaintingState;
import org.apache.fop.afp.AFPResourceInfo;
import org.apache.fop.afp.AFPUnitConverter;
import org.apache.fop.afp.AbstractAFPPainter;
import org.apache.fop.afp.BorderPaintingInfo;
import org.apache.fop.afp.DataStream;
import org.apache.fop.afp.RectanglePaintingInfo;
import org.apache.fop.afp.fonts.AFPFont;
import org.apache.fop.afp.fonts.AFPFontAttributes;
import org.apache.fop.afp.fonts.AFPPageFonts;
import org.apache.fop.afp.fonts.CharacterSet;
import org.apache.fop.afp.modca.AbstractPageObject;
import org.apache.fop.afp.modca.PresentationTextObject;
import org.apache.fop.afp.ptoca.PtocaBuilder;
import org.apache.fop.afp.ptoca.PtocaProducer;
import org.apache.fop.afp.util.AFPResourceAccessor;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.fonts.Typeface;
import org.apache.fop.render.ImageHandlerUtil;
import org.apache.fop.render.RenderingContext;
import org.apache.fop.render.afp.AFPDocumentHandler;
import org.apache.fop.render.afp.AFPFontConfig;
import org.apache.fop.render.afp.AFPForeignAttributeReader;
import org.apache.fop.render.afp.AFPImageHandler;
import org.apache.fop.render.afp.AFPRenderingContext;
import org.apache.fop.render.afp.PageSegmentDescriptor;
import org.apache.fop.render.intermediate.AbstractIFPainter;
import org.apache.fop.render.intermediate.BorderPainter;
import org.apache.fop.render.intermediate.GraphicsPainter;
import org.apache.fop.render.intermediate.IFException;
import org.apache.fop.render.intermediate.IFState;
import org.apache.fop.render.intermediate.IFUtil;
import org.apache.fop.traits.BorderProps;
import org.apache.fop.traits.RuleStyle;
import org.apache.fop.util.CharUtilities;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageException;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageProcessingHints;
import org.apache.xmlgraphics.image.loader.ImageSessionContext;
import org.apache.xmlgraphics.image.loader.ImageSize;
import org.apache.xmlgraphics.image.loader.impl.ImageGraphics2D;
import org.apache.xmlgraphics.java2d.Graphics2DImagePainter;
import org.apache.xmlgraphics.util.QName;
import org.w3c.dom.Document;

public class AFPPainter
extends AbstractIFPainter<AFPDocumentHandler> {
    private static final int X = 0;
    private static final int Y = 1;
    private final GraphicsPainter graphicsPainter;
    private final AFPBorderPainterAdapter borderPainter;
    private final AbstractAFPPainter rectanglePainter;
    private final AFPUnitConverter unitConv;
    private final AFPEventProducer eventProducer;
    private Integer bytesAvailable;

    public AFPPainter(AFPDocumentHandler documentHandler) {
        super(documentHandler);
        this.state = IFState.create();
        this.graphicsPainter = new AFPGraphicsPainter(new AFPBorderPainter(this.getPaintingState(), this.getDataStream()));
        this.borderPainter = new AFPBorderPainterAdapter(this.graphicsPainter, this, documentHandler);
        this.rectanglePainter = documentHandler.createRectanglePainter();
        this.unitConv = this.getPaintingState().getUnitConverter();
        this.eventProducer = AFPEventProducer.Provider.get(this.getUserAgent().getEventBroadcaster());
    }

    private AFPPaintingState getPaintingState() {
        return ((AFPDocumentHandler)this.getDocumentHandler()).getPaintingState();
    }

    private DataStream getDataStream() {
        return ((AFPDocumentHandler)this.getDocumentHandler()).getDataStream();
    }

    @Override
    public String getFontKey(FontTriplet triplet) throws IFException {
        try {
            return super.getFontKey(triplet);
        }
        catch (IFException e) {
            this.eventProducer.invalidConfiguration(null, e);
            return super.getFontKey(FontTriplet.DEFAULT_FONT_TRIPLET);
        }
    }

    @Override
    public void startViewport(AffineTransform transform, Dimension size, Rectangle clipRect) throws IFException {
        try {
            this.saveGraphicsState();
            this.concatenateTransformationMatrix(transform);
        }
        catch (IOException ioe) {
            throw new IFException("I/O error in startViewport()", ioe);
        }
    }

    @Override
    public void endViewport() throws IFException {
        try {
            this.restoreGraphicsState();
        }
        catch (IOException ioe) {
            throw new IFException("I/O error in endViewport()", ioe);
        }
    }

    private void concatenateTransformationMatrix(AffineTransform at) {
        if (!at.isIdentity()) {
            this.getPaintingState().concatenate(at);
        }
    }

    @Override
    public void startGroup(AffineTransform transform, String layer) throws IFException {
        try {
            this.saveGraphicsState();
            this.concatenateTransformationMatrix(transform);
        }
        catch (IOException ioe) {
            throw new IFException("I/O error in startGroup()", ioe);
        }
    }

    @Override
    public void endGroup() throws IFException {
        try {
            this.restoreGraphicsState();
        }
        catch (IOException ioe) {
            throw new IFException("I/O error in endGroup()", ioe);
        }
    }

    @Override
    protected Map createDefaultImageProcessingHints(ImageSessionContext sessionContext) {
        Map hints = super.createDefaultImageProcessingHints(sessionContext);
        hints.put(ImageProcessingHints.TRANSPARENCY_INTENT, "ignore");
        hints.put("CMYK", ((AFPDocumentHandler)this.getDocumentHandler()).getPaintingState().isCMYKImagesSupported());
        return hints;
    }

    @Override
    protected RenderingContext createRenderingContext() {
        AFPRenderingContext renderingContext = new AFPRenderingContext(this.getUserAgent(), ((AFPDocumentHandler)this.getDocumentHandler()).getResourceManager(), this.getPaintingState(), this.getFontInfo(), this.getContext().getForeignAttributes());
        return renderingContext;
    }

    @Override
    public void drawImage(String uri, Rectangle rect) throws IFException {
        PageSegmentDescriptor pageSegment = ((AFPDocumentHandler)this.getDocumentHandler()).getPageSegmentNameFor(uri);
        if (pageSegment != null) {
            float[] srcPts = new float[]{rect.x, rect.y};
            int[] coords = this.unitConv.mpts2units(srcPts);
            int width = Math.round(this.unitConv.mpt2units(rect.width));
            int height = Math.round(this.unitConv.mpt2units(rect.height));
            this.getDataStream().createIncludePageSegment(pageSegment.getName(), coords[0], coords[1], width, height);
            if (pageSegment.getURI() != null) {
                AFPResourceAccessor accessor = new AFPResourceAccessor(((AFPDocumentHandler)this.getDocumentHandler()).getUserAgent().getResourceResolver());
                try {
                    URI resourceUri = new URI(pageSegment.getURI());
                    ((AFPDocumentHandler)this.getDocumentHandler()).getResourceManager().createIncludedResourceFromExternal(pageSegment.getName(), resourceUri, accessor);
                }
                catch (URISyntaxException urie) {
                    throw new IFException("Could not handle resource url" + pageSegment.getURI(), urie);
                }
                catch (IOException ioe) {
                    throw new IFException("Could not handle resource" + pageSegment.getURI(), ioe);
                }
            }
        } else {
            this.drawImageUsingURI(uri, rect);
        }
    }

    @Override
    protected void drawImage(Image image, Rectangle rect, RenderingContext context, boolean convert, Map additionalHints) throws IOException, ImageException {
        AFPRenderingContext afpContext = (AFPRenderingContext)context;
        AFPResourceInfo resourceInfo = AFPImageHandler.createResourceInformation(image.getInfo().getOriginalURI(), afpContext.getForeignAttributes());
        if (afpContext.getResourceManager().isObjectCached(resourceInfo)) {
            AFPObjectAreaInfo areaInfo = AFPImageHandler.createObjectAreaInfo(afpContext.getPaintingState(), rect);
            afpContext.getResourceManager().includeCachedObject(resourceInfo, areaInfo);
        } else {
            super.drawImage(image, rect, context, convert, additionalHints);
        }
    }

    @Override
    public void drawImage(Document doc, Rectangle rect) throws IFException {
        this.drawImageUsingDocument(doc, rect);
    }

    @Override
    public void clipRect(Rectangle rect) throws IFException {
    }

    private float toPoint(int mpt) {
        return (float)mpt / 1000.0f;
    }

    @Override
    public void fillRect(Rectangle rect, Paint fill) throws IFException {
        if (fill == null) {
            return;
        }
        if (rect.width != 0 && rect.height != 0) {
            if (!(fill instanceof Color)) {
                throw new UnsupportedOperationException("Non-Color paints NYI");
            }
            this.getPaintingState().setColor((Color)fill);
            RectanglePaintingInfo rectanglePaintInfo = new RectanglePaintingInfo(this.toPoint(rect.x), this.toPoint(rect.y), this.toPoint(rect.width), this.toPoint(rect.height));
            try {
                this.rectanglePainter.paint(rectanglePaintInfo);
            }
            catch (IOException ioe) {
                throw new IFException("IO error while painting rectangle", ioe);
            }
        }
    }

    @Override
    public void drawBorderRect(Rectangle rect, BorderProps top, BorderProps bottom, BorderProps left, BorderProps right, Color innerBackgroundColor) throws IFException {
        if (top != null || bottom != null || left != null || right != null) {
            this.borderPainter.drawBorders(rect, top, bottom, left, right, innerBackgroundColor);
        }
    }

    @Override
    public void drawLine(Point start, Point end, int width, Color color, RuleStyle style) throws IFException {
        try {
            this.graphicsPainter.drawLine(start, end, width, color, style);
        }
        catch (IOException ioe) {
            throw new IFException("I/O error in drawLine()", ioe);
        }
    }

    @Override
    public void drawText(int x, int y, int letterSpacing, int wordSpacing, int[][] dp, String text) throws IFException {
        new DefaultPtocaProducer(x, y, letterSpacing, wordSpacing, dp, text);
    }

    protected void saveGraphicsState() throws IOException {
        this.getPaintingState().save();
    }

    protected void restoreGraphicsState() throws IOException {
        this.getPaintingState().restore();
    }

    @Override
    public void clipBackground(Rectangle rect, BorderProps bpsBefore, BorderProps bpsAfter, BorderProps bpsStart, BorderProps bpsEnd) throws IFException {
    }

    @Override
    public boolean isBackgroundRequired(BorderProps bpsBefore, BorderProps bpsAfter, BorderProps bpsStart, BorderProps bpsEnd) {
        return this.borderPainter.isBackgroundRequired(bpsBefore, bpsAfter, bpsStart, bpsEnd);
    }

    public void fillBackground(Rectangle rect, Paint fill, BorderProps bpsBefore, BorderProps bpsAfter, BorderProps bpsStart, BorderProps bpsEnd) throws IFException {
    }

    private final class DefaultPtocaProducer
    implements PtocaProducer {
        final int[] coords;
        final int fontReference;
        final String text;
        final int[][] dp;
        final int letterSpacing;
        final int wordSpacing;
        final Font font;
        final AFPFont afpFont;
        final CharacterSet charSet;
        PresentationTextObject pto;

        private DefaultPtocaProducer(int x, int y, int letterSpacing, int wordSpacing, int[][] dp, String text) throws IFException {
            this.letterSpacing = letterSpacing;
            this.wordSpacing = wordSpacing;
            this.text = text;
            this.dp = dp;
            int fontSize = AFPPainter.this.state.getFontSize();
            AFPPainter.this.getPaintingState().setFontSize(fontSize);
            FontTriplet triplet = new FontTriplet(AFPPainter.this.state.getFontFamily(), AFPPainter.this.state.getFontStyle(), AFPPainter.this.state.getFontWeight());
            String fontKey = AFPPainter.this.getFontKey(triplet);
            Map<String, Typeface> fontMetricMap = AFPPainter.this.getFontInfo().getFonts();
            this.afpFont = (AFPFont)fontMetricMap.get(fontKey);
            this.font = AFPPainter.this.getFontInfo().getFontInstance(triplet, fontSize);
            AFPPageFonts pageFonts = AFPPainter.this.getPaintingState().getPageFonts();
            AFPFontAttributes fontAttributes = pageFonts.registerFont(fontKey, this.afpFont, fontSize);
            this.fontReference = fontAttributes.getFontReference();
            this.coords = AFPPainter.this.unitConv.mpts2units(new float[]{x, y});
            this.charSet = this.afpFont.getCharacterSet(fontSize);
            if (this.afpFont.isEmbeddable()) {
                try {
                    ((AFPDocumentHandler)AFPPainter.this.getDocumentHandler()).getResourceManager().embedFont(this.afpFont, this.charSet);
                }
                catch (IOException ioe) {
                    throw new IFException("Error while embedding font resources", ioe);
                }
            }
            AbstractPageObject page = AFPPainter.this.getDataStream().getCurrentPage();
            try {
                if (AFPPainter.this.bytesAvailable != null && AFPPainter.this.bytesAvailable < this.getSize()) {
                    page.endPresentationObject();
                }
                this.pto = page.getPresentationTextObject();
                boolean success = this.pto.createControlSequences(this);
                if (!success) {
                    page.endPresentationObject();
                    this.pto = page.getPresentationTextObject();
                    this.pto.createControlSequences(this);
                }
            }
            catch (IOException ioe) {
                throw new IFException("I/O error in drawText()", ioe);
            }
        }

        private int getSize() throws IOException {
            final ByteArrayOutputStream bos = new ByteArrayOutputStream();
            PtocaBuilder pb = new PtocaBuilder(){

                @Override
                protected OutputStream getOutputStreamForControlSequence(int length) {
                    return bos;
                }
            };
            this.produce(pb);
            return bos.size();
        }

        @Override
        public void produce(PtocaBuilder builder) throws IOException {
            int fixedSpaceCharacterIncrement;
            Point p = AFPPainter.this.getPaintingState().getPoint(this.coords[0], this.coords[1]);
            builder.setTextOrientation(AFPPainter.this.getPaintingState().getRotation());
            builder.absoluteMoveBaseline(p.y);
            builder.absoluteMoveInline(p.x);
            builder.setExtendedTextColor(AFPPainter.this.state.getTextColor());
            builder.setCodedFont((byte)this.fontReference);
            int l = this.text.length();
            int[] dx = IFUtil.convertDPToDX(this.dp);
            int dxl = dx != null ? dx.length : 0;
            StringBuffer sb = new StringBuffer();
            if (dxl > 0 && dx[0] != 0) {
                int dxu = Math.round(AFPPainter.this.unitConv.mpt2units(dx[0]));
                builder.relativeMoveInline(-dxu);
            }
            boolean usePTOCAWordSpacing = true;
            int interCharacterAdjustment = 0;
            if (this.letterSpacing != 0) {
                interCharacterAdjustment = Math.round(AFPPainter.this.unitConv.mpt2units(this.letterSpacing));
            }
            builder.setInterCharacterAdjustment(interCharacterAdjustment);
            int spaceWidth = this.font.getCharWidth(' ');
            int varSpaceCharacterIncrement = fixedSpaceCharacterIncrement = Math.round(AFPPainter.this.unitConv.mpt2units(spaceWidth + this.letterSpacing));
            if (this.wordSpacing != 0) {
                varSpaceCharacterIncrement = Math.round(AFPPainter.this.unitConv.mpt2units(spaceWidth + this.wordSpacing + this.letterSpacing));
            }
            builder.setVariableSpaceCharacterIncrement(varSpaceCharacterIncrement);
            boolean fixedSpaceMode = false;
            double ttPos = p.x;
            boolean positionByChar = this.afpFont instanceof AFPFontConfig.AFPTrueTypeFont && ((AFPFontConfig.AFPTrueTypeFont)this.afpFont).isPositionByChar();
            for (int i = 0; i < l; ++i) {
                int charWidth;
                char orgChar = this.text.charAt(i);
                float glyphAdjust = 0.0f;
                if (positionByChar) {
                    this.flushText(builder, sb, this.charSet);
                    fixedSpaceMode = true;
                    charWidth = this.font.getCharWidth(orgChar);
                    sb.append(orgChar);
                    glyphAdjust += (float)charWidth;
                } else if (CharUtilities.isFixedWidthSpace(orgChar)) {
                    this.flushText(builder, sb, this.charSet);
                    builder.setVariableSpaceCharacterIncrement(fixedSpaceCharacterIncrement);
                    fixedSpaceMode = true;
                    sb.append(' ');
                    charWidth = this.font.getCharWidth(orgChar);
                    glyphAdjust += (float)(charWidth - spaceWidth);
                } else {
                    if (fixedSpaceMode) {
                        this.flushText(builder, sb, this.charSet);
                        builder.setVariableSpaceCharacterIncrement(varSpaceCharacterIncrement);
                        fixedSpaceMode = false;
                    }
                    char ch = orgChar == '\u00a0' ? (char)' ' : (char)orgChar;
                    sb.append(ch);
                }
                if (i < dxl - 1) {
                    glyphAdjust += (float)dx[i + 1];
                }
                if (positionByChar) {
                    this.flushText(builder, sb, this.charSet);
                    builder.absoluteMoveInline((int)Math.round(ttPos += (double)AFPPainter.this.unitConv.mpt2units(glyphAdjust)));
                    continue;
                }
                if (glyphAdjust == 0.0f) continue;
                this.flushText(builder, sb, this.charSet);
                int increment = Math.round(AFPPainter.this.unitConv.mpt2units(glyphAdjust));
                builder.relativeMoveInline(increment);
            }
            this.flushText(builder, sb, this.charSet);
            if (this.pto != null) {
                AFPPainter.this.bytesAvailable = this.pto.getBytesAvailable();
            }
        }

        private void flushText(PtocaBuilder builder, StringBuffer sb, CharacterSet charSet) throws IOException {
            if (sb.length() > 0) {
                builder.addTransparentData(charSet.encodeChars(sb));
                sb.setLength(0);
            }
        }
    }

    private static class AFPBorderPainterAdapter
    extends BorderPainter {
        private final AFPPainter painter;
        private final AFPDocumentHandler documentHandler;

        public AFPBorderPainterAdapter(GraphicsPainter graphicsPainter, AFPPainter painter, AFPDocumentHandler documentHandler) {
            super(graphicsPainter);
            this.painter = painter;
            this.documentHandler = documentHandler;
        }

        @Override
        public void drawBorders(Rectangle borderRect, BorderProps bpsBefore, BorderProps bpsAfter, BorderProps bpsStart, BorderProps bpsEnd, Color innerBackgroundColor) throws IFException {
            this.drawRoundedCorners(borderRect, bpsBefore, bpsAfter, bpsStart, bpsEnd, innerBackgroundColor);
        }

        private boolean isBackgroundRequired(BorderProps bpsBefore, BorderProps bpsAfter, BorderProps bpsStart, BorderProps bpsEnd) {
            return !this.hasRoundedCorners(bpsBefore, bpsAfter, bpsStart, bpsEnd);
        }

        private boolean hasRoundedCorners(BorderProps bpsBefore, BorderProps bpsAfter, BorderProps bpsStart, BorderProps bpsEnd) {
            return bpsStart != null && bpsStart.getRadiusStart() > 0 && bpsBefore != null && bpsBefore.getRadiusStart() > 0 || bpsBefore != null && bpsBefore.getRadiusEnd() > 0 && bpsEnd != null && bpsEnd.getRadiusStart() > 0 || bpsEnd != null && bpsEnd.getRadiusEnd() > 0 && bpsAfter != null && bpsAfter.getRadiusEnd() > 0 || bpsAfter != null && bpsAfter.getRadiusStart() > 0 && bpsStart != null && bpsStart.getRadiusEnd() > 0;
        }

        private void drawRoundedCorners(Rectangle borderRect, BorderProps bpsBefore, BorderProps bpsAfter, BorderProps bpsStart, BorderProps bpsEnd, Color innerBackgroundColor) throws IFException {
            double cornerCorrectionFactor = AFPBorderPainterAdapter.calculateCornerCorrectionFactor(borderRect.width, borderRect.height, bpsBefore, bpsAfter, bpsStart, bpsEnd);
            boolean[] roundCorner = new boolean[]{bpsBefore != null && bpsStart != null && bpsBefore.getRadiusStart() > 0 && bpsStart.getRadiusStart() > 0 && this.isNotCollapseOuter(bpsBefore) && this.isNotCollapseOuter(bpsStart), bpsEnd != null && bpsBefore != null && bpsEnd.getRadiusStart() > 0 && bpsBefore.getRadiusEnd() > 0 && this.isNotCollapseOuter(bpsEnd) && this.isNotCollapseOuter(bpsBefore), bpsEnd != null && bpsAfter != null && bpsEnd.getRadiusEnd() > 0 && bpsAfter.getRadiusEnd() > 0 && this.isNotCollapseOuter(bpsEnd) && this.isNotCollapseOuter(bpsAfter), bpsStart != null && bpsAfter != null && bpsStart.getRadiusEnd() > 0 && bpsAfter.getRadiusStart() > 0 && this.isNotCollapseOuter(bpsStart) && this.isNotCollapseOuter(bpsAfter)};
            if (!(roundCorner[0] || roundCorner[1] || roundCorner[2] || roundCorner[3])) {
                try {
                    this.drawRectangularBorders(borderRect, bpsBefore, bpsAfter, bpsStart, bpsEnd);
                }
                catch (IOException ioe) {
                    throw new IFException("IO error drawing borders", ioe);
                }
                return;
            }
            String areaKey = this.makeKey(borderRect, bpsBefore, bpsEnd, bpsAfter, bpsStart, innerBackgroundColor);
            BorderImagePainter painter = null;
            String name = this.documentHandler.getCachedRoundedCorner(areaKey);
            if (name == null) {
                name = this.documentHandler.cacheRoundedCorner(areaKey);
                painter = new BorderImagePainter(cornerCorrectionFactor, borderRect, bpsStart, bpsEnd, bpsBefore, bpsAfter, roundCorner, innerBackgroundColor);
            }
            this.paintCornersAsBitmap(painter, borderRect, name);
        }

        private boolean isNotCollapseOuter(BorderProps bp) {
            return !bp.isCollapseOuter();
        }

        private Area makeCornerClip(int beforeRadius, int startRadius, AffineTransform transform) {
            Rectangle clipR = new Rectangle(0, 0, startRadius, beforeRadius);
            Area clip = new Area(clipR);
            Ellipse2D.Double e = new Ellipse2D.Double();
            e.x = 0.0;
            e.y = 0.0;
            e.width = 2 * startRadius;
            e.height = 2 * beforeRadius;
            clip.subtract(new Area(e));
            clip.transform(transform);
            return clip;
        }

        private Area makeCornerBorderBPD(int beforeRadius, int startRadius, int beforeWidth, int startWidth, AffineTransform transform) {
            Rectangle clipR = new Rectangle(0, 0, startRadius, beforeRadius);
            Ellipse2D.Double e = new Ellipse2D.Double();
            e.x = 0.0;
            e.y = 0.0;
            e.width = 2 * startRadius;
            e.height = 2 * beforeRadius;
            Ellipse2D.Double i = new Ellipse2D.Double();
            i.x = startWidth;
            i.y = beforeWidth;
            i.width = 2 * (startRadius - startWidth);
            i.height = 2 * (beforeRadius - beforeWidth);
            Area clip = new Area(e);
            clip.subtract(new Area(i));
            clip.intersect(new Area(clipR));
            GeneralPath cut = new GeneralPath();
            cut.moveTo(0.0f, 0.0f);
            cut.lineTo(startRadius, (float)startRadius * (float)beforeWidth / (float)startWidth);
            cut.lineTo(startRadius, 0.0f);
            clip.intersect(new Area(cut));
            clip.transform(transform);
            return clip;
        }

        private Area makeCornerBorderIPD(int beforeRadius, int startRadius, int beforeWidth, int startWidth, AffineTransform transform) {
            Rectangle clipR = new Rectangle(0, 0, startRadius, beforeRadius);
            Ellipse2D.Double e = new Ellipse2D.Double();
            e.x = 0.0;
            e.y = 0.0;
            e.width = 2 * startRadius;
            e.height = 2 * beforeRadius;
            Ellipse2D.Double i = new Ellipse2D.Double();
            i.x = startWidth;
            i.y = beforeWidth;
            i.width = 2 * (startRadius - startWidth);
            i.height = 2 * (beforeRadius - beforeWidth);
            Area clip = new Area(e);
            clip.subtract(new Area(i));
            clip.intersect(new Area(clipR));
            GeneralPath cut = new GeneralPath();
            cut.moveTo(0.0f, 0.0f);
            cut.lineTo(startRadius, (float)startRadius * (float)beforeWidth / (float)startWidth);
            cut.lineTo(startRadius, 0.0f);
            clip.subtract(new Area(cut));
            clip.transform(transform);
            return clip;
        }

        private String makeKey(Rectangle area, BorderProps beforeProps, BorderProps endProps, BorderProps afterProps, BorderProps startProps, Color innerBackgroundColor) {
            return this.hash(new StringBuffer().append(area.width).append(":").append(area.height).append(":").append(beforeProps).append(":").append(endProps).append(":").append(afterProps).append(":").append(startProps).append(":").append(innerBackgroundColor).toString());
        }

        private String hash(String text) {
            MessageDigest md;
            try {
                md = MessageDigest.getInstance("MD5");
            }
            catch (Exception e) {
                throw new RuntimeException("Internal error", e);
            }
            byte[] result = md.digest(text.getBytes());
            StringBuffer sb = new StringBuffer();
            char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
            for (int idx = 0; idx < 6; ++idx) {
                byte b = result[idx];
                sb.append(digits[(b & 0xF0) >> 4]);
                sb.append(digits[b & 0xF]);
            }
            return sb.toString();
        }

        private void paintCornersAsBitmap(Graphics2DImagePainter painter, Rectangle boundingBox, String name) throws IFException {
            ImageInfo info = new ImageInfo(name, null);
            ImageSize size = new ImageSize();
            size.setSizeInMillipoints(boundingBox.width, boundingBox.height);
            HashMap<QName, String> map = new HashMap<QName, String>(2);
            map.put(AFPForeignAttributeReader.RESOURCE_NAME, name);
            map.put(AFPForeignAttributeReader.RESOURCE_LEVEL, "print-file");
            AFPRenderingContext context = (AFPRenderingContext)this.painter.createRenderingContext();
            size.setResolution((double)context.getPaintingState().getResolution());
            size.calcPixelsFromSize();
            info.setSize(size);
            ImageGraphics2D img = new ImageGraphics2D(info, painter);
            HashMap<Object, Object> hints = new HashMap<Object, Object>();
            hints.put(ImageHandlerUtil.CONVERSION_MODE, "bitmap");
            hints.put("TARGET_RESOLUTION", context.getPaintingState().getResolution());
            try {
                this.painter.drawImage((Image)img, boundingBox, context, true, hints);
            }
            catch (IOException ioe) {
                throw new IFException("I/O error while painting corner using a bitmap", ioe);
            }
            catch (ImageException ie) {
                throw new IFException("Image error while painting corner using a bitmap", (Exception)((Object)ie));
            }
        }

        protected void arcTo(double startAngle, double endAngle, int cx, int cy, int width, int height) throws IOException {
            throw new UnsupportedOperationException("Can only deal with horizontal lines right now");
        }

        private final class BorderImagePainter
        implements Graphics2DImagePainter {
            private final double cornerCorrectionFactor;
            private final Rectangle borderRect;
            private final BorderProps bpsStart;
            private final BorderProps bpsEnd;
            private final BorderProps bpsBefore;
            private final BorderProps bpsAfter;
            private final boolean[] roundCorner;
            private final Color innerBackgroundColor;

            private BorderImagePainter(double cornerCorrectionFactor, Rectangle borderRect, BorderProps bpsStart, BorderProps bpsEnd, BorderProps bpsBefore, BorderProps bpsAfter, boolean[] roundCorner, Color innerBackgroundColor) {
                this.cornerCorrectionFactor = cornerCorrectionFactor;
                this.borderRect = borderRect;
                this.bpsStart = bpsStart;
                this.bpsBefore = bpsBefore;
                this.roundCorner = roundCorner;
                this.bpsEnd = bpsEnd;
                this.bpsAfter = bpsAfter;
                this.innerBackgroundColor = innerBackgroundColor;
            }

            public void paint(Graphics2D g2d, Rectangle2D area) {
                GeneralPath borderPath;
                int corner;
                int startWidth;
                int beforeWidth;
                int startRadius;
                int beforeRadius;
                AffineTransform transform;
                Area background = new Area(area);
                Area cornerRegion = new Area();
                Area[] cornerBorder = new Area[]{new Area(), new Area(), new Area(), new Area()};
                Area[] clip = new Area[4];
                if (this.roundCorner[0]) {
                    transform = new AffineTransform();
                    beforeRadius = (int)(this.cornerCorrectionFactor * (double)this.bpsBefore.getRadiusStart());
                    startRadius = (int)(this.cornerCorrectionFactor * (double)this.bpsStart.getRadiusStart());
                    beforeWidth = this.bpsBefore.width;
                    startWidth = this.bpsStart.width;
                    corner = 0;
                    background.subtract(AFPBorderPainterAdapter.this.makeCornerClip(beforeRadius, startRadius, transform));
                    clip[0] = new Area(new Rectangle(0, 0, startRadius, beforeRadius));
                    clip[0].transform(transform);
                    cornerRegion.add(clip[0]);
                    cornerBorder[0].add(AFPBorderPainterAdapter.this.makeCornerBorderBPD(beforeRadius, startRadius, beforeWidth, startWidth, transform));
                    cornerBorder[3].add(AFPBorderPainterAdapter.this.makeCornerBorderIPD(beforeRadius, startRadius, beforeWidth, startWidth, transform));
                }
                if (this.roundCorner[1]) {
                    transform = new AffineTransform(-1.0f, 0.0f, 0.0f, 1.0f, this.borderRect.width, 0.0f);
                    beforeRadius = (int)(this.cornerCorrectionFactor * (double)this.bpsBefore.getRadiusEnd());
                    startRadius = (int)(this.cornerCorrectionFactor * (double)this.bpsEnd.getRadiusStart());
                    beforeWidth = this.bpsBefore.width;
                    startWidth = this.bpsEnd.width;
                    corner = 1;
                    background.subtract(AFPBorderPainterAdapter.this.makeCornerClip(beforeRadius, startRadius, transform));
                    clip[1] = new Area(new Rectangle(0, 0, startRadius, beforeRadius));
                    clip[1].transform(transform);
                    cornerRegion.add(clip[1]);
                    cornerBorder[0].add(AFPBorderPainterAdapter.this.makeCornerBorderBPD(beforeRadius, startRadius, beforeWidth, startWidth, transform));
                    cornerBorder[1].add(AFPBorderPainterAdapter.this.makeCornerBorderIPD(beforeRadius, startRadius, beforeWidth, startWidth, transform));
                }
                if (this.roundCorner[2]) {
                    transform = new AffineTransform(-1.0f, 0.0f, 0.0f, -1.0f, this.borderRect.width, this.borderRect.height);
                    beforeRadius = (int)(this.cornerCorrectionFactor * (double)this.bpsAfter.getRadiusEnd());
                    startRadius = (int)(this.cornerCorrectionFactor * (double)this.bpsEnd.getRadiusEnd());
                    beforeWidth = this.bpsAfter.width;
                    startWidth = this.bpsEnd.width;
                    corner = 2;
                    background.subtract(AFPBorderPainterAdapter.this.makeCornerClip(beforeRadius, startRadius, transform));
                    clip[2] = new Area(new Rectangle(0, 0, startRadius, beforeRadius));
                    clip[2].transform(transform);
                    cornerRegion.add(clip[2]);
                    cornerBorder[2].add(AFPBorderPainterAdapter.this.makeCornerBorderBPD(beforeRadius, startRadius, beforeWidth, startWidth, transform));
                    cornerBorder[1].add(AFPBorderPainterAdapter.this.makeCornerBorderIPD(beforeRadius, startRadius, beforeWidth, startWidth, transform));
                }
                if (this.roundCorner[3]) {
                    transform = new AffineTransform(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, this.borderRect.height);
                    beforeRadius = (int)(this.cornerCorrectionFactor * (double)this.bpsAfter.getRadiusStart());
                    startRadius = (int)(this.cornerCorrectionFactor * (double)this.bpsStart.getRadiusEnd());
                    beforeWidth = this.bpsAfter.width;
                    startWidth = this.bpsStart.width;
                    corner = 3;
                    background.subtract(AFPBorderPainterAdapter.this.makeCornerClip(beforeRadius, startRadius, transform));
                    clip[3] = new Area(new Rectangle(0, 0, startRadius, beforeRadius));
                    clip[3].transform(transform);
                    cornerRegion.add(clip[3]);
                    cornerBorder[2].add(AFPBorderPainterAdapter.this.makeCornerBorderBPD(beforeRadius, startRadius, beforeWidth, startWidth, transform));
                    cornerBorder[3].add(AFPBorderPainterAdapter.this.makeCornerBorderIPD(beforeRadius, startRadius, beforeWidth, startWidth, transform));
                }
                g2d.setColor(this.innerBackgroundColor);
                g2d.fill(background);
                if (this.bpsBefore != null && this.bpsBefore.width > 0) {
                    borderPath = new GeneralPath();
                    borderPath.moveTo(0.0f, 0.0f);
                    borderPath.lineTo(this.borderRect.width, 0.0f);
                    borderPath.lineTo(this.borderRect.width - (this.bpsEnd == null ? 0 : this.bpsEnd.width), this.bpsBefore.width);
                    borderPath.lineTo(this.bpsStart == null ? 0.0f : (float)this.bpsStart.width, this.bpsBefore.width);
                    Area border = new Area(borderPath);
                    if (clip[0] != null) {
                        border.subtract(clip[0]);
                    }
                    if (clip[1] != null) {
                        border.subtract(clip[1]);
                    }
                    g2d.setColor(this.bpsBefore.color);
                    g2d.fill(border);
                    g2d.fill(cornerBorder[0]);
                }
                if (this.bpsEnd != null && this.bpsEnd.width > 0) {
                    borderPath = new GeneralPath();
                    borderPath.moveTo(this.borderRect.width, 0.0f);
                    borderPath.lineTo(this.borderRect.width, this.borderRect.height);
                    borderPath.lineTo(this.borderRect.width - this.bpsEnd.width, this.borderRect.height - (this.bpsAfter == null ? 0 : this.bpsAfter.width));
                    borderPath.lineTo(this.borderRect.width - this.bpsEnd.width, this.bpsBefore == null ? 0.0f : (float)this.bpsBefore.width);
                    Area border = new Area(borderPath);
                    if (clip[2] != null) {
                        border.subtract(clip[2]);
                    }
                    if (clip[1] != null) {
                        border.subtract(clip[1]);
                    }
                    g2d.setColor(this.bpsEnd.color);
                    g2d.fill(border);
                    g2d.fill(cornerBorder[1]);
                }
                if (this.bpsAfter != null && this.bpsAfter.width > 0) {
                    borderPath = new GeneralPath();
                    borderPath.moveTo(0.0f, this.borderRect.height);
                    borderPath.lineTo(this.borderRect.width, this.borderRect.height);
                    borderPath.lineTo(this.borderRect.width - (this.bpsEnd == null ? 0 : this.bpsEnd.width), this.borderRect.height - this.bpsAfter.width);
                    borderPath.lineTo(this.bpsStart == null ? 0.0f : (float)this.bpsStart.width, this.borderRect.height - this.bpsAfter.width);
                    Area border = new Area(borderPath);
                    if (clip[3] != null) {
                        border.subtract(clip[3]);
                    }
                    if (clip[2] != null) {
                        border.subtract(clip[2]);
                    }
                    g2d.setColor(this.bpsAfter.color);
                    g2d.fill(border);
                    g2d.fill(cornerBorder[2]);
                }
                if (this.bpsStart != null && this.bpsStart.width > 0) {
                    borderPath = new GeneralPath();
                    borderPath.moveTo(this.bpsStart.width, this.bpsBefore == null ? 0.0f : (float)this.bpsBefore.width);
                    borderPath.lineTo(this.bpsStart.width, this.borderRect.height - (this.bpsAfter == null ? 0 : this.bpsAfter.width));
                    borderPath.lineTo(0.0f, this.borderRect.height);
                    borderPath.lineTo(0.0f, 0.0f);
                    Area border = new Area(borderPath);
                    if (clip[3] != null) {
                        border.subtract(clip[3]);
                    }
                    if (clip[0] != null) {
                        border.subtract(clip[0]);
                    }
                    g2d.setColor(this.bpsStart.color);
                    g2d.fill(border);
                    g2d.fill(cornerBorder[3]);
                }
            }

            public Dimension getImageSize() {
                return this.borderRect.getSize();
            }
        }
    }

    private static final class AFPGraphicsPainter
    implements GraphicsPainter {
        private final AFPBorderPainter graphicsPainter;

        private AFPGraphicsPainter(AFPBorderPainter delegate) {
            this.graphicsPainter = delegate;
        }

        @Override
        public void drawBorderLine(int x1, int y1, int x2, int y2, boolean horz, boolean startOrBefore, int style, Color color) throws IOException {
            BorderPaintingInfo borderPaintInfo = new BorderPaintingInfo(this.toPoints(x1), this.toPoints(y1), this.toPoints(x2), this.toPoints(y2), horz, style, color);
            this.graphicsPainter.paint(borderPaintInfo);
        }

        private float toPoints(int mpt) {
            return (float)mpt / 1000.0f;
        }

        @Override
        public void drawLine(Point start, Point end, int width, Color color, RuleStyle style) throws IOException {
            if (start.y != end.y) {
                throw new UnsupportedOperationException("Can only deal with horizontal lines right now");
            }
            int halfWidth = width / 2;
            this.drawBorderLine(start.x, start.y - halfWidth, end.x, start.y + halfWidth, true, true, style.getEnumValue(), color);
        }

        @Override
        public void moveTo(int x, int y) throws IOException {
        }

        @Override
        public void lineTo(int x, int y) throws IOException {
        }

        @Override
        public void arcTo(double startAngle, double endAngle, int cx, int cy, int width, int height) throws IOException {
        }

        @Override
        public void rotateCoordinates(double angle) throws IOException {
            throw new UnsupportedOperationException("Cannot handle coordinate rotation");
        }

        @Override
        public void translateCoordinates(int xTranslate, int yTranslate) throws IOException {
            throw new UnsupportedOperationException("Cannot handle coordinate translation");
        }

        @Override
        public void scaleCoordinates(float xScale, float yScale) throws IOException {
            throw new UnsupportedOperationException("Cannot handle coordinate scaling");
        }

        @Override
        public void closePath() throws IOException {
        }

        @Override
        public void clip() throws IOException {
        }

        @Override
        public void saveGraphicsState() throws IOException {
        }

        @Override
        public void restoreGraphicsState() throws IOException {
        }
    }
}

