/*
 * Decompiled with CFR 0.152.
 */
package firrtl.backends.experimental.smt;

import firrtl.backends.experimental.smt.ArrayConstant;
import firrtl.backends.experimental.smt.ArrayEqual;
import firrtl.backends.experimental.smt.ArrayExpr;
import firrtl.backends.experimental.smt.ArrayFunctionCall;
import firrtl.backends.experimental.smt.ArrayIte;
import firrtl.backends.experimental.smt.ArrayRead;
import firrtl.backends.experimental.smt.ArrayStore;
import firrtl.backends.experimental.smt.ArraySymbol;
import firrtl.backends.experimental.smt.ArrayType;
import firrtl.backends.experimental.smt.BVAnd;
import firrtl.backends.experimental.smt.BVComparison;
import firrtl.backends.experimental.smt.BVConcat;
import firrtl.backends.experimental.smt.BVEqual;
import firrtl.backends.experimental.smt.BVExpr;
import firrtl.backends.experimental.smt.BVExtend;
import firrtl.backends.experimental.smt.BVForall;
import firrtl.backends.experimental.smt.BVFunctionCall;
import firrtl.backends.experimental.smt.BVImplies;
import firrtl.backends.experimental.smt.BVImplies$;
import firrtl.backends.experimental.smt.BVIte;
import firrtl.backends.experimental.smt.BVLiteral;
import firrtl.backends.experimental.smt.BVNegate;
import firrtl.backends.experimental.smt.BVNot;
import firrtl.backends.experimental.smt.BVOp;
import firrtl.backends.experimental.smt.BVOr;
import firrtl.backends.experimental.smt.BVReduceAnd;
import firrtl.backends.experimental.smt.BVReduceOr;
import firrtl.backends.experimental.smt.BVReduceXor;
import firrtl.backends.experimental.smt.BVSlice;
import firrtl.backends.experimental.smt.BVSymbol;
import firrtl.backends.experimental.smt.BVType;
import firrtl.backends.experimental.smt.Comment;
import firrtl.backends.experimental.smt.Compare$;
import firrtl.backends.experimental.smt.DeclareFunction;
import firrtl.backends.experimental.smt.DeclareUninterpretedSort;
import firrtl.backends.experimental.smt.DeclareUninterpretedSymbol;
import firrtl.backends.experimental.smt.DefineFunction;
import firrtl.backends.experimental.smt.Expander$;
import firrtl.backends.experimental.smt.Op$;
import firrtl.backends.experimental.smt.SMTCommand;
import firrtl.backends.experimental.smt.SMTExpr;
import firrtl.backends.experimental.smt.SMTFunctionArg;
import firrtl.backends.experimental.smt.SMTSymbol;
import firrtl.backends.experimental.smt.SMTType;
import firrtl.backends.experimental.smt.SetLogic;
import firrtl.backends.experimental.smt.UTSymbol;
import java.io.Serializable;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.AbstractIterable;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.SeqFactory;
import scala.collection.SeqFactory$UnapplySeqWrapper$;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class SMTLibSerializer$ {
    public static final SMTLibSerializer$ MODULE$ = new SMTLibSerializer$();
    private static final String bvZero = "(_ bv0 1)";
    private static final String bvOne = "(_ bv1 1)";
    private static final Regex simple = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("[a-zA-Z\\+-/\\*\\=%\\?!\\.$_~&\\^<>@][a-zA-Z0-9\\+-/\\*\\=%\\?!\\.$_~&\\^<>@]*"));

    public String serialize(SMTExpr e) {
        String string;
        SMTExpr sMTExpr = e;
        if (sMTExpr instanceof BVExpr) {
            BVExpr bVExpr = (BVExpr)sMTExpr;
            string = this.serialize(bVExpr);
        } else if (sMTExpr instanceof ArrayExpr) {
            ArrayExpr arrayExpr = (ArrayExpr)sMTExpr;
            string = this.serialize(arrayExpr);
        } else {
            throw new MatchError(sMTExpr);
        }
        return string;
    }

    public String serialize(SMTType t) {
        String string;
        SMTType sMTType = t;
        if (sMTType instanceof BVType) {
            BVType bVType = (BVType)sMTType;
            int width = bVType.width();
            string = this.serializeBitVectorType(width);
        } else if (sMTType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)sMTType;
            int indexWidth = arrayType.indexWidth();
            int dataWidth = arrayType.dataWidth();
            string = this.serializeArrayType(indexWidth, dataWidth);
        } else {
            throw new MatchError(sMTType);
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String serialize(BVExpr e) {
        Some<Tuple2<BVExpr, BVExpr>> some;
        BVExpr bVExpr;
        BVOp bVOp;
        boolean bl;
        BVComparison bVComparison;
        boolean bl2;
        BVImplies bVImplies;
        boolean bl3;
        while (true) {
            BVExpr bVExpr2;
            boolean bl4 = false;
            BVExtend bVExtend = null;
            boolean bl5 = false;
            BVNot bVNot = null;
            bl3 = false;
            bVImplies = null;
            bl2 = false;
            bVComparison = null;
            bl = false;
            bVOp = null;
            bVExpr = e;
            if (bVExpr instanceof BVLiteral) {
                BigInt twosComplement;
                BVLiteral bVLiteral = (BVLiteral)bVExpr;
                BigInt value = bVLiteral.value();
                int width = bVLiteral.width();
                BigInt mask = package$.MODULE$.BigInt().apply(1).$less$less(width).$minus(BigInt$.MODULE$.int2bigInt(1));
                BigInt bigInt = twosComplement = value.$less(BigInt$.MODULE$.int2bigInt(0)) ? value.unary_$minus().unary_$tilde().$amp(mask).$plus(BigInt$.MODULE$.int2bigInt(1)) : value;
                if (width == 1) {
                    if (!BoxesRunTime.equalsNumObject(twosComplement, BoxesRunTime.boxToInteger(1))) return "false";
                    return "true";
                }
                String string = new StringBuilder(7).append("(_ bv").append(twosComplement).append(" ").append(width).append(")").toString();
                return string;
            }
            if (bVExpr instanceof BVSymbol) {
                BVSymbol bVSymbol = (BVSymbol)bVExpr;
                String name = bVSymbol.name();
                return this.escapeIdentifier(name);
            }
            if (bVExpr instanceof BVExtend) {
                bl4 = true;
                bVExtend = (BVExtend)bVExpr;
                BVExpr e2 = bVExtend.e();
                int n = bVExtend.by();
                if (0 == n) {
                    e = e2;
                    continue;
                }
            }
            if (bl4) {
                BVExpr bVExpr3 = bVExtend.e();
                int by = bVExtend.by();
                boolean bl6 = bVExtend.signed();
                if (bVExpr3 instanceof BVLiteral) {
                    BVLiteral bVLiteral = (BVLiteral)bVExpr3;
                    BigInt value = bVLiteral.value();
                    int width = bVLiteral.width();
                    if (!bl6) {
                        e = new BVLiteral(value, width + by);
                        continue;
                    }
                }
            }
            if (bl4) {
                BVExpr e3 = bVExtend.e();
                int by = bVExtend.by();
                boolean signed = bVExtend.signed();
                String foo = signed ? "sign_extend" : "zero_extend";
                return new StringBuilder(8).append("((_ ").append(foo).append(" ").append(by).append(") ").append(this.asBitVector(e3)).append(")").toString();
            }
            if (bVExpr instanceof BVSlice) {
                BVSlice bVSlice = (BVSlice)bVExpr;
                BVExpr e4 = bVSlice.e();
                int hi = bVSlice.hi();
                int lo = bVSlice.lo();
                if (lo == 0 && hi == e4.width() - 1) {
                    e = e4;
                    continue;
                }
                String bits = new StringBuilder(16).append("((_ extract ").append(hi).append(" ").append(lo).append(") ").append(this.asBitVector(e4)).append(")").toString();
                return lo == hi ? this.toBool(bits) : bits;
            }
            if (bVExpr instanceof BVNot) {
                bl5 = true;
                bVNot = (BVNot)bVExpr;
                BVExpr bVExpr4 = bVNot.e();
                if (bVExpr4 instanceof BVEqual) {
                    BVEqual bVEqual = (BVEqual)bVExpr4;
                    BVExpr a2 = bVEqual.a();
                    BVExpr b = bVEqual.b();
                    if (a2.width() == 1) {
                        return new StringBuilder(12).append("(distinct ").append(this.serialize(a2)).append(" ").append(this.serialize(b)).append(")").toString();
                    }
                }
            }
            if (bl5 && (bVExpr2 = bVNot.e()) instanceof BVNot) {
                BVExpr e5;
                BVNot bVNot2 = (BVNot)bVExpr2;
                e = e5 = bVNot2.e();
                continue;
            }
            if (bl5) {
                BVExpr e6 = bVNot.e();
                return e6.width() == 1 ? new StringBuilder(6).append("(not ").append(this.serialize(e6)).append(")").toString() : new StringBuilder(8).append("(bvnot ").append(this.serialize(e6)).append(")").toString();
            }
            if (bVExpr instanceof BVNegate) {
                BVNegate bVNegate = (BVNegate)bVExpr;
                BVExpr e7 = bVNegate.e();
                return new StringBuilder(8).append("(bvneg ").append(this.asBitVector(e7)).append(")").toString();
            }
            if (bVExpr instanceof BVReduceAnd) {
                BVReduceAnd bVReduceAnd = (BVReduceAnd)bVExpr;
                e = Expander$.MODULE$.expand(bVReduceAnd);
                continue;
            }
            if (bVExpr instanceof BVReduceOr) {
                BVReduceOr bVReduceOr = (BVReduceOr)bVExpr;
                e = Expander$.MODULE$.expand(bVReduceOr);
                continue;
            }
            if (bVExpr instanceof BVReduceXor) {
                BVReduceXor bVReduceXor = (BVReduceXor)bVExpr;
                e = Expander$.MODULE$.expand(bVReduceXor);
                continue;
            }
            if (!(bVExpr instanceof BVImplies)) break;
            bl3 = true;
            bVImplies = (BVImplies)bVExpr;
            Some<Tuple2<BVExpr, BVExpr>> some2 = BVImplies$.MODULE$.unapply(bVImplies);
            if (some2.isEmpty()) break;
            BVExpr bVExpr5 = some2.get()._1();
            BVExpr b = some2.get()._2();
            if (!(bVExpr5 instanceof BVLiteral)) break;
            BVLiteral bVLiteral = (BVLiteral)bVExpr5;
            BigInt v = bVLiteral.value();
            int n = bVLiteral.width();
            if (1 != n || !BoxesRunTime.equalsNumObject(v, BoxesRunTime.boxToInteger(1))) break;
            e = b;
        }
        if (bl3 && !(some = BVImplies$.MODULE$.unapply(bVImplies)).isEmpty()) {
            BVExpr a3 = some.get()._1();
            BVExpr b = some.get()._2();
            return new StringBuilder(6).append("(=> ").append(this.serialize(a3)).append(" ").append(this.serialize(b)).append(")").toString();
        }
        if (bVExpr instanceof BVEqual) {
            BVEqual bVEqual = (BVEqual)bVExpr;
            BVExpr a4 = bVEqual.a();
            BVExpr b = bVEqual.b();
            return new StringBuilder(5).append("(= ").append(this.serialize(a4)).append(" ").append(this.serialize(b)).append(")").toString();
        }
        if (bVExpr instanceof ArrayEqual) {
            ArrayEqual arrayEqual = (ArrayEqual)bVExpr;
            ArrayExpr a5 = arrayEqual.a();
            ArrayExpr b = arrayEqual.b();
            return new StringBuilder(5).append("(= ").append(this.serialize(a5)).append(" ").append(this.serialize(b)).append(")").toString();
        }
        if (bVExpr instanceof BVComparison) {
            bl2 = true;
            bVComparison = (BVComparison)bVExpr;
            Enumeration.Value value = bVComparison.op();
            BVExpr a6 = bVComparison.a();
            BVExpr b = bVComparison.b();
            boolean bl7 = bVComparison.signed();
            Enumeration.Value value2 = Compare$.MODULE$.Greater();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !((Object)value2).equals(value3) : value3 != null) && !bl7) {
                return new StringBuilder(9).append("(bvugt ").append(this.asBitVector(a6)).append(" ").append(this.asBitVector(b)).append(")").toString();
            }
        }
        if (bl2) {
            Enumeration.Value value = bVComparison.op();
            BVExpr a7 = bVComparison.a();
            BVExpr b = bVComparison.b();
            boolean bl8 = bVComparison.signed();
            Enumeration.Value value4 = Compare$.MODULE$.GreaterEqual();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !((Object)value4).equals(value5) : value5 != null) && !bl8) {
                return new StringBuilder(9).append("(bvuge ").append(this.asBitVector(a7)).append(" ").append(this.asBitVector(b)).append(")").toString();
            }
        }
        if (bl2) {
            Enumeration.Value value = bVComparison.op();
            BVExpr a8 = bVComparison.a();
            BVExpr b = bVComparison.b();
            boolean bl9 = bVComparison.signed();
            Enumeration.Value value6 = Compare$.MODULE$.Greater();
            Enumeration.Value value7 = value;
            if (!(value6 != null ? !((Object)value6).equals(value7) : value7 != null) && bl9) {
                return new StringBuilder(9).append("(bvsgt ").append(this.asBitVector(a8)).append(" ").append(this.asBitVector(b)).append(")").toString();
            }
        }
        if (bl2) {
            Enumeration.Value value = bVComparison.op();
            BVExpr a9 = bVComparison.a();
            BVExpr b = bVComparison.b();
            boolean bl10 = bVComparison.signed();
            Enumeration.Value value8 = Compare$.MODULE$.GreaterEqual();
            Enumeration.Value value9 = value;
            if (!(value8 != null ? !((Object)value8).equals(value9) : value9 != null) && bl10) {
                return new StringBuilder(9).append("(bvsge ").append(this.asBitVector(a9)).append(" ").append(this.asBitVector(b)).append(")").toString();
            }
        }
        if (bVExpr instanceof BVAnd) {
            BVAnd bVAnd = (BVAnd)bVExpr;
            return this.serializeVariadic(bVAnd.width() == 1 ? "and" : "bvand", bVAnd.terms());
        }
        if (bVExpr instanceof BVOr) {
            BVOr bVOr = (BVOr)bVExpr;
            return this.serializeVariadic(bVOr.width() == 1 ? "or" : "bvor", bVOr.terms());
        }
        if (bVExpr instanceof BVOp) {
            bl = true;
            bVOp = (BVOp)bVExpr;
            Enumeration.Value value = bVOp.op();
            BVExpr a10 = bVOp.a();
            BVExpr b = bVOp.b();
            Enumeration.Value value10 = Op$.MODULE$.Xor();
            Enumeration.Value value11 = value;
            if (!(value10 != null ? !((Object)value10).equals(value11) : value11 != null) && a10.width() == 1) {
                return new StringBuilder(7).append("(xor ").append(this.serialize(a10)).append(" ").append(this.serialize(b)).append(")").toString();
            }
        }
        if (bl) {
            Enumeration.Value op = bVOp.op();
            BVExpr a11 = bVOp.a();
            BVExpr b = bVOp.b();
            if (a11.width() == 1) {
                return this.toBool(new StringBuilder(4).append("(").append(this.serialize(op)).append(" ").append(this.asBitVector(a11)).append(" ").append(this.asBitVector(b)).append(")").toString());
            }
        }
        if (bl) {
            Enumeration.Value op = bVOp.op();
            BVExpr a12 = bVOp.a();
            BVExpr b = bVOp.b();
            return new StringBuilder(4).append("(").append(this.serialize(op)).append(" ").append(this.serialize(a12)).append(" ").append(this.serialize(b)).append(")").toString();
        }
        if (bVExpr instanceof BVConcat) {
            BVConcat bVConcat = (BVConcat)bVExpr;
            BVExpr a13 = bVConcat.a();
            BVExpr b = bVConcat.b();
            return new StringBuilder(10).append("(concat ").append(this.asBitVector(a13)).append(" ").append(this.asBitVector(b)).append(")").toString();
        }
        if (bVExpr instanceof ArrayRead) {
            ArrayRead arrayRead = (ArrayRead)bVExpr;
            ArrayExpr array = arrayRead.array();
            BVExpr index = arrayRead.index();
            return new StringBuilder(10).append("(select ").append(this.serialize(array)).append(" ").append(this.serialize(index)).append(")").toString();
        }
        if (bVExpr instanceof BVIte) {
            BVIte bVIte = (BVIte)bVExpr;
            BVExpr cond = bVIte.cond();
            BVExpr tru = bVIte.tru();
            BVExpr fals = bVIte.fals();
            return new StringBuilder(8).append("(ite ").append(this.serialize(cond)).append(" ").append(this.serialize(tru)).append(" ").append(this.serialize(fals)).append(")").toString();
        }
        if (bVExpr instanceof BVFunctionCall) {
            BVFunctionCall bVFunctionCall = (BVFunctionCall)bVExpr;
            String name = bVFunctionCall.name();
            List<SMTFunctionArg> args = bVFunctionCall.args();
            return ((AbstractIterable)args.map((Function1<SMTFunctionArg, String> & Serializable)a -> MODULE$.serializeArg((SMTFunctionArg)a))).mkString(new StringBuilder(2).append("(").append(name).append(" ").toString(), " ", ")");
        }
        if (!(bVExpr instanceof BVForall)) throw new MatchError(bVExpr);
        BVForall bVForall = (BVForall)bVExpr;
        BVSymbol variable = bVForall.variable();
        BVExpr e8 = bVForall.e();
        return new StringBuilder(15).append("(forall ((").append(variable.name()).append(" ").append(this.serialize(variable.tpe())).append(")) ").append(this.serialize(e8)).append(")").toString();
    }

    private String serializeVariadic(String op, List<BVExpr> terms) {
        String string;
        SeqOps seqOps;
        SeqOps seqOps2;
        SeqOps seqOps3;
        List<BVExpr> list2 = terms;
        boolean bl = list2 != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps3 = package$.MODULE$.Seq().unapplySeq(list2)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps3)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 0) == 0 ? true : list2 != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2 = package$.MODULE$.Seq().unapplySeq(list2)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps2)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 1) == 0;
        if (bl) {
            throw new RuntimeException(new StringBuilder(46).append("expected at least two elements in variadic op ").append(op).toString());
        }
        if (list2 != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq(list2)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) == 0) {
            BVExpr a = (BVExpr)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            BVExpr b = (BVExpr)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
            string = new StringBuilder(4).append("(").append(op).append(" ").append(this.serialize(a)).append(" ").append(this.serialize(b)).append(")").toString();
        } else if (list2 instanceof $colon$colon) {
            $colon$colon $colon$colon = ($colon$colon)list2;
            BVExpr head = (BVExpr)$colon$colon.head();
            List<BVExpr> tail = $colon$colon.next$access$1();
            string = new StringBuilder(4).append("(").append(op).append(" ").append(this.serialize(head)).append(" ").append(this.serializeVariadic(op, tail)).append(")").toString();
        } else {
            throw new MatchError(list2);
        }
        return string;
    }

    public String serialize(ArrayExpr e) {
        String string;
        ArrayExpr arrayExpr = e;
        if (arrayExpr instanceof ArraySymbol) {
            ArraySymbol arraySymbol = (ArraySymbol)arrayExpr;
            String name = arraySymbol.name();
            string = this.escapeIdentifier(name);
        } else if (arrayExpr instanceof ArrayStore) {
            ArrayStore arrayStore = (ArrayStore)arrayExpr;
            ArrayExpr array = arrayStore.array();
            BVExpr index = arrayStore.index();
            BVExpr data2 = arrayStore.data();
            string = new StringBuilder(10).append("(store ").append(this.serialize(array)).append(" ").append(this.serialize(index)).append(" ").append(this.serialize(data2)).append(")").toString();
        } else if (arrayExpr instanceof ArrayIte) {
            ArrayIte arrayIte = (ArrayIte)arrayExpr;
            BVExpr cond = arrayIte.cond();
            ArrayExpr tru = arrayIte.tru();
            ArrayExpr fals = arrayIte.fals();
            string = new StringBuilder(8).append("(ite ").append(this.serialize(cond)).append(" ").append(this.serialize(tru)).append(" ").append(this.serialize(fals)).append(")").toString();
        } else if (arrayExpr instanceof ArrayConstant) {
            ArrayConstant arrayConstant = (ArrayConstant)arrayExpr;
            BVExpr e2 = arrayConstant.e();
            string = new StringBuilder(14).append("((as const ").append(this.serializeArrayType(arrayConstant.indexWidth(), arrayConstant.dataWidth())).append(") ").append(this.serialize(e2)).append(")").toString();
        } else if (arrayExpr instanceof ArrayFunctionCall) {
            ArrayFunctionCall arrayFunctionCall = (ArrayFunctionCall)arrayExpr;
            String name = arrayFunctionCall.name();
            List<SMTFunctionArg> args = arrayFunctionCall.args();
            string = ((AbstractIterable)args.map((Function1<SMTFunctionArg, String> & Serializable)a -> MODULE$.serializeArg((SMTFunctionArg)a))).mkString(new StringBuilder(2).append("(").append(name).append(" ").toString(), " ", ")");
        } else {
            throw new MatchError(arrayExpr);
        }
        return string;
    }

    public String serialize(SMTCommand c) {
        String string;
        SMTCommand sMTCommand = c;
        if (sMTCommand instanceof Comment) {
            Comment comment = (Comment)sMTCommand;
            String msg = comment.msg();
            string = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps(msg.split("\n")), (Function1<String, String> & Serializable)x$1 -> new StringBuilder(2).append("; ").append((String)x$1).toString(), ClassTag$.MODULE$.apply(String.class))).mkString("\n");
        } else if (sMTCommand instanceof DeclareUninterpretedSort) {
            DeclareUninterpretedSort declareUninterpretedSort = (DeclareUninterpretedSort)sMTCommand;
            String name = declareUninterpretedSort.name();
            string = new StringBuilder(17).append("(declare-sort ").append(this.escapeIdentifier(name)).append(" 0)").toString();
        } else if (sMTCommand instanceof DefineFunction) {
            DefineFunction defineFunction = (DefineFunction)sMTCommand;
            String name = defineFunction.name();
            Seq<SMTFunctionArg> args = defineFunction.args();
            SMTExpr e = defineFunction.e();
            String aa = ((IterableOnceOps)args.map((Function1<SMTFunctionArg, String> & Serializable)a -> new StringBuilder(3).append("(").append(MODULE$.serializeArg((SMTFunctionArg)a)).append(" ").append(MODULE$.serializeArgTpe((SMTFunctionArg)a)).append(")").toString())).mkString(" ");
            string = new StringBuilder(18).append("(define-fun ").append(this.escapeIdentifier(name)).append(" (").append(aa).append(") ").append(this.serialize(e.tpe())).append(" ").append(this.serialize(e)).append(")").toString();
        } else if (sMTCommand instanceof DeclareFunction) {
            DeclareFunction declareFunction = (DeclareFunction)sMTCommand;
            SMTSymbol sym = declareFunction.sym();
            Seq<SMTFunctionArg> tpes = declareFunction.args();
            String aa = ((IterableOnceOps)tpes.map((Function1<SMTFunctionArg, String> & Serializable)a -> MODULE$.serializeArgTpe((SMTFunctionArg)a))).mkString(" ");
            string = new StringBuilder(18).append("(declare-fun ").append(this.escapeIdentifier(sym.name())).append(" (").append(aa).append(") ").append(this.serialize(sym.tpe())).append(")").toString();
        } else if (sMTCommand instanceof SetLogic) {
            SetLogic setLogic = (SetLogic)sMTCommand;
            String logic = setLogic.logic();
            string = new StringBuilder(12).append("(set-logic ").append(logic).append(")").toString();
        } else if (sMTCommand instanceof DeclareUninterpretedSymbol) {
            DeclareUninterpretedSymbol declareUninterpretedSymbol = (DeclareUninterpretedSymbol)sMTCommand;
            String name = declareUninterpretedSymbol.name();
            String tpe = declareUninterpretedSymbol.tpe();
            string = new StringBuilder(18).append("(declare-fun ").append(this.escapeIdentifier(name)).append(" () ").append(this.escapeIdentifier(tpe)).append(")").toString();
        } else {
            throw new MatchError(sMTCommand);
        }
        return string;
    }

    private String serializeArgTpe(SMTFunctionArg a) {
        String string;
        SMTFunctionArg sMTFunctionArg = a;
        if (sMTFunctionArg instanceof UTSymbol) {
            UTSymbol uTSymbol = (UTSymbol)sMTFunctionArg;
            string = this.escapeIdentifier(uTSymbol.tpe());
        } else if (sMTFunctionArg instanceof SMTExpr) {
            SMTExpr sMTExpr = (SMTExpr)sMTFunctionArg;
            string = this.serialize(sMTExpr.tpe());
        } else {
            throw new MatchError(sMTFunctionArg);
        }
        return string;
    }

    private String serializeArg(SMTFunctionArg a) {
        String string;
        SMTFunctionArg sMTFunctionArg = a;
        if (sMTFunctionArg instanceof UTSymbol) {
            UTSymbol uTSymbol = (UTSymbol)sMTFunctionArg;
            string = this.escapeIdentifier(uTSymbol.name());
        } else if (sMTFunctionArg instanceof SMTExpr) {
            SMTExpr sMTExpr = (SMTExpr)sMTFunctionArg;
            string = this.serialize(sMTExpr);
        } else {
            throw new MatchError(sMTFunctionArg);
        }
        return string;
    }

    private String serializeArrayType(int indexWidth, int dataWidth) {
        return new StringBuilder(9).append("(Array ").append(this.serializeBitVectorType(indexWidth)).append(" ").append(this.serializeBitVectorType(dataWidth)).append(")").toString();
    }

    private String serializeBitVectorType(int width) {
        String string;
        if (width == 1) {
            string = "Bool";
        } else {
            Predef$.MODULE$.assert(width > 1);
            string = new StringBuilder(11).append("(_ BitVec ").append(width).append(")").toString();
        }
        return string;
    }

    private String serialize(Enumeration.Value op) {
        String string;
        Enumeration.Value value = op;
        Enumeration.Value value2 = Op$.MODULE$.Xor();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !((Object)value2).equals(value3) : value3 != null)) {
            string = "bvxor";
        } else {
            Enumeration.Value value4 = Op$.MODULE$.ArithmeticShiftRight();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !((Object)value4).equals(value5) : value5 != null)) {
                string = "bvashr";
            } else {
                Enumeration.Value value6 = Op$.MODULE$.ShiftRight();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !((Object)value6).equals(value7) : value7 != null)) {
                    string = "bvlshr";
                } else {
                    Enumeration.Value value8 = Op$.MODULE$.ShiftLeft();
                    Enumeration.Value value9 = value;
                    if (!(value8 != null ? !((Object)value8).equals(value9) : value9 != null)) {
                        string = "bvshl";
                    } else {
                        Enumeration.Value value10 = Op$.MODULE$.Add();
                        Enumeration.Value value11 = value;
                        if (!(value10 != null ? !((Object)value10).equals(value11) : value11 != null)) {
                            string = "bvadd";
                        } else {
                            Enumeration.Value value12 = Op$.MODULE$.Mul();
                            Enumeration.Value value13 = value;
                            if (!(value12 != null ? !((Object)value12).equals(value13) : value13 != null)) {
                                string = "bvmul";
                            } else {
                                Enumeration.Value value14 = Op$.MODULE$.Sub();
                                Enumeration.Value value15 = value;
                                if (!(value14 != null ? !((Object)value14).equals(value15) : value15 != null)) {
                                    string = "bvsub";
                                } else {
                                    Enumeration.Value value16 = Op$.MODULE$.SignedDiv();
                                    Enumeration.Value value17 = value;
                                    if (!(value16 != null ? !((Object)value16).equals(value17) : value17 != null)) {
                                        string = "bvsdiv";
                                    } else {
                                        Enumeration.Value value18 = Op$.MODULE$.UnsignedDiv();
                                        Enumeration.Value value19 = value;
                                        if (!(value18 != null ? !((Object)value18).equals(value19) : value19 != null)) {
                                            string = "bvudiv";
                                        } else {
                                            Enumeration.Value value20 = Op$.MODULE$.SignedMod();
                                            Enumeration.Value value21 = value;
                                            if (!(value20 != null ? !((Object)value20).equals(value21) : value21 != null)) {
                                                string = "bvsmod";
                                            } else {
                                                Enumeration.Value value22 = Op$.MODULE$.SignedRem();
                                                Enumeration.Value value23 = value;
                                                if (!(value22 != null ? !((Object)value22).equals(value23) : value23 != null)) {
                                                    string = "bvsrem";
                                                } else {
                                                    Enumeration.Value value24 = Op$.MODULE$.UnsignedRem();
                                                    Enumeration.Value value25 = value;
                                                    if (!(value24 != null ? !((Object)value24).equals(value25) : value25 != null)) {
                                                        string = "bvurem";
                                                    } else {
                                                        throw new MatchError(value);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return string;
    }

    private String toBool(String e) {
        return new StringBuilder(14).append("(= ").append(e).append(" (_ bv1 1))").toString();
    }

    private String bvZero() {
        return bvZero;
    }

    private String bvOne() {
        return bvOne;
    }

    private String asBitVector(BVExpr e) {
        return e.width() > 1 ? this.serialize(e) : new StringBuilder(8).append("(ite ").append(this.serialize(e)).append(" ").append(this.bvOne()).append(" ").append(this.bvZero()).append(")").toString();
    }

    private Regex simple() {
        return simple;
    }

    public String escapeIdentifier(String name) {
        Option<List<String>> option;
        String string = name;
        String string2 = string != null && !(option = this.simple().unapplySeq(string)).isEmpty() && option.get() != null && option.get().lengthCompare(0) == 0 ? name : (name.startsWith("|") && name.endsWith("|") ? name : new StringBuilder(2).append("|").append(name).append("|").toString());
        return string2;
    }

    private SMTLibSerializer$() {
    }
}

