/*
 * Decompiled with CFR 0.152.
 */
package firrtl;

import firrtl.DuplexFlow$;
import firrtl.EmptyExpression$;
import firrtl.ExpKind$;
import firrtl.FirrtlInternalException;
import firrtl.Flow;
import firrtl.Implicits$;
import firrtl.Kind;
import firrtl.Mappers;
import firrtl.Mappers$;
import firrtl.Mappers$ExprMagnet$;
import firrtl.Mappers$ExprMap$;
import firrtl.Mappers$StmtMagnet$;
import firrtl.Mappers$StmtMap$;
import firrtl.PrimOps$;
import firrtl.PrimOps$And$;
import firrtl.PrimOps$AsAsyncReset$;
import firrtl.PrimOps$AsClock$;
import firrtl.PrimOps$AsFixedPoint$;
import firrtl.PrimOps$AsSInt$;
import firrtl.PrimOps$AsUInt$;
import firrtl.PrimOps$Bits$;
import firrtl.PrimOps$Eq$;
import firrtl.PrimOps$Head$;
import firrtl.PrimOps$Not$;
import firrtl.PrimOps$Or$;
import firrtl.PrimOps$Shr$;
import firrtl.PrimOps$Tail$;
import firrtl.SinkFlow$;
import firrtl.SourceFlow$;
import firrtl.UnknownFlow$;
import firrtl.Utils;
import firrtl.Utils$False$;
import firrtl.Utils$True$;
import firrtl.WDefInstanceConnector;
import firrtl.WInvalid$;
import firrtl.WRef$;
import firrtl.WSubField$;
import firrtl.WSubIndex$;
import firrtl.WrappedExpression;
import firrtl.WrappedExpression$;
import firrtl.annotations.ReferenceTarget;
import firrtl.annotations.TargetToken;
import firrtl.constraint.IsMax$;
import firrtl.constraint.IsMin$;
import firrtl.ir.AnalogType;
import firrtl.ir.AsyncResetType$;
import firrtl.ir.Block;
import firrtl.ir.Bound;
import firrtl.ir.BundleType;
import firrtl.ir.Circuit;
import firrtl.ir.ClockType$;
import firrtl.ir.Conditionally;
import firrtl.ir.Connect;
import firrtl.ir.DefInstance;
import firrtl.ir.DefMemory;
import firrtl.ir.DefMemory$;
import firrtl.ir.DefModule;
import firrtl.ir.DefNode;
import firrtl.ir.DefRegister;
import firrtl.ir.DefWire;
import firrtl.ir.Default$;
import firrtl.ir.Direction;
import firrtl.ir.DoPrim;
import firrtl.ir.EmptyStmt$;
import firrtl.ir.Expression;
import firrtl.ir.ExtModule;
import firrtl.ir.Field;
import firrtl.ir.FixedLiteral;
import firrtl.ir.FixedType;
import firrtl.ir.Flip$;
import firrtl.ir.GroundType;
import firrtl.ir.HasInfo;
import firrtl.ir.HasName;
import firrtl.ir.Info;
import firrtl.ir.Input$;
import firrtl.ir.IntWidth;
import firrtl.ir.IntWidth$;
import firrtl.ir.IntervalType;
import firrtl.ir.IsDeclaration;
import firrtl.ir.IsInvalid;
import firrtl.ir.Literal;
import firrtl.ir.Module;
import firrtl.ir.Mux;
import firrtl.ir.NoInfo$;
import firrtl.ir.Orientation;
import firrtl.ir.Output$;
import firrtl.ir.PartialConnect;
import firrtl.ir.Port;
import firrtl.ir.PrimOp;
import firrtl.ir.Print;
import firrtl.ir.Reference;
import firrtl.ir.ResetType$;
import firrtl.ir.SIntLiteral;
import firrtl.ir.SIntType;
import firrtl.ir.Statement;
import firrtl.ir.Stop;
import firrtl.ir.SubAccess;
import firrtl.ir.SubField;
import firrtl.ir.SubIndex;
import firrtl.ir.Type;
import firrtl.ir.UIntLiteral;
import firrtl.ir.UIntLiteral$;
import firrtl.ir.UIntType;
import firrtl.ir.UnknownBound$;
import firrtl.ir.UnknownType$;
import firrtl.ir.UnknownWidth$;
import firrtl.ir.ValidIf;
import firrtl.ir.VectorType;
import firrtl.ir.Width;
import firrtl.passes.CheckTypes$;
import firrtl.passes.MemPortUtils$;
import firrtl.traversals.Foreachers;
import firrtl.traversals.Foreachers$;
import firrtl.traversals.Foreachers$ExprForMagnet$;
import firrtl.traversals.Foreachers$ExprForeach$;
import firrtl.traversals.Foreachers$StmtForMagnet$;
import firrtl.traversals.Foreachers$StmtForeach$;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import logger.LazyLogging;
import logger.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$mcII$sp;
import scala.Tuple3;
import scala.collection.AbstractMap;
import scala.collection.AbstractSeq;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Growable;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.LinkedHashMap$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.math.BigDecimal;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.math.Ordering$String$;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.matching.Regex;
import scala.util.matching.Regex$;

public final class Utils$
implements LazyLogging {
    public static final Utils$ MODULE$ = new Utils$();
    private static final UIntType BoolType;
    private static final UIntLiteral one;
    private static final UIntLiteral zero;
    private static final DoPrim ClockZero;
    private static final DoPrim AsyncZero;
    private static final Set<String> v_keywords;
    private static Logger logger;

    static {
        LazyLogging.$init$(MODULE$);
        BoolType = new UIntType(IntWidth$.MODULE$.apply(BigInt$.MODULE$.int2bigInt(1)));
        one = UIntLiteral$.MODULE$.apply(BigInt$.MODULE$.int2bigInt(1));
        zero = UIntLiteral$.MODULE$.apply(BigInt$.MODULE$.int2bigInt(0));
        ClockZero = new DoPrim(PrimOps$AsClock$.MODULE$, (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UIntLiteral[]{MODULE$.zero()})), (Seq)scala.package$.MODULE$.Seq().empty(), ClockType$.MODULE$);
        AsyncZero = new DoPrim(PrimOps$AsAsyncReset$.MODULE$, (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UIntLiteral[]{MODULE$.zero()})), scala.package$.MODULE$.Nil(), AsyncResetType$.MODULE$);
        v_keywords = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"alias", "always", "always_comb", "always_ff", "always_latch", "and", "assert", "assign", "assume", "attribute", "automatic", "before", "begin", "bind", "bins", "binsof", "bit", "break", "buf", "bufif0", "bufif1", "byte", "case", "casex", "casez", "cell", "chandle", "checker", "class", "clocking", "cmos", "config", "const", "constraint", "context", "continue", "cover", "covergroup", "coverpoint", "cross", "deassign", "default", "defparam", "design", "disable", "dist", "do", "edge", "else", "end", "endattribute", "endcase", "endclass", "endclocking", "endconfig", "endfunction", "endgenerate", "endgroup", "endinterface", "endmodule", "endpackage", "endprimitive", "endprogram", "endproperty", "endspecify", "endsequence", "endtable", "endtask", "enum", "event", "expect", "export", "extends", "extern", "final", "first_match", "for", "force", "foreach", "forever", "fork", "forkjoin", "function", "generate", "genvar", "highz0", "highz1", "if", "iff", "ifnone", "ignore_bins", "illegal_bins", "import", "incdir", "include", "initial", "initvar", "inout", "input", "inside", "instance", "int", "integer", "interconnect", "interface", "intersect", "join", "join_any", "join_none", "large", "liblist", "library", "local", "localparam", "logic", "longint", "macromodule", "matches", "medium", "modport", "module", "nand", "negedge", "new", "nmos", "nor", "noshowcancelled", "not", "notif0", "notif1", "null", "or", "output", "package", "packed", "parameter", "pmos", "posedge", "primitive", "priority", "program", "property", "protected", "pull0", "pull1", "pulldown", "pullup", "pulsestyle_onevent", "pulsestyle_ondetect", "pure", "rand", "randc", "randcase", "randsequence", "rcmos", "real", "realtime", "ref", "reg", "release", "repeat", "return", "rnmos", "rpmos", "rtran", "rtranif0", "rtranif1", "scalared", "sequence", "shortint", "shortreal", "showcancelled", "signed", "small", "solve", "specify", "specparam", "static", "strength", "string", "strong", "strong0", "strong1", "struct", "super", "supply0", "supply1", "table", "tagged", "task", "this", "throughout", "time", "timeprecision", "timeunit", "tran", "tranif0", "tranif1", "tri", "tri0", "tri1", "triand", "trior", "trireg", "type", "typedef", "union", "unique", "unsigned", "use", "var", "vectored", "virtual", "void", "wait", "wait_order", "wand", "weak", "weak0", "weak1", "while", "wildcard", "wire", "with", "within", "wor", "xnor", "xor", "SYNTHESIS", "PRINTF_COND", "VCS"}));
    }

    @Override
    public Logger getLogger() {
        return LazyLogging.getLogger$(this);
    }

    @Override
    public Logger logger() {
        return logger;
    }

    @Override
    public void logger$LazyLogging$_setter_$logger_$eq(Logger x$1) {
        logger = x$1;
    }

    public Throwable getThrowable(Option<Throwable> maybeException, boolean first) {
        Throwable throwable;
        block6: {
            Some some;
            Throwable e;
            Option<Throwable> option;
            while ((option = maybeException) instanceof Some && (e = (Throwable)(some = (Some)option).value()) != null) {
                Throwable throwable2;
                Throwable throwable3 = e;
                Throwable t = throwable3.getCause();
                if (t != null) {
                    if (first) {
                        maybeException = new Some<Throwable>(t);
                        continue;
                    }
                    throwable2 = t;
                } else {
                    throwable2 = throwable3;
                }
                throwable = throwable2;
                break block6;
            }
            boolean bl = None$.MODULE$.equals(option) ? true : option == null;
            if (bl) {
                throwable = null;
            } else {
                throw new MatchError(option);
            }
        }
        return throwable;
    }

    public Nothing$ throwInternalError(String message, Option<Exception> exception) {
        boolean first = true;
        Throwable throwable = this.getThrowable(exception, true);
        String string = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(message)) ? new StringBuilder(1).append(message).append("\n").toString() : message;
        return this.error(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Internal Error! %sPlease file an issue at https://github.com/ucb-bar/firrtl/issues"), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{string})), throwable);
    }

    public String throwInternalError$default$1() {
        return "";
    }

    public Option<Exception> throwInternalError$default$2() {
        return None$.MODULE$;
    }

    public <R> Tuple2<Object, R> time(Function0<R> block) {
        long t0 = System.nanoTime();
        R result2 = block.apply();
        long t1 = System.nanoTime();
        double timeMillis = (double)(t1 - t0) / 1000000.0;
        return new Tuple2<Double, R>(BoxesRunTime.boxToDouble(timeMillis), result2);
    }

    public Statement squashEmpty(Statement s2) {
        Statement statement;
        Statement statement2 = Mappers$StmtMap$.MODULE$.map$extension(Mappers$.MODULE$.StmtMap(s2), (Function1<Statement, Statement> & Serializable)s -> MODULE$.squashEmpty((Statement)s), (Function1<Function1, Mappers.StmtMagnet> & Serializable)f -> Mappers$StmtMagnet$.MODULE$.forStmt((Function1<Statement, Statement>)f));
        if (statement2 instanceof Block) {
            Statement statement3;
            Block block = (Block)statement2;
            Seq<Statement> stmts = block.stmts();
            Seq newStmts = (Seq)stmts.filter((Function1<Statement, Object> & Serializable)x$6 -> BoxesRunTime.boxToBoolean(Utils$.$anonfun$squashEmpty$3(x$6)));
            int n = newStmts.size();
            switch (n) {
                case 0: {
                    statement3 = EmptyStmt$.MODULE$;
                    break;
                }
                case 1: {
                    statement3 = (Statement)newStmts.head();
                    break;
                }
                default: {
                    statement3 = new Block(newStmts);
                    break;
                }
            }
            statement = statement3;
        } else {
            statement = statement2;
        }
        return statement;
    }

    public boolean isCast(PrimOp op) {
        PrimOp primOp = op;
        boolean bl = PrimOps$AsUInt$.MODULE$.equals(primOp) ? true : (PrimOps$AsSInt$.MODULE$.equals(primOp) ? true : (PrimOps$AsClock$.MODULE$.equals(primOp) ? true : (PrimOps$AsAsyncReset$.MODULE$.equals(primOp) ? true : PrimOps$AsFixedPoint$.MODULE$.equals(primOp))));
        boolean bl2 = bl;
        return bl2;
    }

    public boolean isCast(Expression expr) {
        DoPrim doPrim;
        PrimOp op;
        Expression expression = expr;
        boolean bl = expression instanceof DoPrim && this.isCast(op = (doPrim = (DoPrim)expression).op());
        return bl;
    }

    public boolean isBitExtract(PrimOp op) {
        PrimOp primOp = op;
        boolean bl = PrimOps$Bits$.MODULE$.equals(primOp) ? true : (PrimOps$Head$.MODULE$.equals(primOp) ? true : (PrimOps$Tail$.MODULE$.equals(primOp) ? true : PrimOps$Shr$.MODULE$.equals(primOp)));
        boolean bl2 = bl;
        return bl2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isBitExtract(Expression expr) {
        Expression expression = expr;
        if (!(expression instanceof DoPrim)) return false;
        DoPrim doPrim = (DoPrim)expression;
        PrimOp op = doPrim.op();
        Type type = doPrim.tpe();
        if (!(type instanceof UIntType)) return false;
        if (!this.isBitExtract(op)) return false;
        return true;
    }

    public <A, B> List<A> distinctBy(List<A> xs, Function1<A, B> f) {
        ListBuffer buf = new ListBuffer();
        HashSet seen = new HashSet();
        xs.foreach((Function1<Object, Object> & Serializable)x -> {
            Object object;
            Object y = f.apply(x);
            if (!seen.apply(y)) {
                buf.$plus$eq(x);
                object = seen.$plus$eq(y);
            } else {
                object = BoxedUnit.UNIT;
            }
            return object;
        });
        return buf.toList();
    }

    public String niceName(Expression e) {
        return this.niceName(1, e);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String niceName(int depth, Expression e2) {
        Expression expression;
        Mux mux;
        boolean bl;
        DoPrim doPrim;
        boolean bl2;
        SubAccess subAccess;
        boolean bl3;
        while (true) {
            boolean bl4 = false;
            Reference reference = null;
            bl3 = false;
            subAccess = null;
            bl2 = false;
            doPrim = null;
            bl = false;
            mux = null;
            expression = e2;
            if (expression instanceof Reference) {
                bl4 = true;
                reference = (Reference)expression;
                String name = reference.name();
                if (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(name), 0) == '_') {
                    return name;
                }
            }
            if (bl4) {
                String name = reference.name();
                return new StringBuilder(1).append("_").append(name).toString();
            }
            if (!(expression instanceof SubAccess)) break;
            bl3 = true;
            subAccess = (SubAccess)expression;
            Expression expr = subAccess.expr();
            if (depth > 0) break;
            e2 = expr;
        }
        if (bl3) {
            Expression expr = subAccess.expr();
            Expression index = subAccess.index();
            return new StringBuilder(0).append(this.niceName(depth, expr)).append(this.niceName(depth - 1, index)).toString();
        }
        if (expression instanceof SubField) {
            SubField subField = (SubField)expression;
            Expression expr = subField.expr();
            String field2 = subField.name();
            return new StringBuilder(1).append(this.niceName(depth, expr)).append("_").append(field2).toString();
        }
        if (expression instanceof SubIndex) {
            SubIndex subIndex = (SubIndex)expression;
            Expression expr = subIndex.expr();
            int index = subIndex.value();
            return new StringBuilder(1).append(this.niceName(depth, expr)).append("_").append(index).toString();
        }
        if (expression instanceof DoPrim) {
            bl2 = true;
            doPrim = (DoPrim)expression;
            PrimOp op = doPrim.op();
            if (depth <= 0) {
                return new StringBuilder(1).append("_").append(op).toString();
            }
        }
        if (bl2) {
            PrimOp op = doPrim.op();
            Seq<Expression> args = doPrim.args();
            Seq<BigInt> consts = doPrim.consts();
            int n = depth - 1;
            return new StringBuilder(1).append("_").append(op).append(((IterableOnceOps)((IterableOps)args.map((Function1<Expression, String> & Serializable)e -> MODULE$.niceName(n, (Expression)e))).$plus$plus((IterableOnce)consts.map((Function1<BigInt, String> & Serializable)x$7 -> new StringBuilder(1).append("_").append(x$7).toString()))).mkString("")).toString();
        }
        if (expression instanceof Mux) {
            bl = true;
            mux = (Mux)expression;
            if (depth <= 0) {
                return "_mux";
            }
        }
        if (bl) {
            Expression cond = mux.cond();
            Expression tval = mux.tval();
            Expression fval = mux.fval();
            int n = depth - 1;
            return new StringBuilder(4).append("_mux").append(((IterableOnceOps)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{cond, tval, fval})).map((Function1<Expression, String> & Serializable)e -> MODULE$.niceName(n, (Expression)e))).mkString("")).toString();
        }
        if (expression instanceof UIntLiteral) {
            UIntLiteral uIntLiteral = (UIntLiteral)expression;
            BigInt value = uIntLiteral.value();
            return new StringBuilder(1).append("_").append(value).toString();
        }
        if (!(expression instanceof SIntLiteral)) throw new MatchError(expression);
        SIntLiteral sIntLiteral = (SIntLiteral)expression;
        BigInt value = sIntLiteral.value();
        return new StringBuilder(1).append("_").append(value).toString();
    }

    public boolean isTemp(String str) {
        return StringOps$.MODULE$.head$extension(Predef$.MODULE$.augmentString(str)) == '_';
    }

    public WrappedExpression toWrappedExpression(Expression x) {
        return new WrappedExpression(x);
    }

    public int getSIntWidth(BigInt s) {
        return s.bitLength() + 1;
    }

    public int getUIntWidth(BigInt u) {
        return u.bitLength();
    }

    public String dec2string(BigDecimal v) {
        return v.underlying().stripTrailingZeros().toPlainString();
    }

    public BigDecimal trim(BigDecimal v) {
        return scala.package$.MODULE$.BigDecimal().apply(this.dec2string(v));
    }

    public BigInt max(BigInt a, BigInt b) {
        return a.$greater$eq(b) ? a : b;
    }

    public BigInt min(BigInt a, BigInt b) {
        return a.$greater$eq(b) ? b : a;
    }

    public BigInt pow_minus_one(BigInt a, BigInt b) {
        return a.pow(b.toInt()).$minus(BigInt$.MODULE$.int2bigInt(1));
    }

    public UIntType BoolType() {
        return BoolType;
    }

    public UIntLiteral one() {
        return one;
    }

    public UIntLiteral zero() {
        return zero;
    }

    private DoPrim ClockZero() {
        return ClockZero;
    }

    private DoPrim AsyncZero() {
        return AsyncZero;
    }

    public Expression getGroundZero(GroundType tpe) {
        Expression expression;
        GroundType groundType = tpe;
        if (groundType instanceof UIntType) {
            UIntType uIntType = (UIntType)groundType;
            expression = new UIntLiteral(BigInt$.MODULE$.int2bigInt(0), uIntType.width());
        } else if (groundType instanceof SIntType) {
            SIntType sIntType = (SIntType)groundType;
            expression = new SIntLiteral(BigInt$.MODULE$.int2bigInt(0), sIntType.width());
        } else if (groundType instanceof FixedType) {
            FixedType fixedType = (FixedType)groundType;
            expression = new FixedLiteral(BigInt$.MODULE$.int2bigInt(0), fixedType.width(), fixedType.point());
        } else if (ResetType$.MODULE$.equals(groundType)) {
            expression = this.zero();
        } else if (ClockType$.MODULE$.equals(groundType)) {
            expression = this.ClockZero();
        } else if (AsyncResetType$.MODULE$.equals(groundType)) {
            expression = this.AsyncZero();
        } else {
            throw this.throwInternalError(new StringBuilder(16).append("Unexpected type ").append(groundType).toString(), this.throwInternalError$default$2());
        }
        return expression;
    }

    public Seq<Expression> create_exps(String n, Type t) {
        return this.create_exps(WRef$.MODULE$.apply(n, t, ExpKind$.MODULE$, UnknownFlow$.MODULE$));
    }

    public Seq<Expression> create_exps(Expression e) {
        Seq seq;
        Expression expression = e;
        if (expression instanceof Mux) {
            Mux mux = (Mux)expression;
            Seq<Expression> e1s = this.create_exps(mux.tval());
            Seq<Expression> e2s = this.create_exps(mux.fval());
            seq = (Seq)((IterableOps)e1s.zip(e2s)).map((Function1<Tuple2, Expression> & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                Expression e1 = (Expression)tuple2._1();
                Expression e2 = (Expression)tuple2._2();
                Mux mux = new Mux(mux.cond(), e1, e2, MODULE$.mux_type_and_widths(e1, e2));
                return mux;
            });
        } else if (expression instanceof ValidIf) {
            ValidIf validIf = (ValidIf)expression;
            seq = (Seq)this.create_exps(validIf.value()).map((Function1<Expression, ValidIf> & Serializable)e1 -> new ValidIf(validIf.cond(), (Expression)e1, e1.tpe()));
        } else {
            Seq seq2;
            Type type = expression.tpe();
            if (type instanceof GroundType) {
                seq2 = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{expression}));
            } else if (type instanceof BundleType) {
                BundleType bundleType = (BundleType)type;
                seq2 = (Seq)bundleType.fields().flatMap((Function1<Field, Seq> & Serializable)f -> MODULE$.create_exps(WSubField$.MODULE$.apply(expression, f.name(), f.tpe(), MODULE$.times(MODULE$.flow(expression), f.flip()))));
            } else if (type instanceof VectorType) {
                VectorType vectorType = (VectorType)type;
                seq2 = (Seq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), vectorType.size()).flatMap((Function1<Object, Seq> & Serializable)i -> Utils$.MODULE$.create_exps(WSubIndex$.MODULE$.apply(expression, BoxesRunTime.unboxToInt(i), vectorType.tpe(), Utils$.MODULE$.flow(expression))));
            } else {
                throw new MatchError(type);
            }
            seq = seq2;
        }
        return seq;
    }

    public Seq<Expression> expandRef(Expression e) {
        Seq seq;
        Expression expression = e;
        if (expression instanceof Mux) {
            Mux mux = (Mux)expression;
            Seq<Expression> e1s = this.expandRef(mux.tval());
            Seq<Expression> e2s = this.expandRef(mux.fval());
            seq = (Seq)((IterableOps)e1s.zip(e2s)).map((Function1<Tuple2, Expression> & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                Expression e1 = (Expression)tuple2._1();
                Expression e2 = (Expression)tuple2._2();
                Mux mux = new Mux(mux.cond(), e1, e2, MODULE$.mux_type_and_widths(e1, e2));
                return mux;
            });
        } else if (expression instanceof ValidIf) {
            ValidIf validIf = (ValidIf)expression;
            seq = (Seq)this.expandRef(validIf.value()).map((Function1<Expression, ValidIf> & Serializable)e1 -> new ValidIf(validIf.cond(), (Expression)e1, e1.tpe()));
        } else {
            Seq seq2;
            Type type = expression.tpe();
            if (type instanceof GroundType) {
                seq2 = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{expression}));
            } else if (type instanceof BundleType) {
                BundleType bundleType = (BundleType)type;
                Expression expression2 = expression;
                seq2 = (Seq)((SeqOps)bundleType.fields().flatMap((Function1<Field, Seq> & Serializable)f -> MODULE$.expandRef(WSubField$.MODULE$.apply(expression, f.name(), f.tpe(), MODULE$.times(MODULE$.flow(expression), f.flip()))))).$plus$colon(expression2);
            } else if (type instanceof VectorType) {
                VectorType vectorType = (VectorType)type;
                Expression expression3 = expression;
                seq2 = (Seq)((SeqOps)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), vectorType.size()).flatMap((Function1<Object, Seq> & Serializable)i -> Utils$.MODULE$.expandRef(WSubIndex$.MODULE$.apply(expression, BoxesRunTime.unboxToInt(i), vectorType.tpe(), Utils$.MODULE$.flow(expression))))).$plus$colon(expression3);
            } else {
                throw new MatchError(type);
            }
            seq = seq2;
        }
        return seq;
    }

    public ReferenceTarget toTarget(String main, String module, Expression expression) {
        ArrayBuffer tokens = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        ObjectRef<String> ref = ObjectRef.create("???");
        this.onExp$1(expression, ref, tokens);
        return new ReferenceTarget(main, module, scala.package$.MODULE$.Nil(), (String)ref.elem, tokens.toSeq());
    }

    public int get_point(Expression e) {
        int n;
        block5: {
            Expression expression;
            while (true) {
                if ((expression = e) instanceof Reference) {
                    n = 0;
                    break block5;
                }
                if (expression instanceof SubField) {
                    SubField subField = (SubField)expression;
                    Type type = subField.expr().tpe();
                    if (!(type instanceof BundleType)) {
                        throw new MatchError(type);
                    }
                    BundleType bundleType = (BundleType)type;
                    int n2 = BoxesRunTime.unboxToInt(((IterableOnceOps)bundleType.fields().takeWhile((Function1<Field, Object> & Serializable)x$8 -> BoxesRunTime.boxToBoolean(Utils$.$anonfun$get_point$1(subField, x$8)))).foldLeft(BoxesRunTime.boxToInteger(0), (Function2<Object, Field, Object> & Serializable)(point, f) -> BoxesRunTime.boxToInteger(Utils$.$anonfun$get_point$2(BoxesRunTime.unboxToInt(point), f))));
                    n = n2;
                    break block5;
                }
                if (expression instanceof SubIndex) {
                    SubIndex subIndex = (SubIndex)expression;
                    n = subIndex.value() * this.get_size(subIndex.tpe());
                    break block5;
                }
                if (!(expression instanceof SubAccess)) break;
                SubAccess subAccess = (SubAccess)expression;
                e = subAccess.expr();
            }
            throw new MatchError(expression);
        }
        return n;
    }

    public boolean hasFlip(Type t) {
        boolean bl;
        block2: {
            while (true) {
                Type type;
                if ((type = t) instanceof BundleType) {
                    BundleType bundleType = (BundleType)type;
                    bl = bundleType.fields().exists((Function1<Field, Object> & Serializable)x$9 -> BoxesRunTime.boxToBoolean(Utils$.$anonfun$hasFlip$1(x$9))) || bundleType.fields().exists((Function1<Field, Object> & Serializable)f -> BoxesRunTime.boxToBoolean(Utils$.MODULE$.hasFlip(f.tpe())));
                    break block2;
                }
                if (!(type instanceof VectorType)) break;
                VectorType vectorType = (VectorType)type;
                t = vectorType.tpe();
            }
            bl = false;
        }
        return bl;
    }

    public Seq<Expression> getKids(Expression e2) {
        ArrayBuffer kids = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Mappers$ExprMap$.MODULE$.map$extension(Mappers$.MODULE$.ExprMap(e2), (Function1<Expression, Expression> & Serializable)e -> Utils$.addKids$1(e, kids), (Function1<Function1, Mappers.ExprMagnet> & Serializable)f -> Mappers$ExprMagnet$.MODULE$.forExpr((Function1<Expression, Expression>)f));
        return kids.toSeq();
    }

    /*
     * Enabled aggressive block sorting
     */
    public Seq<Tuple2<Expression, Expression>> diff(Expression e1, Expression e2) {
        Seq<Nothing$> seq;
        if (WrappedExpression$.MODULE$.weq(e1, e2)) {
            seq = scala.package$.MODULE$.Nil();
            return seq;
        }
        Tuple2<Seq<Expression>, Seq<Expression>> tuple2 = new Tuple2<Seq<Expression>, Seq<Expression>>(this.getKids(e1), this.getKids(e2));
        if (tuple2 == null) throw new MatchError(tuple2);
        Seq<Expression> e1Kids = tuple2._1();
        Seq<Expression> e2Kids = tuple2._2();
        Tuple2<Seq<Expression>, Seq<Expression>> tuple22 = new Tuple2<Seq<Expression>, Seq<Expression>>(e1Kids, e2Kids);
        Tuple2<Seq<Expression>, Seq<Expression>> tuple23 = tuple22;
        Seq<Expression> e1Kids2 = tuple23._1();
        Seq<Expression> e2Kids2 = tuple23._2();
        Seq<Expression> seq2 = e1Kids2;
        Nil$ nil$ = scala.package$.MODULE$.Nil();
        if (seq2 == null ? nil$ != null : !seq2.equals(nil$)) {
            Seq<Expression> seq3 = e2Kids2;
            Nil$ nil$2 = scala.package$.MODULE$.Nil();
            if ((seq3 == null ? nil$2 != null : !seq3.equals(nil$2)) && e1Kids2.size() == e2Kids2.size()) {
                seq = (Seq)((IterableOps)e1Kids2.zip(e2Kids2)).flatMap((Function1<Tuple2, IterableOnce> & Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    Expression e1k = (Expression)tuple2._1();
                    Expression e2k = (Expression)tuple2._2();
                    Seq<Tuple2<Expression, Expression>> seq = MODULE$.diff(e1k, e2k);
                    return seq;
                });
                return seq;
            }
        }
        seq = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2<Expression, Expression>(e1, e2)}));
        return seq;
    }

    public Expression inline(HashMap<String, Expression> nodeMap, Function1<String, Object> stop, Expression e) {
        return this.onExp$2(e, nodeMap, stop);
    }

    public Function1<String, Object> inline$default$2() {
        return (Function1<String, Object> & Serializable)x -> BoxesRunTime.boxToBoolean(Utils$.$anonfun$inline$default$2$1(x));
    }

    public Type mux_type(Expression e1, Expression e2) {
        return this.mux_type(e1.tpe(), e2.tpe());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public Type mux_type(Type t1, Type t2) {
        void var3_15;
        Tuple2<Type, Type> tuple2 = new Tuple2<Type, Type>(t1, t2);
        if (tuple2 != null) {
            Type type = tuple2._1();
            Type type2 = tuple2._2();
            if (ClockType$.MODULE$.equals(type) && ClockType$.MODULE$.equals(type2)) {
                ClockType$ clockType$ = ClockType$.MODULE$;
                return var3_15;
            }
        }
        if (tuple2 != null) {
            Type type = tuple2._1();
            Type type3 = tuple2._2();
            if (AsyncResetType$.MODULE$.equals(type) && AsyncResetType$.MODULE$.equals(type3)) {
                AsyncResetType$ asyncResetType$ = AsyncResetType$.MODULE$;
                return var3_15;
            }
        }
        if (tuple2 != null) {
            Type t12 = tuple2._1();
            Type t22 = tuple2._2();
            if (t12 instanceof UIntType && t22 instanceof UIntType) {
                UIntType uIntType = new UIntType(UnknownWidth$.MODULE$);
                return var3_15;
            }
        }
        if (tuple2 != null) {
            Type t13 = tuple2._1();
            Type t23 = tuple2._2();
            if (t13 instanceof SIntType && t23 instanceof SIntType) {
                SIntType sIntType = new SIntType(UnknownWidth$.MODULE$);
                return var3_15;
            }
        }
        if (tuple2 != null) {
            Type t14 = tuple2._1();
            Type t24 = tuple2._2();
            if (t14 instanceof FixedType && t24 instanceof FixedType) {
                FixedType fixedType = new FixedType(UnknownWidth$.MODULE$, UnknownWidth$.MODULE$);
                return var3_15;
            }
        }
        if (tuple2 != null) {
            Type t15 = tuple2._1();
            Type t25 = tuple2._2();
            if (t15 instanceof IntervalType && t25 instanceof IntervalType) {
                IntervalType intervalType = new IntervalType(UnknownBound$.MODULE$, UnknownBound$.MODULE$, UnknownWidth$.MODULE$);
                return var3_15;
            }
        }
        if (tuple2 != null) {
            Type t16 = tuple2._1();
            Type t26 = tuple2._2();
            if (t16 instanceof VectorType) {
                VectorType vectorType = (VectorType)t16;
                if (t26 instanceof VectorType) {
                    VectorType vectorType2 = (VectorType)t26;
                    VectorType vectorType3 = new VectorType(this.mux_type(vectorType.tpe(), vectorType2.tpe()), vectorType.size());
                    return var3_15;
                }
            }
        }
        if (tuple2 != null) {
            Type t17 = tuple2._1();
            Type t27 = tuple2._2();
            if (t17 instanceof BundleType) {
                BundleType bundleType = (BundleType)t17;
                if (t27 instanceof BundleType) {
                    BundleType bundleType2 = (BundleType)t27;
                    BundleType bundleType3 = new BundleType((Seq)((IterableOps)bundleType.fields().zip(bundleType2.fields())).map((Function1<Tuple2, Field> & Serializable)x0$1 -> {
                        Tuple2 tuple2 = x0$1;
                        if (tuple2 == null) {
                            throw new MatchError(tuple2);
                        }
                        Field f1 = (Field)tuple2._1();
                        Field f2 = (Field)tuple2._2();
                        Field field2 = new Field(f1.name(), f1.flip(), MODULE$.mux_type(f1.tpe(), f2.tpe()));
                        return field2;
                    }));
                    return var3_15;
                }
            }
        }
        UnknownType$ unknownType$ = UnknownType$.MODULE$;
        return var3_15;
    }

    public Type mux_type_and_widths(Expression e1, Expression e2) {
        return this.mux_type_and_widths(e1.tpe(), e2.tpe());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public Type mux_type_and_widths(Type t1, Type t2) {
        void var3_15;
        Tuple2<Type, Type> tuple2 = new Tuple2<Type, Type>(t1, t2);
        if (tuple2 != null) {
            Type type = tuple2._1();
            Type type2 = tuple2._2();
            if (ClockType$.MODULE$.equals(type) && ClockType$.MODULE$.equals(type2)) {
                ClockType$ clockType$ = ClockType$.MODULE$;
                return var3_15;
            }
        }
        if (tuple2 != null) {
            Type type = tuple2._1();
            Type type3 = tuple2._2();
            if (AsyncResetType$.MODULE$.equals(type) && AsyncResetType$.MODULE$.equals(type3)) {
                AsyncResetType$ asyncResetType$ = AsyncResetType$.MODULE$;
                return var3_15;
            }
        }
        if (tuple2 != null) {
            Type t1x = tuple2._1();
            Type t2x = tuple2._2();
            if (t1x instanceof UIntType) {
                UIntType uIntType = (UIntType)t1x;
                if (t2x instanceof UIntType) {
                    UIntType uIntType2 = (UIntType)t2x;
                    UIntType uIntType3 = new UIntType(Implicits$.MODULE$.constraint2width(IsMax$.MODULE$.apply(Implicits$.MODULE$.width2constraint(uIntType.width()), Implicits$.MODULE$.width2constraint(uIntType2.width()))));
                    return var3_15;
                }
            }
        }
        if (tuple2 != null) {
            Type t1x = tuple2._1();
            Type t2x = tuple2._2();
            if (t1x instanceof SIntType) {
                SIntType sIntType = (SIntType)t1x;
                if (t2x instanceof SIntType) {
                    SIntType sIntType2 = (SIntType)t2x;
                    SIntType sIntType3 = new SIntType(Implicits$.MODULE$.constraint2width(IsMax$.MODULE$.apply(Implicits$.MODULE$.width2constraint(sIntType.width()), Implicits$.MODULE$.width2constraint(sIntType2.width()))));
                    return var3_15;
                }
            }
        }
        if (tuple2 != null) {
            Type type = tuple2._1();
            Type type4 = tuple2._2();
            if (type instanceof FixedType) {
                FixedType fixedType = (FixedType)type;
                Width w1 = fixedType.width();
                Width p1 = fixedType.point();
                if (type4 instanceof FixedType) {
                    FixedType fixedType2 = (FixedType)type4;
                    Width w2 = fixedType2.width();
                    Width p2 = fixedType2.point();
                    FixedType fixedType3 = new FixedType(Implicits$.MODULE$.constraint2width(PrimOps$.MODULE$.PLUS(Implicits$.MODULE$.constraint2width(PrimOps$.MODULE$.MAX(p1, p2)), Implicits$.MODULE$.constraint2width(PrimOps$.MODULE$.MAX(Implicits$.MODULE$.constraint2width(PrimOps$.MODULE$.MINUS(w1, p1)), Implicits$.MODULE$.constraint2width(PrimOps$.MODULE$.MINUS(w2, p2)))))), Implicits$.MODULE$.constraint2width(PrimOps$.MODULE$.MAX(p1, p2)));
                    return var3_15;
                }
            }
        }
        if (tuple2 != null) {
            Type type = tuple2._1();
            Type type5 = tuple2._2();
            if (type instanceof IntervalType) {
                IntervalType intervalType = (IntervalType)type;
                Bound l1 = intervalType.lower();
                Bound u1 = intervalType.upper();
                Width p1 = intervalType.point();
                if (type5 instanceof IntervalType) {
                    IntervalType intervalType2 = (IntervalType)type5;
                    Bound l2 = intervalType2.lower();
                    Bound u2 = intervalType2.upper();
                    Width p2 = intervalType2.point();
                    IntervalType intervalType3 = new IntervalType(Implicits$.MODULE$.constraint2bound(IsMin$.MODULE$.apply(l1, l2)), Implicits$.MODULE$.constraint2bound(IsMax$.MODULE$.apply(u1, u2)), Implicits$.MODULE$.constraint2width(PrimOps$.MODULE$.MAX(p1, p2)));
                    return var3_15;
                }
            }
        }
        if (tuple2 != null) {
            Type t1x = tuple2._1();
            Type t2x = tuple2._2();
            if (t1x instanceof VectorType) {
                VectorType vectorType = (VectorType)t1x;
                if (t2x instanceof VectorType) {
                    VectorType vectorType2 = (VectorType)t2x;
                    VectorType vectorType3 = new VectorType(this.mux_type_and_widths(vectorType.tpe(), vectorType2.tpe()), vectorType.size());
                    return var3_15;
                }
            }
        }
        if (tuple2 != null) {
            Type t1x = tuple2._1();
            Type t2x = tuple2._2();
            if (t1x instanceof BundleType) {
                BundleType bundleType = (BundleType)t1x;
                if (t2x instanceof BundleType) {
                    BundleType bundleType2 = (BundleType)t2x;
                    BundleType bundleType3 = new BundleType((Seq)((IterableOps)bundleType.fields().zip(bundleType2.fields())).map((Function1<Tuple2, Field> & Serializable)x0$1 -> {
                        Tuple2 tuple2 = x0$1;
                        if (tuple2 == null) {
                            throw new MatchError(tuple2);
                        }
                        Field f1 = (Field)tuple2._1();
                        Field f2 = (Field)tuple2._2();
                        Field field2 = new Field(f1.name(), f1.flip(), MODULE$.mux_type_and_widths(f1.tpe(), f2.tpe()));
                        return field2;
                    }));
                    return var3_15;
                }
            }
        }
        UnknownType$ unknownType$ = UnknownType$.MODULE$;
        return var3_15;
    }

    public BundleType module_type(DefModule m) {
        return new BundleType((Seq)m.ports().map((Function1<Port, Field> & Serializable)x0$1 -> {
            Port port = x0$1;
            if (port == null) {
                throw new MatchError(port);
            }
            String name = port.name();
            Direction dir = port.direction();
            Type tpe = port.tpe();
            Field field2 = new Field(name, MODULE$.to_flip(dir), tpe);
            return field2;
        }));
    }

    public Type sub_type(Type v) {
        Type type;
        Type type2 = v;
        if (type2 instanceof VectorType) {
            VectorType vectorType = (VectorType)type2;
            type = vectorType.tpe();
        } else {
            type = UnknownType$.MODULE$;
        }
        return type;
    }

    public Type field_type(Type v, String s) {
        UnknownType$ unknownType$;
        Type type = v;
        if (type instanceof BundleType) {
            Type type2;
            BundleType bundleType = (BundleType)type;
            Option option = bundleType.fields().find((Function1<Field, Object> & Serializable)x$11 -> BoxesRunTime.boxToBoolean(Utils$.$anonfun$field_type$1(s, x$11)));
            if (option instanceof Some) {
                Some some = (Some)option;
                Field f = (Field)some.value();
                type2 = f.tpe();
            } else if (None$.MODULE$.equals(option)) {
                type2 = UnknownType$.MODULE$;
            } else {
                throw new MatchError(option);
            }
            unknownType$ = type2;
        } else {
            unknownType$ = UnknownType$.MODULE$;
        }
        return unknownType$;
    }

    public Nothing$ error(String str, Throwable cause) {
        throw new FirrtlInternalException(str, cause);
    }

    public Throwable error$default$2() {
        return null;
    }

    public int get_size(Type t) {
        int n;
        Type type = t;
        if (type instanceof BundleType) {
            BundleType bundleType = (BundleType)type;
            n = BoxesRunTime.unboxToInt(bundleType.fields().foldLeft(BoxesRunTime.boxToInteger(0), (Function2<Object, Field, Object> & Serializable)(sum, f) -> BoxesRunTime.boxToInteger(Utils$.$anonfun$get_size$1(BoxesRunTime.unboxToInt(sum), f))));
        } else if (type instanceof VectorType) {
            VectorType vectorType = (VectorType)type;
            n = vectorType.size() * this.get_size(vectorType.tpe());
        } else {
            n = 1;
        }
        return n;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public Seq<Tuple2<Object, Object>> get_valid_points(Type t1, Type t2, Orientation flip1, Orientation flip2) {
        block5: {
            block14: {
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    block8: {
                                        block7: {
                                            block6: {
                                                block4: {
                                                    var6_5 = new Tuple2<Type, Type>(t1, t2);
                                                    if (var6_5 == null || !(var6_5._1() instanceof UIntType) || !(var6_5._2() instanceof UIntType)) break block4;
                                                    v0 = flip1;
                                                    var7_6 = flip2;
                                                    var5_7 /* !! */  = !(v0 != null ? v0.equals(var7_6) == false : var7_6 != null) ? (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2$mcII$sp(0, 0)})) : scala.package$.MODULE$.Nil();
                                                    break block5;
                                                }
                                                if (var6_5 == null || !(var6_5._1() instanceof SIntType) || !(var6_5._2() instanceof SIntType)) break block6;
                                                v1 = flip1;
                                                var8_8 = flip2;
                                                var5_7 /* !! */  = !(v1 != null ? v1.equals(var8_8) == false : var8_8 != null) ? (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2$mcII$sp(0, 0)})) : scala.package$.MODULE$.Nil();
                                                break block5;
                                            }
                                            if (var6_5 == null || !(var6_5._1() instanceof FixedType) || !(var6_5._2() instanceof FixedType)) break block7;
                                            v2 = flip1;
                                            var9_9 = flip2;
                                            var5_7 /* !! */  = !(v2 != null ? v2.equals(var9_9) == false : var9_9 != null) ? (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2$mcII$sp(0, 0)})) : scala.package$.MODULE$.Nil();
                                            break block5;
                                        }
                                        if (var6_5 == null || !(var6_5._1() instanceof AnalogType) || !(var6_5._2() instanceof AnalogType)) break block8;
                                        v3 = flip1;
                                        var10_10 = flip2;
                                        var5_7 /* !! */  = !(v3 != null ? v3.equals(var10_10) == false : var10_10 != null) ? (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2$mcII$sp(0, 0)})) : scala.package$.MODULE$.Nil();
                                        break block5;
                                    }
                                    if (var6_5 == null) break block9;
                                    t1x = var6_5._1();
                                    t2x = var6_5._2();
                                    if (!(t1x instanceof BundleType)) break block9;
                                    var13_13 = (BundleType)t1x;
                                    if (!(t2x instanceof BundleType)) break block9;
                                    var14_14 = (BundleType)t2x;
                                    t1_fields = var13_13.fields().foldLeft(new Tuple2<Map, Integer>(Utils$.emptyMap$1(), BoxesRunTime.boxToInteger(0)), (Function2<Tuple2, Field, Tuple2> & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$get_valid_points$1(scala.Tuple2 firrtl.ir.Field ), (Lscala/Tuple2;Lfirrtl/ir/Field;)Lscala/Tuple2;)())._1();
                                    var5_7 /* !! */  = (Seq)var14_14.fields().foldLeft(new Tuple2<Object, Integer>(scala.package$.MODULE$.Seq().apply((Seq)Nil$.MODULE$), BoxesRunTime.boxToInteger(0)), (Function2<Tuple2, Field, Tuple2> & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$get_valid_points$2(scala.collection.immutable.Map firrtl.ir.Orientation firrtl.ir.Orientation scala.Tuple2 firrtl.ir.Field ), (Lscala/Tuple2;Lfirrtl/ir/Field;)Lscala/Tuple2;)((Map)t1_fields, (Orientation)flip1, (Orientation)flip2))._1();
                                    break block5;
                                }
                                if (var6_5 == null) break block10;
                                t1x = var6_5._1();
                                t2x = var6_5._2();
                                if (!(t1x instanceof VectorType)) break block10;
                                var18_18 = (VectorType)t1x;
                                if (!(t2x instanceof VectorType)) break block10;
                                var19_19 = (VectorType)t2x;
                                size = package$.MODULE$.min(var18_18.size(), var19_19.size());
                                var5_7 /* !! */  = (Seq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), size).foldLeft(new Tuple3<Object, Integer, Integer>(scala.package$.MODULE$.Seq().apply((Seq)Nil$.MODULE$), BoxesRunTime.boxToInteger(0), BoxesRunTime.boxToInteger(0)), (Function2<Tuple3, Object, Tuple3> & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$get_valid_points$4$adapted(firrtl.ir.VectorType firrtl.ir.VectorType firrtl.ir.Orientation firrtl.ir.Orientation scala.Tuple3 java.lang.Object ), (Lscala/Tuple3;Ljava/lang/Object;)Lscala/Tuple3;)((VectorType)var18_18, (VectorType)var19_19, (Orientation)flip1, (Orientation)flip2))._1();
                                break block5;
                            }
                            if (var6_5 == null) break block11;
                            var21_21 = var6_5._1();
                            var22_22 = var6_5._2();
                            if (!ClockType$.MODULE$.equals(var21_21) || !ClockType$.MODULE$.equals(var22_22)) break block11;
                            v4 = flip1;
                            var23_23 = flip2;
                            var5_7 /* !! */  = !(v4 != null ? v4.equals(var23_23) == false : var23_23 != null) ? (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2$mcII$sp(0, 0)})) : scala.package$.MODULE$.Nil();
                            break block5;
                        }
                        if (var6_5 == null) break block12;
                        var24_24 = var6_5._1();
                        var25_25 = var6_5._2();
                        if (!AsyncResetType$.MODULE$.equals(var24_24) || !AsyncResetType$.MODULE$.equals(var25_25)) break block12;
                        v5 = flip1;
                        var26_26 = flip2;
                        var5_7 /* !! */  = !(v5 != null ? v5.equals(var26_26) == false : var26_26 != null) ? (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2$mcII$sp(0, 0)})) : scala.package$.MODULE$.Nil();
                        break block5;
                    }
                    if (var6_5 == null) break block13;
                    var27_27 = var6_5._1();
                    other = var6_5._2();
                    if (!ResetType$.MODULE$.equals(var27_27)) break block13;
                    if (!CheckTypes$.MODULE$.legalResetType(other)) ** GOTO lbl-1000
                    v6 = flip1;
                    var29_29 = Default$.MODULE$;
                    if (v6 != null ? v6.equals(var29_29) == false : var29_29 != null) ** GOTO lbl-1000
                    v7 = flip1;
                    var30_30 = flip2;
                    if (!(v7 != null ? v7.equals(var30_30) == false : var30_30 != null)) {
                        v8 /* !! */  = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2$mcII$sp(0, 0)}));
                    } else lbl-1000:
                    // 3 sources

                    {
                        v8 /* !! */  = scala.package$.MODULE$.Nil();
                    }
                    var5_7 /* !! */  = v8 /* !! */ ;
                    break block5;
                }
                if (var6_5 == null) break block14;
                other = var6_5._1();
                var32_32 = var6_5._2();
                if (!ResetType$.MODULE$.equals(var32_32)) break block14;
                if (!CheckTypes$.MODULE$.legalResetType(other)) ** GOTO lbl-1000
                v9 = flip1;
                var33_33 = Flip$.MODULE$;
                if (v9 != null ? v9.equals(var33_33) == false : var33_33 != null) ** GOTO lbl-1000
                v10 = flip1;
                var34_34 = flip2;
                if (!(v10 != null ? v10.equals(var34_34) == false : var34_34 != null)) {
                    v11 /* !! */  = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2$mcII$sp(0, 0)}));
                } else lbl-1000:
                // 3 sources

                {
                    v11 /* !! */  = scala.package$.MODULE$.Nil();
                }
                var5_7 /* !! */  = v11 /* !! */ ;
                break block5;
            }
            throw this.throwInternalError(new StringBuilder(42).append("get_valid_points: shouldn't be here - (").append(t1).append(", ").append(t2).append(")").toString(), this.throwInternalError$default$2());
        }
        return var5_7 /* !! */ ;
    }

    public Flow swap(Flow g) {
        Product product;
        Flow flow = g;
        if (UnknownFlow$.MODULE$.equals(flow)) {
            product = UnknownFlow$.MODULE$;
        } else if (SourceFlow$.MODULE$.equals(flow)) {
            product = SinkFlow$.MODULE$;
        } else if (SinkFlow$.MODULE$.equals(flow)) {
            product = SourceFlow$.MODULE$;
        } else if (DuplexFlow$.MODULE$.equals(flow)) {
            product = DuplexFlow$.MODULE$;
        } else {
            throw new MatchError(flow);
        }
        return product;
    }

    public Direction swap(Direction d) {
        Direction direction;
        Direction direction2 = d;
        if (Output$.MODULE$.equals(direction2)) {
            direction = Input$.MODULE$;
        } else if (Input$.MODULE$.equals(direction2)) {
            direction = Output$.MODULE$;
        } else {
            throw new MatchError(direction2);
        }
        return direction;
    }

    public Orientation swap(Orientation f) {
        Orientation orientation;
        Orientation orientation2 = f;
        if (Default$.MODULE$.equals(orientation2)) {
            orientation = Flip$.MODULE$;
        } else if (Flip$.MODULE$.equals(orientation2)) {
            orientation = Default$.MODULE$;
        } else {
            throw new MatchError(orientation2);
        }
        return orientation;
    }

    public Direction to_dir(Flow g) {
        Direction direction;
        Flow flow = g;
        if (SourceFlow$.MODULE$.equals(flow)) {
            direction = Input$.MODULE$;
        } else if (SinkFlow$.MODULE$.equals(flow)) {
            direction = Output$.MODULE$;
        } else {
            throw new MatchError(flow);
        }
        return direction;
    }

    public Direction to_dir(Orientation o) {
        Direction direction;
        Orientation orientation = o;
        if (Flip$.MODULE$.equals(orientation)) {
            direction = Input$.MODULE$;
        } else if (Default$.MODULE$.equals(orientation)) {
            direction = Output$.MODULE$;
        } else {
            throw new MatchError(orientation);
        }
        return direction;
    }

    public Flow to_flow(Direction d) {
        Product product;
        Direction direction = d;
        if (Input$.MODULE$.equals(direction)) {
            product = SourceFlow$.MODULE$;
        } else if (Output$.MODULE$.equals(direction)) {
            product = SinkFlow$.MODULE$;
        } else {
            throw new MatchError(direction);
        }
        return product;
    }

    public Orientation to_flip(Direction d) {
        Orientation orientation;
        Direction direction = d;
        if (Input$.MODULE$.equals(direction)) {
            orientation = Flip$.MODULE$;
        } else if (Output$.MODULE$.equals(direction)) {
            orientation = Default$.MODULE$;
        } else {
            throw new MatchError(direction);
        }
        return orientation;
    }

    public Orientation to_flip(Flow g) {
        Orientation orientation;
        Flow flow = g;
        if (SourceFlow$.MODULE$.equals(flow)) {
            orientation = Flip$.MODULE$;
        } else if (SinkFlow$.MODULE$.equals(flow)) {
            orientation = Default$.MODULE$;
        } else {
            throw new MatchError(flow);
        }
        return orientation;
    }

    public Orientation field_flip(Type v, String s) {
        Default$ default$;
        Type type = v;
        if (type instanceof BundleType) {
            Orientation orientation;
            BundleType bundleType = (BundleType)type;
            Option option = bundleType.fields().find((Function1<Field, Object> & Serializable)x$12 -> BoxesRunTime.boxToBoolean(Utils$.$anonfun$field_flip$1(s, x$12)));
            if (option instanceof Some) {
                Some some = (Some)option;
                Field ft = (Field)some.value();
                orientation = ft.flip();
            } else if (None$.MODULE$.equals(option)) {
                orientation = Default$.MODULE$;
            } else {
                throw new MatchError(option);
            }
            default$ = orientation;
        } else {
            default$ = Default$.MODULE$;
        }
        return default$;
    }

    public Field get_field(Type v, String s) {
        Field field2;
        Type type = v;
        if (type instanceof BundleType) {
            Field ft;
            BundleType bundleType = (BundleType)type;
            Option option = bundleType.fields().find((Function1<Field, Object> & Serializable)x$13 -> BoxesRunTime.boxToBoolean(Utils$.$anonfun$get_field$1(s, x$13)));
            if (!(option instanceof Some)) {
                if (None$.MODULE$.equals(option)) {
                    throw this.throwInternalError(new StringBuilder(32).append("get_field: shouldn't be here - ").append(v).append(".").append(s).toString(), this.throwInternalError$default$2());
                }
                throw new MatchError(option);
            }
            Some some = (Some)option;
            field2 = ft = (Field)some.value();
        } else {
            throw this.throwInternalError(new StringBuilder(31).append("get_field: shouldn't be here - ").append(v).toString(), this.throwInternalError$default$2());
        }
        Field field3 = field2;
        return field3;
    }

    public Direction times(Direction d, Orientation flip) {
        Direction direction;
        Orientation orientation = flip;
        if (Default$.MODULE$.equals(orientation)) {
            direction = d;
        } else if (Flip$.MODULE$.equals(orientation)) {
            direction = this.swap(d);
        } else {
            throw new MatchError(orientation);
        }
        return direction;
    }

    public Direction times(Flow g, Direction d) {
        return this.times(d, g);
    }

    public Direction times(Direction d, Flow g) {
        Direction direction;
        Flow flow = g;
        if (SinkFlow$.MODULE$.equals(flow)) {
            direction = d;
        } else if (SourceFlow$.MODULE$.equals(flow)) {
            direction = this.swap(d);
        } else {
            throw new MatchError(flow);
        }
        return direction;
    }

    public Flow times(Flow g, Orientation flip) {
        return this.times(flip, g);
    }

    public Flow times(Orientation flip, Flow g) {
        Flow flow;
        Orientation orientation = flip;
        if (Default$.MODULE$.equals(orientation)) {
            flow = g;
        } else if (Flip$.MODULE$.equals(orientation)) {
            flow = this.swap(g);
        } else {
            throw new MatchError(orientation);
        }
        return flow;
    }

    public Orientation times(Orientation f1, Orientation f2) {
        Orientation orientation;
        Orientation orientation2 = f2;
        if (Default$.MODULE$.equals(orientation2)) {
            orientation = f1;
        } else if (Flip$.MODULE$.equals(orientation2)) {
            orientation = this.swap(f1);
        } else {
            throw new MatchError(orientation2);
        }
        return orientation;
    }

    public Kind kind(Expression e) {
        Kind kind;
        block4: {
            while (true) {
                Expression expression;
                if ((expression = e) instanceof Reference) {
                    Reference reference = (Reference)expression;
                    kind = reference.kind();
                    break block4;
                }
                if (expression instanceof SubField) {
                    SubField subField = (SubField)expression;
                    e = subField.expr();
                    continue;
                }
                if (expression instanceof SubIndex) {
                    SubIndex subIndex = (SubIndex)expression;
                    e = subIndex.expr();
                    continue;
                }
                if (!(expression instanceof SubAccess)) break;
                SubAccess subAccess = (SubAccess)expression;
                e = subAccess.expr();
            }
            kind = ExpKind$.MODULE$;
        }
        return kind;
    }

    public Flow flow(Expression e) {
        Flow flow;
        Expression expression = e;
        if (expression instanceof Reference) {
            Reference reference = (Reference)expression;
            flow = reference.flow();
        } else if (expression instanceof SubField) {
            SubField subField = (SubField)expression;
            flow = subField.flow();
        } else if (expression instanceof SubIndex) {
            SubIndex subIndex = (SubIndex)expression;
            flow = subIndex.flow();
        } else if (expression instanceof SubAccess) {
            SubAccess subAccess = (SubAccess)expression;
            flow = subAccess.flow();
        } else if (expression instanceof DoPrim) {
            flow = SourceFlow$.MODULE$;
        } else if (expression instanceof UIntLiteral) {
            flow = SourceFlow$.MODULE$;
        } else if (expression instanceof SIntLiteral) {
            flow = SourceFlow$.MODULE$;
        } else if (expression instanceof Mux) {
            flow = SourceFlow$.MODULE$;
        } else if (expression instanceof ValidIf) {
            flow = SourceFlow$.MODULE$;
        } else if (WInvalid$.MODULE$.equals(expression)) {
            flow = SourceFlow$.MODULE$;
        } else {
            throw this.throwInternalError(new StringBuilder(26).append("flow: shouldn't be here - ").append(e).toString(), this.throwInternalError$default$2());
        }
        return flow;
    }

    public Flow get_flow(Statement s) {
        Product product;
        Statement statement = s;
        if (statement instanceof DefWire) {
            product = DuplexFlow$.MODULE$;
        } else if (statement instanceof DefRegister) {
            product = DuplexFlow$.MODULE$;
        } else if (statement instanceof DefNode) {
            product = SourceFlow$.MODULE$;
        } else if (statement instanceof DefInstance) {
            product = SourceFlow$.MODULE$;
        } else if (statement instanceof DefMemory) {
            product = SourceFlow$.MODULE$;
        } else if (statement instanceof Block) {
            product = UnknownFlow$.MODULE$;
        } else if (statement instanceof Connect) {
            product = UnknownFlow$.MODULE$;
        } else if (statement instanceof PartialConnect) {
            product = UnknownFlow$.MODULE$;
        } else if (statement instanceof Stop) {
            product = UnknownFlow$.MODULE$;
        } else if (statement instanceof Print) {
            product = UnknownFlow$.MODULE$;
        } else if (statement instanceof IsInvalid) {
            product = UnknownFlow$.MODULE$;
        } else if (EmptyStmt$.MODULE$.equals(statement)) {
            product = UnknownFlow$.MODULE$;
        } else {
            throw new MatchError(statement);
        }
        return product;
    }

    public Flow get_flow(Port p) {
        Direction direction = p.direction();
        Input$ input$ = Input$.MODULE$;
        return !(direction != null ? !direction.equals(input$) : input$ != null) ? SourceFlow$.MODULE$ : SinkFlow$.MODULE$;
    }

    public Info get_info(Statement s) {
        Info info;
        Statement statement = s;
        if (statement instanceof HasInfo) {
            Statement statement2 = statement;
            info = ((HasInfo)((Object)statement2)).info();
        } else {
            info = NoInfo$.MODULE$;
        }
        return info;
    }

    public Seq<Reference> getAllRefs(Expression expr) {
        Object refs = ListBuffer$.MODULE$.empty();
        Utils$.rec$1(expr, (ListBuffer)refs);
        return ((ListBuffer)refs).toList();
    }

    public Tuple2<Reference, Expression> splitRef(Expression e) {
        Tuple2<Reference, Expression> tuple2;
        Expression expression = e;
        if (expression instanceof Reference) {
            Reference reference = (Reference)expression;
            tuple2 = new Tuple2<Reference, Expression>(reference, EmptyExpression$.MODULE$);
        } else if (expression instanceof SubIndex) {
            SubIndex subIndex = (SubIndex)expression;
            Tuple2<Reference, Expression> tuple22 = this.splitRef(subIndex.expr());
            if (tuple22 == null) {
                throw new MatchError(tuple22);
            }
            Reference root = tuple22._1();
            Expression tail = tuple22._2();
            Tuple2<Reference, Expression> tuple23 = new Tuple2<Reference, Expression>(root, tail);
            Tuple2<Reference, Expression> tuple24 = tuple23;
            Reference root2 = tuple24._1();
            Expression tail2 = tuple24._2();
            tuple2 = new Tuple2<Reference, SubIndex>(root2, new SubIndex(tail2, subIndex.value(), subIndex.tpe(), subIndex.flow()));
        } else if (expression instanceof SubField) {
            Expression tail;
            SubField subField = (SubField)expression;
            Tuple2<Reference, Expression> tuple25 = this.splitRef(subField.expr());
            if (tuple25 == null) {
                throw new MatchError(tuple25);
            }
            Reference root = tuple25._1();
            Expression tail3 = tuple25._2();
            Tuple2<Reference, Expression> tuple26 = new Tuple2<Reference, Expression>(root, tail3);
            Tuple2<Reference, Expression> tuple27 = tuple26;
            Reference root3 = tuple27._1();
            Expression expression2 = tail = tuple27._2();
            Tuple2<Reference, Expression> tuple28 = EmptyExpression$.MODULE$.equals(expression2) ? new Tuple2<Reference, Reference>(root3, new Reference(subField.name(), subField.tpe(), root3.kind(), subField.flow())) : new Tuple2<Reference, SubField>(root3, new SubField(tail, subField.name(), subField.tpe(), subField.flow()));
            tuple2 = tuple28;
        } else if (expression instanceof SubAccess) {
            SubAccess subAccess = (SubAccess)expression;
            Tuple2<Reference, Expression> tuple29 = this.splitRef(subAccess.expr());
            if (tuple29 == null) {
                throw new MatchError(tuple29);
            }
            Reference root = tuple29._1();
            Expression tail = tuple29._2();
            Tuple2<Reference, Expression> tuple210 = new Tuple2<Reference, Expression>(root, tail);
            Tuple2<Reference, Expression> tuple211 = tuple210;
            Reference root4 = tuple211._1();
            Expression tail4 = tuple211._2();
            tuple2 = new Tuple2<Reference, SubAccess>(root4, new SubAccess(tail4, subAccess.index(), subAccess.tpe(), subAccess.flow()));
        } else {
            throw new MatchError(expression);
        }
        return tuple2;
    }

    public Expression mergeRef(Expression root, Expression body) {
        Expression expression;
        Expression expression2 = body;
        if (expression2 instanceof Reference) {
            Reference reference = (Reference)expression2;
            expression = WSubField$.MODULE$.apply(root, reference.name(), reference.tpe(), reference.flow());
        } else if (expression2 instanceof SubIndex) {
            SubIndex subIndex = (SubIndex)expression2;
            expression = WSubIndex$.MODULE$.apply(this.mergeRef(root, subIndex.expr()), subIndex.value(), subIndex.tpe(), subIndex.flow());
        } else if (expression2 instanceof SubField) {
            SubField subField = (SubField)expression2;
            expression = WSubField$.MODULE$.apply(this.mergeRef(root, subField.expr()), subField.name(), subField.tpe(), subField.flow());
        } else if (EmptyExpression$.MODULE$.equals(expression2)) {
            expression = root;
        } else {
            throw new MatchError(expression2);
        }
        return expression;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IsDeclaration getDeclaration(Module m, Expression expr) {
        void rootDecl;
        void var4_17;
        Expression expression = expr;
        boolean bl = expression instanceof Reference ? true : (expression instanceof SubIndex ? true : expression instanceof SubField);
        if (!bl) throw this.error(new StringBuilder(52).append("getDeclaration does not support Expressions of type ").append(expression.getClass()).toString(), this.error$default$2());
        Tuple2<Reference, Expression> tuple2 = this.splitRef(expr);
        if (tuple2 == null) throw new MatchError(tuple2);
        Reference root = tuple2._1();
        Expression tail = tuple2._2();
        Tuple2<Reference, Expression> tuple22 = new Tuple2<Reference, Expression>(root, tail);
        Tuple2<Reference, Expression> tuple23 = tuple22;
        Reference root2 = tuple23._1();
        Expression tail2 = tuple23._2();
        Option option = m.ports().find((Function1<Port, Object> & Serializable)x$18 -> BoxesRunTime.boxToBoolean(Utils$.$anonfun$getDeclaration$2(root2, x$18)));
        if (option instanceof Some) {
            Port decl;
            Some some = (Some)option;
            Port port = decl = (Port)some.value();
            rootDecl = var4_17;
            return rootDecl;
        } else {
            IsDeclaration decl;
            if (!None$.MODULE$.equals(option)) throw new MatchError(option);
            Option option2 = Utils$.getRootDecl$1(root2.name(), m.body());
            if (!(option2 instanceof Some)) {
                if (!None$.MODULE$.equals(option2)) throw new MatchError(option2);
                throw new Utils.DeclarationNotFoundException(new StringBuilder(35).append("[module ").append(m.name()).append("]  Reference ").append(expr.serialize()).append(" not declared!").toString());
            }
            Some some = (Some)option2;
            IsDeclaration isDeclaration = decl = (IsDeclaration)some.value();
            IsDeclaration isDeclaration2 = isDeclaration;
        }
        rootDecl = var4_17;
        return rootDecl;
    }

    public BundleType stmtToType(Statement s) {
        return new BundleType(Utils$.recStmtToType$1(s));
    }

    public Set<String> v_keywords() {
        return v_keywords;
    }

    public Seq<String> expandPrefixes(String name, String prefixDelim) {
        Regex regex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(new StringBuilder(15).append("(").append(Regex$.MODULE$.quote(prefixDelim)).append(")+[A-Za-z0-9$]").toString()));
        String string = name;
        return (Seq)((SeqOps)regex.findAllMatchIn(name).map((Function1<Regex.Match, Object> & Serializable)x$19 -> BoxesRunTime.boxToInteger(Utils$.$anonfun$expandPrefixes$1(x$19))).toSeq().foldLeft(scala.package$.MODULE$.Seq().apply((Seq)Nil$.MODULE$), (Function2<Seq, Object, Seq> & Serializable)(x0$1, x1$1) -> Utils$.$anonfun$expandPrefixes$2(name, x0$1, BoxesRunTime.unboxToInt(x1$1)))).$plus$colon(string);
    }

    public String expandPrefixes$default$2() {
        return "_";
    }

    public BigInt maskBigInt(BigInt value, int width) {
        return value.$amp(scala.package$.MODULE$.BigInt().apply(1).$less$less(width).$minus(BigInt$.MODULE$.int2bigInt(1)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isLiteral(Expression e2) {
        Expression expression = e2;
        if (expression instanceof Literal) {
            return true;
        }
        if (!(expression instanceof DoPrim)) return false;
        DoPrim doPrim = (DoPrim)expression;
        PrimOp op = doPrim.op();
        Seq<Expression> args = doPrim.args();
        if (!this.isCast(op)) return false;
        return args.exists((Function1<Expression, Object> & Serializable)e -> BoxesRunTime.boxToBoolean(Utils$.MODULE$.isLiteral(e)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Expression and(Expression e1, Expression e2) {
        UIntLiteral uIntLiteral;
        Expression expression;
        UIntLiteral uIntLiteral2;
        Expression expression2;
        Type type = e1.tpe();
        Type type2 = e2.tpe();
        Predef$.MODULE$.assert(!(type != null ? !type.equals(type2) : type2 != null));
        Tuple2<Expression, Expression> tuple2 = new Tuple2<Expression, Expression>(e1, e2);
        if (tuple2 != null) {
            Expression a = tuple2._1();
            Expression b = tuple2._2();
            if (a instanceof UIntLiteral) {
                UIntLiteral uIntLiteral3 = (UIntLiteral)a;
                if (b instanceof UIntLiteral) {
                    UIntLiteral uIntLiteral4 = (UIntLiteral)b;
                    return new UIntLiteral(uIntLiteral3.value().$bar(uIntLiteral4.value()), uIntLiteral3.width());
                }
            }
        }
        if (tuple2 != null) {
            UIntLiteral uIntLiteral5;
            Expression expression3 = tuple2._1();
            Expression b = tuple2._2();
            if (expression3 instanceof UIntLiteral && Utils$True$.MODULE$.unapply(uIntLiteral5 = (UIntLiteral)expression3)) {
                return b;
            }
        }
        if (tuple2 != null) {
            UIntLiteral uIntLiteral6;
            Expression a = tuple2._1();
            Expression expression4 = tuple2._2();
            if (expression4 instanceof UIntLiteral && Utils$True$.MODULE$.unapply(uIntLiteral6 = (UIntLiteral)expression4)) {
                return a;
            }
        }
        if (tuple2 != null && (expression2 = tuple2._1()) instanceof UIntLiteral && Utils$False$.MODULE$.unapply(uIntLiteral2 = (UIntLiteral)expression2)) {
            return Utils$False$.MODULE$.apply();
        }
        if (tuple2 != null && (expression = tuple2._2()) instanceof UIntLiteral && Utils$False$.MODULE$.unapply(uIntLiteral = (UIntLiteral)expression)) {
            return Utils$False$.MODULE$.apply();
        }
        if (tuple2 != null) {
            Expression a = tuple2._1();
            Expression b = tuple2._2();
            Expression expression5 = a;
            Expression expression6 = b;
            if (expression5 == null) {
                if (expression6 == null) return a;
            } else if (expression5.equals(expression6)) {
                return a;
            }
        }
        if (tuple2 == null) throw new MatchError(tuple2);
        Expression a = tuple2._1();
        Expression b = tuple2._2();
        return new DoPrim(PrimOps$And$.MODULE$, (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{a, b})), scala.package$.MODULE$.Nil(), this.BoolType());
    }

    public Expression eq(Expression e1, Expression e2) {
        return new DoPrim(PrimOps$Eq$.MODULE$, (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{e1, e2})), scala.package$.MODULE$.Nil(), this.BoolType());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public Expression or(Expression e1, Expression e2) {
        UIntLiteral uIntLiteral;
        Expression expression;
        UIntLiteral uIntLiteral2;
        Expression expression2;
        void var3_16;
        Type type = e1.tpe();
        Type type2 = e2.tpe();
        Predef$.MODULE$.assert(!(type != null ? !type.equals(type2) : type2 != null));
        Tuple2<Expression, Expression> tuple2 = new Tuple2<Expression, Expression>(e1, e2);
        if (tuple2 != null) {
            Expression a = tuple2._1();
            Expression b = tuple2._2();
            if (a instanceof UIntLiteral) {
                UIntLiteral uIntLiteral3 = (UIntLiteral)a;
                if (b instanceof UIntLiteral) {
                    UIntLiteral uIntLiteral4 = (UIntLiteral)b;
                    UIntLiteral uIntLiteral5 = new UIntLiteral(uIntLiteral3.value().$bar(uIntLiteral4.value()), uIntLiteral3.width());
                    return var3_16;
                }
            }
        }
        if (tuple2 != null && (expression2 = tuple2._1()) instanceof UIntLiteral && Utils$True$.MODULE$.unapply(uIntLiteral2 = (UIntLiteral)expression2)) {
            UIntLiteral uIntLiteral6 = Utils$True$.MODULE$.apply();
            return var3_16;
        }
        if (tuple2 != null && (expression = tuple2._2()) instanceof UIntLiteral && Utils$True$.MODULE$.unapply(uIntLiteral = (UIntLiteral)expression)) {
            UIntLiteral uIntLiteral7 = Utils$True$.MODULE$.apply();
            return var3_16;
        }
        if (tuple2 != null) {
            UIntLiteral uIntLiteral8;
            Expression expression3 = tuple2._1();
            Expression b = tuple2._2();
            if (expression3 instanceof UIntLiteral && Utils$False$.MODULE$.unapply(uIntLiteral8 = (UIntLiteral)expression3)) {
                Expression expression4 = b;
                return var3_16;
            }
        }
        if (tuple2 != null) {
            UIntLiteral uIntLiteral9;
            Expression a = tuple2._1();
            Expression expression5 = tuple2._2();
            if (expression5 instanceof UIntLiteral && Utils$False$.MODULE$.unapply(uIntLiteral9 = (UIntLiteral)expression5)) {
                Expression expression6 = a;
                return var3_16;
            }
        }
        if (tuple2 != null) {
            Expression a = tuple2._1();
            Expression b = tuple2._2();
            Expression expression7 = a;
            Expression expression8 = b;
            if (!(expression7 != null ? !expression7.equals(expression8) : expression8 != null)) {
                Expression expression9 = a;
                return var3_16;
            }
        }
        if (tuple2 == null) throw new MatchError(tuple2);
        Expression a = tuple2._1();
        Expression b = tuple2._2();
        DoPrim doPrim = new DoPrim(PrimOps$Or$.MODULE$, (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{a, b})), scala.package$.MODULE$.Nil(), this.BoolType());
        return var3_16;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public Expression not(Expression e) {
        void var2_8;
        boolean bl = false;
        UIntLiteral uIntLiteral = null;
        Expression expression = e;
        if (expression instanceof UIntLiteral) {
            bl = true;
            uIntLiteral = (UIntLiteral)expression;
            if (Utils$True$.MODULE$.unapply(uIntLiteral)) {
                UIntLiteral uIntLiteral2 = Utils$False$.MODULE$.apply();
                return var2_8;
            }
        }
        if (bl && Utils$False$.MODULE$.unapply(uIntLiteral)) {
            UIntLiteral uIntLiteral3 = Utils$True$.MODULE$.apply();
            return var2_8;
        }
        DoPrim doPrim = new DoPrim(PrimOps$Not$.MODULE$, (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{expression})), scala.package$.MODULE$.Nil(), this.BoolType());
        return var2_8;
    }

    public Expression implies(Expression e1, Expression e2) {
        return this.or(this.not(e1), e2);
    }

    public Expression mux(Expression cond, Expression tval, Expression fval) {
        Type type = tval.tpe();
        Type type2 = fval.tpe();
        Predef$.MODULE$.require(!(type != null ? !type.equals(type2) : type2 != null));
        return new Mux(cond, tval, fval, tval.tpe());
    }

    public <A, K> Seq<Tuple2<K, Seq<A>>> groupByIntoSeq(Iterable<A> xs, Function1<A, K> f) {
        Object map = LinkedHashMap$.MODULE$.empty();
        xs.foreach(arg_0 -> Utils$.$anonfun$groupByIntoSeq$1(f, (LinkedHashMap)map, arg_0));
        return ((AbstractMap)map).view().map((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Object k = tuple2._1();
            ListBuffer vs = (ListBuffer)tuple2._2();
            Tuple2 tuple22 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(k), vs.toList());
            return tuple22;
        }).toList();
    }

    public Seq<DefModule> collectInstantiatedModules(Module mod, Map<String, DefModule> map) {
        Object modules = ArrayBuffer$.MODULE$.empty();
        this.onStmt$1(mod.body(), (ArrayBuffer)modules, map);
        return ((IterableOnceOps)((AbstractSeq)modules).distinct()).toSeq();
    }

    public boolean orderAgnosticEquality(Circuit a, Circuit b) {
        Seq x$1 = (Seq)a.modules().sortBy((Function1<DefModule, String> & Serializable)x$20 -> x$20.name(), Ordering$String$.MODULE$);
        Info x$2 = a.copy$default$1();
        String x$3 = a.copy$default$3();
        Circuit circuit = a.copy(x$2, x$1, x$3);
        Seq x$4 = (Seq)b.modules().sortBy((Function1<DefModule, String> & Serializable)x$21 -> x$21.name(), Ordering$String$.MODULE$);
        Info x$5 = b.copy$default$1();
        String x$6 = b.copy$default$3();
        Circuit circuit2 = b.copy(x$5, x$4, x$6);
        return !(circuit != null ? !((Object)circuit).equals(circuit2) : circuit2 != null);
    }

    public Circuit combine(Seq<Circuit> circuits) {
        Seq grouped = this.groupByIntoSeq((Iterable)circuits.flatMap((Function1<Circuit, Seq> & Serializable)x$23 -> x$23.modules()), (Function1<DefModule, String> & Serializable)x0$1 -> {
            String string;
            DefModule defModule = x0$1;
            if (defModule instanceof Module) {
                Module module = (Module)defModule;
                string = module.name();
            } else if (defModule instanceof ExtModule) {
                ExtModule extModule = (ExtModule)defModule;
                string = extModule.defname();
            } else {
                throw new MatchError(defModule);
            }
            return string;
        });
        Iterable deduped = (Iterable)grouped.flatMap((Function1<Tuple2, IterableOnce> & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Seq insts = (Seq)tuple2._2();
            Seq seq = Utils$.dedup$1(insts);
            return seq;
        });
        Iterable found = (Iterable)deduped.collect(new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Either<Module, DefModule>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof Left) {
                    Left left = (Left)A1;
                    Module m = (Module)left.value();
                    object = m;
                } else {
                    object = function1.apply(x1);
                }
                return object;
            }

            public final boolean isDefinedAt(Either<Module, DefModule> x1) {
                Either<Module, DefModule> either = x1;
                boolean bl = either instanceof Left;
                return bl;
            }
        });
        Predef$.MODULE$.assert(found.size() == 1, (Function0<Object>)(Function0<String> & Serializable)() -> new StringBuilder(40).append("There should only be 1 top module, got: ").append(((IterableOnceOps)found.map((Function1<Module, String> & Serializable)x$24 -> x$24.name())).mkString(", ")).toString());
        Module top = (Module)found.head();
        Iterable res = (Iterable)deduped.collect(new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Either<Module, DefModule>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 instanceof Right) {
                    Right right = (Right)A1;
                    DefModule m = (DefModule)right.value();
                    object = m;
                } else {
                    object = function1.apply(x2);
                }
                return object;
            }

            public final boolean isDefinedAt(Either<Module, DefModule> x2) {
                Either<Module, DefModule> either = x2;
                boolean bl = either instanceof Right;
                return bl;
            }
        });
        Module module = top;
        return new Circuit(NoInfo$.MODULE$, (Seq)res.toSeq().$plus$colon(module), top.name());
    }

    public static final /* synthetic */ boolean $anonfun$squashEmpty$3(Statement x$6) {
        Statement statement = x$6;
        EmptyStmt$ emptyStmt$ = EmptyStmt$.MODULE$;
        return statement == null ? emptyStmt$ != null : !statement.equals(emptyStmt$);
    }

    private final Expression onExp$1(Expression expr2, ObjectRef ref$1, ArrayBuffer tokens$1) {
        Growable<TargetToken.Index> growable;
        Expression expression = Mappers$ExprMap$.MODULE$.map$extension(Mappers$.MODULE$.ExprMap(expr2), (Function1<Expression, Expression> & Serializable)expr -> this.onExp$1((Expression)expr, ref$1, tokens$1), (Function1<Function1, Mappers.ExprMagnet> & Serializable)f -> Mappers$ExprMagnet$.MODULE$.forExpr((Function1<Expression, Expression>)f));
        if (expression instanceof Reference) {
            Reference reference = (Reference)expression;
            ref$1.elem = reference.name();
            growable = BoxedUnit.UNIT;
        } else if (expression instanceof SubField) {
            SubField subField = (SubField)expression;
            growable = tokens$1.$plus$eq(new TargetToken.Field(subField.name()));
        } else if (expression instanceof SubIndex) {
            SubIndex subIndex = (SubIndex)expression;
            growable = tokens$1.$plus$eq(new TargetToken.Index(subIndex.value()));
        } else {
            throw this.throwInternalError("Cannot call Utils.toTarget on non-referencing expression", this.throwInternalError$default$2());
        }
        return expr2;
    }

    public static final /* synthetic */ boolean $anonfun$get_point$1(SubField x3$3, Field x$8) {
        String string = x$8.name();
        String string2 = x3$3.name();
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ int $anonfun$get_point$2(int point, Field f) {
        return point + MODULE$.get_size(f.tpe());
    }

    public static final /* synthetic */ boolean $anonfun$hasFlip$1(Field x$9) {
        Orientation orientation = x$9.flip();
        Flip$ flip$ = Flip$.MODULE$;
        return !(orientation != null ? !orientation.equals(flip$) : flip$ != null);
    }

    private static final Expression addKids$1(Expression e, ArrayBuffer kids$1) {
        kids$1.$plus$eq(e);
        return e;
    }

    private final Expression onExp$2(Expression e2, HashMap nodeMap$1, Function1 stop$1) {
        Reference reference;
        String name;
        Expression expression;
        while ((expression = Mappers$ExprMap$.MODULE$.map$extension(Mappers$.MODULE$.ExprMap(e2), (Function1<Expression, Expression> & Serializable)e -> this.onExp$2((Expression)e, nodeMap$1, stop$1), (Function1<Function1, Mappers.ExprMagnet> & Serializable)f -> Mappers$ExprMagnet$.MODULE$.forExpr((Function1<Expression, Expression>)f))) instanceof Reference && nodeMap$1.contains(name = (reference = (Reference)expression).name()) && !BoxesRunTime.unboxToBoolean(stop$1.apply(name))) {
            e2 = (Expression)nodeMap$1.apply(name);
        }
        Expression expression2 = expression;
        return expression2;
    }

    public static final /* synthetic */ boolean $anonfun$inline$default$2$1(String x) {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final Width wmax$1(Width w1, Width w2) {
        Tuple2<Width, Width> tuple2 = new Tuple2<Width, Width>(w1, w2);
        if (tuple2 != null) {
            Width w1x = tuple2._1();
            Width w2x = tuple2._2();
            if (w1x instanceof IntWidth) {
                IntWidth intWidth = (IntWidth)w1x;
                if (w2x instanceof IntWidth) {
                    IntWidth intWidth2 = (IntWidth)w2x;
                    return IntWidth$.MODULE$.apply(intWidth.width().max(intWidth2.width()));
                }
            }
        }
        if (tuple2 == null) throw new MatchError(tuple2);
        Width w1x = tuple2._1();
        Width w2x = tuple2._2();
        return Implicits$.MODULE$.constraint2width(IsMax$.MODULE$.apply(Implicits$.MODULE$.width2constraint(w1x), Implicits$.MODULE$.width2constraint(w2x)));
    }

    public static final /* synthetic */ boolean $anonfun$field_type$1(String s$1, Field x$11) {
        String string = x$11.name();
        String string2 = s$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ int $anonfun$get_size$1(int sum, Field f) {
        return sum + MODULE$.get_size(f.tpe());
    }

    private static final Map emptyMap$1() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    public static final /* synthetic */ Tuple2 $anonfun$get_valid_points$1(Tuple2 x0$1, Field x1$1) {
        Field f1;
        Tuple2 tuple2;
        block3: {
            Tuple2<Tuple2, Field> tuple22;
            block2: {
                tuple22 = new Tuple2<Tuple2, Field>(x0$1, x1$1);
                if (tuple22 == null) break block2;
                tuple2 = tuple22._1();
                f1 = tuple22._2();
                if (tuple2 != null) break block3;
            }
            throw new MatchError(tuple22);
        }
        Map map = (Map)tuple2._1();
        int ilen = tuple2._2$mcI$sp();
        Tuple2 tuple23 = new Tuple2(map.$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(f1.name()), new Tuple3<Type, Orientation, Integer>(f1.tpe(), f1.flip(), BoxesRunTime.boxToInteger(ilen)))), BoxesRunTime.boxToInteger(ilen + MODULE$.get_size(f1.tpe())));
        return tuple23;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ Tuple2 $anonfun$get_valid_points$2(Map t1_fields$1, Orientation flip1$1, Orientation flip2$1, Tuple2 x0$2, Field x1$2) {
        void var6_13;
        Tuple2<Tuple2, Field> tuple2 = new Tuple2<Tuple2, Field>(x0$2, x1$2);
        if (tuple2 == null) throw new MatchError(tuple2);
        Tuple2 tuple22 = tuple2._1();
        Field f2 = tuple2._2();
        if (tuple22 == null) throw new MatchError(tuple2);
        Seq points = (Seq)tuple22._1();
        int jlen = tuple22._2$mcI$sp();
        Option option = t1_fields$1.get(f2.name());
        if (None$.MODULE$.equals(option)) {
            Tuple2<Seq, Integer> tuple23 = new Tuple2<Seq, Integer>(points, BoxesRunTime.boxToInteger(jlen + MODULE$.get_size(f2.tpe())));
            return var6_13;
        } else {
            if (!(option instanceof Some)) throw new MatchError(option);
            Some some = (Some)option;
            Tuple3 tuple3 = (Tuple3)some.value();
            if (tuple3 == null) throw new MatchError(option);
            Type f1_tpe = (Type)tuple3._1();
            Orientation f1_flip = (Orientation)tuple3._2();
            int ilen = BoxesRunTime.unboxToInt(tuple3._3());
            Orientation f1_times = MODULE$.times(flip1$1, f1_flip);
            Orientation f2_times = MODULE$.times(flip2$1, f2.flip());
            Seq<Tuple2<Object, Object>> ls = MODULE$.get_valid_points(f1_tpe, f2.tpe(), f1_times, f2_times);
            Tuple2 tuple24 = new Tuple2(points.$plus$plus((IterableOnce)ls.map((Function1<Tuple2, Tuple2> & Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                int x = tuple2._1$mcI$sp();
                int y = tuple2._2$mcI$sp();
                Tuple2$mcII$sp tuple2$mcII$sp = new Tuple2$mcII$sp(x + ilen, y + jlen);
                return tuple2$mcII$sp;
            })), BoxesRunTime.boxToInteger(jlen + MODULE$.get_size(f2.tpe())));
        }
        return var6_13;
    }

    public static final /* synthetic */ Tuple3 $anonfun$get_valid_points$4(VectorType x20$1, VectorType x21$1, Orientation flip1$1, Orientation flip2$1, Tuple3 x0$4, int x1$3) {
        Tuple3 tuple3;
        Tuple2<Tuple3, Integer> tuple2 = new Tuple2<Tuple3, Integer>(x0$4, BoxesRunTime.boxToInteger(x1$3));
        if (tuple2 == null || (tuple3 = tuple2._1()) == null) {
            throw new MatchError(tuple2);
        }
        Seq points = (Seq)tuple3._1();
        int ilen = BoxesRunTime.unboxToInt(tuple3._2());
        int jlen = BoxesRunTime.unboxToInt(tuple3._3());
        Seq<Tuple2<Object, Object>> ls = MODULE$.get_valid_points(x20$1.tpe(), x21$1.tpe(), flip1$1, flip2$1);
        Tuple3 tuple32 = new Tuple3(points.$plus$plus((IterableOnce)ls.map((Function1<Tuple2, Tuple2> & Serializable)x0$5 -> {
            Tuple2 tuple2 = x0$5;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            int x = tuple2._1$mcI$sp();
            int y = tuple2._2$mcI$sp();
            Tuple2$mcII$sp tuple2$mcII$sp = new Tuple2$mcII$sp(x + ilen, y + jlen);
            return tuple2$mcII$sp;
        })), BoxesRunTime.boxToInteger(ilen + MODULE$.get_size(x20$1.tpe())), BoxesRunTime.boxToInteger(jlen + MODULE$.get_size(x21$1.tpe())));
        return tuple32;
    }

    public static final /* synthetic */ boolean $anonfun$field_flip$1(String s$2, Field x$12) {
        String string = x$12.name();
        String string2 = s$2;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$get_field$1(String s$3, Field x$13) {
        String string = x$13.name();
        String string2 = s$3;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private static final void rec$1(Expression e2, ListBuffer refs$1) {
        Expression expression = e2;
        if (expression instanceof Reference) {
            Reference reference = (Reference)expression;
            refs$1.$plus$eq(reference);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            Foreachers$ExprForeach$.MODULE$.foreach$extension(Foreachers$.MODULE$.ExprForeach(expression), (Function1<Expression, Object> & Serializable)e -> {
                Utils$.rec$1(e, refs$1);
                return BoxedUnit.UNIT;
            }, (Function1<Function1, Foreachers.ExprForMagnet> & Serializable)f -> Foreachers$ExprForMagnet$.MODULE$.forExpr((Function1<Expression, BoxedUnit>)f));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ Option $anonfun$getDeclaration$1(String name$1, Statement s) {
        return Utils$.getRootDecl$1(name$1, s);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static final Option getRootDecl$1(String name, Statement s) {
        block3: {
            block4: {
                block6: {
                    block7: {
                        block5: {
                            block2: {
                                var4_2 = s;
                                if (!(var4_2 instanceof IsDeclaration)) break block2;
                                var5_3 = var4_2;
                                v0 = ((HasName)var5_3).name();
                                var6_4 = name;
                                var2_5 /* !! */  = !(v0 != null ? v0.equals(var6_4) == false : var6_4 != null) ? new Some<Statement>(var5_3) : None$.MODULE$;
                                break block3;
                            }
                            if (!(var4_2 instanceof Conditionally)) break block4;
                            var7_6 = (Conditionally)var4_2;
                            m = new Tuple2<Option, Option>(Utils$.getRootDecl$1(name, var7_6.conseq()), Utils$.getRootDecl$1(name, var7_6.alt()));
                            var9_8 = m;
                            if (var9_8 == null) break block5;
                            var10_9 = var9_8._1();
                            var11_10 = var9_8._2();
                            if (!(var10_9 instanceof Some)) break block5;
                            var12_11 = (Some)var10_9;
                            decl = (IsDeclaration)var12_11.value();
                            if (!None$.MODULE$.equals(var11_10)) break block5;
                            var3_13 /* !! */  = new Some<IsDeclaration>(decl);
                            break block6;
                        }
                        if (var9_8 == null) break block7;
                        var14_14 = var9_8._1();
                        var15_15 = var9_8._2();
                        if (!None$.MODULE$.equals(var14_14) || !(var15_15 instanceof Some)) break block7;
                        var16_16 = (Some)var15_15;
                        decl = (IsDeclaration)var16_16.value();
                        var3_13 /* !! */  = new Some<IsDeclaration>(decl);
                        break block6;
                    }
                    if (var9_8 == null) ** GOTO lbl-1000
                    var18_18 = var9_8._1();
                    var19_19 = var9_8._2();
                    if (None$.MODULE$.equals(var18_18) && None$.MODULE$.equals(var19_19)) {
                        var3_13 /* !! */  = None$.MODULE$;
                    } else lbl-1000:
                    // 2 sources

                    {
                        throw new MatchError(var9_8);
                    }
                }
                var2_5 /* !! */  = var3_13 /* !! */ ;
                break block3;
            }
            var2_5 /* !! */  = var4_2 instanceof Block ? ((stmts = (Seq)(var20_20 = (Block)var4_2).stmts().flatMap((Function1<Statement, Option> & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$getDeclaration$1(java.lang.String firrtl.ir.Statement ), (Lfirrtl/ir/Statement;)Lscala/Option;)((String)name))).nonEmpty() != false ? new Some<A>(stmts.head()) : None$.MODULE$) : None$.MODULE$;
        }
        return var2_5 /* !! */ ;
    }

    public static final /* synthetic */ boolean $anonfun$getDeclaration$2(Reference root$1, Port x$18) {
        String string = x$18.name();
        String string2 = root$1.name();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ DefMemory $anonfun$stmtToType$3(VectorType x6$1, DefMemory x5$1, int i) {
        String x$1 = Integer.toString(i);
        Type x$2 = x6$1.tpe();
        Info x$3 = x5$1.copy$default$1();
        BigInt x$4 = x5$1.copy$default$4();
        int x$5 = x5$1.copy$default$5();
        int x$6 = x5$1.copy$default$6();
        Seq<String> x$7 = x5$1.copy$default$7();
        Seq<String> x$8 = x5$1.copy$default$8();
        Seq<String> x$9 = x5$1.copy$default$9();
        Enumeration.Value x$10 = x5$1.copy$default$10();
        return x5$1.copy(x$3, x$1, x$2, x$4, x$5, x$6, x$7, x$8, x$9, x$10);
    }

    private static final Seq recStmtToType$1(Statement s2) {
        Seq seq;
        Statement statement = s2;
        if (statement instanceof DefWire) {
            DefWire defWire = (DefWire)statement;
            seq = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Field[]{new Field(defWire.name(), Default$.MODULE$, defWire.tpe())}));
        } else if (statement instanceof DefRegister) {
            DefRegister defRegister = (DefRegister)statement;
            seq = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Field[]{new Field(defRegister.name(), Default$.MODULE$, defRegister.tpe())}));
        } else if (statement instanceof DefInstance) {
            DefInstance defInstance = (DefInstance)statement;
            seq = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Field[]{new Field(defInstance.name(), Default$.MODULE$, defInstance.tpe())}));
        } else if (statement instanceof DefMemory) {
            Seq seq2;
            DefMemory defMemory = (DefMemory)statement;
            Type type = defMemory.dataType();
            boolean bl = type instanceof UIntType ? true : (type instanceof SIntType ? true : type instanceof FixedType);
            if (bl) {
                seq2 = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Field[]{new Field(defMemory.name(), Default$.MODULE$, MemPortUtils$.MODULE$.memType(defMemory))}));
            } else if (type instanceof BundleType) {
                BundleType bundleType = (BundleType)type;
                Seq newFields = (Seq)((IterableOps)bundleType.fields().map((Function1<Field, DefMemory> & Serializable)f -> new DefMemory(defMemory.info(), f.name(), f.tpe(), defMemory.depth(), defMemory.writeLatency(), defMemory.readLatency(), defMemory.readers(), defMemory.writers(), defMemory.readwriters(), DefMemory$.MODULE$.apply$default$10()))).flatMap((Function1<Statement, Seq> & Serializable)s -> Utils$.recStmtToType$1(s));
                seq2 = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Field[]{new Field(defMemory.name(), Default$.MODULE$, new BundleType(newFields))}));
            } else if (type instanceof VectorType) {
                VectorType vectorType = (VectorType)type;
                IndexedSeq newFields = (IndexedSeq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), vectorType.size()).map((Function1<Object, DefMemory> & Serializable)i -> Utils$.$anonfun$stmtToType$3(vectorType, defMemory, BoxesRunTime.unboxToInt(i))).flatMap((Function1<Statement, Seq> & Serializable)s -> Utils$.recStmtToType$1(s));
                seq2 = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Field[]{new Field(defMemory.name(), Default$.MODULE$, new BundleType(newFields))}));
            } else {
                throw new MatchError(type);
            }
            seq = seq2;
        } else if (statement instanceof DefNode) {
            DefNode defNode = (DefNode)statement;
            seq = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Field[]{new Field(defNode.name(), Default$.MODULE$, defNode.value().tpe())}));
        } else if (statement instanceof Conditionally) {
            Conditionally conditionally = (Conditionally)statement;
            seq = (Seq)Utils$.recStmtToType$1(conditionally.conseq()).$plus$plus(Utils$.recStmtToType$1(conditionally.alt()));
        } else if (statement instanceof Block) {
            Block block = (Block)statement;
            seq = (Seq)((IterableOps)block.stmts().map((Function1<Statement, Seq> & Serializable)s -> Utils$.recStmtToType$1(s))).flatten(Predef$.MODULE$.$conforms());
        } else {
            seq = (Seq)scala.package$.MODULE$.Seq().apply((Seq)Nil$.MODULE$);
        }
        return seq;
    }

    public static final /* synthetic */ int $anonfun$expandPrefixes$1(Regex.Match x$19) {
        return x$19.end() - 1;
    }

    public static final /* synthetic */ Seq $anonfun$expandPrefixes$2(String name$2, Seq x0$1, int x1$1) {
        Tuple2<Seq, Integer> tuple2 = new Tuple2<Seq, Integer>(x0$1, BoxesRunTime.boxToInteger(x1$1));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq seq = tuple2._1();
        int id = tuple2._2$mcI$sp();
        Seq seq2 = (Seq)seq.$colon$plus(StringOps$.MODULE$.splitAt$extension(Predef$.MODULE$.augmentString(name$2), id)._1());
        return seq2;
    }

    public static final /* synthetic */ ListBuffer $anonfun$groupByIntoSeq$1(Function1 f$2, LinkedHashMap map$1, Object x) {
        Object key = f$2.apply(x);
        ListBuffer l = (ListBuffer)map$1.getOrElseUpdate(key, (Function0<ListBuffer> & Serializable)() -> ListBuffer$.MODULE$.empty());
        return (ListBuffer)l.$plus$eq(x);
    }

    private final void onStmt$1(Statement stmt2, ArrayBuffer modules$1, Map map$2) {
        Statement statement = stmt2;
        if (statement instanceof DefInstance) {
            DefInstance defInstance = (DefInstance)statement;
            String name = defInstance.module();
            modules$1.$plus$eq(map$2.apply(name));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            if (statement instanceof WDefInstanceConnector) {
                throw this.throwInternalError(new StringBuilder(24).append("unrecognized statement: ").append(stmt2).toString(), this.throwInternalError$default$2());
            }
            Foreachers$StmtForeach$.MODULE$.foreach$extension(Foreachers$.MODULE$.StmtForeach(statement), (Function1<Statement, Object> & Serializable)stmt -> {
                this.onStmt$1(stmt, modules$1, map$2);
                return BoxedUnit.UNIT;
            }, (Function1<Function1, Foreachers.StmtForMagnet> & Serializable)f -> Foreachers$StmtForMagnet$.MODULE$.forStmt((Function1<Statement, BoxedUnit>)f));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private static final Seq dedup$1(Seq modules) {
        Seq found = (Seq)modules.collect(new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends DefModule, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Module module;
                A1 A1 = x1;
                Module module2 = A1 instanceof Module ? (module = (Module)A1) : function1.apply(x1);
                return (B1)module2;
            }

            public final boolean isDefinedAt(DefModule x1) {
                DefModule defModule = x1;
                boolean bl = defModule instanceof Module;
                return bl;
            }
        });
        Predef$.MODULE$.assert(found.size() <= 1, (Function0<Object>)(Function0<String> & Serializable)() -> new StringBuilder(70).append("Module definitions should have unique names, found ").append(found.size()).append(" definitions named ").append(((Module)found.head()).name()).toString());
        Option module = found.headOption();
        Seq extModules = (Seq)((SeqOps)modules.collect(new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends DefModule, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                ExtModule extModule;
                A1 A1 = x2;
                ExtModule extModule2 = A1 instanceof ExtModule ? (extModule = (ExtModule)A1) : function1.apply(x2);
                return (B1)extModule2;
            }

            public final boolean isDefinedAt(DefModule x2) {
                DefModule defModule = x2;
                boolean bl = defModule instanceof ExtModule;
                return bl;
            }
        })).distinct();
        return extModules.isEmpty() && !module.isEmpty() ? (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Left[]{scala.package$.MODULE$.Left().apply(module.get())})) : (!extModules.isEmpty() && module.isEmpty() ? (Seq)extModules.map((Function1<ExtModule, Right> & Serializable)x$22 -> scala.package$.MODULE$.Right().apply(x$22)) : (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Right[]{scala.package$.MODULE$.Right().apply(module.get())})));
    }

    private Utils$() {
    }

    public static final /* synthetic */ Tuple3 $anonfun$get_valid_points$4$adapted(VectorType x20$1, VectorType x21$1, Orientation flip1$1, Orientation flip2$1, Tuple3 x0$4, Object x1$3) {
        return Utils$.$anonfun$get_valid_points$4(x20$1, x21$1, flip1$1, flip2$1, x0$4, BoxesRunTime.unboxToInt(x1$3));
    }
}

