/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.bitmap;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.ocf.OCFContainer;
import com.adobe.epubcheck.opf.PublicationResourceChecker;
import com.adobe.epubcheck.opf.ValidationContext;
import com.adobe.epubcheck.util.CheckUtil;
import io.mola.galimatias.URL;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;

public class BitmapChecker
extends PublicationResourceChecker {
    private static final int HEIGHT_MAX = 2160;
    private static final int WIDTH_MAX = 3840;
    private static final long IMAGESIZE_MAX = 0x400000L;

    public BitmapChecker(ValidationContext context) {
        super(context);
    }

    private void checkHeader(byte[] header) {
        boolean passed;
        String mimeType = this.context.mimeType;
        if (mimeType.equals("image/jpeg")) {
            passed = header[0] == -1 && header[1] == -40;
        } else if (mimeType.equals("image/gif")) {
            passed = header[0] == 71 && header[1] == 73 && header[2] == 70 && header[3] == 56;
        } else {
            boolean bl = passed = !mimeType.equals("image/png") || header[0] == -119 && header[1] == 80 && header[2] == 78 && header[3] == 71;
        }
        if (!passed) {
            this.report.message(MessageId.OPF_029, EPUBLocation.of(this.context), this.context.path, mimeType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImageHeuristics getImageSizes() throws IOException {
        OCFContainer container = (OCFContainer)this.context.container.get();
        URL imgURL = this.context.url;
        int pos = imgURL.path().lastIndexOf(".");
        if (pos == -1) {
            throw new IOException("No extension for file: " + imgURL);
        }
        String suffix = imgURL.path().substring(pos + 1);
        File tempFile = null;
        if ("svg".compareToIgnoreCase(suffix) == 0) {
            tempFile = BitmapChecker.getImageFile(container, imgURL);
            if (tempFile != null) {
                long tempFileLength = tempFile.length();
                tempFile.delete();
                return new ImageHeuristics(0, 0, tempFileLength);
            }
            return null;
        }
        tempFile = BitmapChecker.getImageFile(container, imgURL);
        String formatFromInputStream = null;
        String formatFromSuffix = null;
        ImageReader reader = null;
        ImageInputStream imageInputStream = ImageIO.createImageInputStream(tempFile);
        Iterator<ImageReader> imageReaderIteratorFromInputStream = ImageIO.getImageReaders(imageInputStream);
        while (imageReaderIteratorFromInputStream.hasNext()) {
            ImageReader imageReaderFromInputStream = imageReaderIteratorFromInputStream.next();
            formatFromInputStream = imageReaderFromInputStream.getFormatName();
            Iterator<ImageReader> imageReaderIteratorFromSuffix = ImageIO.getImageReadersBySuffix(suffix);
            while (imageReaderIteratorFromSuffix.hasNext() && ((formatFromSuffix = (reader = imageReaderIteratorFromSuffix.next()).getFormatName()) == null || !formatFromSuffix.equals(formatFromInputStream))) {
            }
            if (formatFromSuffix == null || !formatFromSuffix.equals(formatFromInputStream)) continue;
            break;
        }
        imageInputStream.close();
        if (formatFromSuffix != null && formatFromSuffix.equals(formatFromInputStream)) {
            try {
                ImageHeuristics imageHeuristics;
                FileImageInputStream stream = new FileImageInputStream(tempFile);
                try {
                    reader.setInput(stream);
                    int width = reader.getWidth(reader.getMinIndex());
                    int height = reader.getHeight(reader.getMinIndex());
                    imageHeuristics = new ImageHeuristics(width, height, tempFile.length());
                }
                catch (Throwable throwable) {
                    ImageHeuristics imageHeuristics2;
                    try {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        this.report.message(MessageId.PKG_021, EPUBLocation.of(this.context), new Object[0]);
                        imageHeuristics2 = null;
                        return imageHeuristics2;
                    }
                    catch (RuntimeException argex) {
                        this.report.message(MessageId.PKG_021, EPUBLocation.of(this.context), new Object[0]);
                        imageHeuristics2 = null;
                        return imageHeuristics2;
                    }
                }
                stream.close();
                return imageHeuristics;
            }
            finally {
                tempFile.delete();
            }
        }
        tempFile.delete();
        if (formatFromSuffix != null) {
            this.report.message(MessageId.PKG_022, EPUBLocation.of(this.context), formatFromInputStream, suffix);
            return null;
        }
        throw new IOException("Not a known image file: " + imgURL);
    }

    private static File getImageFile(OCFContainer container, URL imageURL) throws IOException {
        return BitmapChecker.getTempImageFile(container, imageURL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File getTempImageFile(OCFContainer container, URL imageURL) throws IOException {
        File file = null;
        OutputStream os = null;
        InputStream is = null;
        try {
            int read;
            int pos = imageURL.path().lastIndexOf(".");
            if (pos == -1) {
                throw new IOException("No extension for file: " + imageURL);
            }
            String suffix = imageURL.path().substring(pos);
            String prefix = "img";
            file = File.createTempFile(prefix, suffix);
            os = new FileOutputStream(file);
            is = container.openStream(imageURL);
            if (is == null) {
                File file2 = null;
                return file2;
            }
            byte[] bytes = new byte[32768];
            while ((read = is.read(bytes)) > 0) {
                ((FileOutputStream)os).write(bytes, 0, read);
            }
        }
        finally {
            if (os != null) {
                os.flush();
                ((FileOutputStream)os).close();
            }
            if (is != null) {
                is.close();
            }
        }
        return file;
    }

    private void checkImageDimensions() {
        try {
            ImageHeuristics h = this.getImageSizes();
            if (h != null) {
                if (h.height >= 2160 || h.width >= 3840) {
                    this.report.message(MessageId.OPF_051, EPUBLocation.of(this.context), new Object[0]);
                }
                if (h.length >= 0x400000L) {
                    this.report.message(MessageId.OPF_057, EPUBLocation.of(this.context), new Object[0]);
                }
            }
        }
        catch (IOException ex) {
            this.report.message(MessageId.PKG_021, EPUBLocation.of(this.context), new Object[0]);
        }
        catch (LinkageError error) {
            this.report.message(MessageId.RSC_022, EPUBLocation.of(this.context), new Object[0]);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean checkContent() {
        try (InputStream in = this.context.resourceProvider.openStream(this.context.url);){
            if (in == null) {
                this.report.message(MessageId.RSC_001, EPUBLocation.of(this.context), new Object[0]);
                boolean bl2 = false;
                return bl2;
            }
            byte[] header = new byte[4];
            int rd = CheckUtil.readBytes(in, header, 0, 4);
            if (rd < 4) {
                this.report.message(MessageId.MED_004, EPUBLocation.of(this.context), new Object[0]);
            } else {
                this.checkHeader(header);
            }
            this.checkImageDimensions();
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            this.report.message(MessageId.PKG_021, EPUBLocation.of(this.context), new Object[0]);
            return false;
        }
    }

    public class ImageHeuristics {
        public int width;
        public int height;
        public long length;

        public ImageHeuristics(int width, int height, long length) {
            this.width = width;
            this.height = height;
            this.length = length;
        }
    }
}

